/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.core.entity.model.sf.std.AppConfig;
import kd.ai.ids.core.entity.model.sf.std.Fdim;
import kd.ai.ids.core.entity.model.sf.std.Ftype;
import kd.ai.ids.core.entity.model.sf.std.ListCol;
import kd.ai.ids.core.entity.model.sf.std.SchemeConfig;
import kd.ai.ids.core.entity.model.sf.std.SfOnlineScheme;
import kd.ai.ids.core.enumtype.ClientProperitesEnum;
import kd.ai.ids.core.enumtype.DimEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.sf.std.CosmicControlType;
import kd.ai.ids.core.query.sf.std.DimValuesDTO;
import kd.ai.ids.core.query.sf.std.StandardFilterItemQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.DynamicObjectUtils;
import kd.ai.ids.core.utils.SfAppConfigUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.form.sf.std.ModelAnalysisContext;
import kd.ai.ids.plugin.form.sf.std.PredictDetailEntryGrid;
import kd.ai.ids.plugin.job.IdsJobForm;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class PredictDetailListPlugin
extends BaseFormPlugin {
    public static final String KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP = "modSchemeSelectMap_";
    public static final String KEY_CACHE_CURRENT_FILTER_ITEM_QUERY = "currentFilterItemQuery";
    private static final String KEY_BTN_UN_ONLINE_OK = "btnunonlineok";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_BTN_EXPORT = "btnexport";
    private static final String KEY_COMBO_MOD_SCHEME_SELECT = "combomodschemeselect";
    private static final String KEY_LABEL_ORG_DIM = "labelorgdim";
    private static final String KEY_LABEL_CUST_DIM = "labelcustdim";
    private static final String KEY_LABEL_PRODUCT_DIM = "labelproductdim";
    private static final String KEY_LABEL_PREDICT_PERIOD = "labelpredictperiod";
    private static final String KEY_LABEL_PREDICT_LENGTH = "labelpredictlength";
    private static final String KEY_LABEL_PREDICT_VALUE = "labelpredictvalue";
    private static final String KEY_DATARANGEEDIT_TIME = "daterangeedittime";
    private static final String KEY_LABEL_LASTUPDATETIME = "labellastupdatetime";
    private ModelAnalysisContext ctx = null;
    private static final String KEY_FILTER_ITEM_QUERY = "filterItemQuery";
    private static final String KEY_FLEX_FILTER = "flexfilter";
    private static final String KEY_BTN_FILTER = "btnfilter";
    private static final String KEY_VECTOR_FILTER = "vectorfilter";
    private static final String KEY_IS_FOLD_FILTER = "isFoldFilter";
    private static final String TASK_CLOSE_BACK = "taskcloseback";
    private static final String FLEX_ORG_DIM = "flexorgdim";
    private static final String FLEX_CUST_DIM = "flexcustdim";
    private static final String FLEX_PRODUCT_DIM = "flexproductdim";
    private static final String KEY_FLEXFILTERS = "flexfilters";
    private static final String KEY_MULBD_FILTER_ID_LIST = "mulbdFilterIdList";
    private static final String KEY_SCHEME_CONFIG = "schemeConfig";
    private static final String KEY_APP_CONFIG = "appConfig";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String CACHE_KEY_VALUE_MAP = "valueMap";

    private String getSubServiceIdWithNoCache() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        return subServiceId;
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private String getSubServiceId() {
        String s = this.getCache().get("subServiceId");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
            TenantDTO tenantDTO = this.getTenantDTO();
            if (tenantDTO != null) {
                s = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
                this.getCache().put("subServiceId", s);
            }
        }
        return s;
    }

    private Map<String, Object> getValueMap() {
        return (Map)this.getCache().getAsObject(CACHE_KEY_VALUE_MAP, Map.class);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{KEY_ENTRYENTITY});
        this.ctx = new ModelAnalysisContext(this.getCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET, KEY_BTN_FILTER, KEY_VECTOR_FILTER, KEY_BTN_EXPORT});
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnrefresh": {
                StandardFilterItemQuery filterItemQuery = this.ctx.getCurFilterItemQuery();
                ArrayList<DimValuesDTO> dimValuesDTOList = new ArrayList<DimValuesDTO>();
                Map<String, Object> map = this.getValueByKey(this.ctx.getCurModelTypeId());
                List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
                if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
                    for (String fdimid : mulbdFilterList) {
                        DimValuesDTO dimValuesDTO = new DimValuesDTO();
                        dimValuesDTO.setLabelId(fdimid);
                        MulBasedataDynamicObjectCollection mulbdDoc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(fdimid);
                        List valueList = DynamicObjectUtils.getPkValueListFromDoc((DynamicObjectCollection)mulbdDoc);
                        dimValuesDTO.setValues(valueList);
                        dimValuesDTOList.add(dimValuesDTO);
                    }
                }
                filterItemQuery.setFdimvaluesList(dimValuesDTOList);
                this.loadChartData(false, filterItemQuery, true);
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                this.loadChartData(true, null, true);
                break;
            }
            case "btnfilter": 
            case "vectorfilter": {
                this.expandOrFoldFilterPanel(true, false);
                break;
            }
            case "btnexport": {
                this.exportList();
                break;
            }
        }
    }

    private String getSingleExportCacheKey() {
        return KEY_BTN_EXPORT + this.getView().getEntityId();
    }

    private void exportList() {
        RequestContext rc = RequestContext.get();
        String requestId = SessionCache.get().get(this.getSingleExportCacheKey());
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)requestId)) {
            this.getView().showTipNotification(String.format("\u5df2\u6709\u4e0b\u8f7d\u4efb\u52a1\u5728\u6267\u884c\uff0c\u8bf7\u7b49\u5f85\u4e0b\u8f7d\u5b8c\u6210\u6216%s\u5206\u949f\u540e\u518d\u8bd5", 15));
            return;
        }
        long total = Long.parseLong(this.ctx.getCache().get("total"));
        if (total == 0L) {
            this.getView().showTipNotification("\u67e5\u8be2\u8bb0\u5f55\u4e3a0\u6761\uff0c\u4e0d\u652f\u6301\u5bfc\u51fa");
            return;
        }
        if (total > 1000000L) {
            this.getView().showTipNotification(String.format("\u5bfc\u51fa\u603b\u8bb0\u5f55\u6570%s\u8d85\u8fc7100\u4e07\u6761\uff0c\u8bf7\u8fc7\u6ee4\u67e5\u8be2\u540e\u518d\u5bfc\u51fa", total));
            this.expandOrFoldFilterPanel(true, true);
            return;
        }
        Map<String, Object> map = this.getValueByKey(this.ctx.getCurModelTypeId());
        SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
        AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
        Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        Ftype firstFtype = (Ftype)fidFtypeMap.get(mulbdFilterList.get(0));
        StandardFilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
        List fdimvaluesList = curFilterItemQuery.getFdimvaluesList();
        if (!(CommonUtil.useMock() || !CollectionUtils.isEmpty((Collection)fdimvaluesList) && ((DimValuesDTO)fdimvaluesList.get(0)).getLabelId().equalsIgnoreCase(firstFtype.getFid()))) {
            String dimName = firstFtype.getFname();
            this.getView().showTipNotification(String.format("\u5bfc\u51fa\u524d\u8bf7\u5148\u6309\u3010%s\u3011\u8fdb\u884c\u8fc7\u6ee4\u67e5\u8be2", dimName));
            this.expandOrFoldFilterPanel(true, true);
            return;
        }
        String msg = String.format("\u5c06\u5bfc\u51fa%s\u6761\u8bb0\u5f55\uff0c\r\n\u662f\u5426\u7ee7\u7eed\u6267\u884c\u64cd\u4f5c\uff1f", total);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_BTN_EXPORT, (IFormPlugin)this);
        this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, total + "");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_BACK)) {
            TaskInfo taskInfo;
            Map result;
            String taskInfoStr;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                SessionCache.get().remove(this.getSingleExportCacheKey());
                String data = taskInfo.getData();
                JSONObject dataJo = JSONObject.parseObject((String)data);
                if (dataJo.getIntValue("errcode") == BaseResult.SUCCESS.intValue()) {
                    RequestContext rc = RequestContext.get();
                    StandardFilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
                    String exportUrl = this.sfStandardService().getLastDetailListExportFileUrl(curFilterItemQuery.getSubServiceId(), curFilterItemQuery.getRequestId());
                    this.getView().download(exportUrl);
                    this.getView().showMessage("\u5df2\u4e0b\u8f7d\u5b8c\u6210");
                }
            }
        }
    }

    private Map<String, Map<String, String>> getFtypeFidFnameMap() {
        HashMap<String, Map<String, String>> ftypeFidFnameMap = new HashMap<String, Map<String, String>>(4);
        Map<String, Object> map = this.getValueByKey(this.ctx.getCurModelTypeId());
        SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
        AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
        Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
        Iterator iterator = fidFtypeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String fdimid = (String)iterator.next().getKey();
            Ftype ftype = (Ftype)fidFtypeMap.get(fdimid);
            String fentityid = ftype.getFentityid();
            Map<Object, Object> fidFnameMap = new HashMap();
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)fentityid)) {
                fidFnameMap = this.getFidFnameMap(fentityid);
            }
            ftypeFidFnameMap.put(fdimid, fidFnameMap);
        }
        return ftypeFidFnameMap;
    }

    private Map<String, String> getFidFnameMap(String fentityid) {
        HashMap<String, String> fidFnameMap = new HashMap<String, String>();
        DynamicObject[] allDo = BusinessDataServiceHelper.load((String)fentityid, (String)"id, name", null);
        if (allDo != null && allDo.length > 0) {
            for (DynamicObject dynamicObject : allDo) {
                fidFnameMap.put(String.valueOf(dynamicObject.getPkValue()), dynamicObject.getString("name"));
            }
        }
        return fidFnameMap;
    }

    private void triggerExport(long total) {
        RequestContext rc = RequestContext.get();
        StandardFilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
        curFilterItemQuery.setTotal(Long.valueOf(total));
        curFilterItemQuery.setFcreator(String.valueOf(rc.getCurrUserId()));
        curFilterItemQuery.setFcreatorname(rc.getUserName());
        ThreadUtils.execute(() -> {
            Map<String, Map<String, String>> ftypeFidFnameMap = this.getFtypeFidFnameMap();
            curFilterItemQuery.setFtypeFidFnameMap(ftypeFidFnameMap);
            this.sfStandardService().getLastDetailListExport(curFilterItemQuery);
        });
        ThreadUtils.sleep((long)100L);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("ids");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("\u660e\u7ec6\u5217\u8868\u5bfc\u51fa");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.ai.ids.plugin.form.PredictDetailExportTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("subServiceId", curFilterItemQuery.getSubServiceId());
        params.put("requestId", curFilterItemQuery.getRequestId());
        params.put("total", total);
        SessionCache.get().put(this.getSingleExportCacheKey(), curFilterItemQuery.getRequestId(), 900);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_BACK);
        IdsJobForm.dispatch(jobInfo, this.getView(), closeCallBack);
    }

    private void expandOrFoldFilterPanel(boolean isAutoSwitch, boolean forceExpand) {
        String isFoldFilter = AppCache.get().get(KEY_IS_FOLD_FILTER);
        boolean isFold = true;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)isFoldFilter)) {
            isFold = Boolean.parseBoolean(isFoldFilter);
        }
        Vector vector = (Vector)this.getControl(KEY_VECTOR_FILTER);
        HashMap map1 = new HashMap();
        HashMap map2 = new HashMap();
        if (isAutoSwitch) {
            if (forceExpand || isFold) {
                this.expandFilterPanel(vector, map1, map2);
            } else {
                this.foldFilterPanel(vector, map1, map2);
            }
        } else if (isFold) {
            this.foldFilterPanel(vector, map1, map2);
        } else {
            this.expandFilterPanel(vector, map1, map2);
        }
    }

    private void foldFilterPanel(Vector vector, Map map1, Map map2) {
        AppCache.get().put(KEY_IS_FOLD_FILTER, Boolean.TRUE.toString(), 604800);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_FILTER});
        map1.put("zh_CN", "\u5c55\u5f00\u8fc7\u6ee4");
        map2.put("text", map1);
        this.getView().updateControlMetadata(KEY_BTN_FILTER, map2);
        vector.setFontClass("kdfont kdfont-zhankai4");
    }

    private void expandFilterPanel(Vector vector, Map map1, Map map2) {
        AppCache.get().put(KEY_IS_FOLD_FILTER, Boolean.FALSE.toString(), 604800);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_FILTER});
        map1.put("zh_CN", "\u6536\u8d77\u8fc7\u6ee4");
        map2.put("text", map1);
        this.getView().updateControlMetadata(KEY_BTN_FILTER, map2);
        vector.setFontClass("kdfont kdfont-shouqi7");
    }

    private void resetQueryCondition() {
        Map<String, Object> map;
        List mulbdFilterList;
        StandardFilterItemQuery defaultFilterItemQuery = this.ctx.getDefaultFilterItemQuery();
        if (defaultFilterItemQuery != null) {
            defaultFilterItemQuery.setCurrent(Long.valueOf(1L));
            defaultFilterItemQuery.setOrderByExpr(null);
            defaultFilterItemQuery.setFilters(null);
        }
        this.getView().getPageCache().put(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, JSONObject.toJSONString((Object)defaultFilterItemQuery));
        this.ctx.setCurFilterItemQuery(defaultFilterItemQuery);
        if (defaultFilterItemQuery != null) {
            DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
            String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
            String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
            this.getModel().setValue(keyTimeStartDate, null);
            this.getModel().setValue(keyTimeEndDate, null);
        }
        if (CollectionUtils.isNotEmpty((Collection)(mulbdFilterList = (List)(map = this.getValueByKey(this.ctx.getCurModelTypeId())).get(KEY_MULBD_FILTER_ID_LIST)))) {
            for (String fdimid : mulbdFilterList) {
                this.getModel().setValue(fdimid, null);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView formView = (IFormView)e.getSource();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        EntryAp entryAp = this.createEntryAp(fschemeid);
        PredictDetailEntryGrid entryGrid = (PredictDetailEntryGrid)formView.getControl(KEY_ENTRYENTITY);
        entryGrid.getItems().clear();
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(formView);
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private EntryAp createEntryAp(String fschemeid) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setShowSeq(true);
        Map<String, Object> map = this.getValueByKey(fschemeid);
        fschemeid = (String)map.get("fschemeid");
        String subServiceId = this.getSubServiceIdWithNoCache();
        StandardFilterItemQuery standardFilterItemQuery = new StandardFilterItemQuery();
        standardFilterItemQuery.setSubServiceId(subServiceId);
        standardFilterItemQuery.setFschemeid(fschemeid);
        standardFilterItemQuery.setNeedRecord(Boolean.FALSE);
        JSONObject dataJo = this.sfStandardService().getLastDetailList(standardFilterItemQuery);
        JSONArray fields = dataJo.getJSONArray("fields");
        if (fields != null && fields.size() > 0) {
            List listColList = fields.toJavaList(ListCol.class);
            for (ListCol listCol : listColList) {
                String controlType = listCol.getControlType();
                if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                    EntryFieldAp fieldAp = new EntryFieldAp();
                    fieldAp.setId(listCol.getId());
                    fieldAp.setKey(listCol.getId());
                    fieldAp.setWidth(new LocaleString("120px"));
                    fieldAp.setName(new LocaleString(listCol.getName()));
                    fieldAp.setFireUpdEvt(true);
                    TextField field = new TextField();
                    field.setId(listCol.getId());
                    field.setKey(listCol.getId());
                    fieldAp.setField((Field)field);
                    entryAp.getItems().add(fieldAp);
                    continue;
                }
                if (controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) {
                    EntryFieldAp apMat = new EntryFieldAp();
                    apMat.setId(listCol.getId());
                    apMat.setKey(listCol.getId());
                    apMat.setWidth(new LocaleString("120px"));
                    apMat.setName(new LocaleString(listCol.getName()));
                    BasedataField bdMat = new BasedataField();
                    bdMat.setBaseEntityNumber(listCol.getBaseEntityId());
                    apMat.setField((Field)bdMat);
                    entryAp.getItems().add(apMat);
                    continue;
                }
                if (!controlType.equalsIgnoreCase(CosmicControlType.DECIMAL_EDIT.getId())) continue;
                String colId = listCol.getId();
                EntryFieldAp fieldAp = new EntryFieldAp();
                fieldAp.setId(colId);
                fieldAp.setKey(colId);
                fieldAp.setWidth(new LocaleString("120px"));
                fieldAp.setName(new LocaleString(listCol.getName()));
                fieldAp.setFireUpdEvt(true);
                DecimalField field = new DecimalField();
                field.setId(colId);
                field.setKey(colId);
                field.setScale(2);
                fieldAp.setField((Field)field);
                entryAp.getItems().add(fieldAp);
            }
        }
        return entryAp;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_MOD_SCHEME_SELECT)) {
            String fschemeid = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("fschemeid", fschemeid);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_PRE_DETAIL.getId());
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(formShowParameter);
        }
    }

    private String loadAppConfig(String subServiceId) {
        JSONObject dataJo = this.sfStandardService().appConfigGet(subServiceId);
        JSONObject appConfigJo = dataJo.getJSONObject(KEY_APP_CONFIG);
        String appConfigStr = appConfigJo.toJSONString();
        this.getCache().put(KEY_APP_CONFIG, appConfigStr);
        return appConfigStr;
    }

    private AppConfig getAppConfig(String subServiceId) {
        AppConfig appConfig = null;
        String appConfigStr = this.getCache().get(KEY_APP_CONFIG);
        if (StringUtils.isEmpty((CharSequence)appConfigStr)) {
            appConfigStr = this.loadAppConfig(subServiceId);
        }
        appConfig = (AppConfig)JSONObject.parseObject((String)appConfigStr, AppConfig.class);
        return appConfig;
    }

    private void showCurrentModSelectAndFilterItem(String modelTypeId) {
        SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)this.getCache().getAsObject(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, SfOnlineScheme.class);
        if (sfOnlineScheme != null) {
            AppConfig appConfig = this.getAppConfig(this.ctx.getSubServiceId());
            String fconfigTag = sfOnlineScheme.getFconfigTag();
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
            String orgDimName = schemeConfig.getDimName(appConfig, DimEnum.ORG);
            String custDimName = schemeConfig.getDimName(appConfig, DimEnum.CUST);
            String productDimName = schemeConfig.getDimName(appConfig, DimEnum.PRODUCT);
            String fpretimetype = (String)schemeConfig.getFtimegranularity().get(0);
            String predictPeriodName = schemeConfig.getFtimegranularityName(appConfig);
            String predictLengthName = String.valueOf(schemeConfig.getFpredictlength());
            String predictValueName = schemeConfig.getFvaluetypeName(appConfig);
            this.ctx.setCurPreTimeType(fpretimetype);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ORG_DIM, FLEX_CUST_DIM, FLEX_PRODUCT_DIM});
            this.setLabelText(KEY_LABEL_ORG_DIM, orgDimName);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)orgDimName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ORG_DIM});
            }
            this.setLabelText(KEY_LABEL_CUST_DIM, custDimName);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)custDimName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CUST_DIM});
            }
            this.setLabelText(KEY_LABEL_PRODUCT_DIM, productDimName);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)productDimName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PRODUCT_DIM});
            }
            this.setLabelText(KEY_LABEL_PREDICT_PERIOD, predictPeriodName);
            this.setLabelText(KEY_LABEL_PREDICT_LENGTH, predictLengthName);
            this.setLabelText(KEY_LABEL_PREDICT_VALUE, predictValueName);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    private void loadOnlineModelTypeList(RequestContext rc) {
        JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(this.ctx.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_MOD_SCHEME_SELECT);
        int len = sfOnlineSchemeList.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, String> modSchemeSelectMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)sfOnlineSchemeList.get(i);
            String modelTypeId = String.valueOf(sfOnlineScheme.getFschemeid());
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)this.ctx.getCurModelTypeId())) {
                this.ctx.setCurModelTypeId(modelTypeId);
            }
            modSchemeSelectMap.put(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, JSONObject.toJSONString((Object)sfOnlineScheme));
            LocaleString comboItemText = new LocaleString(sfOnlineScheme.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, modelTypeId);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(modSchemeSelectMap);
        this.showCurrentModSelectAndFilterItem(this.ctx.getCurModelTypeId());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.expandOrFoldFilterPanel(false, false);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterItemQueryStr = (String)formShowParameter.getCustomParam(KEY_FILTER_ITEM_QUERY);
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        fschemeid = (String)map.get("fschemeid");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fschemeid)) {
            this.ctx.setCurModelTypeId(fschemeid);
        }
        this.initDimFilters();
        StandardFilterItemQuery filterItemQuery = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)filterItemQueryStr)) {
            filterItemQuery = (StandardFilterItemQuery)JSON.toJavaObject((JSON)JSON.parseObject((String)filterItemQueryStr), StandardFilterItemQuery.class);
            this.getView().getPageCache().put(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, filterItemQueryStr);
            this.ctx.setCurFilterItemQuery(filterItemQuery);
            this.ctx.setCurModelTypeId(filterItemQuery.getFschemeid());
            DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
            String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
            String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
            this.getModel().setValue(keyTimeStartDate, (Object)DateUtils.parseDate((String)filterItemQuery.getStartTime(), (String)"yyyy-MM-dd"));
            this.getModel().setValue(keyTimeEndDate, (Object)DateUtils.parseDate((String)filterItemQuery.getEndTime(), (String)"yyyy-MM-dd"));
            List fdimvaluesList = filterItemQuery.getFdimvaluesList();
            SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
            AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
            Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
            Fdim lastDim = SfAppConfigUtils.getLastDim((AppConfig)appConfig, (String)schemeConfig.getFdatasource(), (String)schemeConfig.getFschemetemplate());
            if (CollectionUtils.isNotEmpty((Collection)fdimvaluesList)) {
                for (DimValuesDTO dimValuesDTO : fdimvaluesList) {
                    String labelId = dimValuesDTO.getLabelId();
                    List valueList = dimValuesDTO.getValues();
                    if (!CollectionUtils.isNotEmpty((Collection)valueList)) continue;
                    Ftype ftype = (Ftype)fidFtypeMap.get(labelId);
                    List<Object> pkList = valueList.stream().map(s -> Long.parseLong(String.valueOf(s))).collect(Collectors.toList());
                    Object[] values = pkList.toArray(new Object[pkList.size()]);
                    String fentityid = ftype.getFentityid();
                    if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fentityid)) continue;
                    this.getModel().setValue(labelId, (Object)values);
                    this.getView().updateView(labelId);
                }
            }
        }
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadOnlineModelTypeList(rc);
        this.loadChartData(true, filterItemQuery, false);
        this.getModel().setValue(KEY_COMBO_MOD_SCHEME_SELECT, (Object)this.ctx.getCurModelTypeId());
    }

    private void refreshChartData(StandardFilterItemQuery filterItemQuery) {
        filterItemQuery.setNeedRecord(Boolean.TRUE);
        JSONObject dataJo = this.sfStandardService().getLastDetailList(filterItemQuery);
        if (dataJo != null) {
            JSONArray fields = dataJo.getJSONArray("fields");
            JSONObject resultJo = dataJo.getJSONObject("result");
            String flastUpdateTime = resultJo.getString("flastUpdateTime");
            this.setLastUpdateTimeTips(flastUpdateTime);
            int total = resultJo.getIntValue("total");
            JSONArray records = resultJo.getJSONArray("records");
            this.ctx.getCache().put("total", String.valueOf(total));
            PredictDetailEntryGrid grid = (PredictDetailEntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
            AbstractGrid.GridState entryState = grid.getEntryState();
            int pageRow = grid.getPageRow();
            int startRowIndex = 0;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
            entryEntities.clear();
            int rowCount = total;
            dataEntity.getDataEntityState().setEntryRowCount(KEY_ENTRYENTITY, rowCount);
            dataEntity.getDataEntityState().setEntryPageSize(KEY_ENTRYENTITY, pageRow);
            dataEntity.getDataEntityState().setEntryStartRowIndex(KEY_ENTRYENTITY, startRowIndex);
            if (records != null && records.size() > 0 && fields != null && fields.size() > 0) {
                List listColList = fields.toJavaList(ListCol.class);
                for (int i = 0; i < records.size(); ++i) {
                    DynamicObject entryEntity = entryEntities.addNew();
                    JSONObject jo = records.getJSONObject(i);
                    for (ListCol listCol : listColList) {
                        String key = listCol.getId().replace("_lc", "");
                        Object value = jo.getOrDefault((Object)key, null);
                        this.getModel().setValue(listCol.getId(), value, i);
                        if (listCol.getVisible().booleanValue()) continue;
                        this.getView().setVisible(Boolean.FALSE, new String[]{listCol.getId()});
                    }
                }
            }
            this.getPageCache().put("records", JSONObject.toJSONString((Object)records));
            this.getView().updateView(KEY_ENTRYENTITY);
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ENTRYENTITY});
            this.loadSummary(fields, grid);
        }
    }

    private void loadSummary(JSONArray fields, PredictDetailEntryGrid grid) {
        JSONObject summaryJo = this.sfStandardService().getLastDetailSummary(this.ctx.getCurFilterItemQuery());
        if (fields != null && fields.size() > 0) {
            List listColList = fields.toJavaList(ListCol.class);
            for (ListCol listCol : listColList) {
                if (!listCol.getAllowSum().booleanValue()) continue;
                String colId = listCol.getId();
                BigDecimal value = summaryJo.getBigDecimal(this.getColIdWithoutLc(colId));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(colId, value != null ? value.toString() : "");
                grid.setFloatButtomData(map);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        PredictDetailEntryGrid entryGrid = (PredictDetailEntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryGrid.bindData(new BindingContext((Object)this.getModel().getDataEntity(true)));
    }

    private void loadChartData(boolean isInit, StandardFilterItemQuery filterItemQuery, boolean showLoading) {
        if (showLoading) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        }
        if (filterItemQuery == null) {
            filterItemQuery = new StandardFilterItemQuery();
        }
        DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
        String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
        String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
        Date timeStartDate = (Date)this.getModel().getValue(keyTimeStartDate);
        Date timeEndDate = (Date)this.getModel().getValue(keyTimeEndDate);
        if (timeStartDate != null) {
            filterItemQuery.setStartTime(DateFormatUtils.format((Date)timeStartDate, (String)"yyyy-MM-dd"));
        } else {
            filterItemQuery.setStartTime(null);
        }
        if (timeEndDate != null) {
            filterItemQuery.setEndTime(DateFormatUtils.format((Date)timeEndDate, (String)"yyyy-MM-dd"));
        } else {
            filterItemQuery.setEndTime(null);
        }
        filterItemQuery.setFschemeid(this.ctx.getCurModelTypeId());
        filterItemQuery.setSubServiceId(this.ctx.getSubServiceId());
        filterItemQuery.setCurrent(Long.valueOf(1L));
        PredictDetailEntryGrid entryGrid = (PredictDetailEntryGrid)this.getControl(KEY_ENTRYENTITY);
        long size = Long.parseLong(String.valueOf(entryGrid.getPageRow()));
        filterItemQuery.setSize(Long.valueOf(size));
        filterItemQuery.setRequestId(UUID.randomUUID().toString());
        this.getView().getPageCache().put(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, JSONObject.toJSONString((Object)filterItemQuery));
        this.ctx.setCurFilterItemQuery(filterItemQuery);
        if (isInit) {
            this.ctx.setDefaultFilterItemQuery(filterItemQuery);
        }
        this.refreshChartData(filterItemQuery);
        if (showLoading) {
            this.getView().hideLoading();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)KEY_BTN_UN_ONLINE_OK, (CharSequence)callBackId)) {
            if (e.getResult() == MessageBoxResult.Cancel) {
                this.getView().close();
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_BTN_EXPORT) && e.getResult() == MessageBoxResult.Yes) {
            long total = Long.parseLong(this.ctx.getCache().get("total"));
            this.triggerExport(total);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        } else {
            String subServiceId = this.getSubServiceIdWithNoCache();
            JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
            if (dataJa == null || dataJa.size() == 0) {
                e.setCancel(true);
                Object source = e.getSource();
                if (!(source instanceof FormShowParameter)) {
                    return;
                }
                FormShowParameter fsp = (FormShowParameter)source;
                String parentPageId = fsp.getParentPageId();
                IdsPageCache parentCache = new IdsPageCache(parentPageId);
                parentCache.put("is_scheme_online_" + fsp.getFormId(), "false");
                parentCache.saveChanges();
            }
        }
    }

    private void setLastUpdateTimeTips(String lastUpdateTime) {
        Label ftimeLabel = (Label)this.getControl(KEY_LABEL_LASTUPDATETIME);
        Tips tips = new Tips();
        tips.setShowIcon(true);
        tips.setType("text");
        tips.setIconClassName("kdfont kdfont-Toast-tishi");
        tips.setTitle(new LocaleString("\u6570\u636e\u66f4\u65b0\u65f6\u95f4"));
        tips.setContent(new LocaleString(lastUpdateTime));
        ftimeLabel.addTips(tips);
    }

    public void initDimFilters() {
        Container container = (Container)this.getView().getControl(KEY_FLEXFILTERS);
        Map<String, Object> map = this.getValueByKey(this.ctx.getCurModelTypeId());
        SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
        AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
        Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
            for (int i = 0; i < mulbdFilterList.size(); ++i) {
                String fdimid = (String)mulbdFilterList.get(i);
                ArrayList<Map> items = new ArrayList<Map>();
                Ftype ftype = (Ftype)fidFtypeMap.get(fdimid);
                FieldAp fieldAp = this.createDynamicFieldAp(ftype);
                items.add(fieldAp.createControl());
                container.insertControls(i, items);
            }
        }
    }

    private FieldAp createDynamicFieldAp(Ftype ftype) {
        String fid = ftype.getFid();
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fid);
        fieldAp.setKey(fid);
        fieldAp.setName(new LocaleString(ftype.getFname()));
        fieldAp.setFireUpdEvt(true);
        MulBasedataField ba = new MulBasedataField();
        ba.setId(fid);
        ba.setKey(fid);
        ba.setBaseEntityId(ftype.getFentityid());
        ba.setOrgFuncs(ftype.getForgfuncid());
        fieldAp.setField((Field)ba);
        return fieldAp;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        this.getView().getPageCache().put(KEY_MULBD_FILTER_ID_LIST, JSONObject.toJSONString((Object)mulbdFilterList));
        fschemeid = (String)map.get("fschemeid");
        String subServiceId = this.getSubServiceId();
        String fieldsStr = this.getCache().get("fields");
        JSONArray fields = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fieldsStr)) {
            fields = JSONArray.parseArray((String)fieldsStr);
        } else {
            StandardFilterItemQuery standardFilterItemQuery = new StandardFilterItemQuery();
            standardFilterItemQuery.setSubServiceId(subServiceId);
            standardFilterItemQuery.setFschemeid(fschemeid);
            standardFilterItemQuery.setNeedRecord(Boolean.FALSE);
            JSONObject dataJo = this.sfStandardService().getLastDetailList(standardFilterItemQuery);
            fields = dataJo.getJSONArray("fields");
        }
        if (fields != null && fields.size() > 0) {
            ListCol listCol;
            this.getCache().put("fields", JSONObject.toJSONString((Object)fields));
            List listColList = fields.toJavaList(ListCol.class);
            listColList = listColList.stream().filter(col -> col.getId().equalsIgnoreCase(key)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(listColList) && (listCol = (ListCol)listColList.get(0)) != null) {
                TextEdit textEdit;
                String controlType = listCol.getControlType();
                if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                    textEdit = new TextEdit();
                    textEdit.setKey(listCol.getId());
                    textEdit.setEntryKey(KEY_ENTRYENTITY);
                    textEdit.setView(this.getView());
                    e.setControl((Control)textEdit);
                } else if (controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) {
                    BasedataEdit bdMatEdit = new BasedataEdit();
                    bdMatEdit.setKey(listCol.getId());
                    bdMatEdit.setEntryKey(KEY_ENTRYENTITY);
                    bdMatEdit.setView(this.getView());
                    e.setControl((Control)bdMatEdit);
                } else if (controlType.equalsIgnoreCase(CosmicControlType.DECIMAL_EDIT.getId())) {
                    textEdit = new DecimalEdit();
                    textEdit.setKey(listCol.getId());
                    textEdit.setEntryKey(KEY_ENTRYENTITY);
                    textEdit.setView(this.getView());
                    e.setControl((Control)textEdit);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList) && mulbdFilterList.contains(key)) {
            MulBasedataEdit basedataEdit = new MulBasedataEdit();
            basedataEdit.setKey(key);
            basedataEdit.setView(this.getView());
            e.setControl((Control)basedataEdit);
        } else if (KEY_ENTRYENTITY.equals(key)) {
            PredictDetailEntryGrid entryGrid = new PredictDetailEntryGrid();
            entryGrid.setView(this.getView());
            entryGrid.setKey(key);
            entryGrid.setEntryKey(key);
            entryGrid.setSplitPage(true);
            EntryGrid oGrid = (EntryGrid)e.getControl();
            if (oGrid == null) {
                oGrid = (EntryGrid)this.findControl(KEY_ENTRYENTITY);
            }
            if (oGrid != null) {
                if (fields != null && fields.size() > 0) {
                    String colId;
                    List listColList = fields.toJavaList(ListCol.class);
                    for (ListCol listCol : listColList) {
                        colId = listCol.getId();
                        String controlType = listCol.getControlType();
                        if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                            TextEdit textEdit = new TextEdit();
                            textEdit.setKey(listCol.getId());
                            textEdit.setEntryKey(KEY_ENTRYENTITY);
                            textEdit.setView(this.getView());
                            oGrid.getItems().add(textEdit);
                            continue;
                        }
                        if (controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) {
                            BasedataEdit bdMatEdit = new BasedataEdit();
                            bdMatEdit.setKey(colId);
                            bdMatEdit.setEntryKey(KEY_ENTRYENTITY);
                            bdMatEdit.setView(this.getView());
                            oGrid.getItems().add(bdMatEdit);
                            continue;
                        }
                        if (!controlType.equalsIgnoreCase(CosmicControlType.DECIMAL_EDIT.getId())) continue;
                        DecimalEdit decimalEdit = new DecimalEdit();
                        decimalEdit.setKey(colId);
                        decimalEdit.setEntryKey(KEY_ENTRYENTITY);
                        decimalEdit.setView(this.getView());
                        oGrid.getItems().add(decimalEdit);
                    }
                    for (ListCol listCol : listColList) {
                        colId = listCol.getId();
                        String lastdim = (String)mulbdFilterList.get(mulbdFilterList.size() - 1);
                        if (this.getColIdWithoutLc(colId).equalsIgnoreCase(lastdim)) {
                            oGrid.setColumnProperty(colId, ClientProperitesEnum.LN.getId(), (Object)Boolean.TRUE);
                        }
                        oGrid.setColumnProperty(colId, ClientProperitesEnum.FILTER.getId(), (Object)listCol.getAllowFilter());
                        oGrid.setColumnProperty(colId, ClientProperitesEnum.SORT.getId(), (Object)listCol.getAllowOrder());
                        oGrid.setColumnProperty(colId, ClientProperitesEnum.SUM.getId(), (Object)(listCol.getAllowSum() != false ? YesNoEnum.YES.getKey() : YesNoEnum.NO.getKey()));
                    }
                }
                entryGrid.getItems().addAll(oGrid.getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private String getColIdWithoutLc(String colId) {
        return colId.replace("_lc", "");
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    private Map<String, Object> getValueByKey(String fschemeid) {
        Map<String, Object> map = this.getValueMap();
        if (map != null) {
            for (String key : map.keySet()) {
                if (key.equalsIgnoreCase(KEY_MULBD_FILTER_ID_LIST)) {
                    List mulbdFilterList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)map.get(KEY_MULBD_FILTER_ID_LIST)), String.class);
                    map.put(KEY_MULBD_FILTER_ID_LIST, mulbdFilterList);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_SCHEME_CONFIG)) {
                    SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_SCHEME_CONFIG)), SchemeConfig.class);
                    map.put(KEY_SCHEME_CONFIG, schemeConfig);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_APP_CONFIG)) {
                    AppConfig appConfig = (AppConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_APP_CONFIG)), AppConfig.class);
                    map.put(KEY_APP_CONFIG, appConfig);
                    continue;
                }
                if (!key.equalsIgnoreCase("fschemeid")) continue;
                map.put("fschemeid", map.get("fschemeid"));
            }
            return map;
        }
        map = new HashMap<String, Object>(4);
        String subServiceId = this.getSubServiceIdWithNoCache();
        JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
        List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)fschemeid) && CollectionUtils.isNotEmpty((Collection)sfOnlineSchemeList)) {
            fschemeid = String.valueOf(((SfOnlineScheme)sfOnlineSchemeList.get(0)).getFschemeid());
        }
        Integer finalFschemeid = Integer.parseInt(fschemeid);
        SfOnlineScheme sfOnlineScheme = sfOnlineSchemeList.stream().filter(e1 -> e1.getFschemeid().equals(finalFschemeid)).findFirst().get();
        AppConfig appConfig = this.getAppConfig(subServiceId);
        String fconfigTag = sfOnlineScheme.getFconfigTag();
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
        ArrayList mulbdFilterList = new ArrayList();
        for (DimEnum dim : DimEnum.values()) {
            List fdimidList = schemeConfig.getFidListByDim(dim.getId(), appConfig);
            if (!CollectionUtils.isNotEmpty((Collection)fdimidList)) continue;
            mulbdFilterList.addAll(fdimidList);
        }
        map.put(KEY_MULBD_FILTER_ID_LIST, mulbdFilterList);
        map.put(KEY_SCHEME_CONFIG, schemeConfig);
        map.put(KEY_APP_CONFIG, appConfig);
        map.put("fschemeid", fschemeid);
        this.getCache().put(CACHE_KEY_VALUE_MAP, JSONObject.toJSONString(map));
        return map;
    }

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        EntryAp entryAp = this.createEntryAp(fschemeid);
        mapEntry.put("id", KEY_ENTRYENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        fschemeid = (String)map.get("fschemeid");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        this.registBasedataEntityType(newMainType, fschemeid);
        this.registerEntityType(newMainType, fschemeid);
        e.setNewEntityType(newMainType);
    }

    private void registerEntityType(MainEntityType newMainType, String fschemeid) {
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fschemeid)) {
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(KEY_ENTRYENTITY);
            Map<String, Object> map = this.getValueByKey(fschemeid);
            fschemeid = (String)map.get("fschemeid");
            String subServiceId = this.getSubServiceIdWithNoCache();
            StandardFilterItemQuery standardFilterItemQuery = new StandardFilterItemQuery();
            standardFilterItemQuery.setSubServiceId(subServiceId);
            standardFilterItemQuery.setFschemeid(fschemeid);
            standardFilterItemQuery.setNeedRecord(Boolean.FALSE);
            JSONObject dataJo = this.sfStandardService().getLastDetailList(standardFilterItemQuery);
            JSONArray fields = dataJo.getJSONArray("fields");
            if (fields != null && fields.size() > 0) {
                List listColList = fields.toJavaList(ListCol.class);
                for (ListCol listCol : listColList) {
                    String controlType = listCol.getControlType();
                    if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                        TextProp textProp = new TextProp();
                        textProp.setName(listCol.getId());
                        textProp.setDisplayName(new LocaleString(listCol.getName()));
                        textProp.setDbIgnore(true);
                        textProp.setAlias("");
                        entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
                        continue;
                    }
                    if (controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) {
                        BasedataProp bdMatProp = new BasedataProp();
                        bdMatProp.setDbIgnore(true);
                        bdMatProp.setBaseEntityId(listCol.getBaseEntityId());
                        bdMatProp.setName(listCol.getId());
                        bdMatProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)listCol.getBaseEntityId()));
                        DynamicSimpleProperty pMatRefId = bdMatProp.createRefIDProp();
                        pMatRefId.setPrimaryKey(false);
                        pMatRefId.setName(String.format("%s_id", listCol.getId()));
                        pMatRefId.setDbIgnore(true);
                        bdMatProp.setRefIdProp((IDataEntityProperty)pMatRefId);
                        bdMatProp.setRefIdPropName(String.format("%s_id", listCol.getId()));
                        entryType.registerComplexProperty((DynamicComplexProperty)bdMatProp);
                        entryType.addProperty((DynamicProperty)pMatRefId);
                        continue;
                    }
                    if (!controlType.equalsIgnoreCase(CosmicControlType.DECIMAL_EDIT.getId())) continue;
                    String colId = listCol.getId();
                    DecimalProp textProp = new DecimalProp();
                    textProp.setName(colId);
                    textProp.setDisplayName(new LocaleString(listCol.getName()));
                    textProp.setDbIgnore(true);
                    textProp.setAlias("");
                    textProp.setScale(2);
                    entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
                }
            }
        }
    }

    private void registBasedataEntityType(MainEntityType newMainType, String fschemeid) {
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fschemeid)) {
            Map<String, Object> map = this.getValueByKey(fschemeid);
            SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
            AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
            Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
            List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
            if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
                for (String key : mulbdFilterList) {
                    Ftype ftype = (Ftype)fidFtypeMap.get(key);
                    DynamicObjectType type = new DynamicObjectType(key);
                    type.setDbIgnore(false);
                    this.registerProperties(type, ftype);
                    MulBasedataProp prop = new MulBasedataProp(key, type);
                    prop.setDbIgnore(true);
                    prop.setBaseEntityId(ftype.getFentityid());
                    prop.setName(key);
                    prop.setDbIgnore(true);
                    prop.setDisplayName(new LocaleString(ftype.getFname()));
                    prop.setGroupControl(false);
                    prop.setOrgFunc(ftype.getForgfuncid());
                    newMainType.registerCollectionProperty((DynamicCollectionProperty)prop);
                }
            }
        }
    }

    private void registerProperties(DynamicObjectType type, Ftype ftype) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ftype.getFentityid());
        baseProp.setBaseEntityId(dt.getName());
        baseProp.setAlias("FBasedataId");
        baseProp.setName("fbasedataid");
        baseProp.setDisplayProp("name");
        baseProp.setDisplayName(new LocaleString(ftype.getFname()));
        baseProp.setEditSearchProp("name");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)dt);
        String key_ref = "fbasedataid_id";
        DynamicSimpleProperty refIdProp = baseProp.createRefIDProp();
        refIdProp.setName(key_ref);
        refIdProp.setAlias("FBasedataId");
        refIdProp.setDbIgnore(false);
        baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
        baseProp.setRefIdPropName(key_ref);
        type.registerComplexProperty((DynamicComplexProperty)baseProp);
        type.registerSimpleProperty(refIdProp);
    }
}

