/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.entity.model.sf.std.AppConfig;
import kd.ai.ids.core.entity.model.sf.std.Fdim;
import kd.ai.ids.core.entity.model.sf.std.Ftype;
import kd.ai.ids.core.entity.model.sf.std.ListCol;
import kd.ai.ids.core.entity.model.sf.std.SchemeConfig;
import kd.ai.ids.core.entity.model.sf.std.SfOnlineScheme;
import kd.ai.ids.core.enumtype.ActionEnum;
import kd.ai.ids.core.enumtype.ClientProperitesEnum;
import kd.ai.ids.core.enumtype.DimEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.sf.std.CosmicControlType;
import kd.ai.ids.core.query.data.HomeOverviewQuery;
import kd.ai.ids.core.query.sf.std.DimValuesDTO;
import kd.ai.ids.core.query.sf.std.PreObjCheckQuery;
import kd.ai.ids.core.query.sf.std.PreObjConfigQuery;
import kd.ai.ids.core.query.sf.std.PreObjListQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.DynamicObjectUtils;
import kd.ai.ids.core.utils.MathUtils;
import kd.ai.ids.core.utils.SfAppConfigUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.form.sf.std.CurrPredictObjEntryGrid;
import kd.ai.ids.plugin.tool.ShowTipsTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.log.LogServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictObjConfigFormPlugin
extends BaseFormPlugin
implements TabSelectListener {
    public static final String KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP = "modSchemeSelectMap_";
    public static final String CACHE_KEY_PREDICT_OBJ_CONFIG_LIST_JO = "predictObjConfigListJo";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_COMBO_MOD_SCHEME_SELECT = "combomodschemeselect";
    private static final String KEY_FLEXFILTERS = "flexfilters";
    private static final String KEY_PRE_DIM_LEVEL_NAME_N = "predimlevelname_%s";
    private static final String KEY_PRE_DIM_LEVEL_COUNT_N = "predimlevelcount_%s";
    private static final String KEY_FLEX_DIM_LEVEL_N = "flexdimlevel_%s";
    private static final String KEY_HOME_OVERVIEW_N = "homeoverview_%s";
    private static final String KEY_CURRENT_COUNT = "currentcount";
    private static final String KEY_CONTROL_FORGID = "forgid";
    private static final String KEY_TABPAGE_PREDICT = "tabpage_predict";
    private static final String KEY_TABPAGE_CONFIG = "tabpage_config";
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_CONFIG_PREFIX = "config_";
    private static final String[] CONFIG_ENTRY_ENTITY_ALL_DIM_FIELD = new String[]{"forgid", "fwarehouseid", "fcustid", "fmaterialid"};
    private static final String KEY_TOOLBARAP_CONFIG = "toolbarapconfig";
    private static final String KEY_BAR_ITEM_ADD_PREDICT = "baritemaddpredict";
    private static final String KEY_BAR_ITEM_CANCEL_PREDICT = "baritemcancelpredict";
    private static final String KEY_F_PREDIMTYPE_CODE = "fpredimtypecode";
    private static final String KEY_F_IS_PREDICT = "fispredict";
    private static final String KEY_IS_PREDICTED_LIST = "fispredictedlist";
    private static final String KEY_MULBD_FILTER_ID_LIST = "mulbdFilterIdList";
    private static final String KEY_BD_FILTER_ID_LIST = "bdFilterIdList";
    private static final String KEY_SCHEME_CONFIG = "schemeConfig";
    private static final String KEY_APP_CONFIG = "appConfig";
    private static final String KEY_CURRENT_SCHEME = "currentScheme";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String CACHE_KEY_VALUE_MAP = "valueMap";
    private static final String CACHE_KEY_CURRENT_TAB = "currentTab";
    private static final String KEY_CACHE_CURRENT_FILTER_ITEM_QUERY = "currentFilterItemQuery";

    public String getFschemeid() {
        return this.getCache().get("fschemeid");
    }

    public void setFschemeid(String currentFmodeltypeid) {
        this.getView().getPageCache().put("fschemeid", currentFmodeltypeid);
        this.getCache().put("fschemeid", currentFmodeltypeid);
    }

    public PreObjListQuery getCurFilterItemQuery() {
        return (PreObjListQuery)this.getCache().getAsObject(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, PreObjListQuery.class);
    }

    public void setCurFilterItemQuery(PreObjListQuery currentFilterItemQuery) {
        String filter = JSON.toJSONString((Object)currentFilterItemQuery);
        this.getView().getPageCache().put(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, filter);
        this.getCache().put(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, filter);
    }

    private JSONObject getHomeOverviewJo(String fmodeltypeid) {
        JSONObject jo = this.getCache().getAsObject(String.format(KEY_HOME_OVERVIEW_N, fmodeltypeid));
        return jo;
    }

    private String getSubServiceIdWithNoCache() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        return subServiceId;
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private String getSubServiceId() {
        String s = this.getCache().get("subServiceId");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
            TenantDTO tenantDTO = this.getTenantDTO();
            if (tenantDTO != null) {
                s = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
                this.getCache().put("subServiceId", s);
            }
        }
        return s;
    }

    private void setSubServiceId() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getView().getPageCache().put("subServiceId", subServiceId);
        this.getCache().put("subServiceId", subServiceId);
    }

    private boolean isPredictedList() {
        return Boolean.parseBoolean(this.getCache().get(KEY_IS_PREDICTED_LIST));
    }

    private String loadAppConfig(String subServiceId) {
        JSONObject dataJo = this.sfStandardService().appConfigGet(subServiceId);
        JSONObject appConfigJo = dataJo.getJSONObject(KEY_APP_CONFIG);
        String appConfigStr = appConfigJo.toJSONString();
        this.getCache().put(KEY_APP_CONFIG, appConfigStr);
        return appConfigStr;
    }

    private AppConfig getAppConfig(String subServiceId) {
        AppConfig appConfig = null;
        String appConfigStr = this.getCache().get(KEY_APP_CONFIG);
        if (StringUtils.isEmpty((CharSequence)appConfigStr)) {
            appConfigStr = this.loadAppConfig(subServiceId);
        }
        appConfig = (AppConfig)JSONObject.parseObject((String)appConfigStr, AppConfig.class);
        return appConfig;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{KEY_ENTRYENTITY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET});
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP_CONFIG});
    }

    public void itemClick(ItemClickEvent evt) {
        BaseResult baseResult;
        super.itemClick(evt);
        RequestContext rc = RequestContext.get();
        String itemKey = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        DynamicObjectCollection entityDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> fpreobjcodeList = new ArrayList<String>(10);
        boolean hasDifferentStatus = false;
        int fispredict = -1;
        for (int selectRow : selectRows) {
            int tempFispredict;
            DynamicObject dynamicObject = (DynamicObject)entityDoc.get(selectRow);
            fpreobjcodeList.add(dynamicObject.getString("fpreobjcode_lc"));
            String ispredict = dynamicObject.getString("fispredict_lc");
            int n = tempFispredict = StringUtils.equals((CharSequence)ispredict, (CharSequence)"\u662f") ? YesNoEnum.YES.getKey() : YesNoEnum.NO.getKey();
            if (fispredict != -1 && fispredict != tempFispredict) {
                hasDifferentStatus = true;
                break;
            }
            fispredict = tempFispredict;
        }
        if (hasDifferentStatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e00\u81f4\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"Common_Select_Same_Status_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
            return;
        }
        PreObjConfigQuery preObjConfigQuery = new PreObjConfigQuery();
        preObjConfigQuery.setFschemeid(this.getFschemeid());
        preObjConfigQuery.setFuserid(rc.getUid());
        preObjConfigQuery.setFusername(rc.getUserName());
        preObjConfigQuery.setSubServiceId(this.getSubServiceId());
        preObjConfigQuery.setFpreobjcodeList(fpreobjcodeList);
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)KEY_BAR_ITEM_ADD_PREDICT)) {
            preObjConfigQuery.setFaction(ActionEnum.ADD.getId());
            if (fispredict == YesNoEnum.YES.getKey()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52a0\u5165\u9884\u6d4b\u7684\u5bf9\u8c61\u65e0\u9700\u91cd\u590d\u52a0\u5165", (String)"PredictObjConfigFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)KEY_BAR_ITEM_CANCEL_PREDICT)) {
            preObjConfigQuery.setFaction(ActionEnum.DELETE.getId());
            if (fispredict == YesNoEnum.NO.getKey()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u52a0\u5165\u9884\u6d4b\u7684\u5bf9\u8c61\u65e0\u9700\u53d6\u6d88", (String)"PredictObjConfigFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
        }
        if (Objects.equals((baseResult = this.sfStandardService().predictObjConfig(preObjConfigQuery)).getErrcode(), BaseResult.SUCCESS)) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
            ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
            for (String fpredimentypeCode : fpreobjcodeList) {
                LogServiceHelper.addLog((IFormView)this.getView(), (String)itemKey, (String)String.format("\u6807\u8bc6:%s\uff0c\u6210\u529f", fpredimentypeCode));
            }
            if (this.isPredictedList()) {
                this.loadPredictConfigFromRemote(this.getCurFilterItemQuery(), true);
            } else {
                this.loadConfigPredictObjList(true);
            }
        } else {
            this.getView().showErrorNotification(baseResult.getDescriptionCn());
            for (String fpredimentypeCode : fpreobjcodeList) {
                LogServiceHelper.addLog((IFormView)this.getView(), (String)itemKey, (String)String.format("\u6807\u8bc6:%s\uff0c\u5931\u8d25", fpredimentypeCode));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String btnKey = ctl.getKey();
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        String currentTab = tab.getCurrentTab();
        switch (btnKey) {
            case "btnrefresh": {
                if (KEY_TABPAGE_PREDICT.equalsIgnoreCase(currentTab)) {
                    this.loadCurrentPredictObjList(true);
                    break;
                }
                if (!KEY_TABPAGE_CONFIG.equals(currentTab)) break;
                this.loadConfigPredictObjList(false);
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                if (KEY_TABPAGE_PREDICT.equalsIgnoreCase(currentTab)) {
                    this.loadCurrentPredictObjList(true);
                    break;
                }
                if (!KEY_TABPAGE_CONFIG.equals(currentTab)) break;
                this.loadPredictConfigFromRemote(this.getCurFilterItemQuery(), true);
                break;
            }
        }
    }

    private void loadConfigPredictObjList(boolean isResetRefresh) {
        String fpreobjcode = null;
        String emptyDimTypes = "";
        ArrayList<String> fpreobjcodeitemList = new ArrayList<String>();
        Map<String, Object> map = this.getValueByKey(this.getFschemeid());
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        List bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST);
        SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
        AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
        Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
        JSONObject recordJo = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)bdFilterList)) {
            for (String fdimid : bdFilterList) {
                DimValuesDTO dimValuesDTO = new DimValuesDTO();
                dimValuesDTO.setLabelId(fdimid);
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(fdimid);
                if (dynamicObject != null) {
                    Object pkValue = dynamicObject.getPkValue();
                    ArrayList<Object> valueList = new ArrayList<Object>();
                    valueList.add(pkValue);
                    dimValuesDTO.setValues(valueList);
                    fpreobjcodeitemList.add(String.valueOf(pkValue));
                    recordJo.put(fdimid, pkValue);
                    continue;
                }
                String fdimName = ((Ftype)fidFtypeMap.get(fdimid)).getFname();
                emptyDimTypes = StringUtils.isEmpty((CharSequence)emptyDimTypes) ? fdimName : String.format("%s,%s", emptyDimTypes, fdimName);
            }
        }
        MulBasedataDynamicObjectCollection mulbdDoc = null;
        String multypeid = null;
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
            multypeid = (String)mulbdFilterList.get(0);
            mulbdDoc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(multypeid);
        }
        if ((mulbdDoc == null || mulbdDoc.size() == 0) && StringUtils.isNotEmpty(multypeid)) {
            String fdimName = ((Ftype)fidFtypeMap.get(multypeid)).getFname();
            String string = emptyDimTypes = StringUtils.isEmpty((CharSequence)emptyDimTypes) ? fdimName : String.format("%s,%s", emptyDimTypes, fdimName);
        }
        if (StringUtils.isNotEmpty((CharSequence)emptyDimTypes) && !isResetRefresh) {
            String s = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"PredictObjConfigFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(s, emptyDimTypes));
            return;
        }
        fpreobjcode = StringUtils.join(fpreobjcodeitemList, (String)"->");
        JSONObject dataJo = this.getCache().getAsObject(CACHE_KEY_PREDICT_OBJ_CONFIG_LIST_JO);
        JSONObject resultJo = dataJo.getJSONObject("result");
        int total = 0;
        ArrayList<String> fpreobjcodeList = new ArrayList<String>();
        if (mulbdDoc != null && mulbdDoc.size() > 0) {
            total = mulbdDoc.size();
            JSONArray recordJa = new JSONArray();
            for (DynamicObject mulDo : mulbdDoc) {
                Object pkValue = mulDo.getDynamicObject(1).getPkValue();
                String newFpreobjcode = String.format("%s%s%s", fpreobjcode, "->", pkValue);
                fpreobjcodeList.add(newFpreobjcode);
                JSONObject newRecordJo = JSONObject.parseObject((String)recordJo.toJSONString());
                newRecordJo.put("fpreobjcode", (Object)newFpreobjcode);
                newRecordJo.put(multypeid, pkValue);
                recordJa.add((Object)newRecordJo);
            }
            Map<String, Integer> fpreobjcodeFispredictMap = this.getFpreobjcodeFispredictMap(fpreobjcodeList);
            for (Object recordObj : recordJa) {
                JSONObject jo = (JSONObject)recordObj;
                String code = jo.getString("fpreobjcode");
                int isPredict = fpreobjcodeFispredictMap != null ? fpreobjcodeFispredictMap.getOrDefault(code, 0) : 0;
                jo.put(KEY_F_IS_PREDICT, (Object)(isPredict == YesNoEnum.YES.getKey() ? "\u662f" : "\u5426"));
            }
            resultJo.put("total", (Object)total);
            resultJo.put("size", (Object)20);
            resultJo.put("pages", (Object)(total % 20 == 0 ? total / 20 : total / 20 + 1));
            resultJo.put("records", (Object)recordJa);
        }
        this.loadPredictConfigList(dataJo, false);
    }

    private void loadCurrentPredictObjList(boolean showLoading) {
        List bdFilterList;
        if (showLoading) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        }
        PreObjListQuery preObjListQuery = this.getCurFilterItemQuery();
        ArrayList<DimValuesDTO> dimValuesDTOList = new ArrayList<DimValuesDTO>();
        Map<String, Object> map = this.getValueByKey(this.getFschemeid());
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
            for (String fdimid : mulbdFilterList) {
                DimValuesDTO dimValuesDTO = new DimValuesDTO();
                dimValuesDTO.setLabelId(fdimid);
                MulBasedataDynamicObjectCollection mulbdDoc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(fdimid);
                List valueList = DynamicObjectUtils.getPkValueListFromDoc((DynamicObjectCollection)mulbdDoc);
                dimValuesDTO.setValues(valueList);
                dimValuesDTOList.add(dimValuesDTO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST)))) {
            for (String fdimid : bdFilterList) {
                DimValuesDTO dimValuesDTO = new DimValuesDTO();
                dimValuesDTO.setLabelId(fdimid);
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(fdimid);
                if (dynamicObject == null) continue;
                ArrayList<Object> valueList = new ArrayList<Object>();
                valueList.add(dynamicObject.getPkValue());
                dimValuesDTO.setValues(valueList);
                dimValuesDTOList.add(dimValuesDTO);
            }
        }
        preObjListQuery.setFdimvaluesList(dimValuesDTOList);
        this.loadCurrPreObjListFromRemote(preObjListQuery);
        if (showLoading) {
            this.getView().hideLoading();
        }
    }

    private PreObjListQuery resetQueryCondition() {
        List bdFilterList;
        Map<String, Object> map = this.getValueByKey(this.getFschemeid());
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
            for (Object fdimid : mulbdFilterList) {
                this.getModel().setValue((String)fdimid, null);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST)))) {
            for (String fdimid : bdFilterList) {
                this.getModel().setValue(fdimid, null);
            }
        }
        PreObjListQuery preObjListQuery = this.getCurFilterItemQuery();
        preObjListQuery.setCurrent(Long.valueOf(1L));
        preObjListQuery.setFdimvaluesList(null);
        this.setCurFilterItemQuery(preObjListQuery);
        return preObjListQuery;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_MOD_SCHEME_SELECT)) {
            String fmodeltypeid = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.openPredictObjConfig(fmodeltypeid);
        }
    }

    private void openPredictObjConfig(String fmodeltypeid) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("fschemeid", fmodeltypeid);
        String caption = ResManager.loadKDString((String)"\u914d\u7f6e\u9884\u6d4b\u5bf9\u8c61\u8303\u56f4", (String)"PredictObjConfigFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_PRE_OBJ_CONF.getId());
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        this.getView().showForm(formShowParameter);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOOLBARAP_CONFIG});
        this.setSubServiceId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        String subServiceId = this.getSubServiceId();
        this.loadHomeOverview();
        this.loadOnlineModelTypeList(fschemeid);
        PreObjListQuery preObjListQuery = new PreObjListQuery();
        preObjListQuery.setSubServiceId(subServiceId);
        preObjListQuery.setFschemeid(fschemeid);
        this.initDimFilters();
        this.loadCurrPreObjListFromRemote(preObjListQuery);
    }

    private void loadPredictConfigFromRemote(PreObjListQuery preObjListQuery, boolean showLoading) {
        if (showLoading) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        }
        this.setCurFilterItemQuery(preObjListQuery);
        JSONObject predictObjConfigListJo = this.sfStandardService().getPredictObjConfigList(preObjListQuery);
        this.getCache().put(CACHE_KEY_PREDICT_OBJ_CONFIG_LIST_JO, JSONObject.toJSONString((Object)predictObjConfigListJo));
        this.loadPredictConfigList(predictObjConfigListJo, true);
        if (showLoading) {
            this.getView().hideLoading();
        }
    }

    private void loadPredictConfigList(JSONObject predictObjConfigListJo, boolean isPredicted) {
        this.getCache().put(KEY_IS_PREDICTED_LIST, String.valueOf(isPredicted));
        this.showPreObjList(predictObjConfigListJo);
    }

    private Map<String, Integer> getFpreobjcodeFispredictMap(List<String> fpredimtypeCodeList) {
        HashMap<String, Integer> fpreobjcodeFispredictMap = new HashMap<String, Integer>();
        PreObjCheckQuery preObjCheckQuery = new PreObjCheckQuery();
        preObjCheckQuery.setFpreobjcodeList(fpredimtypeCodeList);
        preObjCheckQuery.setFschemeid(this.getFschemeid());
        preObjCheckQuery.setSubServiceId(this.getSubServiceId());
        JSONArray dataJa = this.sfStandardService().predictObjCheck(preObjCheckQuery);
        if (dataJa != null && dataJa.size() > 0) {
            for (Object obj : dataJa) {
                JSONObject itemJo = (JSONObject)obj;
                fpreobjcodeFispredictMap.put(itemJo.getString("fpreobjcode"), itemJo.getIntValue(KEY_F_IS_PREDICT));
            }
        }
        return fpreobjcodeFispredictMap;
    }

    private void loadOnlineModelTypeList(String fmodeltypeid) {
        JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(this.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_MOD_SCHEME_SELECT);
        int len = sfOnlineSchemeList.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, String> modSchemeSelectMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)sfOnlineSchemeList.get(i);
            String modelTypeId = String.valueOf(sfOnlineScheme.getFschemeid());
            if (StringUtils.isEmpty((CharSequence)fmodeltypeid)) {
                fmodeltypeid = modelTypeId;
            }
            modSchemeSelectMap.put(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, JSONObject.toJSONString((Object)sfOnlineScheme));
            LocaleString comboItemText = new LocaleString(sfOnlineScheme.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, modelTypeId);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(modSchemeSelectMap);
        this.setFschemeid(fmodeltypeid);
        this.loadModelSummary(fmodeltypeid);
        this.getModel().setValue(KEY_COMBO_MOD_SCHEME_SELECT, (Object)fmodeltypeid);
    }

    private void loadHomeOverview() {
        RequestContext rc = RequestContext.get();
        HomeOverviewQuery homeOverviewQuery = new HomeOverviewQuery();
        homeOverviewQuery.setSubServiceId(this.getSubServiceId());
        BaseResult baseResult = this.sfStandardService().getHomeOverview(Long.valueOf(rc.getOrgId()), homeOverviewQuery);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            int modelCount;
            JSONArray dataJa = baseResult.getDataAsJSONArray();
            int n = modelCount = dataJa != null ? dataJa.size() : 0;
            if (dataJa != null && modelCount > 0) {
                for (int index = 0; index < dataJa.size(); ++index) {
                    JSONObject jo = (JSONObject)dataJa.get(index);
                    String fmodeltypeid = jo.getString("fschemeid");
                    JSONObject homeOverviewJo = jo.getJSONObject("fhomeoverview");
                    if (homeOverviewJo == null) continue;
                    this.getCache().put(String.format(KEY_HOME_OVERVIEW_N, fmodeltypeid), homeOverviewJo.toJSONString());
                }
            }
        }
    }

    private Map<String, Object> getValueMap() {
        return (Map)this.getCache().getAsObject(CACHE_KEY_VALUE_MAP, Map.class);
    }

    private void loadModelSummary(String fmodeltypeid) {
        int i;
        Map<String, Object> map = this.getValueByKey(fmodeltypeid);
        SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
        AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
        Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
        List ftypeidList = schemeConfig.getAllFtypeidList(appConfig);
        JSONObject homeOverviewJo = this.getHomeOverviewJo(fmodeltypeid);
        int dimCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)ftypeidList)) {
            dimCount = ftypeidList.size();
            for (i = 0; i < dimCount; ++i) {
                String ftypeid = (String)ftypeidList.get(i);
                Ftype ftype = (Ftype)fidFtypeMap.get(ftypeid);
                String labelId = ftype.getFid();
                String labelName = ftype.getFname();
                this.setLabelText(String.format(KEY_PRE_DIM_LEVEL_NAME_N, i + 1), String.format("\u9884\u6d4b%s\uff1a", labelName));
                this.setLabelText(String.format(KEY_PRE_DIM_LEVEL_COUNT_N, i + 1), String.valueOf(homeOverviewJo.getIntValue(String.format("%sCount", labelId))));
            }
        }
        this.setLabelText(KEY_CURRENT_COUNT, MathUtils.normalNum((String)homeOverviewJo.getString("currentCount")));
        for (i = 0; i < 5; ++i) {
            this.getView().setVisible(Boolean.valueOf(dimCount >= i + 1), new String[]{String.format(KEY_FLEX_DIM_LEVEL_N, i + 1)});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView formView = (IFormView)e.getSource();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        EntryAp entryAp = this.createEntryAp(fschemeid);
        CurrPredictObjEntryGrid entryGrid = (CurrPredictObjEntryGrid)formView.getControl(KEY_ENTRYENTITY);
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(formView);
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CurrPredictObjEntryGrid entryGrid = (CurrPredictObjEntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryGrid.bindData(new BindingContext((Object)this.getModel().getDataEntity(true)));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getView().getPageCache().put(CACHE_KEY_CURRENT_TAB, tabKey);
        this.resetQueryCondition();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TABPAGE_PREDICT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOOLBARAP_CONFIG});
            HashMap<String, Boolean> metadata = new HashMap<String, Boolean>();
            metadata.put("selchexkbox", Boolean.FALSE);
            metadata.put("ismul", Boolean.TRUE);
            this.getView().updateControlMetadata(KEY_ENTRYENTITY, metadata);
            this.loadCurrentPredictObjList(false);
        } else if (StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TABPAGE_CONFIG)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TOOLBARAP_CONFIG});
            HashMap<String, Boolean> metadata = new HashMap<String, Boolean>();
            metadata.put("selchexkbox", Boolean.TRUE);
            metadata.put("ismul", Boolean.TRUE);
            this.getView().updateControlMetadata(KEY_ENTRYENTITY, metadata);
            PreObjListQuery preObjListQuery = this.getCurFilterItemQuery();
            preObjListQuery.setCurrent(Long.valueOf(1L));
            preObjListQuery.setFdimvaluesList(null);
            this.loadPredictConfigFromRemote(preObjListQuery, false);
        }
    }

    private void loadCurrPreObjListFromRemote(PreObjListQuery preObjListQuery) {
        this.setCurFilterItemQuery(preObjListQuery);
        JSONObject dataJo = this.sfStandardService().getCurrPredictObjList(preObjListQuery);
        this.showPreObjList(dataJo);
    }

    private void showPreObjList(JSONObject dataJo) {
        if (dataJo != null) {
            JSONArray fields = dataJo.getJSONArray("fields");
            JSONObject resultJo = dataJo.getJSONObject("result");
            int total = resultJo.getIntValue("total");
            JSONArray records = resultJo.getJSONArray("records");
            CurrPredictObjEntryGrid grid = (CurrPredictObjEntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
            AbstractGrid.GridState entryState = grid.getEntryState();
            Map entryFilter = entryState.getEntryFilter();
            String columnQFilter = entryState.getColumnQFilter();
            int pageRow = grid.getPageRow();
            int startRowIndex = 0;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
            entryEntities.clear();
            int rowCount = total;
            dataEntity.getDataEntityState().setEntryRowCount(KEY_ENTRYENTITY, rowCount);
            dataEntity.getDataEntityState().setEntryPageSize(KEY_ENTRYENTITY, pageRow);
            dataEntity.getDataEntityState().setEntryStartRowIndex(KEY_ENTRYENTITY, startRowIndex);
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
            if (records != null && records.size() > 0 && fields != null && fields.size() > 0) {
                List listColList = fields.toJavaList(ListCol.class);
                for (int i = 0; i < records.size(); ++i) {
                    DynamicObject entryEntity = entryEntities.addNew();
                    JSONObject jo = records.getJSONObject(i);
                    for (ListCol listCol : listColList) {
                        String key = listCol.getId().replace("_lc", "");
                        Object value = jo.getOrDefault((Object)key, null);
                        this.getModel().setValue(listCol.getId(), value, i);
                        this.getView().setVisible(listCol.getVisible(), new String[]{listCol.getId()});
                    }
                }
            }
            this.getView().updateView(KEY_ENTRYENTITY);
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ENTRYENTITY});
        }
    }

    public void initDimFilters() {
        FieldAp fieldAp;
        Ftype ftype;
        Container container = (Container)this.getView().getControl(KEY_FLEXFILTERS);
        ArrayList<Map> items = new ArrayList<Map>();
        Map<String, Object> map = this.getValueByKey(this.getFschemeid());
        SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
        AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
        Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        List bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST);
        if (CollectionUtils.isNotEmpty((Collection)bdFilterList)) {
            for (String fdimid : bdFilterList) {
                ftype = (Ftype)fidFtypeMap.get(fdimid);
                fieldAp = this.createDynamicBdFieldAp(ftype);
                items.add(fieldAp.createControl());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
            for (String fdimid : mulbdFilterList) {
                ftype = (Ftype)fidFtypeMap.get(fdimid);
                fieldAp = this.createDynamicFieldAp(ftype);
                items.add(fieldAp.createControl());
            }
        }
        container.addControls(items);
    }

    private FieldAp createDynamicBdFieldAp(Ftype ftype) {
        String fid = ftype.getFid();
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fid);
        fieldAp.setKey(fid);
        fieldAp.setName(new LocaleString(ftype.getFname()));
        fieldAp.setFireUpdEvt(true);
        BasedataField ba = new BasedataField();
        ba.setId(fid);
        ba.setKey(fid);
        ba.setBaseEntityId(ftype.getFentityid());
        fieldAp.setField((Field)ba);
        return fieldAp;
    }

    private FieldAp createDynamicFieldAp(Ftype ftype) {
        String fid = ftype.getFid();
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fid);
        fieldAp.setKey(fid);
        fieldAp.setName(new LocaleString(ftype.getFname()));
        fieldAp.setFireUpdEvt(true);
        MulBasedataField ba = new MulBasedataField();
        ba.setId(fid);
        ba.setKey(fid);
        ba.setBaseEntityId(ftype.getFentityid());
        ba.setOrgFuncs(ftype.getForgfuncid());
        fieldAp.setField((Field)ba);
        return fieldAp;
    }

    public void onGetControl(OnGetControlArgs e) {
        MulBasedataEdit basedataEdit;
        super.onGetControl(e);
        String key = e.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        List bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST);
        fschemeid = (String)map.get("fschemeid");
        String subServiceId = this.getSubServiceId();
        String fieldsStr = this.getCache().get("fields");
        JSONArray fields = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fieldsStr)) {
            fields = JSONArray.parseArray((String)fieldsStr);
        } else {
            PreObjListQuery preObjListQuery = new PreObjListQuery();
            preObjListQuery.setSubServiceId(subServiceId);
            preObjListQuery.setFschemeid(fschemeid);
            preObjListQuery.setNeedRecord(Boolean.FALSE);
            JSONObject dataJo = this.sfStandardService().getCurrPredictObjList(preObjListQuery);
            fields = dataJo.getJSONArray("fields");
        }
        if (fields != null && fields.size() > 0) {
            ListCol listCol;
            this.getCache().put("fields", JSONObject.toJSONString((Object)fields));
            List listColList = fields.toJavaList(ListCol.class);
            listColList = listColList.stream().filter(col -> col.getId().equalsIgnoreCase(key)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(listColList) && (listCol = (ListCol)listColList.get(0)) != null) {
                String controlType = listCol.getControlType();
                if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                    TextEdit textEdit = new TextEdit();
                    textEdit.setKey(listCol.getId());
                    textEdit.setEntryKey(KEY_ENTRYENTITY);
                    textEdit.setView(this.getView());
                    e.setControl((Control)textEdit);
                } else if (controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) {
                    BasedataEdit bdMatEdit = new BasedataEdit();
                    bdMatEdit.setKey(listCol.getId());
                    bdMatEdit.setEntryKey(KEY_ENTRYENTITY);
                    bdMatEdit.setView(this.getView());
                    e.setControl((Control)bdMatEdit);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList) && mulbdFilterList.contains(key)) {
            basedataEdit = new MulBasedataEdit();
            basedataEdit.setKey(key);
            basedataEdit.setView(this.getView());
            e.setControl((Control)basedataEdit);
        } else if (CollectionUtils.isNotEmpty((Collection)bdFilterList) && bdFilterList.contains(key)) {
            basedataEdit = new BasedataEdit();
            basedataEdit.setKey(key);
            basedataEdit.setView(this.getView());
            e.setControl((Control)basedataEdit);
        } else if (KEY_ENTRYENTITY.equals(key)) {
            CurrPredictObjEntryGrid entryGrid = new CurrPredictObjEntryGrid();
            entryGrid.setView(this.getView());
            entryGrid.setKey(key);
            entryGrid.setEntryKey(key);
            entryGrid.setSplitPage(true);
            EntryGrid oGrid = (EntryGrid)e.getControl();
            if (oGrid == null) {
                oGrid = (EntryGrid)this.findControl(KEY_ENTRYENTITY);
            }
            if (oGrid != null) {
                if (fields != null && fields.size() > 0) {
                    String colId;
                    List listColList = fields.toJavaList(ListCol.class);
                    for (ListCol listCol : listColList) {
                        colId = listCol.getId();
                        String controlType = listCol.getControlType();
                        if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                            TextEdit textEdit = new TextEdit();
                            textEdit.setKey(listCol.getId());
                            textEdit.setEntryKey(KEY_ENTRYENTITY);
                            textEdit.setView(this.getView());
                            oGrid.getItems().add(textEdit);
                            continue;
                        }
                        if (!controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) continue;
                        BasedataEdit bdMatEdit = new BasedataEdit();
                        bdMatEdit.setKey(colId);
                        bdMatEdit.setEntryKey(KEY_ENTRYENTITY);
                        bdMatEdit.setView(this.getView());
                        oGrid.getItems().add(bdMatEdit);
                    }
                    for (ListCol listCol : listColList) {
                        colId = listCol.getId();
                        oGrid.setColumnProperty(colId, ClientProperitesEnum.FILTER.getId(), (Object)listCol.getAllowFilter());
                        oGrid.setColumnProperty(colId, ClientProperitesEnum.SORT.getId(), (Object)listCol.getAllowOrder());
                        oGrid.setColumnProperty(colId, ClientProperitesEnum.SUM.getId(), (Object)(listCol.getAllowSum() != false ? YesNoEnum.YES.getKey() : YesNoEnum.NO.getKey()));
                    }
                }
                entryGrid.getItems().addAll(oGrid.getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    private Map<String, Object> getValueByKey(String fschemeid) {
        Map<String, Object> map = this.getValueMap();
        if (map != null) {
            for (String key : map.keySet()) {
                if (key.equalsIgnoreCase(KEY_MULBD_FILTER_ID_LIST)) {
                    List mulbdFilterList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)map.get(KEY_MULBD_FILTER_ID_LIST)), String.class);
                    map.put(KEY_MULBD_FILTER_ID_LIST, mulbdFilterList);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_BD_FILTER_ID_LIST)) {
                    List bdFilterList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)map.get(KEY_BD_FILTER_ID_LIST)), String.class);
                    map.put(KEY_BD_FILTER_ID_LIST, bdFilterList);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_SCHEME_CONFIG)) {
                    SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_SCHEME_CONFIG)), SchemeConfig.class);
                    map.put(KEY_SCHEME_CONFIG, schemeConfig);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_APP_CONFIG)) {
                    AppConfig appConfig = (AppConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_APP_CONFIG)), AppConfig.class);
                    map.put(KEY_APP_CONFIG, appConfig);
                    continue;
                }
                if (key.equalsIgnoreCase("fschemeid")) {
                    map.put("fschemeid", map.get("fschemeid"));
                    continue;
                }
                if (!key.equalsIgnoreCase(KEY_CURRENT_SCHEME)) continue;
                SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_CURRENT_SCHEME)), SfOnlineScheme.class);
                map.put(KEY_CURRENT_SCHEME, sfOnlineScheme);
            }
            return map;
        }
        map = new HashMap<String, Object>(6);
        String subServiceId = this.getSubServiceIdWithNoCache();
        JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
        List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
        if (StringUtils.isEmpty((CharSequence)fschemeid) && CollectionUtils.isNotEmpty((Collection)sfOnlineSchemeList)) {
            fschemeid = String.valueOf(((SfOnlineScheme)sfOnlineSchemeList.get(0)).getFschemeid());
        }
        Integer finalFschemeid = Integer.parseInt(fschemeid);
        SfOnlineScheme sfOnlineScheme = sfOnlineSchemeList.stream().filter(e1 -> e1.getFschemeid().equals(finalFschemeid)).findFirst().get();
        AppConfig appConfig = this.getAppConfig(subServiceId);
        String fconfigTag = sfOnlineScheme.getFconfigTag();
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
        Fdim lastDim = SfAppConfigUtils.getLastDim((AppConfig)appConfig, (String)schemeConfig.getFdatasource(), (String)schemeConfig.getFschemetemplate());
        List mulbdFilterList = new ArrayList();
        ArrayList bdFilterList = new ArrayList();
        for (DimEnum dim : DimEnum.values()) {
            List fdimidList = schemeConfig.getFidListByDim(dim.getId(), appConfig);
            if (dim.getId().equalsIgnoreCase(lastDim.getFid())) {
                if (!CollectionUtils.isNotEmpty((Collection)fdimidList)) continue;
                mulbdFilterList.addAll(fdimidList);
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)fdimidList)) continue;
            bdFilterList.addAll(fdimidList);
        }
        if (mulbdFilterList != null && mulbdFilterList.size() > 1) {
            bdFilterList.add(mulbdFilterList.get(mulbdFilterList.size() - 2));
            mulbdFilterList = mulbdFilterList.subList(1, mulbdFilterList.size());
        }
        map.put(KEY_MULBD_FILTER_ID_LIST, mulbdFilterList);
        map.put(KEY_BD_FILTER_ID_LIST, bdFilterList);
        map.put(KEY_SCHEME_CONFIG, schemeConfig);
        map.put(KEY_APP_CONFIG, appConfig);
        map.put("fschemeid", fschemeid);
        map.put(KEY_CURRENT_SCHEME, sfOnlineScheme);
        this.getCache().put(CACHE_KEY_VALUE_MAP, JSONObject.toJSONString(map));
        return map;
    }

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        EntryAp entryAp = this.createEntryAp(fschemeid);
        mapEntry.put("id", KEY_ENTRYENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    private EntryAp createEntryAp(String fschemeid) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setShowSeq(true);
        Map<String, Object> map = this.getValueByKey(fschemeid);
        fschemeid = (String)map.get("fschemeid");
        String subServiceId = this.getSubServiceIdWithNoCache();
        PreObjListQuery preObjListQuery = new PreObjListQuery();
        preObjListQuery.setSubServiceId(subServiceId);
        preObjListQuery.setFschemeid(fschemeid);
        preObjListQuery.setNeedRecord(Boolean.FALSE);
        JSONObject dataJo = this.sfStandardService().getCurrPredictObjList(preObjListQuery);
        JSONArray fields = dataJo.getJSONArray("fields");
        if (fields != null && fields.size() > 0) {
            List listColList = fields.toJavaList(ListCol.class);
            for (ListCol listCol : listColList) {
                String controlType = listCol.getControlType();
                if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                    EntryFieldAp fieldAp = new EntryFieldAp();
                    fieldAp.setId(listCol.getId());
                    fieldAp.setKey(listCol.getId());
                    fieldAp.setWidth(new LocaleString("120px"));
                    fieldAp.setName(new LocaleString(listCol.getName()));
                    fieldAp.setFireUpdEvt(true);
                    TextField field = new TextField();
                    field.setId(listCol.getId());
                    field.setKey(listCol.getId());
                    fieldAp.setField((Field)field);
                    entryAp.getItems().add(fieldAp);
                    continue;
                }
                if (!controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) continue;
                EntryFieldAp apMat = new EntryFieldAp();
                apMat.setId(listCol.getId());
                apMat.setKey(listCol.getId());
                apMat.setWidth(new LocaleString("120px"));
                apMat.setName(new LocaleString(listCol.getName()));
                BasedataField bdMat = new BasedataField();
                bdMat.setBaseEntityNumber(listCol.getBaseEntityId());
                apMat.setField((Field)bdMat);
                entryAp.getItems().add(apMat);
            }
        }
        return entryAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        fschemeid = (String)map.get("fschemeid");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        this.registBasedataEntityType(newMainType, fschemeid);
        this.registerEntityType(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registerEntityType(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(KEY_ENTRYENTITY);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        fschemeid = (String)map.get("fschemeid");
        String subServiceId = this.getSubServiceIdWithNoCache();
        PreObjListQuery preObjListQuery = new PreObjListQuery();
        preObjListQuery.setSubServiceId(subServiceId);
        preObjListQuery.setFschemeid(fschemeid);
        preObjListQuery.setNeedRecord(Boolean.FALSE);
        JSONObject dataJo = this.sfStandardService().getCurrPredictObjList(preObjListQuery);
        JSONArray fields = dataJo.getJSONArray("fields");
        if (fields != null && fields.size() > 0) {
            List listColList = fields.toJavaList(ListCol.class);
            for (ListCol listCol : listColList) {
                String controlType = listCol.getControlType();
                if (controlType.equalsIgnoreCase(CosmicControlType.TEXT_EDIT.getId())) {
                    TextProp textProp = new TextProp();
                    textProp.setName(listCol.getId());
                    textProp.setDisplayName(new LocaleString(listCol.getName()));
                    textProp.setDbIgnore(true);
                    textProp.setAlias("");
                    entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
                    continue;
                }
                if (!controlType.equalsIgnoreCase(CosmicControlType.BASEDATA_EDIT.getId())) continue;
                BasedataProp bdMatProp = new BasedataProp();
                bdMatProp.setDbIgnore(true);
                bdMatProp.setBaseEntityId(listCol.getBaseEntityId());
                bdMatProp.setName(listCol.getId());
                bdMatProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)listCol.getBaseEntityId()));
                DynamicSimpleProperty pMatRefId = bdMatProp.createRefIDProp();
                pMatRefId.setPrimaryKey(false);
                pMatRefId.setName(String.format("%s_id", listCol.getId()));
                pMatRefId.setDbIgnore(true);
                bdMatProp.setRefIdProp((IDataEntityProperty)pMatRefId);
                bdMatProp.setRefIdPropName(String.format("%s_id", listCol.getId()));
                entryType.registerComplexProperty((DynamicComplexProperty)bdMatProp);
                entryType.addProperty((DynamicProperty)pMatRefId);
            }
        }
    }

    private void registBasedataEntityType(MainEntityType newMainType, String fschemeid) {
        if (StringUtils.isNotEmpty((CharSequence)fschemeid)) {
            List bdFilterList;
            Map<String, Object> map = this.getValueByKey(fschemeid);
            SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
            AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
            Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
            List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
            if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
                for (String key : mulbdFilterList) {
                    Ftype ftype = (Ftype)fidFtypeMap.get(key);
                    DynamicObjectType type = new DynamicObjectType(key);
                    type.setDbIgnore(false);
                    this.registerProperties(type, ftype);
                    MulBasedataProp prop = new MulBasedataProp(key, type);
                    prop.setDbIgnore(true);
                    prop.setBaseEntityId(ftype.getFentityid());
                    prop.setOrgFunc(ftype.getForgfuncid());
                    prop.setName(key);
                    prop.setDbIgnore(true);
                    prop.setDisplayName(new LocaleString(ftype.getFname()));
                    prop.setGroupControl(false);
                    newMainType.registerCollectionProperty((DynamicCollectionProperty)prop);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST)))) {
                for (String key : bdFilterList) {
                    Ftype ftype = (Ftype)fidFtypeMap.get(key);
                    BasedataProp bdMatProp = this.createBasedataProp(newMainType, ftype.getFid(), ftype.getFentityid());
                    newMainType.registerComplexProperty((DynamicComplexProperty)bdMatProp);
                }
            }
        }
    }

    private BasedataProp createBasedataProp(MainEntityType newMainType, String fieldKey, String baseEntityId) {
        BasedataProp bdMatProp = new BasedataProp();
        bdMatProp.setDbIgnore(true);
        bdMatProp.setBaseEntityId(baseEntityId);
        bdMatProp.setName(fieldKey);
        bdMatProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId));
        DynamicSimpleProperty pMatRefId = bdMatProp.createRefIDProp();
        pMatRefId.setPrimaryKey(false);
        pMatRefId.setName(fieldKey + "_id");
        pMatRefId.setDbIgnore(true);
        bdMatProp.setRefIdProp((IDataEntityProperty)pMatRefId);
        bdMatProp.setRefIdPropName(fieldKey + "_id");
        newMainType.addProperty((DynamicProperty)pMatRefId);
        return bdMatProp;
    }

    private void registerProperties(DynamicObjectType type, Ftype ftype) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ftype.getFentityid());
        baseProp.setBaseEntityId(dt.getName());
        baseProp.setAlias("FBasedataId");
        baseProp.setName("fbasedataid");
        baseProp.setDisplayProp("name");
        baseProp.setDisplayName(new LocaleString(ftype.getFname()));
        baseProp.setEditSearchProp("name");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)dt);
        String key_ref = "fbasedataid_id";
        DynamicSimpleProperty refIdProp = baseProp.createRefIDProp();
        refIdProp.setName(key_ref);
        refIdProp.setAlias("FBasedataId");
        refIdProp.setDbIgnore(false);
        baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
        baseProp.setRefIdPropName(key_ref);
        type.registerComplexProperty((DynamicComplexProperty)baseProp);
        type.registerSimpleProperty(refIdProp);
    }
}

