/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.entity.model.DataScore;
import kd.ai.ids.core.entity.model.DataScoreCheckItem;
import kd.ai.ids.core.entity.model.Dataapp;
import kd.ai.ids.core.entity.model.Entity;
import kd.ai.ids.core.entity.model.EntityCatalog;
import kd.ai.ids.core.entity.model.EntityTable;
import kd.ai.ids.core.entity.model.Field;
import kd.ai.ids.core.entity.model.sf.std.AppConfig;
import kd.ai.ids.core.entity.model.sf.std.Fdatasources;
import kd.ai.ids.core.entity.model.sf.std.Fdim;
import kd.ai.ids.core.entity.model.sf.std.Fpricefield;
import kd.ai.ids.core.entity.model.sf.std.Fschemetemplate;
import kd.ai.ids.core.entity.model.sf.std.Ftimefield;
import kd.ai.ids.core.entity.model.sf.std.Ftimegranularity;
import kd.ai.ids.core.entity.model.sf.std.Ftype;
import kd.ai.ids.core.entity.model.sf.std.Fvaluetype;
import kd.ai.ids.core.entity.model.sf.std.SchemeConfig;
import kd.ai.ids.core.entity.model.sf.std.SubserviceInit;
import kd.ai.ids.core.enumtype.DimEnum;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.IncrementFieldEnum;
import kd.ai.ids.core.enumtype.XtypeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataQualityService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.EntityUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TimeLineStyle;
import kd.bos.form.control.Timeline;
import kd.bos.form.control.TimelineContentOption;
import kd.bos.form.control.TimelineLabelOption;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineText;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SchemeConfigFormPlugin
extends BaseFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
BeforeBindDataListener,
WizardStepsListener {
    private static final String KEY_COMBO_DATASOURCE = "combodatasource";
    private static final String KEY_COMBO_TIMEFIELD = "combotimefield";
    private static final String KEY_COMBO_PRICEFIELD = "combopricefield";
    private static final String KEY_TEXT_SCHEMENAME = "tfschemename";
    private static final String KEY_COMBO_SCHEME_TEMPLATE = "comboschemetemplate";
    private static final String KEY_MUL_COMBO_ORG_DIM = "mulcomboorgdim";
    private static final String KEY_RADIO_GROUP_CUST_DIM = "radiogroupcustdim";
    private static final String KEY_COMBO_CUST_STANDARD = "combocuststandard";
    private static final String KEY_RADIO_GROUP_PRODUCT_DIM = "radiogroupproductdim";
    private static final String KEY_COMBO_PRODUCT_STANDARD = "comboproductstandard";
    private static final String KEY_RADIO_GROUP_VALUETYPE = "radiogroupvaluetype";
    private static final String KEY_RADIO_GROUP_TIMEGRANULARITY = "radiogrouptimegranularity";
    private static final String KEY_STEPPER_FPREDICTLENGTH = "stepperfpredictlength";
    private static final String KEY_CHECKBOX_FPREDICTSTRIDE = "checkboxfpredictstride";
    private static final String[] KEY_EDIT_CONTROLS = new String[]{"combodatasource", "combotimefield", "combopricefield", "tfschemename", "comboschemetemplate", "mulcomboorgdim", "radiogroupcustdim", "combocuststandard", "radiogroupproductdim", "comboproductstandard", "radiogroupvaluetype", "radiogrouptimegranularity", "stepperfpredictlength", "checkboxfpredictstride"};
    private static final String KEY_FLEX_ORG_DIM_WRAPPER = "flexorgdimwrapper";
    private static final String KEY_FLEX_CUST_DIM_WRAPPER = "flexcustdimwrapper";
    private static final String KEY_FLEX_PRODUCT_DIM_WRAPPER = "flexproductdimwrapper";
    private static final String KEY_FLEX_CUST_DIM = "flexcustdim";
    private static final String KEY_FLEX_PRODUCT_DIM = "flexproductdim";
    private static final String KEY_FLEX_VALUETYPE = "flexvaluetype";
    private static final String KEY_FLEX_TIMEGRANULARITY = "flextimegranularity";
    private static final String KEY_FLEX_STEP_ACTION = "flexstepaction";
    private static final String KEY_FLEX_SAVE_RESULT = "flexsaveresult";
    private static final String KEY_FLEX_ENABLE_STATUS = "flexenablestatus";
    private static final String KEY_LABELAP_REFRESH_TIME = "labelaprefreshtime";
    private static final Integer REFRESH_TIME = 1000;
    private static final String KEY_FLEX_REFRESH_TIME = "flexrefreshtime";
    private static final String KEY_FLEX_RESULT = "flexresult";
    private static final String KEY_FLEX_PROCESS = "flexprocess";
    private static final String KEY_TIMELINEAP = "timelineap";
    private static final String KEY_UPDATE_REFRESH_TIME = "updateRefreshTime";
    private static final String KEY_EXIST_CUST_DIM_LIST = "existCustDimList";
    private static final String KEY_EXIST_PRODUCT_DIM_LIST = "existProductDimList";
    private static final String KEY_EXIST_VALUETYPE_LIST = "existValuetypeList";
    private static final String KEY_EXIST_TIMEGRANULARITY_LIST = "existTimegranularityList";
    private static final String KEY_CURR_DATASOURCE = "currDatasource";
    private static final String KEY_LAST_DIM_FID = "lastDimFid";
    private static final String KEY_ID = "id";
    private static final String KEY_FIELDTYPE = "fieldtype";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_FIELDNAME = "fieldname";
    private static final String KEY_FIELDCOMMENT = "fieldcomment";
    private static final String KEY_INCREMENTFIELD = "incrementfield";
    private static final String KEY_CUSTOMCONTROLAP = "customcontrolap";
    private static final String KEY_CURRENT_STEP = "currentStep";
    private static final String KEY_CURRENT_STATUS = "currentStatus";
    private static final String PREDICT_TARGET_SCHEME = "predictTargetScheme";
    private static final String STEP_INFO = "stepInfo";
    private static final String KEY_SCORE = "Score";
    private static final String KEY_CHECK_LIST = "checkList";
    private static final String KEY_WIZARDAP = "wizardap";
    private static final String KEY_BTN_PREV = "btnprev";
    private static final String KEY_BTN_NEXT = "btnnext";
    private static final String KEY_BTN_SAVE = "btnsave";
    private static final String KEY_BTN_TOLIST = "btntolist";
    private static final String KEY_BTN_TOLIST2 = "btntolist2";
    private static final String KEY_BTN_ENABLE = "btnenable";
    private static final String KEY_BTN_PROCESS = "btnprocess";
    private static final String KEY_BTN_RETRY = "btnretry";
    private static final String KEY_TAB_GUIDECONTENT = "guidecontent";
    private static final String KEY_TAB_PAGE_AP_1 = "tabpageap1";
    private static final String KEY_TAB_PAGE_AP_2 = "tabpageap2";
    private static final String KEY_TAB_PAGE_AP_3 = "tabpageap3";
    private static final String KEY_TAB_PAGE_AP_4 = "tabpageap4";
    private static final String KEY_LABELAP_ENTITY_BASE_INFO = "labelapentitybaseinfo";
    private static final String KEY_LABELAP_TABLE_BASE_INFO = "labelaptablebaseinfo";
    private static final String KEY_TREEVIEWAP_MODEL = "treeviewapmodel";
    private static final String KEY_LABELAP_DATA_CENTNER = "labelapdatacenter";
    private static final String KEY_LABELAP_BIZ_ORG_COUNT = "labelapbizorgcount";
    private static final String KEY_LABELAP_MATERIAL_GROUP_COUNT = "labelapmaterialgroupcount";
    private static final String KEY_LABELAP_MATERIAL_COUNT = "labelapmaterialcount";
    private static final String KEY_LABELAP_CUSTOMER_COUNT = "labelapcustomercount";
    private static final String KEY_LABELAP_ORDER_COUNT = "labelapordercount";
    private static final String KEY_LABELAP_APP_NAME = "labelapappname";
    private static final String KEY_LABELAP_BIZ_MODULE = "labelapbizmodule";
    private static final String KEY_HTML_APP_DESCRIBE = "htmlapappdescribe";
    private static final String KEY_HTML_BIZOBJ = "htmlapbizobj";
    private static final String KEY_TF_APP_DESCRIBE = "tfappdescribe";
    private static final String KEY_TF_BIZOBJ = "tfbizobj";
    private static final String KEY_ENTITY_NAME_BIZ_ORG = "bos_org";
    private static final String KEY_ENTITY_NAME_MATERIAL_GROUP = "bd_materialgroup";
    private static final String KEY_ENTITY_NAME_MATERIAL = "bd_material";
    private static final String KEY_ENTITY_NAME_CUSTOMER = "bd_customer";
    private static final String KEY_ENTITY_NAME_ORDER = "sm_salorder";
    private static final String KEY_BILLLISTAP_ENTITY_FIELD = "billlistapenityfield";
    private static final String KEY_FLEX_CONFIG = "flexconfig";
    private static final String KEY_FLEX_CONFIG_RESULT = "flexconfigresult";
    private static final String CACHE_KEY_ORG_DIM_REQUIRED = "orgDimRequired";

    private boolean getOrgDimRequired() {
        String s = this.getCache().get(CACHE_KEY_ORG_DIM_REQUIRED);
        return Boolean.parseBoolean(s);
    }

    private String getLastDimFid() {
        return this.getCache().get(KEY_LAST_DIM_FID);
    }

    private String getSubServiceId() {
        String s = this.getCache().get("subServiceId");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
            TenantDTO tenantDTO = this.getTenantDTO();
            if (tenantDTO != null) {
                s = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
                this.setSubServiceId(s);
            }
        }
        return s;
    }

    private String getFschemeid() {
        return this.getCache().get("fschemeid");
    }

    public void setSubServiceId(String subServiceId) {
        this.getCache().put("subServiceId", subServiceId);
    }

    private void putEntityToCache(Map<String, String> data, Entity entity) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)entity);
        o.remove((Object)"children");
        data.put("EntityCache_" + entity.getKey(), o.toJSONString());
    }

    private Entity getEntityFromCache(String entityKey) {
        String s = this.getCache().get("EntityCache_" + entityKey);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return (Entity)JSON.parseObject((String)s, Entity.class);
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_BTN_PREV, KEY_BTN_NEXT, KEY_BTN_SAVE, KEY_BTN_TOLIST, KEY_BTN_TOLIST2, KEY_BTN_ENABLE, KEY_BTN_PROCESS, KEY_BTN_RETRY});
        Wizard wizard = (Wizard)this.getControl(KEY_WIZARDAP);
        wizard.addWizardStepsListener((WizardStepsListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_DATASOURCE)) {
            String datasource = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.datasourceChangeUpdate(datasource);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_SCHEME_TEMPLATE)) {
            String schemetemplate;
            String datasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
            String string = schemetemplate = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            if (StringUtils.isNotEmpty((CharSequence)datasource) && StringUtils.isNotEmpty((CharSequence)schemetemplate)) {
                this.loadDim(datasource, schemetemplate);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_RADIO_GROUP_CUST_DIM)) {
            String custDimValue;
            String string = custDimValue = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            if (DimEnum.CUST.getId().equalsIgnoreCase(this.getLastDimFid()) && StringUtils.isNotEmpty((CharSequence)custDimValue)) {
                this.loadValuetype(custDimValue);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_RADIO_GROUP_PRODUCT_DIM)) {
            String productDimValue;
            String string = productDimValue = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            if (DimEnum.PRODUCT.getId().equalsIgnoreCase(this.getLastDimFid()) && StringUtils.isNotEmpty((CharSequence)productDimValue)) {
                this.loadValuetype(productDimValue);
            }
        }
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnprev": {
                this.setControlVisible(-1);
                break;
            }
            case "btnnext": {
                this.setControlVisible(1);
                break;
            }
            case "btnsave": {
                this.setControlVisible(1);
                break;
            }
            case "btntolist": 
            case "btntolist2": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_APP_CONFIG.getId());
                showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
                this.getView().showForm(showParameter);
                break;
            }
            case "btnenable": 
            case "btnretry": {
                this.modSchemeStatus(YesNoEnum.YES.getKey());
                break;
            }
            case "btnprocess": {
                this.enterProcessManage();
                break;
            }
        }
    }

    private void enterProcessManage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_EXEC_PROCESS.getId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("appId", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode());
        this.getView().showForm(showParameter);
    }

    private void modSchemeStatus(int enable) {
        RequestContext rc;
        if (enable == YesNoEnum.YES.getKey() && !PermissionServiceHelper.checkPermission((Long)(rc = RequestContext.get()).getCurrUserId(), (String)"1ZY6U=RCHA6Y", (String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (String)"4730fc5d000000ac")) {
            this.getView().showErrorNotification(String.format("\u65e0\"%s\"\u7684\"%s\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", IdsFormIdEnum.IDS_SF_SCHEME.getName(), "\u542f\u7528"));
            return;
        }
        String fschemeid = this.getFschemeid();
        DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (QFilter[])new QFilter("number", "=", (Object)fschemeid).toArray());
        schemeDo.set("enable", (Object)String.valueOf(enable));
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDo});
        if (saveObjs != null && saveObjs.length > 0) {
            if (enable == YesNoEnum.YES.getKey()) {
                String fdatasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
                BaseResult baseResult = this.sfStandardService().subServiceInit(this.getSubServiceId(), this.getTenantDTO().getTenantId(), fdatasource);
                if (baseResult.isSuccess()) {
                    this.showEnableStatus();
                } else {
                    this.getView().showErrorNotification(baseResult.getDescriptionCn());
                }
            }
            this.log.info("modSchemeStatus success");
        } else {
            this.log.info("modSchemeStatus fail");
        }
    }

    private void showEnableStatus() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_SAVE_RESULT});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ENABLE_STATUS});
        this.loadSubserviceInitList(false);
    }

    private void showSaveResult() {
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_SAVE_RESULT});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENABLE_STATUS});
    }

    private int loadSubserviceInitList(boolean showLoading) {
        if (showLoading) {
            this.getView().showLoading(new LocaleString("\u67e5\u8be2\u72b6\u6001\u4e2d..."), 1000);
        }
        RequestContext rc = RequestContext.get();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_REFRESH_TIME});
        Timeline timeline = (Timeline)this.getView().getControl(KEY_TIMELINEAP);
        JSONArray subServiceInitNodeArr = this.sfStandardService().getSubsericeInitNodeList(this.getSubServiceId());
        List subserviceInitList = JSONArray.parseArray((String)subServiceInitNodeArr.toJSONString(), SubserviceInit.class);
        int executeStatus = this.getInitExecuteStatus(subserviceInitList);
        if (subserviceInitList != null && subserviceInitList.size() > 0) {
            ArrayList<TimelineOption> newTimelineOptions = new ArrayList<TimelineOption>(subserviceInitList.size());
            for (int i = 0; i < subserviceInitList.size(); ++i) {
                SubserviceInit node = (SubserviceInit)subserviceInitList.get(i);
                TimelineOption timelineOption = new TimelineOption();
                TimelineContentOption contentOption = new TimelineContentOption();
                TimelineText timelineText = new TimelineText();
                String nodeName = node.getNodeName();
                TimeLineStyle timeLineStyle = new TimeLineStyle();
                String color = "#999999";
                String text = String.format("%s\uff08%s\uff09", nodeName, ExecuteStatusEnum.INIT.getName());
                if (node.getExecuteStatus().intValue() == ExecuteStatusEnum.EXECUTING.getKey()) {
                    color = "#5582F3";
                    text = String.format("%s\uff08%s\uff09", nodeName, ExecuteStatusEnum.EXECUTING.getName());
                } else if (node.getExecuteStatus().intValue() == ExecuteStatusEnum.SUCCESS.getKey()) {
                    color = "#1BA854";
                    text = String.format("%s\uff08%s\uff09", nodeName, ExecuteStatusEnum.SUCCESS.getName());
                } else if (node.getExecuteStatus().intValue() == ExecuteStatusEnum.FAIL.getKey()) {
                    color = "#FB2323";
                    text = String.format("%s\uff08%s\uff09", nodeName, ExecuteStatusEnum.FAIL.getName());
                }
                timelineText.setText(new LocaleString(text));
                timeLineStyle.setColor(color);
                timelineText.setStyle(timeLineStyle);
                contentOption.setTimelineContentTitle(timelineText);
                timelineOption.setContent(contentOption);
                TimelineLabelOption labelOption = new TimelineLabelOption();
                labelOption.setTitle(new LocaleString(String.format("\u7b2c%s\u6b65", i + 1)));
                labelOption.setDescription(new LocaleString(""));
                timelineOption.setLabel(labelOption);
                newTimelineOptions.add(timelineOption);
            }
            timeline.setClientTimelineOptions(newTimelineOptions);
        }
        if (executeStatus == ExecuteStatusEnum.EXECUTING.getKey()) {
            this.getCache().put(KEY_LABELAP_REFRESH_TIME, String.valueOf(5));
            this.setLabelText(KEY_LABELAP_REFRESH_TIME, String.valueOf(5));
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_REFRESH_TIME});
            this.getView().addClientCallBack(KEY_UPDATE_REFRESH_TIME, REFRESH_TIME);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_PROCESS, KEY_BTN_RETRY});
        } else if (executeStatus == ExecuteStatusEnum.SUCCESS.getKey()) {
            this.taskExecuteService().syncNeedUpdateTaskList2K3Cloud(this.getTenantDTO(), AppConstants.ADMINISTRATOR_FID.longValue(), rc.getOrgId());
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_RETRY});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_PROCESS});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_PROCESS});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_RETRY});
        }
        return executeStatus;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        RequestContext rc = RequestContext.get();
        String action = e.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)KEY_UPDATE_REFRESH_TIME)) {
            int refreshTime = this.getRefrshTime() - 1;
            this.getCache().put(KEY_LABELAP_REFRESH_TIME, String.valueOf(refreshTime));
            this.setLabelText(KEY_LABELAP_REFRESH_TIME, String.valueOf(refreshTime));
            if (refreshTime > 0) {
                this.getView().addClientCallBack(KEY_UPDATE_REFRESH_TIME, REFRESH_TIME);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_REFRESH_TIME});
                this.loadSubserviceInitList(true);
            }
        }
    }

    public int getRefrshTime() {
        String s = this.getCache().get(KEY_LABELAP_REFRESH_TIME);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Integer.parseInt(s);
        }
        return 5;
    }

    private int getInitExecuteStatus(List<SubserviceInit> subserviceInitList) {
        int executeStatus = ExecuteStatusEnum.FAIL.getKey();
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(subserviceInitList)) {
            Map<Integer, List<SubserviceInit>> subserviceInitListMap = subserviceInitList.stream().collect(Collectors.groupingBy(SubserviceInit::getExecuteStatus));
            List<SubserviceInit> failList = subserviceInitListMap.get(ExecuteStatusEnum.FAIL.getKey());
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(failList)) {
                return ExecuteStatusEnum.FAIL.getKey();
            }
            List<SubserviceInit> initList = subserviceInitListMap.get(ExecuteStatusEnum.INIT.getKey());
            List<SubserviceInit> executingList = subserviceInitListMap.get(ExecuteStatusEnum.EXECUTING.getKey());
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(initList) || !kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(executingList)) {
                return ExecuteStatusEnum.EXECUTING.getKey();
            }
            List<SubserviceInit> successList = subserviceInitListMap.get(ExecuteStatusEnum.SUCCESS.getKey());
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(successList) && successList.size() == subserviceInitList.size()) {
                return ExecuteStatusEnum.SUCCESS.getKey();
            }
        }
        return executeStatus;
    }

    private JSONObject getStepInfo() {
        String s = this.getCache().get(STEP_INFO);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new JSONObject();
        }
        return JSON.parseObject((String)s);
    }

    public void setStepInfo(JSONObject stepInfo) {
        this.getCache().put(STEP_INFO, stepInfo.toJSONString());
    }

    private void loadDataAssessData(TenantDTO tenantDTO) {
        RequestContext rc = RequestContext.get();
        IFormView view = this.getView();
        IDataQualityService dataQualityService = this.dataQualityService();
        int bizOrgCount = dataQualityService.count(KEY_ENTITY_NAME_BIZ_ORG);
        int materialGroupCount = dataQualityService.count(KEY_ENTITY_NAME_MATERIAL_GROUP);
        int materialCount = dataQualityService.count(KEY_ENTITY_NAME_MATERIAL);
        int customerCount = dataQualityService.count(KEY_ENTITY_NAME_CUSTOMER);
        int orderCount = dataQualityService.count(KEY_ENTITY_NAME_ORDER);
        Account account = AccountUtils.getAccountById((String)rc.getAccountId());
        this.setLabelText(KEY_LABELAP_DATA_CENTNER, account.getAccountName());
        this.setLabelText(KEY_LABELAP_BIZ_ORG_COUNT, String.valueOf(bizOrgCount));
        this.setLabelText(KEY_LABELAP_MATERIAL_GROUP_COUNT, String.valueOf(materialGroupCount));
        this.setLabelText(KEY_LABELAP_MATERIAL_COUNT, String.valueOf(materialCount));
        this.setLabelText(KEY_LABELAP_CUSTOMER_COUNT, String.valueOf(customerCount));
        this.setLabelText(KEY_LABELAP_ORDER_COUNT, String.valueOf(orderCount));
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("appId", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode());
        BaseResult baseResult = this.idsServer().getBaseResultByPost(Long.valueOf(rc.getOrgId()), "/ids/clientproxy/dataapp/get", paramsJo);
        Dataapp dataapp = new Dataapp();
        if (baseResult.getData() != null) {
            JSONObject jsonObject = baseResult.getDataAsJSONObject();
            dataapp = (Dataapp)jsonObject.toJavaObject(Dataapp.class);
        }
        String datasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)datasource);
        EntityCatalog entityCatalog = this.dataAppService().getModelData(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), this.dataAppService().getSalesForecastAppIdByPlatformCode());
        String entityNames = mainEntityType.getName();
        if (entityCatalog != null) {
            List entityTableList = EntityUtils.getHeadEntityTableList((EntityCatalog)entityCatalog);
            List entityNameList = entityTableList.stream().map(EntityTable::getName).collect(Collectors.toList());
            entityNames = StringUtils.join(entityNameList, (String)"\u3001");
        }
        Label appNameLabel = (Label)view.getControl(KEY_LABELAP_APP_NAME);
        appNameLabel.setText(dataapp.getAppName());
        Label bizModuleLabel = (Label)view.getControl(KEY_LABELAP_BIZ_MODULE);
        bizModuleLabel.setText(dataapp.getBussinessName());
        this.getModel().setValue(KEY_TF_APP_DESCRIBE, (Object)dataapp.getDescripe());
        this.getModel().setValue(KEY_TF_BIZOBJ, (Object)entityNames);
        CustomControl ctl = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP);
        if (ctl != null) {
            DataScore dataScore = this.dataQualityService().calcScore(KEY_ENTITY_NAME_ORDER);
            HashMap<String, Serializable> model = new HashMap<String, Serializable>();
            Double percent = 100.0;
            DataScoreCheckItem checkItem = new DataScoreCheckItem("aiy_sjlsdjc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u79bb\u6563\u5ea6\u68c0\u6d4b", (String)"ApplicationConfigPlugin_7", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getDispersionScore()), percent);
            DataScoreCheckItem checkItem1 = new DataScoreCheckItem("aiy_sjycjc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\u68c0\u6d4b", (String)"ApplicationConfigPlugin_8", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getOutlierScore()), percent);
            DataScoreCheckItem checkItem2 = new DataScoreCheckItem("aiy_sjqsjc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u7f3a\u5931\u5ea6\u68c0\u6d4b", (String)"ApplicationConfigPlugin_9", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getMissingScore()), percent);
            DataScoreCheckItem checkItem3 = new DataScoreCheckItem("aiy_sjljc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u91cf\u68c0\u6d4b", (String)"ApplicationConfigPlugin_10", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getSizeScore()), percent);
            ArrayList<DataScoreCheckItem> list = new ArrayList<DataScoreCheckItem>();
            list.add(checkItem);
            list.add(checkItem1);
            list.add(checkItem2);
            list.add(checkItem3);
            model.put(KEY_SCORE, Integer.valueOf(dataScore.getScore()));
            model.put(KEY_CHECK_LIST, list);
            ctl.setData(model);
        }
    }

    private void setControlVisible(int stepIndexOffset) {
        TenantDTO tenantDTO = this.getTenantDTO();
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CONFIG});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CONFIG_RESULT});
        JSONObject stepInfo = this.getStepInfo();
        int stepIndex = stepInfo.getIntValue("stepIndex") + stepIndexOffset;
        stepInfo.put("stepIndex", (Object)stepIndex);
        if (stepIndex == 0) {
            Tab tab = (Tab)this.getControl(KEY_TAB_GUIDECONTENT);
            tab.activeTab(KEY_TAB_PAGE_AP_1);
            if (!stepInfo.getBooleanValue("loadedStepIndex0")) {
                stepInfo.put("loadedStepIndex0", (Object)Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_SAVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_NEXT});
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTN_PREV});
        } else if (stepIndex == 1) {
            Tab tab = (Tab)this.getControl(KEY_TAB_GUIDECONTENT);
            tab.activeTab(KEY_TAB_PAGE_AP_2);
            if (!stepInfo.getBooleanValue("loadedStepIndex1")) {
                this.loadDataAssessData(tenantDTO);
                stepInfo.put("loadedStepIndex1", (Object)Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_SAVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_NEXT});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTN_PREV});
        } else if (stepIndex == 2) {
            Tab tab = (Tab)this.getControl(KEY_TAB_GUIDECONTENT);
            tab.activeTab(KEY_TAB_PAGE_AP_3);
            if (!stepInfo.getBooleanValue("loadedStepIndex2")) {
                stepInfo.put("loadedStepIndex2", (Object)Boolean.TRUE);
            }
            String datasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
            String schemetemplate = (String)this.getModel().getValue(KEY_COMBO_SCHEME_TEMPLATE);
            this.loadDim(datasource, schemetemplate);
            this.initSchemeStep2();
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_NEXT});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_SAVE});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTN_SAVE});
        } else if (stepIndex == 3) {
            DynamicObject schemeDo;
            OrmLocaleValue fname = (OrmLocaleValue)this.getModel().getValue(KEY_TEXT_SCHEMENAME);
            if (fname == null || fname.isEmpty() || StringUtils.isEmpty((CharSequence)fname.getLocaleValue())) {
                this.getView().showTipNotification("\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            String forgdims = (String)this.getModel().getValue(KEY_MUL_COMBO_ORG_DIM);
            if (this.getOrgDimRequired() && StringUtils.isEmpty((CharSequence)forgdims)) {
                this.getView().showTipNotification("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec4\u7ec7\u7ef4\u5ea6\u201d\u3002");
                return;
            }
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String isOnline = (String)fsp.getCustomParam("isonline");
            String fschemeid = this.getFschemeid();
            boolean enable = false;
            if (StringUtils.isNotEmpty((CharSequence)fschemeid) && (schemeDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (QFilter[])new QFilter("number", "=", (Object)fschemeid).toArray())) != null) {
                enable = schemeDo.getBoolean("enable");
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)isOnline, (CharSequence)YesNoEnum.YES.getKeyStr()) && !enable) {
                boolean saveResult = this.saveScheme();
                this.log.info("exec saveScheme");
                if (!saveResult) {
                    return;
                }
            } else {
                this.log.info("unexec saveScheme");
            }
            Tab tab = (Tab)this.getControl(KEY_TAB_GUIDECONTENT);
            tab.activeTab(KEY_TAB_PAGE_AP_4);
            if (!stepInfo.getBooleanValue("loadedStepIndex3")) {
                stepInfo.put("loadedStepIndex3", (Object)Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_NEXT, KEY_BTN_SAVE, KEY_FLEX_STEP_ACTION, KEY_FLEX_ENABLE_STATUS});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_PREV});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTN_PREV});
            if (enable) {
                this.showEnableStatus();
            } else {
                this.showSaveResult();
            }
        }
        this.setStepInfo(stepInfo);
    }

    private boolean saveScheme() {
        RequestContext rc = RequestContext.get();
        AppConfig appConfig = this.getAppConfig();
        String subServiceId = this.getSubServiceId();
        String fschemeid = this.getFschemeid();
        OrmLocaleValue fname = (OrmLocaleValue)this.getModel().getValue(KEY_TEXT_SCHEMENAME);
        String fstatus = "C";
        String fenable = YesNoEnum.NO.getKeyStr();
        String fconfig = "\u9884\u6d4b\u65b9\u6848\u914d\u7f6e";
        String fconfigTag = "";
        String fdatasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
        String ftimefield = (String)this.getModel().getValue(KEY_COMBO_TIMEFIELD);
        String fpricefield = (String)this.getModel().getValue(KEY_COMBO_PRICEFIELD);
        String fschemetemplateNumber = (String)this.getModel().getValue(KEY_COMBO_SCHEME_TEMPLATE);
        String forgdims = (String)this.getModel().getValue(KEY_MUL_COMBO_ORG_DIM);
        String fcustdim = (String)this.getModel().getValue(KEY_RADIO_GROUP_CUST_DIM);
        String custstandardStr = (String)this.getModel().getValue(KEY_COMBO_CUST_STANDARD);
        String productstandardStr = (String)this.getModel().getValue(KEY_COMBO_PRODUCT_STANDARD);
        String fproductdim = (String)this.getModel().getValue(KEY_RADIO_GROUP_PRODUCT_DIM);
        String fvaluetype = (String)this.getModel().getValue(KEY_RADIO_GROUP_VALUETYPE);
        String ftimegranularity = (String)this.getModel().getValue(KEY_RADIO_GROUP_TIMEGRANULARITY);
        BigDecimal fpredictlength = (BigDecimal)this.getModel().getValue(KEY_STEPPER_FPREDICTLENGTH);
        int fpredictstride = (Boolean)this.getModel().getValue(KEY_CHECKBOX_FPREDICTSTRIDE) != false ? YesNoEnum.NO.getKey() : YesNoEnum.YES.getKey();
        SchemeConfig schemeConfig = new SchemeConfig();
        schemeConfig.setFdatasource(fdatasource);
        schemeConfig.setFtimefield(ftimefield);
        schemeConfig.setFpricefield(fpricefield);
        schemeConfig.setFschemetemplate(fschemetemplateNumber);
        schemeConfig.setOrg(forgdims != null ? Arrays.asList(StringUtils.split((String)forgdims, (String)",")) : new ArrayList(0));
        schemeConfig.setCust(fcustdim != null ? Arrays.asList(StringUtils.split((String)fcustdim, (String)",")) : new ArrayList(0));
        JSONObject custstandardJo = new JSONObject();
        Ftype custstandardFtype = this.getStandardFtype(appConfig, fdatasource, fschemetemplateNumber, "cust");
        if (custstandardFtype != null) {
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)schemeConfig.getCust()) && custstandardFtype.getFid().equalsIgnoreCase((String)schemeConfig.getCust().get(0))) {
                custstandardJo.put(custstandardFtype.getFid(), custstandardStr != null ? Collections.singletonList(Long.parseLong(custstandardStr)) : new ArrayList(0));
            } else {
                custstandardJo.put(custstandardFtype.getFid(), new ArrayList(0));
            }
        }
        schemeConfig.setCuststandard(custstandardJo);
        schemeConfig.setProduct(fproductdim != null ? Arrays.asList(StringUtils.split((String)fproductdim, (String)",")) : new ArrayList(0));
        JSONObject productstandardJo = new JSONObject();
        Ftype productstandardFtype = this.getStandardFtype(appConfig, fdatasource, fschemetemplateNumber, "product");
        if (productstandardFtype != null) {
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)schemeConfig.getProduct()) && productstandardFtype.getFid().equalsIgnoreCase((String)schemeConfig.getProduct().get(0))) {
                productstandardJo.put(productstandardFtype.getFid(), productstandardStr != null ? Collections.singletonList(Long.parseLong(productstandardStr)) : new ArrayList(0));
            } else {
                productstandardJo.put(productstandardFtype.getFid(), new ArrayList(0));
            }
        }
        schemeConfig.setProductstandard(productstandardJo);
        schemeConfig.setFvaluetype(fvaluetype != null ? Arrays.asList(StringUtils.split((String)fvaluetype, (String)",")) : new ArrayList(0));
        schemeConfig.setFtimegranularity(ftimegranularity != null ? Arrays.asList(StringUtils.split((String)ftimegranularity, (String)",")) : new ArrayList(0));
        schemeConfig.setFpredictlength(fpredictlength.intValue());
        schemeConfig.setFpredictstride(fpredictstride);
        fconfigTag = JSONObject.toJSONString((Object)schemeConfig);
        DynamicObject schemeDo = null;
        if (StringUtils.isEmpty((CharSequence)fschemeid)) {
            if (!this.vaildSuccess(fname, fconfigTag, null)) {
                return false;
            }
            fschemeid = String.valueOf(this.sfStandardService().newSchemeid(subServiceId));
            this.getCache().put("fschemeid", fschemeid);
            schemeDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_SF_SCHEME.getId());
            schemeDo.set("number", (Object)fschemeid);
            schemeDo.set("creator", (Object)rc.getCurrUserId());
            schemeDo.set("createtime", (Object)KDDateUtils.now());
            schemeDo.set("status", (Object)fstatus);
            schemeDo.set("enable", (Object)fenable);
        } else {
            schemeDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (QFilter[])new QFilter("number", "=", (Object)fschemeid).toArray());
            if (!this.vaildSuccess(fname, fconfigTag, schemeDo.getPkValue())) {
                return false;
            }
            if (schemeDo.getBoolean("enable")) {
                this.getView().showTipNotification("\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
                return false;
            }
        }
        schemeDo.set("name", (Object)fname);
        schemeDo.set("modifier", (Object)rc.getCurrUserId());
        schemeDo.set("modifytime", (Object)KDDateUtils.now());
        schemeDo.set("config", (Object)fconfig);
        schemeDo.set("config_tag", (Object)fconfigTag);
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDo});
        if (saveObjs != null && saveObjs.length > 0) {
            return true;
        }
        this.getView().showErrorNotification("\u4fdd\u5b58\u5931\u8d25");
        return false;
    }

    private boolean vaildSuccess(OrmLocaleValue fname, String fconfigTag, Object pkValue) {
        DynamicObject existConfigDo;
        DynamicObject existSchemeDo;
        QFilter nameQFilter = new QFilter("name", "=", (Object)fname.getLocaleValue());
        if (pkValue != null) {
            nameQFilter.and(KEY_ID, "!=", pkValue);
        }
        if ((existSchemeDo = QueryServiceHelper.queryOne((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (String)KEY_ID, (QFilter[])nameQFilter.toArray())) != null) {
            this.getView().showErrorNotification("\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        QFilter configQFilter = new QFilter("config_tag", "=", (Object)fconfigTag);
        if (pkValue != null) {
            configQFilter.and(KEY_ID, "!=", pkValue);
        }
        if ((existConfigDo = QueryServiceHelper.queryOne((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (String)KEY_ID, (QFilter[])configQFilter.toArray())) != null) {
            this.getView().showErrorNotification("\u65b9\u6848\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0");
            return false;
        }
        return true;
    }

    private Ftype getStandardFtype(AppConfig appConfig, String fdatasource, String fschemetemplateNumber, String dimType) {
        Fdim fdim;
        List dimFtypeList;
        Ftype standardFtype = null;
        List fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(fdatasource)).findFirst().get();
        List fschemetemplateList = fdatasources.getFschemetemplate();
        Fschemetemplate fschemetemplate = fschemetemplateList.stream().filter(e -> e.getFid().equalsIgnoreCase(fschemetemplateNumber)).findFirst().get();
        List fdimList = fschemetemplate.getFdim().stream().filter(e -> e.getFid().equalsIgnoreCase(dimType)).collect(Collectors.toList());
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(fdimList) && !kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(dimFtypeList = (fdim = (Fdim)fdimList.get(0)).getFtype().stream().filter(e -> e.isFisgroup()).collect(Collectors.toList()))) {
            standardFtype = (Ftype)dimFtypeList.get(0);
        }
        return standardFtype;
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTN_PREV});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_SAVE, KEY_FLEX_PROCESS, KEY_FLEX_REFRESH_TIME, KEY_BTN_RETRY});
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String fschemeid = (String)fsp.getCustomParam("fschemeid");
        this.getCache().put("fschemeid", fschemeid);
        this.clearEntityFieldBillListData();
        this.loadDatasourceList();
        this.loadPriceFieldList();
        this.initSchemeStep1();
    }

    private void initSchemeStep1() {
        DynamicObject schemeDo;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String fschemeid = this.getFschemeid();
        Boolean canEdit = (Boolean)fsp.getCustomParam("canEdit");
        if (canEdit == null || !canEdit.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, KEY_EDIT_CONTROLS);
        }
        if (StringUtils.isNotEmpty((CharSequence)fschemeid) && (schemeDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (QFilter[])new QFilter("number", "=", (Object)fschemeid).toArray())) != null) {
            String name = schemeDo.getString("name");
            String fconfigTag = schemeDo.getString("config_tag");
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
            this.getModel().setValue(KEY_TEXT_SCHEMENAME, (Object)name);
            this.getModel().setValue(KEY_COMBO_DATASOURCE, (Object)schemeConfig.getFdatasource());
            this.datasourceChangeUpdate(schemeConfig.getFdatasource());
            this.getModel().setValue(KEY_COMBO_TIMEFIELD, (Object)schemeConfig.getFtimefield());
            this.getModel().setValue(KEY_COMBO_PRICEFIELD, (Object)schemeConfig.getFpricefield());
        }
    }

    private void initSchemeStep2() {
        DynamicObject schemeDo;
        String fschemeid = this.getFschemeid();
        if (StringUtils.isNotEmpty((CharSequence)fschemeid) && (schemeDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (QFilter[])new QFilter("number", "=", (Object)fschemeid).toArray())) != null) {
            String fproductstandardid;
            String fcuststandardid;
            String fconfigTag = schemeDo.getString("config_tag");
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
            String fdatasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
            if (!schemeConfig.getFdatasource().equalsIgnoreCase(fdatasource)) {
                return;
            }
            this.getModel().setValue(KEY_COMBO_SCHEME_TEMPLATE, (Object)schemeConfig.getFschemetemplate());
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)schemeConfig.getOrg())) {
                this.getModel().setValue(KEY_MUL_COMBO_ORG_DIM, (Object)StringUtils.join((Iterable)schemeConfig.getOrg(), (String)","));
            }
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)schemeConfig.getCust())) {
                this.getModel().setValue(KEY_RADIO_GROUP_CUST_DIM, (Object)StringUtils.join((Iterable)schemeConfig.getCust(), (String)","));
            }
            if (StringUtils.isNotEmpty((CharSequence)(fcuststandardid = schemeConfig.getStandardId(schemeConfig.getCuststandard())))) {
                this.getModel().setValue(KEY_COMBO_CUST_STANDARD, (Object)fcuststandardid);
            }
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)schemeConfig.getProduct())) {
                this.getModel().setValue(KEY_RADIO_GROUP_PRODUCT_DIM, (Object)StringUtils.join((Iterable)schemeConfig.getProduct(), (String)","));
            }
            if (StringUtils.isNotEmpty((CharSequence)(fproductstandardid = schemeConfig.getStandardId(schemeConfig.getProductstandard())))) {
                this.getModel().setValue(KEY_COMBO_PRODUCT_STANDARD, (Object)fproductstandardid);
            }
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)schemeConfig.getFvaluetype())) {
                this.getModel().setValue(KEY_RADIO_GROUP_VALUETYPE, (Object)StringUtils.join((Iterable)schemeConfig.getFvaluetype(), (String)","));
            }
            if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)schemeConfig.getFtimegranularity())) {
                this.getModel().setValue(KEY_RADIO_GROUP_TIMEGRANULARITY, (Object)StringUtils.join((Iterable)schemeConfig.getFtimegranularity(), (String)","));
            }
            this.getModel().setValue(KEY_STEPPER_FPREDICTLENGTH, (Object)schemeConfig.getFpredictlength());
            this.getModel().setValue(KEY_CHECKBOX_FPREDICTSTRIDE, (Object)(schemeConfig.getFpredictstride() == 0 ? 1 : 0));
        }
    }

    private String loadAppConfig() {
        String appConfigStr = "";
        JSONObject dataJo = this.sfStandardService().appConfigGet(this.getSubServiceId());
        if (dataJo != null) {
            JSONObject appConfigJo = dataJo.getJSONObject("appConfig");
            appConfigStr = appConfigJo.toJSONString();
            this.getCache().put("appConfig", appConfigStr);
        }
        return appConfigStr;
    }

    private AppConfig getAppConfig() {
        AppConfig appConfig = null;
        String appConfigStr = this.getCache().get("appConfig");
        if (StringUtils.isEmpty((CharSequence)appConfigStr)) {
            appConfigStr = this.loadAppConfig();
        }
        appConfig = (AppConfig)JSONObject.parseObject((String)appConfigStr, AppConfig.class);
        return appConfig;
    }

    private void clearEntityFieldBillListData() {
        String datasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
        if (StringUtils.isEmpty((CharSequence)datasource)) {
            DeleteServiceHelper.delete((String)IdsFormIdEnum.IDS_ENTITY_FIELD.getId(), null);
            BillList billList = (BillList)this.getControl(KEY_BILLLISTAP_ENTITY_FIELD);
            if (billList != null) {
                billList.refreshData();
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String entityKey = (String)treeNodeEvent.getNodeId();
        this.log.info("#####treeNodeClick entityKey : {}" + entityKey);
        Entity entity = this.getEntityFromCache(entityKey);
        if (entity != null) {
            this.log.info("##### entity:{}", (Object)JSONObject.toJSONString((Object)entity));
            this.initEntityFieldData(entity);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void update(StepEvent stepEvent) {
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
    }

    private void loadDatasourceList() {
        String defaultValue = null;
        AppConfig appConfig = this.getAppConfig();
        List fdatasourcesList = appConfig.getFdatasources();
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_DATASOURCE);
        int len = fdatasourcesList.size();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            Fdatasources fdatasources = (Fdatasources)fdatasourcesList.get(i);
            LocaleString comboItemText = new LocaleString(fdatasources.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, fdatasources.getFid());
            comboItemList.add(comboItem);
            if (i != 0 && !fdatasources.getFisdefault()) continue;
            defaultValue = fdatasources.getFid();
        }
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue(KEY_COMBO_DATASOURCE, defaultValue);
        this.datasourceChangeUpdate(defaultValue);
    }

    private void datasourceChangeUpdate(String datasource) {
        this.getCache().put(KEY_CURR_DATASOURCE, datasource);
        if (StringUtils.isNotEmpty((CharSequence)datasource)) {
            this.loadTimefieldList(datasource);
            this.loadDatasourceModelData(datasource);
            this.loadSchemeTemplate(datasource);
            this.loadTimegranularity();
        }
    }

    private void loadTimefieldList(String datasource) {
        String defaultValue = null;
        AppConfig appConfig = this.getAppConfig();
        List fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(datasource)).findFirst().get();
        List ftimefieldList = fdatasources.getFtimefield();
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_TIMEFIELD);
        int len = ftimefieldList.size();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            Ftimefield ftimefield = (Ftimefield)ftimefieldList.get(i);
            LocaleString comboItemText = new LocaleString(ftimefield.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, ftimefield.getFid());
            comboItemList.add(comboItem);
            if (i != 0 && !ftimefield.getFisdefault()) continue;
            defaultValue = ftimefield.getFid();
        }
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue(KEY_COMBO_TIMEFIELD, defaultValue);
    }

    private void loadSchemeTemplate(String datasource) {
        String defaultValue = null;
        AppConfig appConfig = this.getAppConfig();
        List fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(datasource)).findFirst().get();
        List fschemetemplateList = fdatasources.getFschemetemplate();
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_SCHEME_TEMPLATE);
        int len = fschemetemplateList.size();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            Fschemetemplate fschemetemplate = (Fschemetemplate)fschemetemplateList.get(i);
            LocaleString comboItemText = new LocaleString(fschemetemplate.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, fschemetemplate.getFid());
            comboItemList.add(comboItem);
            if (i != 0 && !fschemetemplate.getFisdefault()) continue;
            defaultValue = fschemetemplate.getFid();
        }
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue(KEY_COMBO_SCHEME_TEMPLATE, defaultValue);
    }

    private void loadDim(String datasource, String schemetemplate) {
        Fdatasources fdatasources;
        this.clearSelectedDimValue();
        AppConfig appConfig = this.getAppConfig();
        List fdatasourcesList = appConfig.getFdatasources();
        fdatasourcesList = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(datasource)).collect(Collectors.toList());
        Fdatasources fdatasources2 = fdatasources = kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(fdatasourcesList) ? null : (Fdatasources)fdatasourcesList.get(0);
        if (fdatasources != null) {
            Fschemetemplate fschemetemplate;
            List fschemetemplateList = fdatasources.getFschemetemplate();
            Fschemetemplate fschemetemplate2 = fschemetemplate = kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(fschemetemplateList = fschemetemplateList.stream().filter(e -> e.getFid().equalsIgnoreCase(schemetemplate)).collect(Collectors.toList())) ? null : (Fschemetemplate)fschemetemplateList.get(0);
            if (fschemetemplate != null) {
                List fdimList = fschemetemplate.getFdim();
                List orgDimList = fdimList.stream().filter(e -> e.getFid().equalsIgnoreCase(DimEnum.ORG.getId())).collect(Collectors.toList());
                Fdim orgDim = kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(orgDimList) ? null : (Fdim)orgDimList.get(0);
                List custDimList = fdimList.stream().filter(e -> e.getFid().equalsIgnoreCase(DimEnum.CUST.getId())).collect(Collectors.toList());
                Fdim custDim = kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(custDimList) ? null : (Fdim)custDimList.get(0);
                List productDimList = fdimList.stream().filter(e -> e.getFid().equalsIgnoreCase(DimEnum.PRODUCT.getId())).collect(Collectors.toList());
                Fdim productDim = kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(productDimList) ? null : (Fdim)productDimList.get(0);
                Fdim lastDim = (Fdim)fdimList.get(fdimList.size() - 1);
                this.getCache().put(KEY_LAST_DIM_FID, lastDim.getFid());
                List fvaluetypeList = fschemetemplate.getFvaluetype();
                if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)fvaluetypeList)) {
                    this.generateValuetypeRadioItems(fvaluetypeList);
                }
                if (orgDim != null) {
                    this.getCache().put(CACHE_KEY_ORG_DIM_REQUIRED, String.valueOf(true));
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ORG_DIM_WRAPPER});
                    this.generateOrgMulComboItems(orgDim);
                } else {
                    this.getCache().put(CACHE_KEY_ORG_DIM_REQUIRED, String.valueOf(false));
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ORG_DIM_WRAPPER});
                }
                if (custDim != null) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CUST_DIM_WRAPPER});
                    this.generateDimRadioItems(custDim, KEY_FLEX_CUST_DIM, KEY_RADIO_GROUP_CUST_DIM, KEY_EXIST_CUST_DIM_LIST, KEY_COMBO_CUST_STANDARD);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CUST_DIM_WRAPPER});
                }
                if (productDim != null) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PRODUCT_DIM_WRAPPER});
                    this.generateDimRadioItems(productDim, KEY_FLEX_PRODUCT_DIM, KEY_RADIO_GROUP_PRODUCT_DIM, KEY_EXIST_PRODUCT_DIM_LIST, KEY_COMBO_PRODUCT_STANDARD);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PRODUCT_DIM_WRAPPER});
                }
            }
        }
    }

    private void clearSelectedDimValue() {
        this.getModel().setValue(KEY_MUL_COMBO_ORG_DIM, null);
        this.getModel().setValue(KEY_RADIO_GROUP_CUST_DIM, null);
        this.getModel().setValue(KEY_COMBO_CUST_STANDARD, null);
        this.getModel().setValue(KEY_RADIO_GROUP_PRODUCT_DIM, null);
        this.getModel().setValue(KEY_COMBO_PRODUCT_STANDARD, null);
        this.getModel().setValue(KEY_RADIO_GROUP_VALUETYPE, null);
    }

    private void loadValuetype(String ftypefid) {
        Fdatasources fdatasources;
        String lastDimFid = this.getLastDimFid();
        String fdatasource = (String)this.getModel().getValue(KEY_COMBO_DATASOURCE);
        String fschemetemplateNumber = (String)this.getModel().getValue(KEY_COMBO_SCHEME_TEMPLATE);
        AppConfig appConfig = this.getAppConfig();
        List fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources2 = fdatasources = kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(fdatasourcesList = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(fdatasource)).collect(Collectors.toList())) ? null : (Fdatasources)fdatasourcesList.get(0);
        if (fdatasources != null) {
            Fschemetemplate fschemetemplate;
            List fschemetemplateList = fdatasources.getFschemetemplate();
            Fschemetemplate fschemetemplate2 = fschemetemplate = kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(fschemetemplateList = fschemetemplateList.stream().filter(e -> e.getFid().equalsIgnoreCase(fschemetemplateNumber)).collect(Collectors.toList())) ? null : (Fschemetemplate)fschemetemplateList.get(0);
            if (fschemetemplate != null) {
                List fvaluetypeList = fschemetemplate.getFvaluetype();
                List<String> allfvaluetypeidList = fvaluetypeList.stream().map(Fvaluetype::getFid).collect(Collectors.toList());
                this.getView().setVisible(Boolean.TRUE, allfvaluetypeidList.toArray(new String[allfvaluetypeidList.size()]));
                List fdimList = fschemetemplate.getFdim();
                Fdim lastDim = fdimList.stream().filter(e -> e.getFid().equalsIgnoreCase(lastDimFid)).findFirst().get();
                List ftypeList = lastDim.getFtype();
                Ftype ftype = ftypeList.stream().filter(e -> e.getFid().equalsIgnoreCase(ftypefid)).findFirst().get();
                List fvaluetypeidList = ftype.getFvaluetypeid();
                if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)fvaluetypeidList)) {
                    this.getModel().setValue(KEY_RADIO_GROUP_VALUETYPE, fvaluetypeidList.get(0));
                    allfvaluetypeidList.removeAll(fvaluetypeidList);
                }
                if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(allfvaluetypeidList)) {
                    this.getView().setVisible(Boolean.FALSE, allfvaluetypeidList.toArray(new String[allfvaluetypeidList.size()]));
                }
            }
        }
    }

    private void generateValuetypeRadioItems(List<Fvaluetype> fvaluetypeList) {
        String defaultValue = null;
        Container flex = (Container)this.getControl(KEY_FLEX_VALUETYPE);
        ArrayList<String> existDimList = this.getCache().getAsList(KEY_EXIST_VALUETYPE_LIST, String.class);
        if (existDimList != null && !existDimList.isEmpty()) {
            flex.deleteControls(existDimList.toArray(new String[existDimList.size()]));
        }
        existDimList = new ArrayList<String>(fvaluetypeList.size());
        for (int i = 0; i < fvaluetypeList.size(); ++i) {
            Fvaluetype fvaluetype = fvaluetypeList.get(i);
            String fid = fvaluetype.getFid();
            String fname = fvaluetype.getFname();
            existDimList.add(fid);
            Control control = this.getView().getControl(fid);
            if (control == null) {
                FieldAp fieldAp = this.createRadioFieldAp(fid, new LocaleString(fname), KEY_RADIO_GROUP_VALUETYPE);
                fieldAp.setHeight(new LocaleString("18px"));
                flex.addControls(Collections.singletonList(fieldAp.createControl()));
                flex.deleteControls(new String[0]);
            }
            if (i != 0 && !fvaluetype.getFisdefault()) continue;
            defaultValue = fvaluetype.getFid();
        }
        this.getCache().put(KEY_EXIST_VALUETYPE_LIST, existDimList);
        this.getModel().setValue(KEY_RADIO_GROUP_VALUETYPE, defaultValue);
    }

    private void generateOrgMulComboItems(Fdim orgDim) {
        String defaultValue = null;
        List ftypeList = orgDim.getFtype();
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(KEY_MUL_COMBO_ORG_DIM);
        int len = ftypeList.size();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            Ftype ftype = (Ftype)ftypeList.get(i);
            LocaleString comboItemText = new LocaleString(ftype.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, ftype.getFid());
            comboItemList.add(comboItem);
            if (!ftype.getFisdefault()) continue;
            defaultValue = StringUtils.isEmpty((CharSequence)defaultValue) ? ftype.getFid() : String.format("%s,%s", defaultValue, ftype.getFid());
        }
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)ftypeList) && StringUtils.isEmpty(defaultValue)) {
            defaultValue = ((Ftype)ftypeList.get(0)).getFid();
        }
        mulComboEdit.setComboItems(comboItemList);
        this.getModel().setValue(KEY_MUL_COMBO_ORG_DIM, defaultValue);
    }

    private void generateDimRadioItems(Fdim dim, String containerFlexKey, String radioGroupKey, String existCacheKey, String standardComboKey) {
        String defaultValue = null;
        List ftypeList = dim.getFtype();
        Container flex = (Container)this.getControl(containerFlexKey);
        ArrayList<String> existDimList = this.getCache().getAsList(existCacheKey, String.class);
        if (existDimList != null && !existDimList.isEmpty()) {
            String[] keys = existDimList.toArray(new String[existDimList.size()]);
            flex.deleteControls(keys);
        }
        int size = ftypeList != null ? ftypeList.size() : 0;
        existDimList = new ArrayList<String>(size);
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)ftypeList)) {
            for (int i = 0; i < ftypeList.size(); ++i) {
                Ftype ftype = (Ftype)ftypeList.get(i);
                String fid = ftype.getFid();
                String fname = ftype.getFname();
                existDimList.add(fid);
                Control control = this.getView().getControl(fid);
                if (control == null) {
                    FieldAp fieldAp = this.createRadioFieldAp(fid, new LocaleString(fname), radioGroupKey);
                    fieldAp.setHeight(new LocaleString("18px"));
                    flex.addControls(Collections.singletonList(fieldAp.createControl()));
                }
                if (i == 0 || ftype.getFisdefault()) {
                    defaultValue = ftype.getFid();
                }
                if (!ftype.isFisgroup()) continue;
                MainEntityType standardMainEntityType = MetadataServiceHelper.getDataEntityType((String)ftype.getFstandardentityid());
                ComboEdit standardComboEdit = (ComboEdit)this.getControl(standardComboKey);
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
                DynamicObject[] standardDoArr = BusinessDataServiceHelper.load((String)ftype.getFstandardentityid(), (String)"id,number,name", (QFilter[])new QFilter("enable", "=", (Object)YesNoEnum.YES.getKeyStr()).toArray());
                String defaultStandardId = null;
                if (standardDoArr != null && standardDoArr.length > 0) {
                    for (DynamicObject standardDo : standardDoArr) {
                        Object fstandardid = standardDo.get(KEY_ID);
                        String fstandardidStr = fstandardid.toString();
                        ComboItem item = new ComboItem();
                        item.setValue(fstandardidStr);
                        item.setCaption(new LocaleString(standardDo.getString("name")));
                        comboItemList.add(item);
                        if (!StringUtils.isEmpty(defaultStandardId)) continue;
                        defaultStandardId = fstandardidStr;
                    }
                }
                standardComboEdit.setCaption(standardMainEntityType.getDisplayName());
                standardComboEdit.setComboItems(comboItemList);
                this.getModel().setValue(standardComboKey, defaultStandardId);
            }
        }
        this.getCache().put(existCacheKey, existDimList);
        if (dim.getFid().equalsIgnoreCase(this.getLastDimFid())) {
            this.loadValuetype(defaultValue);
        }
        this.getModel().setValue(radioGroupKey, defaultValue);
    }

    private void loadTimegranularity() {
        String defaultValue = null;
        AppConfig appConfig = this.getAppConfig();
        List ftimegranularityList = appConfig.getFtimegranularity();
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)ftimegranularityList)) {
            Container flex = (Container)this.getControl(KEY_FLEX_TIMEGRANULARITY);
            ArrayList<String> existDimList = this.getCache().getAsList(KEY_EXIST_TIMEGRANULARITY_LIST, String.class);
            if (existDimList != null && !existDimList.isEmpty()) {
                flex.deleteControls(existDimList.toArray(new String[existDimList.size()]));
            }
            existDimList = new ArrayList<String>(ftimegranularityList.size());
            for (int i = 0; i < ftimegranularityList.size(); ++i) {
                Ftimegranularity ftimegranularity = (Ftimegranularity)ftimegranularityList.get(i);
                String fid = ftimegranularity.getFid();
                String fname = ftimegranularity.getFname();
                existDimList.add(fid);
                Control control = this.getView().getControl(fid);
                if (control == null) {
                    FieldAp fieldAp = this.createRadioFieldAp(fid, new LocaleString(fname), KEY_RADIO_GROUP_TIMEGRANULARITY);
                    fieldAp.setHeight(new LocaleString("18px"));
                    flex.addControls(Collections.singletonList(fieldAp.createControl()));
                }
                if (i != 0 && !ftimegranularity.getFisdefault()) continue;
                defaultValue = ftimegranularity.getFid();
            }
            this.getCache().put(KEY_EXIST_TIMEGRANULARITY_LIST, existDimList);
            this.getModel().setValue(KEY_RADIO_GROUP_TIMEGRANULARITY, defaultValue);
        }
    }

    private FieldAp createRadioFieldAp(String key, LocaleString name, String radioGroup) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(name);
        fieldAp.setFireUpdEvt(true);
        RadioField radioField = new RadioField();
        radioField.setId(key);
        radioField.setKey(key);
        radioField.setName(name);
        radioField.setGroup(radioGroup);
        radioField.setItems(key);
        fieldAp.setField((kd.bos.metadata.entity.commonfield.Field)radioField);
        fieldAp.setWidth(new LocaleString("80px"));
        return fieldAp;
    }

    private void loadPriceFieldList() {
        String defaultValue = null;
        AppConfig appConfig = this.getAppConfig();
        List fpricefieldList = appConfig.getFpricefield();
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_PRICEFIELD);
        int len = fpricefieldList.size();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            Fpricefield fpricefield = (Fpricefield)fpricefieldList.get(i);
            LocaleString comboItemText = new LocaleString(fpricefield.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, fpricefield.getFid());
            comboItemList.add(comboItem);
            if (i != 0 && !fpricefield.getFisdefault()) continue;
            defaultValue = fpricefield.getFid();
        }
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue(KEY_COMBO_PRICEFIELD, defaultValue);
    }

    private void loadDatasourceModelData(String datasource) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String isOnline = (String)fsp.getCustomParam("isonline");
        if (StringUtils.equalsIgnoreCase((CharSequence)isOnline, (CharSequence)YesNoEnum.YES.getKeyStr())) {
            JSONObject modelJo;
            JSONObject dataJo = this.sfStandardService().appModelGet(this.getSubServiceId(), this.getTenantDTO().getTenantId());
            if (dataJo != null && (modelJo = dataJo.getJSONObject("model")) != null) {
                EntityCatalog entityCatalog = (EntityCatalog)modelJo.toJavaObject(EntityCatalog.class);
                this.loadModelData(entityCatalog);
            }
        } else {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)datasource);
            EntityCatalog entityEntityCatalog = new EntityCatalog();
            entityEntityCatalog.setId(datasource);
            entityEntityCatalog.setText(mainEntityType.getName());
            entityEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
            entityEntityCatalog.setParentid(mainEntityType.getAppId());
            Entity entity = this.tenantModelService().getEntityStructByMainEntityType(entityEntityCatalog, mainEntityType);
            String bizAppNumber = mainEntityType.getBizAppNumber();
            QFilter filter = new QFilter("number", "=", (Object)bizAppNumber);
            DynamicObject bizAppDo = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filter.toArray());
            String bizAppId = bizAppDo.getString(KEY_ID);
            String bizCloudId = bizAppDo.getString("bizcloud");
            DynamicObject bizCloudDo = BizCloudServiceHelp.getBizCloudByID((String)bizCloudId);
            EntityCatalog allEntityCatalog = new EntityCatalog();
            allEntityCatalog.setId("0");
            allEntityCatalog.setParentid("0");
            allEntityCatalog.setText("\u5168\u90e8");
            allEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
            allEntityCatalog.setEntity(null);
            allEntityCatalog.setChildren(null);
            ArrayList<EntityCatalog> bizCloudEntityCatalogList = new ArrayList<EntityCatalog>();
            EntityCatalog bizCloudCatalog = new EntityCatalog();
            bizCloudCatalog.setXtype(XtypeEnum.CATALOG.getKey());
            bizCloudCatalog.setId(bizCloudDo.getString(KEY_ID));
            bizCloudCatalog.setParentid("0");
            bizCloudCatalog.setText(bizCloudDo.getString("name"));
            bizCloudCatalog.setEntity(null);
            ArrayList<EntityCatalog> bizAppEntityCatalogList = new ArrayList<EntityCatalog>();
            EntityCatalog bizAppEntityCatalog = new EntityCatalog();
            bizAppEntityCatalog.setId(bizAppId);
            bizAppEntityCatalog.setParentid(bizCloudId);
            bizAppEntityCatalog.setText(bizAppDo.getString("name"));
            bizAppEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
            bizAppEntityCatalog.setEntity(null);
            ArrayList<EntityCatalog> bizObjectList = new ArrayList<EntityCatalog>();
            EntityCatalog bizObjectEntityCatalog = new EntityCatalog();
            bizObjectEntityCatalog.setId(datasource);
            bizObjectEntityCatalog.setParentid(bizAppId);
            bizObjectEntityCatalog.setText(mainEntityType.getDisplayName().getLocaleValue());
            bizObjectEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
            bizObjectEntityCatalog.setEntity(entity);
            bizObjectEntityCatalog.setChildren(null);
            bizObjectList.add(bizObjectEntityCatalog);
            if (!CollectionUtils.isEmpty(bizObjectList)) {
                bizAppEntityCatalog.setChildren(bizObjectList);
                bizAppEntityCatalogList.add(bizAppEntityCatalog);
            }
            if (!CollectionUtils.isEmpty(bizAppEntityCatalogList)) {
                bizCloudCatalog.setChildren(bizAppEntityCatalogList);
            }
            if (!CollectionUtils.isEmpty((Collection)bizCloudCatalog.getChildren())) {
                bizCloudEntityCatalogList.add(bizCloudCatalog);
            }
            allEntityCatalog.setChildren(bizCloudEntityCatalogList);
            this.loadModelData(allEntityCatalog);
        }
    }

    private void loadModelData(EntityCatalog entityCatalog) {
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        tv.deleteAllNodes();
        String rootId = entityCatalog.getId();
        TreeNode rootNode = new TreeNode(null, rootId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApplicationConfigPlugin_11", (String)"ai-ids-plugin", (Object[])new Object[0]), (Object)Boolean.TRUE);
        rootNode.setIsOpened(true);
        Entity initEntity = null;
        TreeNode initTreeNode = null;
        List bizCloudList = entityCatalog.getChildren();
        HashMap<String, String> cache = new HashMap<String, String>();
        for (EntityCatalog bizCloudEntityCatalog : bizCloudList) {
            TreeNode tn1 = new TreeNode(bizCloudEntityCatalog.getParentid(), bizCloudEntityCatalog.getKey(), bizCloudEntityCatalog.getText(), (Object)Boolean.TRUE);
            tn1.setIcon("folder");
            tn1.setIsOpened(true);
            List appList = bizCloudEntityCatalog.getChildren();
            for (EntityCatalog appEntityCatalog : appList) {
                TreeNode tn2 = new TreeNode(appEntityCatalog.getParentid(), appEntityCatalog.getKey(), appEntityCatalog.getText(), (Object)Boolean.TRUE);
                tn2.setIsOpened(true);
                List entityList = appEntityCatalog.getChildren();
                for (EntityCatalog entityEntityCatalog : entityList) {
                    Entity entity = entityEntityCatalog.getEntity();
                    if (entity == null) continue;
                    String entityKey = entity.getKey();
                    TreeNode tn3 = new TreeNode(entityEntityCatalog.getParentid(), entityKey, entityEntityCatalog.getText(), (Object)Boolean.TRUE);
                    tn2.addChild(tn3);
                    tn3.setIsOpened(true);
                    if (initEntity == null) {
                        initEntity = entity;
                        initTreeNode = tn3;
                        this.initEntityFieldData(initEntity);
                    }
                    entity.setEntityId(entity.getId());
                    this.putEntityToCache(cache, entity);
                    List entityChildrenList = entity.getChildren();
                    if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)entityChildrenList)) continue;
                    for (Entity childrenEntity : entityChildrenList) {
                        childrenEntity.setEntityId(entity.getId());
                        this.putEntityToCache(cache, childrenEntity);
                        List subEntityChildrenList = childrenEntity.getChildren();
                        boolean isParent = !kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)childrenEntity.getChildren());
                        TreeNode tn4 = new TreeNode(entity.getKey(), childrenEntity.getKey(), childrenEntity.getName(), isParent);
                        tn3.addChild(tn4);
                        tn4.setIsOpened(true);
                        if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)subEntityChildrenList)) continue;
                        for (Entity subChildrenEntity : subEntityChildrenList) {
                            subChildrenEntity.setEntityId(entity.getId());
                            this.putEntityToCache(cache, subChildrenEntity);
                            List subSubEntityChildrenList = subChildrenEntity.getChildren();
                            boolean subEntityIsParent = !kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)subSubEntityChildrenList);
                            TreeNode tn5 = new TreeNode(entity.getKey(), subChildrenEntity.getKey(), subChildrenEntity.getName(), subEntityIsParent);
                            tn4.addChild(tn5);
                            tn5.setIsOpened(true);
                        }
                    }
                }
                tn1.addChild(tn2);
            }
            rootNode.addChild(tn1);
        }
        tv.addNode(rootNode);
        tv.setRootVisible(false);
        if (initTreeNode != null) {
            tv.focusNode(initTreeNode);
        }
        this.getCache().put(cache);
    }

    private void initEntityFieldData(Entity entity) {
        if (entity == null) {
            return;
        }
        Label entityBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_ENTITY_BASE_INFO);
        entityBaseInfoLabel.setText(String.format("%s\uff1a%s(%s)", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"ApplicationConfigPlugin_12", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getName(), entity.getId()));
        Label tableBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_TABLE_BASE_INFO);
        tableBaseInfoLabel.setText(String.format("%s\uff1a%s", ResManager.loadKDString((String)"\u8868\u540d", (String)"ApplicationConfigPlugin_13", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getTableName()));
        List fieldList = CommonUtil.emptyIfNull((List)entity.getFields());
        DynamicObject[] dynamicObjects = new DynamicObject[fieldList.size()];
        int dynamicObjectsIndex = 0;
        for (Field field : fieldList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_ENTITY_FIELD.getId());
            dynamicObject.set(KEY_ID, (Object)ID.genLongId());
            dynamicObject.set(KEY_FIELDTYPE, (Object)field.getFieldType());
            dynamicObject.set(KEY_FIELDKEY, (Object)field.getFieldName());
            dynamicObject.set(KEY_FIELDNAME, (Object)field.getKey());
            dynamicObject.set(KEY_FIELDCOMMENT, (Object)field.getName());
            dynamicObject.set(KEY_INCREMENTFIELD, (Object)(StringUtils.equalsIgnoreCase((CharSequence)entity.getIncrementField(), (CharSequence)field.getKey()) ? String.valueOf(IncrementFieldEnum.YES.getKey()) : String.valueOf(IncrementFieldEnum.NO.getKey())));
            dynamicObjects[dynamicObjectsIndex] = dynamicObject;
            ++dynamicObjectsIndex;
        }
        DeleteServiceHelper.delete((String)IdsFormIdEnum.IDS_ENTITY_FIELD.getId(), null);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP_ENTITY_FIELD);
        if (billList != null) {
            billList.refreshData();
        }
    }
}

