/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.job;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.entity.model.TenantExtra;
import kd.ai.ids.core.enumtype.ExecuteTypeEnum;
import kd.ai.ids.core.enumtype.ForceSyncEnum;
import kd.ai.ids.core.enumtype.RetryTypeEnum;
import kd.ai.ids.core.enumtype.TaskTypeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.response.server.TenantModelInfoDTO;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ISfStandardService;
import kd.ai.ids.core.service.ITaskExecuteService;
import kd.ai.ids.core.service.ITenantModelService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.TaskUtils;
import kd.ai.ids.plugin.tool.CommonTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class TaskExecutionJobPlugin
extends AbstractTask {
    private static final Log log = LogFactory.getLog(TaskExecutionJobPlugin.class);
    private final ITaskExecuteService taskExecuteService = (ITaskExecuteService)Services.get(ITaskExecuteService.class);
    private final ITenantService tenantService = (ITenantService)Services.get(ITenantService.class);
    private final IDataappService dataappService = (IDataappService)Services.get(IDataappService.class);
    private final ISfStandardService sfStandardService = (ISfStandardService)Services.get(ISfStandardService.class);

    private Object getOrDefault(Map<String, Object> paramsMap, String key, Object defaultVal) {
        Object o = paramsMap.get(key);
        return o == null ? defaultVal : o;
    }

    public void execute(RequestContext rc, Map<String, Object> paramsMap) throws KDException {
        log.info("#####JobExecutionPlugin execute params: {} \n rc.getTenantId: {}, rc.getAccountId:{}", new Object[]{JSONObject.toJSONString(paramsMap), rc.getTenantId(), rc.getAccountId()});
        long orgId = Long.parseLong(this.getOrDefault(paramsMap, "orgId", 0).toString());
        int taskType = Integer.parseInt(this.getOrDefault(paramsMap, "taskType", TaskTypeEnum.COMMON.getKey()).toString());
        String modelVersionId = this.getOrDefault(paramsMap, "modelVersionId", "").toString();
        String subServiceId = this.getOrDefault(paramsMap, "subServiceId", "").toString();
        String appId = this.getOrDefault(paramsMap, "appId", "").toString();
        String taskName = this.getOrDefault(paramsMap, "taskName", "").toString();
        String taskParamTenantId = this.getOrDefault(paramsMap, "tenantId", "").toString();
        long runByUserId = AppConstants.ADMINISTRATOR_FID;
        Boolean isUnitTest = Boolean.parseBoolean(this.getOrDefault(paramsMap, "isUnitTest", false).toString());
        int retryType = paramsMap.get("retryType") != null ? Integer.parseInt(paramsMap.get("retryType").toString()) : RetryTypeEnum.NORMAL.getKey();
        String executeId = this.getOrDefault(paramsMap, "executeId", "").toString();
        TenantDTO executeTenantDTO = this.tenantService.getTenantDTO(Long.valueOf(orgId), rc.getTenantId(), rc.getAccountId());
        if (executeTenantDTO == null) {
            log.info("#####executeTenantDTO is null with customerId:{}, dbId:{}", (Object)rc.getTenantId(), (Object)rc.getAccountId());
            return;
        }
        if (!isUnitTest.booleanValue() && !StringUtils.equalsIgnoreCase((CharSequence)executeTenantDTO.getTenantId(), (CharSequence)taskParamTenantId)) {
            log.info("#####executeTenantDTO is null OR executeTenantId:{} different from setting taskParamTenantId:{} with paramsMap:{}", new Object[]{executeTenantDTO.getTenantId(), taskParamTenantId, JSONObject.toJSONString(paramsMap)});
            return;
        }
        if (taskType == TaskTypeEnum.COMMON.getKey()) {
            log.info("execute commonTask");
            this.taskExecuteService.syncNeedUpdateTaskList2K3Cloud(executeTenantDTO, runByUserId, orgId);
            this.syncTenantInfo(orgId, executeTenantDTO);
            this.rebuildCommonTask(orgId, runByUserId, executeTenantDTO);
            this.forceSyncTenantModel(orgId, executeTenantDTO, ResManager.loadKDString((String)"\u5b9a\u65f6\u7ef4\u62a4\u4efb\u52a1\u81ea\u52a8\u540c\u6b65\u79df\u6237\u9886\u57df\u6a21\u578b", (String)"TaskExecutionJobPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]));
        } else if (taskType == TaskTypeEnum.UPLOAD.getKey()) {
            log.info("execute uploadTask");
            int executeType = ExecuteTypeEnum.CRONTAB.getKey();
            executeId = UUID.randomUUID().toString();
            this.taskExecuteService.uploadData(Long.valueOf(orgId), modelVersionId, executeTenantDTO, appId, taskName, executeType, runByUserId, null, executeId);
        } else if (taskType == TaskTypeEnum.QUERY.getKey()) {
            log.info("execute queryTask");
            if (!this.dataappService.appIsOnline(Long.valueOf(orgId), executeTenantDTO.getTenantId(), appId)) {
                log.info("The application is not online and queryTask {} interrupted.", (Object)subServiceId);
                return;
            }
            this.taskExecuteService.queryData(Long.valueOf(orgId), subServiceId, appId, executeTenantDTO, taskName, ExecuteTypeEnum.CRONTAB.getKey(), retryType, runByUserId, executeId);
        } else if (taskType == TaskTypeEnum.APP_EXECUTE_CHECK.getKey()) {
            String currDay21Clock = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyy-MM-dd 21:00:00");
            if (KDDateUtils.now().after(KDDateUtils.parseDateTime((String)currDay21Clock))) {
                TaskUtils.deletePlan((String)executeId);
            }
            log.info("execute appExecuteCheckTask");
            if (!this.dataappService.appIsOnline(Long.valueOf(orgId), executeTenantDTO.getTenantId(), appId)) {
                log.info("The application is not online and appExecuteCheckTask {} interrupted.", (Object)executeId);
                return;
            }
            this.taskExecuteService.appExecuteCheck(ExecuteTypeEnum.CRONTAB.getKey(), executeId, orgId, subServiceId, appId, executeTenantDTO, runByUserId);
        }
    }

    private void rebuildCommonTask(long orgId, long runByUserId, TenantDTO executeTenantDTO) {
        TenantExtra tenantExtra = this.tenantService.getTenantExtra(executeTenantDTO.getTenantId());
        if (tenantExtra != null && tenantExtra.getCommonTaskRebuild().intValue() == YesNoEnum.YES.getKey()) {
            TaskUtils.createCommonTask((TenantDTO)executeTenantDTO, (long)runByUserId, (long)orgId);
        }
    }

    private void syncTenantInfo(Long orgId, TenantDTO tenantDTO) {
        IdsParameter idsParameter = ((IIdsParameterService)Services.get(IIdsParameterService.class)).getIdsParameter(orgId);
        String authorityClientId = idsParameter.getAuthorityAppId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
        paramsJo.put("tenantArea", null);
        paramsJo.put("authorityClientId", (Object)authorityClientId);
        String productVersion = CommonTools.getProductVersion();
        if (!StringUtils.equalsIgnoreCase((CharSequence)tenantDTO.getProductVersion(), (CharSequence)productVersion)) {
            paramsJo.put("productVersion", (Object)productVersion);
            paramsJo.put("productVersionUtime", (Object)KDDateFormatUtils.getDateTimeFormat().format(new Date()));
        }
        BaseResult baseResultByPost = ((IIdsServerService)Services.get(IIdsServerService.class)).getBaseResultByPost(orgId, "/ids/ids/tenant/mod/baseInfo", paramsJo);
    }

    private void forceSyncTenantModel(long orgId, TenantDTO tenantDTO, String description) {
        log.info("start forceSyncTenantModel...{}", (Object)tenantDTO.getTenantId());
        TenantModelInfoDTO tenantModelInfoDTO = ((ITenantModelService)Services.get(ITenantModelService.class)).getTenantModelInfo(Long.valueOf(orgId), tenantDTO.getTenantId());
        if (tenantModelInfoDTO != null && tenantModelInfoDTO.getForceSync() != null) {
            int forceSync = tenantModelInfoDTO.getForceSync();
            if (forceSync == ForceSyncEnum.FORCE_UPDATE.getKey() || forceSync == ForceSyncEnum.UPGRADE_FORCE_UPDATE.getKey() && !StringUtils.equalsIgnoreCase((CharSequence)tenantDTO.getProductVersion(), (CharSequence)CommonTools.getProductVersion())) {
                ThreadPools.executeOnceIncludeRequestContext((String)description, () -> ((ITenantModelService)Services.get(ITenantModelService.class)).syncTenantModel(Long.valueOf(orgId), description, tenantDTO.getTenantId(), CommonTools.getProductVersion()));
            }
        } else {
            log.info("#####{} forceSync is 0", (Object)tenantDTO.getTenantId());
        }
        log.info("end forceSyncTenantModel...{}", (Object)tenantDTO.getTenantId());
    }
}

