/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.test;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MserviceTestCaseFormPlugin
extends BaseFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_CLOUD = "cloud";
    private static final String KEY_APP = "app";
    private static final String KEY_SERVICE = "service";
    private static final String KEY_METHOD = "method";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SUBENTRYENTITY = "subentryentity";
    private static final String KEY_ERRCODE = "errcode";
    private static final String KEY_DATA = "data";
    private static final String KEY_DATA_TAG = "data_tag";
    private static final String KEY_DESCRIPTIONCN = "descriptioncn";
    private static final String KEY_TIMECONSUMING = "timeconsuming";
    private static final String KEY_PARAKEY = "parakey";
    private static final String KEY_PARANAME = "paraname";
    private static final String KEY_PARATYPE = "paratype";
    private static final String KEY_PARAVALUE = "paravalue";
    private static final String KEY_PARAVALUE_TAG = "paravalue_tag";
    private static final String KEY_TEST = "test";
    private static final String KEY_OP_NEWENTRY = "newentry";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit methodBD = (BasedataEdit)this.getView().getControl(KEY_METHOD);
        methodBD.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject methodDo;
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_TEST)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject serviceDo = (DynamicObject)this.getModel().getValue(KEY_SERVICE);
            serviceDo = BusinessDataServiceHelper.loadSingle((Object)serviceDo.getPkValue(), (String)IdsFormIdEnum.IDS_MSERVICE_SERVICE.getId());
            DynamicObject methodDo2 = (DynamicObject)this.getModel().getValue(KEY_METHOD);
            String methodNumber = methodDo2.getString("number");
            String cloudId = serviceDo.getDynamicObject(KEY_CLOUD).getString("number");
            cloudId = StringUtils.lowerCase((String)cloudId);
            String appId = serviceDo.getDynamicObject(KEY_APP).getString("number");
            String serviceNumber = serviceDo.getString("number");
            DynamicObjectCollection sceneDoc = dataEntity.getDynamicObjectCollection(KEY_ENTRYENTITY);
            long st = KDDateUtils.now().getTime();
            if (sceneDoc != null && sceneDoc.size() > 0) {
                for (DynamicObject sceneDo : sceneDoc) {
                    sceneDo.set(KEY_TIMECONSUMING, null);
                    DynamicObjectCollection parasDoc = sceneDo.getDynamicObjectCollection(KEY_SUBENTRYENTITY);
                    Object[] paras = null;
                    if (parasDoc != null && parasDoc.size() > 0) {
                        paras = new Object[parasDoc.size()];
                        for (int i = 0; i < parasDoc.size(); ++i) {
                            DynamicObject parasDo = (DynamicObject)parasDoc.get(i);
                            String paratype = parasDo.getString(KEY_PARATYPE);
                            String paravalue = parasDo.getString(KEY_PARAVALUE_TAG);
                            Object paravalueObj = paravalue;
                            if (StringUtils.equalsIgnoreCase((CharSequence)paratype, (CharSequence)"Integer")) {
                                paravalueObj = Integer.parseInt(paravalue);
                            }
                            paras[i] = paravalueObj;
                        }
                    }
                    String result = (String)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceNumber, (String)methodNumber, paras);
                    CustomApiResult customApiResult = (CustomApiResult)JSONObject.parseObject((String)result, CustomApiResult.class);
                    sceneDo.set(KEY_ERRCODE, (Object)customApiResult.getErrorCode());
                    Object data = customApiResult.getData();
                    sceneDo.set(KEY_DATA, (Object)(data != null ? "\u8bf7\u6c42\u7ed3\u679c\u6982\u89c8" : "null"));
                    sceneDo.set(KEY_DATA_TAG, (Object)JSONObject.toJSONString((Object)data));
                    sceneDo.set(KEY_DESCRIPTIONCN, (Object)customApiResult.getMessage());
                    long et = KDDateUtils.now().getTime();
                    sceneDo.set(KEY_TIMECONSUMING, (Object)DateUtils.formatConsuming((Long)(et - st)));
                }
            }
            this.getView().invokeOperation("save");
            this.getView().updateView();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_OP_NEWENTRY) && (methodDo = (DynamicObject)this.getModel().getValue(KEY_METHOD)) != null) {
            this.initMethodParas((Long)methodDo.getPkValue());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject methodDo;
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_METHOD) && (methodDo = (DynamicObject)changeData[0].getNewValue()) != null) {
            this.initMethodParas((Long)methodDo.getPkValue());
        }
    }

    private void initMethodParas(long methodId) {
        DynamicObject methodDo = BusinessDataServiceHelper.loadSingle((Object)methodId, (String)IdsFormIdEnum.IDS_MSERVICE_METHOD.getId());
        DynamicObject serviceDo = methodDo.getDynamicObject(KEY_SERVICE);
        this.getModel().setValue(KEY_SERVICE, (Object)serviceDo);
        DynamicObjectCollection parasDoc = methodDo.getDynamicObjectCollection(KEY_ENTRYENTITY);
        EntryGrid subentryGrid = (EntryGrid)this.getControl(KEY_SUBENTRYENTITY);
        EntryData subentryData = subentryGrid.getEntryData();
        DynamicObject[] subdataEntitys = subentryData.getDataEntitys();
        if (subdataEntitys != null && subdataEntitys.length > 0) {
            this.getModel().deleteEntryData(KEY_SUBENTRYENTITY);
        }
        if (parasDoc != null) {
            this.getModel().batchCreateNewEntryRow(KEY_SUBENTRYENTITY, parasDoc.size());
            for (int i = 0; i < parasDoc.size(); ++i) {
                DynamicObject parasDo = (DynamicObject)parasDoc.get(i);
                this.getModel().setValue(KEY_PARAKEY, (Object)parasDo.getString(KEY_PARAKEY), i);
                this.getModel().setValue(KEY_PARANAME, (Object)parasDo.getString(KEY_PARANAME), i);
                this.getModel().setValue(KEY_PARATYPE, (Object)parasDo.getString(KEY_PARATYPE), i);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject serviceDo;
        IDataEntityProperty property = evt.getProperty();
        if (property.getName().equalsIgnoreCase(KEY_METHOD) && (serviceDo = (DynamicObject)this.getModel().getValue(KEY_SERVICE)) != null) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(KEY_SERVICE, "=", serviceDo.getPkValue()));
            formShowParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.log.info("");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }
}

