/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.tool;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.query.gpe.AttachmentFileInfo;
import kd.ai.ids.core.utils.AwsS3Utils;
import kd.ai.ids.core.utils.StrUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;

public class AttachmentTools {
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";

    public static String getAttachmentFileUrl(long attachmentId, String proxyIp) {
        Map<String, Object> map;
        String url = null;
        if (attachmentId > 0L && (map = AttachmentTools.getFileInfoMap(attachmentId)) != null) {
            url = AttachmentTools.getFileUrl(proxyIp, map);
        }
        return url;
    }

    public static AttachmentFileInfo getAttachmentInfo(long attachmentId, String proxyIp) {
        Map<String, Object> map;
        AttachmentFileInfo attachmentFileInfo = null;
        if (attachmentId > 0L && (map = AttachmentTools.getFileInfoMap(attachmentId)) != null) {
            String url = AttachmentTools.getFileUrl(proxyIp, map);
            String name = (String)map.get("name");
            String content = AwsS3Utils.readS3File((String)url);
            InputStream in = IOUtils.toInputStream((String)content, (Charset)Charset.forName("utf-8"));
            attachmentFileInfo = new AttachmentFileInfo(in, name);
        }
        return attachmentFileInfo;
    }

    private static Map<String, Object> getFileInfoMap(long attachmentId) {
        List list = AttachmentServiceHelper.getAttachments((String)IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId(), (Object)attachmentId, (String)KEY_ATTACHMENTPANELAP);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (Map)list.get(0);
        }
        return null;
    }

    private static String getFileUrl(String proxyIp, Map<String, Object> map) {
        String url = (String)map.get("url");
        url = StrUtils.replaceProxyIp((String)url, (String)proxyIp);
        return url;
    }
}

