/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.tool;

import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;

public class ControlTools {
    private ControlTools() {
    }

    private static FieldAp createFieldAp(String fieldKey, String showText) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(fieldKey);
        fieldAp.setName(new LocaleString(showText));
        fieldAp.setTextAlign("left");
        fieldAp.setLabelDirection("h");
        fieldAp.setFontSize(13);
        fieldAp.setFireUpdEvt(true);
        fieldAp.setQuickAddNew(false);
        fieldAp.setForeColor("#000000");
        fieldAp.setWidth(new LocaleString("194px"));
        return fieldAp;
    }

    private static FlexPanelAp createFlexPanelAp(String fieldKey) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(fieldKey + "_panel");
        flexPanelAp.setLazyLoad(false);
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setJustifyContent("flex-start");
        flexPanelAp.setGrow(0);
        flexPanelAp.setShrink(0);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("20px");
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        return flexPanelAp;
    }

    private static LabelAp createLabelAp(String fieldKey, String showText) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(fieldKey + "_label");
        labelAp.setClickable(false);
        labelAp.setTextAlign("right");
        labelAp.setFontSize(13);
        labelAp.setName(new LocaleString(showText));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("24px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        return labelAp;
    }

    public static Map<String, Object> createBaseDataControl(String fieldKey, String showText) {
        return ControlTools.createBaseDataControl(fieldKey, showText, null, "v");
    }

    public static Map<String, Object> createBaseDataControl(String fieldKey, String showText, String emptyText, String labelDirection) {
        FieldAp fieldAp = ControlTools.createFieldAp(fieldKey, showText);
        FlexPanelAp flexPanelAp = ControlTools.createFlexPanelAp(fieldKey);
        BasedataField field = new BasedataField();
        field.setKey(fieldKey);
        field.setMustInput(false);
        field.setEmptyText(new LocaleString(emptyText));
        field.setViewDetail(false);
        fieldAp.setField((Field)field);
        if (StringUtils.equalsIgnoreCase((CharSequence)labelDirection, (CharSequence)"h")) {
            fieldAp.setShowTitle(false);
            flexPanelAp.getItems().add(ControlTools.createLabelAp(fieldKey, showText));
        } else {
            fieldAp.setShowTitle(true);
        }
        fieldAp.setLabelDirection(labelDirection);
        flexPanelAp.getItems().add(fieldAp);
        return flexPanelAp.createControl();
    }

    public static Map<String, Object> createMulBaseDataControl(String fieldKey, String showText) {
        return ControlTools.createMulBaseDataControl(fieldKey, showText, null, "v");
    }

    public static Map<String, Object> createMulBaseDataControl(String fieldKey, String showText, String emptyText, String labelDirection) {
        FieldAp fieldAp = ControlTools.createFieldAp(fieldKey, showText);
        FlexPanelAp flexPanelAp = ControlTools.createFlexPanelAp(fieldKey);
        MulBasedataField field = new MulBasedataField();
        field.setKey(fieldKey);
        field.setMustInput(false);
        field.setEmptyText(new LocaleString(emptyText));
        fieldAp.setField((Field)field);
        if (StringUtils.equalsIgnoreCase((CharSequence)labelDirection, (CharSequence)"h")) {
            fieldAp.setShowTitle(false);
            flexPanelAp.getItems().add(ControlTools.createLabelAp(fieldKey, showText));
        } else {
            fieldAp.setShowTitle(true);
        }
        fieldAp.setLabelDirection(labelDirection);
        flexPanelAp.getItems().add(fieldAp);
        return flexPanelAp.createControl();
    }
}

