/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.ai.ids.core.cache.SessionCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.LoadingType;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.util.StringUtils;

public class FormTools {
    public static final String KEY_PAGE_ID = "pageId";
    public static final String KEY_ACTIONS = "actions";

    private FormTools() {
    }

    public static void cachePageId(IFormView formView) {
        SessionCache.get().put(formView.getEntityId() + "/pageId", formView.getPageId());
    }

    public static void notifyAppHomeMenuRefresh(IFormView formView) {
        FormTools.addClientCallBack(formView, "refreshMenu", "ids_apphome");
    }

    public static void notifyMyServiceCardRefresh(IFormView formView) {
        FormTools.addClientCallBack(formView, "refresh", "ids_my_service", "ids_apphome_applist");
    }

    public static void addClientCallBack(IFormView formView, String callBackName, String ... targetPage) {
        if (targetPage == null || targetPage.length == 0) {
            return;
        }
        String[] key = new String[targetPage.length];
        for (int i = 0; i < targetPage.length; ++i) {
            key[i] = targetPage[i] + "/pageId";
        }
        List pageIdList = SessionCache.get().mget(key);
        for (String pageId : pageIdList) {
            IFormView targetView;
            if (!StringUtils.isNotEmpty((String)pageId) || (targetView = formView.getViewNoPlugin(pageId)) == null) continue;
            targetView.addClientCallBack(callBackName);
            formView.sendFormAction(targetView);
        }
    }

    public static void showConfirmAsync(String rootPageId, String parentPageId, String msg, String detail) {
        IFormView parentFormView = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
        if (parentFormView == null) {
            return;
        }
        parentFormView.showConfirm(msg, detail, MessageBoxOptions.OK, ConfirmTypes.Wait, null);
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put(KEY_PAGE_ID, parentPageId);
        arg.put(KEY_ACTIONS, parentFormView.getActionResult());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("a", "sendDynamicFormAction");
        data.put("p", Collections.singletonList(arg));
        MsgSendFactory.getSender().send(rootPageId, SerializationUtils.toJsonString(Collections.singletonList(data)));
    }

    public static void showLoadingAsync(String rootPageId) {
        FormTools.loadingAsync(rootPageId, true);
    }

    public static void hideLoadingAsync(String rootPageId) {
        FormTools.loadingAsync(rootPageId, false);
    }

    private static void loadingAsync(String rootPageId, boolean visible) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList paraList = new ArrayList();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("type", LoadingType.Default.getType());
        paraMap.put("visible", visible);
        paraMap.put(KEY_PAGE_ID, rootPageId);
        paraList.add(paraMap);
        data.put("p", paraList);
        data.put("a", "setPageLoading");
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        result.add(data);
        MsgSendFactory.getSender().send(rootPageId, SerializationUtils.toJsonString(result));
    }

    public static void showLoading(IFormView formView, String targetPageId, LocaleString msg) {
        ArrayList paraList = new ArrayList();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        if (msg != null) {
            paraMap.put("text", msg.toString());
        }
        paraMap.put("type", LoadingType.Default.getType());
        paraMap.put("visible", Boolean.TRUE);
        paraMap.put(KEY_PAGE_ID, targetPageId);
        paraList.add(paraMap);
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        if (proxy != null) {
            FormTools.hideLoading(formView, targetPageId);
            proxy.addAction("setPageLoading", paraList);
        }
    }

    public static void hideLoading(IFormView formView, String targetPageId) {
        ArrayList paraList = new ArrayList();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("type", LoadingType.Default.getType());
        paraMap.put("visible", Boolean.FALSE);
        paraMap.put(KEY_PAGE_ID, targetPageId);
        paraList.add(paraMap);
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        if (proxy != null) {
            proxy.addAction("setPageLoading", paraList);
        }
    }
}

