/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.business.merchant;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import kd.bamp.apay.business.merchant.MerchantApiService;
import kd.bamp.apay.business.merchant.annotation.MerchantApi;
import kd.bamp.apay.business.merchant.dto.req.MerchantApiReqDTO;
import kd.bamp.apay.business.merchant.dto.resp.MerchantApiRespDTO;
import kd.bamp.apay.business.paramconfig.dao.ParamConfigDAO;
import kd.bamp.apay.common.dao.DAOFactory;
import kd.bamp.apay.common.dto.RespDTO;
import kd.bamp.apay.common.util.BeanValidator;
import kd.bamp.apay.common.util.CipherAES;
import kd.bamp.apay.common.util.JsonUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.util.HttpClientUtils;

public class MerchantApiServiceProxy
implements InvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(MerchantApiServiceProxy.class);
    private static final Class<?> INTERFACE = MerchantApiService.class;
    private static String APP_ID;
    private static String MERCHANT_API_AES_KEY;
    private static String MERCHANT_API;
    private ParamConfigDAO paramConfigDAO = DAOFactory.get(ParamConfigDAO.class);

    private MerchantApiServiceProxy() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object arg = args[0];
        LOGGER.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + arg);
        APP_ID = this.paramConfigDAO.getConfigValue("app_id");
        MERCHANT_API_AES_KEY = this.paramConfigDAO.getConfigValue("merchant_aes_key");
        MERCHANT_API = this.paramConfigDAO.getConfigValue("merchant_url");
        this.validate(arg);
        MerchantApiReqDTO reqDTO = this.getReqDTO(arg);
        String url = this.getUrl(method);
        String respData = this.execute(url, reqDTO);
        RespDTO<Object> respDTO = this.getRespData(method, respData);
        LOGGER.info("\u54cd\u5e94\u7ed3\u679c\uff1a" + JsonUtils.toJson(respDTO));
        return respDTO;
    }

    private void validate(Object arg) {
        Assert.notNull((Object)arg, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a null\uff01");
        BeanValidator.validate(arg);
    }

    private MerchantApiReqDTO getReqDTO(Object arg) {
        String encryptedReqData = CipherAES.encrypt(JsonUtils.toJson(arg), MERCHANT_API_AES_KEY);
        return MerchantApiReqDTO.builder().appId(APP_ID).data(encryptedReqData).build();
    }

    private String getUrl(Method method) {
        MerchantApi merchantApi = method.getDeclaredAnnotation(MerchantApi.class);
        if (merchantApi == null) {
            throw new IllegalArgumentException("\u5546\u6237\u63a5\u53e3\u7f3a\u5c11 @MerchantApi");
        }
        String path = merchantApi.value();
        return MERCHANT_API + path;
    }

    private String execute(String url, MerchantApiReqDTO reqDTO) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json;charset=UTF-8");
        String json = JsonUtils.toJson(reqDTO);
        try {
            return HttpClientUtils.postjson((String)url, map, (String)json, (int)45000, (int)45000);
        }
        catch (IOException e) {
            LOGGER.error(String.format("HTTP \u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\uff1a%s", url), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private RespDTO<Object> getRespData(Method method, String respData) {
        LOGGER.info("\u54cd\u5e94\u5185\u5bb9->" + respData);
        if (StringUtils.isBlank((CharSequence)respData)) {
            return RespDTO.builder().ok(Boolean.FALSE).build();
        }
        MerchantApiRespDTO merchantApiRespDTO = JsonUtils.fromJson(respData, MerchantApiRespDTO.class);
        Object result = null;
        if (StringUtils.isNotBlank((CharSequence)merchantApiRespDTO.getData())) {
            String decryptedRespData = CipherAES.decrypt(merchantApiRespDTO.getData(), MERCHANT_API_AES_KEY);
            result = this.getRespObj(method, decryptedRespData);
        }
        return RespDTO.builder().ok("KP0000".equalsIgnoreCase(merchantApiRespDTO.getCode())).code(merchantApiRespDTO.getCode()).msg(merchantApiRespDTO.getMsg()).data(result).build();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getRespObj(Method method, String decryptedRespData) {
        void var3_9;
        ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
        Type type = returnType.getActualTypeArguments()[0];
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Object t = JsonUtils.fromJson(decryptedRespData, clazz);
            return var3_9;
        } else {
            if (!(type instanceof ParameterizedType)) throw new IllegalStateException("\u672a\u5b9e\u73b0\u7684 JSON \u89e3\u6790\uff0c\u8bf7\u68c0\u67e5\u6e90\u7801\uff01");
            ParameterizedType nestedReturnType = (ParameterizedType)type;
            if (nestedReturnType.getRawType() != List.class) throw new IllegalStateException("\u672a\u5b9e\u73b0\u7684 JSON \u89e3\u6790\uff0c\u8bf7\u68c0\u67e5\u6e90\u7801\uff01");
            Class clazz = (Class)nestedReturnType.getActualTypeArguments()[0];
            List list = JsonUtils.fromJsonToList(decryptedRespData, clazz);
        }
        return var3_9;
    }

    public static MerchantApiService createProxy() {
        return (MerchantApiService)Proxy.newProxyInstance(INTERFACE.getClassLoader(), new Class[]{INTERFACE}, (InvocationHandler)new MerchantApiServiceProxy());
    }
}

