/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.business.merchant.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMerchantTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMerchantTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.doRun();
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        String lockKey = this.getLockKey();
        String lockDesc = this.getLockDesc();
        DLock lock = DLock.create((String)lockKey, (String)lockDesc);
        boolean locked = lock.tryLock();
        try {
            if (locked) {
                LOGGER.info("\u6210\u529f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff0c\u5f00\u59cb\u6267\u884c\u672c\u6b21\u8c03\u5ea6\u5468\u671f\uff0clock info={}", (Object)DLock.getLockInfo((String)lockKey));
                this.execute();
                LOGGER.info("\u672c\u6b21\u8c03\u5ea6\u5468\u671f\u6267\u884c\u5b8c\u6bd5");
            } else {
                LOGGER.info("\u65e0\u6cd5\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff0c\u7ec8\u6b62\u6267\u884c\u672c\u6b21\u8c03\u5ea6\u5468\u671f");
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public abstract void execute();

    public abstract String getLockDesc();

    public abstract String getLockKey();
}

