/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.business.merchant.task;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bamp.apay.business.merchant.MerchantApiService;
import kd.bamp.apay.business.merchant.dto.req.MerchantAddReqDTO;
import kd.bamp.apay.business.merchant.dto.req.MerchantFileUploadReqDTO;
import kd.bamp.apay.business.merchant.dto.req.StoreAddOrEditReqDTO;
import kd.bamp.apay.business.merchant.dto.resp.MerchantAddRespDTO;
import kd.bamp.apay.business.merchant.dto.resp.MerchantFileUploadRespDTO;
import kd.bamp.apay.business.merchant.dto.resp.StoreAddOrEditRespDTO;
import kd.bamp.apay.business.merchant.task.AbstractMerchantTask;
import kd.bamp.apay.business.paramconfig.dao.IndustryDAO;
import kd.bamp.apay.business.paramconfig.dao.PlatStoreDAO;
import kd.bamp.apay.business.paramconfig.po.IndustryDO;
import kd.bamp.apay.business.paramconfig.po.PlatStoreDO;
import kd.bamp.apay.common.constant.ErrorCodeConstant;
import kd.bamp.apay.common.dao.DAOFactory;
import kd.bamp.apay.common.dto.RespDTO;
import kd.bamp.apay.common.util.CheckedExceptionWrapper;
import kd.bamp.apay.common.util.FileUtils;
import kd.bamp.apay.common.util.factory.ApiServiceFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class MerchantAddTask
extends AbstractMerchantTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantAddTask.class);
    private static final String PIC_PREFIX = "pic";
    private MerchantApiService merchantApiService = ApiServiceFactory.getInstance(MerchantApiService.class);
    private PlatStoreDAO platStoreDAO = DAOFactory.get(PlatStoreDAO.class);
    private IndustryDAO industryDAO = DAOFactory.get(IndustryDAO.class);

    @Override
    public void execute() {
        List merchantDOList = this.platStoreDAO.selectList(new QFilter("billStatus", "=", (Object)"B").and(new QFilter("merchantStatus", "!=", (Object)"3")).and(new QFilter("createTime", ">=", (Object)LocalDateTime.now().plusDays(-7L))));
        if (CollectionUtils.isEmpty(merchantDOList)) {
            LOGGER.info("\u65e0\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u8fdb\u4ef6\uff0c\u8c03\u5ea6\u7ec8\u6b62");
            return;
        }
        merchantDOList.stream().collect(Collectors.toMap(Function.identity(), this::getPicPairs)).forEach((merchantDO, pics) -> {
            try {
                String operateType = merchantDO.getOperateType();
                if ("3".equalsIgnoreCase(operateType)) {
                    this.addDirectSaleShop((PlatStoreDO)merchantDO);
                } else {
                    String picIds = this.getPicIds((List<Pair<String, String>>)pics);
                    if (StringUtils.isNotBlank((CharSequence)picIds)) {
                        this.invokeMerchantAddApi((PlatStoreDO)merchantDO, picIds);
                    } else {
                        LOGGER.warn("\u8be5\u8fdb\u4ef6\u7684\u56fe\u7247\u5168\u90e8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff0cbillNo={}", (Object)merchantDO.getBillNo());
                    }
                }
            }
            catch (Exception e) {
                merchantDO.setAuditMsg(ErrorCodeConstant.FILE_REQUST_ERR.getMessage());
                merchantDO.setBillStatus("A");
                merchantDO.setMerchantStatus("2");
                this.platStoreDAO.updateById(merchantDO);
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    private List<Pair<String, String>> getPicPairs(PlatStoreDO merchantDO) {
        Set picFields = Arrays.stream(PlatStoreDO.class.getDeclaredFields()).filter(field -> field.getName().startsWith(PIC_PREFIX)).collect(Collectors.toSet());
        return picFields.stream().peek(field -> ReflectionUtils.makeAccessible((Field)field)).map(field -> CheckedExceptionWrapper.get(() -> {
            String picType = field.getName().substring(PIC_PREFIX.length());
            String picPath = (String)field.get(merchantDO);
            return Pair.of((Object)picType, (Object)picPath);
        })).collect(Collectors.toList());
    }

    private String getPicIds(List<Pair<String, String>> pics) {
        return pics.stream().filter(pic -> StringUtils.isNotBlank((CharSequence)((CharSequence)pic.getValue()))).map(pic -> {
            String picPath = (String)pic.getValue();
            LOGGER.info("\u67e5\u770b\u56fe\u7247\u5730\u5740{}", (Object)picPath);
            String realPicPath = this.getRealPicPath(picPath);
            String base64 = FileUtils.downloadToBase64(realPicPath);
            if (StringUtils.isNotBlank((CharSequence)base64)) {
                RespDTO<MerchantFileUploadRespDTO> respDTO = this.merchantApiService.fileUpload(MerchantFileUploadReqDTO.builder().fileName((String)pic.getKey()).fileBase64Str(base64).build());
                if (RespDTO.ok(respDTO)) {
                    String fileNo = respDTO.getData().getFileNo();
                    if (StringUtils.isNotBlank((CharSequence)fileNo)) {
                        return String.format("%s@%s", fileNo, pic.getKey());
                    }
                } else {
                    LOGGER.warn("\u56fe\u7247{}\u4e0a\u4f20sass\u7aef\u5931\u8d25", pic.getKey());
                }
            }
            throw new KDException(ErrorCodeConstant.FILE_ACCESS_ERR, new Object[0]);
        }).collect(Collectors.joining(","));
    }

    private String getRealPicPath(String picPath) {
        int index = picPath.indexOf("?v=");
        if (index <= 0) {
            index = picPath.indexOf("&v=");
        }
        if (index <= 0) {
            LOGGER.warn("\u56fe\u7247\u5730\u5740{},\u6682\u4e0d\u652f\u6301\u5904\u7406\u8be5\u56fe\u7247\u5730\u5740\u683c\u5f0f", (Object)picPath);
            return picPath;
        }
        return picPath.substring(0, index);
    }

    private void addDirectSaleShop(PlatStoreDO merchantDO) {
        StoreAddOrEditReqDTO reqDTO = new StoreAddOrEditReqDTO();
        reqDTO.setReqSeqNo(merchantDO.getBillNo());
        reqDTO.setMerchantName(merchantDO.getMerchantName());
        PlatStoreDO parent = (PlatStoreDO)this.platStoreDAO.selectById(merchantDO.getParentMerchantNo());
        if (parent == null) {
            LOGGER.info("\u5f53\u524d\u95e8\u5e97\u7684\u7236\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff1b\u5546\u6237ID->{}", (Object)merchantDO.getId());
            return;
        }
        reqDTO.setParentMerchantNo(parent.getMerchantNo());
        reqDTO.setMerchantNo(merchantDO.getMerchantNo());
        reqDTO.setContactsMobile(merchantDO.getContactsMobile().split("-")[1]);
        reqDTO.setContacts(merchantDO.getContacts());
        RespDTO<StoreAddOrEditRespDTO> respDTO = this.merchantApiService.storeIncomeOrEdit(reqDTO);
        if (RespDTO.ok(respDTO)) {
            String merchantNo = respDTO.getData().getMerchantNo();
            if (!"KP0000".equalsIgnoreCase(respDTO.getData().getCode())) {
                String msg = respDTO.getData().getMsg();
                if ("KP0001".equalsIgnoreCase(respDTO.getData().getCode())) {
                    merchantDO.setAuditMsg(ErrorCodeConstant.FILE_REQUST_ERR.getMessage());
                } else if (StringUtils.isNotBlank((CharSequence)msg)) {
                    merchantDO.setAuditMsg(msg);
                } else {
                    merchantDO.setAuditMsg(ErrorCodeConstant.FILE_REQUST_ERR.getMessage());
                }
                merchantDO.setBillStatus("A");
                merchantDO.setMerchantStatus("2");
                this.platStoreDAO.updateById(merchantDO);
                LOGGER.warn("SaaS \u8fdb\u4ef6\u5931\u8d25\uff0crespDTO={}", respDTO);
            } else if (StringUtils.isNotBlank((CharSequence)merchantNo)) {
                merchantDO.setBillStatus("B");
                merchantDO.setMerchantStatus("3");
                merchantDO.setMerchantNo(merchantNo);
                this.platStoreDAO.updateById(merchantDO);
                LOGGER.info("SaaS \u8fdb\u4ef6\u6210\u529f, respDTO={}", respDTO);
            } else {
                LOGGER.warn("SaaS \u8fdb\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u5546\u6237\u53f7\u4e3a\u7a7a\uff0crespDTO={}", respDTO);
            }
        } else {
            LOGGER.warn("SaaS \u8fdb\u4ef6\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0crespDTO={}", respDTO);
        }
    }

    private void invokeMerchantAddApi(PlatStoreDO merchantDO, String picIds) {
        MerchantAddReqDTO merchantAddReqDTO = new MerchantAddReqDTO();
        if ("2".equalsIgnoreCase(merchantDO.getOperateType())) {
            PlatStoreDO parent = (PlatStoreDO)this.platStoreDAO.selectById(merchantDO.getParentMerchantNo());
            if (parent == null) {
                LOGGER.info("\u5f53\u524d\u95e8\u5e97\u7684\u7236\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff1b\u5546\u6237ID->{}", (Object)merchantDO.getId());
                return;
            }
            merchantDO.setMerchantMccId(parent.getMerchantMccId());
            merchantAddReqDTO.setParentMerchantNo(parent.getMerchantNo());
        }
        IndustryDO industryDO = (IndustryDO)this.industryDAO.selectById(merchantDO.getMerchantMccId());
        QFilter[] bankLineNofilters = new QFilter[]{new QFilter("id", "=", (Object)merchantDO.getReceiverBankLineNoId())};
        String receiverBankLineNo = ((DynamicObject)QueryServiceHelper.query((String)"bd_bebank", (String)"number", (QFilter[])bankLineNofilters).get(0)).getString("number");
        QFilter[] merchantAreaCodeIdfilters = new QFilter[]{new QFilter("id", "=", (Object)merchantDO.getMerchantAreaCodeId())};
        String merchantAreaCode = ((DynamicObject)QueryServiceHelper.query((String)"bd_admindivision", (String)"number", (QFilter[])merchantAreaCodeIdfilters).get(0)).getString("number");
        QFilter[] receiverBankAddressIdfilters = new QFilter[]{new QFilter("id", "=", (Object)merchantDO.getReceiverBankAddressId())};
        String receiverBankAddressCode = ((DynamicObject)QueryServiceHelper.query((String)"bd_admindivision", (String)"number", (QFilter[])receiverBankAddressIdfilters).get(0)).getString("number");
        RespDTO<MerchantAddRespDTO> respDTO = this.merchantApiService.add(merchantAddReqDTO = MerchantAddReqDTO.from(merchantDO, industryDO, receiverBankLineNo, picIds, merchantAddReqDTO.getParentMerchantNo(), merchantAreaCode, receiverBankAddressCode));
        if (RespDTO.ok(respDTO)) {
            String merchantNo = respDTO.getData().getMerchantNo();
            if (!"KP0000".equalsIgnoreCase(respDTO.getData().getCode())) {
                String msg = respDTO.getData().getMsg();
                if ("KP0001".equalsIgnoreCase(respDTO.getData().getCode())) {
                    merchantDO.setAuditMsg(ErrorCodeConstant.FILE_REQUST_ERR.getMessage());
                } else if (StringUtils.isNotBlank((CharSequence)msg)) {
                    merchantDO.setAuditMsg(msg);
                } else {
                    merchantDO.setAuditMsg(ErrorCodeConstant.FILE_REQUST_ERR.getMessage());
                }
                merchantDO.setBillStatus("A");
                merchantDO.setMerchantStatus("2");
                this.platStoreDAO.updateById(merchantDO);
                LOGGER.warn("SaaS \u8fdb\u4ef6\u5931\u8d25\uff0crespDTO={}", respDTO);
            } else if (StringUtils.isNotBlank((CharSequence)merchantNo)) {
                merchantDO.setBillStatus("B");
                merchantDO.setMerchantStatus("3");
                merchantDO.setMerchantNo(merchantNo);
                merchantDO.setAuditMsg("");
                this.platStoreDAO.updateById(merchantDO);
                LOGGER.info("SaaS \u8fdb\u4ef6\u6210\u529f, respDTO={}", respDTO);
            } else {
                LOGGER.warn("SaaS \u8fdb\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u5546\u6237\u53f7\u4e3a\u7a7a\uff0crespDTO={}", respDTO);
            }
        } else {
            LOGGER.warn("SaaS \u8fdb\u4ef6\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0crespDTO={}", respDTO);
        }
    }

    @Override
    public String getLockDesc() {
        return "\u5546\u6237\u8fdb\u4ef6-\u5206\u5e03\u5f0f\u9501";
    }

    @Override
    public String getLockKey() {
        return "bamp/apay/Merchant-Add";
    }
}

