/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.business.merchant.task;

import java.time.LocalDateTime;
import java.util.List;
import kd.bamp.apay.business.merchant.MerchantApiService;
import kd.bamp.apay.business.merchant.dto.req.MerchantQueryReqDTO;
import kd.bamp.apay.business.merchant.dto.resp.MerchantQueryRespDTO;
import kd.bamp.apay.business.merchant.task.AbstractMerchantTask;
import kd.bamp.apay.business.paramconfig.dao.PlatStoreDAO;
import kd.bamp.apay.business.paramconfig.po.PlatStoreDO;
import kd.bamp.apay.common.dao.DAOFactory;
import kd.bamp.apay.common.dto.RespDTO;
import kd.bamp.apay.common.util.JsonUtils;
import kd.bamp.apay.common.util.factory.ApiServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class MerchantQueryTask
extends AbstractMerchantTask {
    private static final Logger logger = LoggerFactory.getLogger(MerchantQueryTask.class);
    private PlatStoreDAO platStoreDAO = DAOFactory.get(PlatStoreDAO.class);
    private MerchantApiService merchantApiService = ApiServiceFactory.getInstance(MerchantApiService.class);

    @Override
    public void execute() {
        long start = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u6267\u884c\u5546\u6237\u8fdb\u4ef6\u72b6\u6001\u67e5\u8be2\u4efb\u52a1");
        List merchantDOList = this.platStoreDAO.selectList(new QFilter("billStatus", "=", (Object)"B").and(new QFilter("merchantStatus", "=", (Object)"3")).and(new QFilter("createTime", ">=", (Object)LocalDateTime.now().plusDays(-7L))));
        if (CollectionUtils.isEmpty(merchantDOList)) {
            logger.info("\u65e0\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u8fdb\u4ef6\u9700\u8981\u67e5\u8be2\uff0c\u8c03\u5ea6\u7ec8\u6b62");
            return;
        }
        for (PlatStoreDO merchant : merchantDOList) {
            if (ObjectUtils.isEmpty((Object)merchant) || StringUtils.isEmpty((Object)merchant.getMerchantNo())) continue;
            logger.info("\u5f53\u524d\u5904\u7406\u7684\u5546\u6237\u53f7\u4e3a->{}", (Object)merchant.getMerchantNo());
            MerchantQueryReqDTO merchantQueryReqDTO = new MerchantQueryReqDTO();
            merchantQueryReqDTO.setMerchantNo(merchant.getMerchantNo());
            RespDTO<MerchantQueryRespDTO> merchantQueryRespDTO = this.merchantApiService.query(merchantQueryReqDTO);
            logger.info("SAAS\u67e5\u8be2\u54cd\u5e94\u7ed3\u679c\u4e3a->{}", (Object)JsonUtils.toJson(merchantQueryRespDTO));
            if (!RespDTO.ok(merchantQueryRespDTO)) {
                logger.info("\u670d\u52a1\u5230SAAS\u7aef\u7684\u94fe\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173SAAS\u7aef\u670d\u52a1");
                continue;
            }
            if (!"KP0000".equalsIgnoreCase(merchantQueryRespDTO.getData().getCode())) {
                logger.info("\u5546\u6237\u72b6\u6001\u67e5\u8be2\u5f02\u5e38\uff0c\u5546\u6237\u53f7->{}, \u54cd\u5e94\u7801->{}, \u54cd\u5e94\u4fe1\u606f->{}", new Object[]{merchant.getMerchantNo(), merchantQueryRespDTO.getData().getCode(), merchantQueryRespDTO.getData().getMsg()});
                continue;
            }
            int auditStatus = merchantQueryRespDTO.getData().getAuditStatus();
            if (2 == auditStatus) {
                logger.info("\u8fdb\u4ef6\u5ba1\u6838\u5df2\u901a\u8fc7");
                merchant.setBillStatus("C");
                merchant.setMerchantStatus("1");
                merchant.setAuditMsg("\u8fdb\u4ef6\u5ba1\u6838\u5df2\u901a\u8fc7");
            } else if (3 == auditStatus) {
                logger.info("\u8fdb\u4ef6\u5ba1\u6838\u88ab\u62d2\u7edd\uff0c\u62d2\u7edd\u539f\u56e0->{}", (Object)merchantQueryRespDTO.getData().getAuditMsg());
                merchant.setBillStatus("A");
                merchant.setMerchantStatus("2");
                merchant.setAuditMsg(merchantQueryRespDTO.getData().getAuditMsg());
            } else {
                logger.info("SAAS\u7aef\u8fdb\u4ef6\u72b6\u6001\u975e\u7ec8\u6001\uff0c\u4e0d\u505a\u5904\u7406\uff01\u5546\u6237\u53f7->{}, auditStatus -> {}", (Object)merchant.getMerchantNo(), (Object)auditStatus);
            }
            this.platStoreDAO.updateById(merchant);
        }
        long end = System.currentTimeMillis();
        logger.info("\u6267\u884c\u5546\u6237\u8fdb\u4ef6\u72b6\u6001\u67e5\u8be2\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6= {} ms", (Object)(end - start));
    }

    @Override
    public String getLockDesc() {
        return "\u5546\u6237\u67e5\u8be2-\u5206\u5e03\u5f0f\u9501";
    }

    @Override
    public String getLockKey() {
        return "bamp/apay/Merchant-Query";
    }
}

