/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.business.pay;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.UUID;
import kd.bamp.apay.business.paramconfig.dao.ParamConfigDAO;
import kd.bamp.apay.business.paramconfig.dao.PlatMerchantConfDAO;
import kd.bamp.apay.business.paramconfig.po.PlatMerchantConfDO;
import kd.bamp.apay.business.pay.PayApiService;
import kd.bamp.apay.business.pay.annotation.PayApi;
import kd.bamp.apay.business.pay.dto.req.common.BaseReqDTO;
import kd.bamp.apay.business.pay.dto.req.common.PayApiReqDTO;
import kd.bamp.apay.business.pay.dto.resp.common.BaseRespDTO;
import kd.bamp.apay.business.pay.dto.resp.common.PayApiRespDTO;
import kd.bamp.apay.common.dao.DAOFactory;
import kd.bamp.apay.common.dto.RespDTO;
import kd.bamp.apay.common.util.BeanValidator;
import kd.bamp.apay.common.util.CipherAES;
import kd.bamp.apay.common.util.CipherRSA;
import kd.bamp.apay.common.util.JsonUtils;
import kd.bamp.apay.common.util.StrUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang.StringUtils;

public class PayApiServiceProxy
implements InvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(PayApiServiceProxy.class);
    private static final Class<?> INTERFACE = PayApiService.class;
    private static final String[] SIGN_IGNORE_FIELD = new String[]{"sign", "$jacocoData"};
    private static ThreadLocal<HashMap<String, String>> threadLocalMap = new ThreadLocal();
    private ParamConfigDAO paramConfigDAO = DAOFactory.get(ParamConfigDAO.class);
    private PlatMerchantConfDAO platMerchantConfDAO = DAOFactory.get(PlatMerchantConfDAO.class);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object arg = args[0];
        LOGGER.warn("\u8bf7\u6c42\u53c2\u6570\uff1a" + arg);
        String merchantNo = ((BaseReqDTO)arg).getMerchantNo();
        this.getPlatMerchantExtDO(merchantNo);
        Class<?> returnClass = this.getReturnClass(method);
        PayApi payApi = method.getDeclaredAnnotation(PayApi.class);
        this.validate(arg, returnClass, payApi);
        PayApiReqDTO reqDTO = this.getPayApiReqDTO(payApi, arg);
        String respData = this.execute(reqDTO);
        RespDTO<Object> respDTO = this.getRespData(returnClass, respData);
        LOGGER.warn("\u54cd\u5e94\u7ed3\u679c\uff1a" + respDTO);
        return respDTO;
    }

    private void getPlatMerchantExtDO(String merchantNo) {
        PlatMerchantConfDO platMerchantConfigDO = this.platMerchantConfDAO.getByMerchantNo(merchantNo);
        LOGGER.warn("\u5546\u6237\u914d\u7f6e\u4fe1\u606f->" + JsonUtils.toJson(platMerchantConfigDO));
        Assert.notNull((Object)platMerchantConfigDO, (String)"\u5546\u6237\u672a\u914d\u7f6e\u652f\u4ed8\u4fe1\u606f");
        Assert.isTrue((!StringUtils.isEmpty((String)platMerchantConfigDO.getAeskey()) ? 1 : 0) != 0, (String)"\u52a0\u5bc6\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((!StringUtils.isEmpty((String)platMerchantConfigDO.getPlatformPublicKey()) ? 1 : 0) != 0, (String)"\u5e73\u53f0\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((!StringUtils.isEmpty((String)platMerchantConfigDO.getMerchantPrivateKey()) ? 1 : 0) != 0, (String)"\u5546\u6237\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gateway_api_aes_key", platMerchantConfigDO.getAeskey());
        map.put("plat_public_key", platMerchantConfigDO.getPlatformPublicKey());
        map.put("merchant_private_key", platMerchantConfigDO.getMerchantPrivateKey());
        threadLocalMap.set(map);
    }

    private void validate(Object arg, Class<?> returnClass, PayApi payApi) {
        Assert.notNull((Object)arg, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a null\uff01");
        Assert.isTrue((boolean)(arg instanceof BaseReqDTO), (String)"\u5165\u53c2\u5fc5\u987b\u7ee7\u627f BaseReqDTO\uff01");
        Assert.isTrue((boolean)BaseRespDTO.class.isAssignableFrom(returnClass), (String)"\u51fa\u53c2\u5fc5\u987b\u7ee7\u627f BaseRespDTO\uff01");
        Assert.notNull((Object)payApi, (String)"\u5fc5\u987b\u4f7f\u7528 @PayApi \u6ce8\u89e3\uff01");
        Assert.notNull((Object)((Object)payApi.value()), (String)"service \u670d\u52a1\u4ee3\u7801\u4e0d\u80fd\u4e3a null\uff01");
        Assert.notNull((Object)payApi.version(), (String)"version \u7248\u672c\u53f7\u4e0d\u80fd\u4e3a null\uff01");
        BeanValidator.validate(arg);
    }

    private PayApiReqDTO getPayApiReqDTO(PayApi payApi, Object arg) {
        String merchantNo = ((BaseReqDTO)arg).getMerchantNo();
        LOGGER.warn("\u660e\u6587BizContent->" + JsonUtils.toJson(arg));
        String encryptedBizContent = this.getEncryptedBizContent(arg);
        long timestamp = System.currentTimeMillis();
        String nonceStr = UUID.randomUUID().toString();
        PayApiReqDTO reqDTO = PayApiReqDTO.builder().version(payApi.version()).merchantNo(merchantNo).service(payApi.value().getCode()).bizContent(encryptedBizContent).signType("RSA").encType("AESGCM").timestamp(String.valueOf(timestamp)).nonceStr(nonceStr).build();
        String waitStr = StrUtils.genKVStr((Object)reqDTO, SIGN_IGNORE_FIELD);
        LOGGER.warn("\u5f85\u52a0\u5bc6\u8bf7\u6c42\u62a5\u6587->" + JsonUtils.toJson(reqDTO));
        HashMap<String, String> map = threadLocalMap.get();
        String sign = CipherRSA.sign(waitStr, map.get("merchant_private_key"));
        LOGGER.warn("\u7b7e\u540d\u4e32->" + sign);
        reqDTO.setSign(sign);
        return reqDTO;
    }

    private String getEncryptedBizContent(Object arg) {
        String json = JsonUtils.toJson(arg);
        HashMap<String, String> map = threadLocalMap.get();
        return CipherAES.encrypt(json, map.get("gateway_api_aes_key"));
    }

    private String execute(PayApiReqDTO reqDTO) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json;charset=UTF-8");
        String json = JsonUtils.toJson(reqDTO);
        String url = this.paramConfigDAO.getConfigValue("gateway_url");
        try {
            return HttpClientUtils.postjson((String)url, map, (String)json);
        }
        catch (IOException e) {
            LOGGER.error(String.format("HTTP \u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\uff1a%s", url), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private RespDTO<Object> getRespData(Class<?> returnClass, String respData) {
        PayApiRespDTO payApiRespDTO = this.getPayApiRespDTO(respData);
        if (this.verifySign(payApiRespDTO)) {
            Object obj = this.getRespObj(returnClass, payApiRespDTO.getBizContent());
            return RespDTO.builder().ok("KP0000".equalsIgnoreCase(payApiRespDTO.getCode())).code(payApiRespDTO.getCode()).msg(payApiRespDTO.getMessage()).data(obj).build();
        }
        throw new IllegalStateException("\u9a8c\u7b7e\u5931\u8d25\uff01" + StrUtils.genKVStr((Object)payApiRespDTO, "sign"));
    }

    private PayApiRespDTO getPayApiRespDTO(String respData) {
        Assert.notNull((Object)respData, (String)"\u63a5\u53e3\u54cd\u5e94\u6570\u636e\u4e0d\u80fd\u4e3a null\uff01");
        return JsonUtils.fromJson(respData, PayApiRespDTO.class);
    }

    private boolean verifySign(PayApiRespDTO payApiRespDTO) {
        String sign = StrUtils.genKVStr((Object)payApiRespDTO, SIGN_IGNORE_FIELD);
        HashMap<String, String> map = threadLocalMap.get();
        return CipherRSA.verify(sign, map.get("plat_public_key"), payApiRespDTO.getSign());
    }

    private Object getRespObj(Class<?> returnClass, String content) {
        if (content != null) {
            HashMap<String, String> map = threadLocalMap.get();
            String bizContent = CipherAES.decrypt(content, map.get("gateway_api_aes_key"));
            return JsonUtils.fromJson(bizContent, returnClass);
        }
        return null;
    }

    private Class<?> getReturnClass(Method method) {
        ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
        Type type = returnType.getActualTypeArguments()[0];
        return (Class)type;
    }

    public static PayApiService createProxy() {
        return (PayApiService)Proxy.newProxyInstance(INTERFACE.getClassLoader(), new Class[]{INTERFACE}, (InvocationHandler)new PayApiServiceProxy());
    }
}

