/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.dao;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bamp.apay.common.constant.ErrorCodeConstant;
import kd.bamp.apay.common.dao.BaseDAO;
import kd.bamp.apay.common.dao.TableCached;
import kd.bamp.apay.common.dao.TableId;
import kd.bamp.apay.common.util.GenericsUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class BaseDAOImpl<T>
implements BaseDAO<T> {
    private static final Log LOGGER = LogFactory.getLog(BaseDAO.class);

    @Override
    public int insert(T entity) {
        return this.insert((Collection<T>)Collections.singleton(entity));
    }

    @Override
    public int insert(Collection<T> entities) {
        List<DynamicObject> dynamicObjects = entities.stream().map(entity -> this.getDynamicObject(entity, "id")).collect(Collectors.toList());
        Object[] result = SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        return result.length;
    }

    @Override
    public int deleteById(Serializable id) {
        return DeleteServiceHelper.delete((String)this.getEntityName(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    @Override
    public int updateById(T entity) {
        DynamicObject dynamicObject = this.getDynamicObject(entity, "$jacocoData");
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        return 1;
    }

    @Override
    public T selectById(Serializable id) {
        return this.selectOne(new QFilter("id", "=", (Object)id));
    }

    @Override
    public T selectOne(QFilter qFilter) {
        Class entityClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        Set<String> entityKeys = GenericsUtils.getClassFields(entityClass, new String[0]);
        String allSelectFields = String.join((CharSequence)",", entityKeys);
        LOGGER.info("All select fields are -> " + allSelectFields);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getEntityName(), (String)allSelectFields, (QFilter[])new QFilter[]{qFilter});
        return null == dynamicObject ? null : (T)this.getEntity(entityClass, entityKeys, dynamicObject);
    }

    @Override
    public List<T> selectList(QFilter qFilter) {
        Class entityClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        Set<String> entityKeys = GenericsUtils.getClassFields(entityClass, new String[0]);
        String allSelectFields = String.join((CharSequence)",", entityKeys);
        DynamicObjectCollection list = QueryServiceHelper.query((String)this.getEntityName(), (String)allSelectFields, (QFilter[])new QFilter[]{qFilter});
        return CollectionUtils.isEmpty((Collection)list) ? null : this.getEntities(entityClass, entityKeys, (List<DynamicObject>)list);
    }

    @Override
    public int selectCount(QFilter qFilter) {
        return this.selectList(qFilter).size();
    }

    private T getEntity(Class<T> entityClass, Set<String> entityKeys, DynamicObject dynamicObject) {
        try {
            Object entity = entityClass.newInstance();
            Method getMethod = DynamicObject.class.getDeclaredMethod("get", String.class);
            entityKeys.forEach(entityKey -> {
                try {
                    Object entityValue = getMethod.invoke((Object)dynamicObject, entityKey);
                    Field entityField = entityClass.getDeclaredField((String)entityKey);
                    ReflectionUtils.makeAccessible((Field)entityField);
                    entityField.set(entity, entityValue);
                }
                catch (Exception e) {
                    throw new KDException(ErrorCodeConstant.PERSISTENCE_ERR, new Object[]{e});
                }
            });
            return entity;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDException(ErrorCodeConstant.PERSISTENCE_ERR, new Object[]{e});
        }
    }

    private List<T> getEntities(Class<T> entityClass, Set<String> entityKeys, List<DynamicObject> dynamicObjects) {
        return dynamicObjects.stream().map(dynamicObject -> this.getEntity(entityClass, entityKeys, (DynamicObject)dynamicObject)).collect(Collectors.toList());
    }

    private String getEntityName() {
        Class entityClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        TableId tableId = entityClass.getDeclaredAnnotation(TableId.class);
        return tableId.value();
    }

    private boolean isTableCache() {
        Class entityClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        TableCached tableCached = entityClass.getDeclaredAnnotation(TableCached.class);
        return tableCached != null;
    }

    private DynamicObject getDynamicObject(T entity, String ... ignoreFields) {
        Map<String, Object> kv = GenericsUtils.getClassFieldValue(entity, ignoreFields);
        TableId tableId = entity.getClass().getDeclaredAnnotation(TableId.class);
        String entityName = tableId.value();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        kv.forEach((arg_0, arg_1) -> ((DynamicObject)dynamicObject).set(arg_0, arg_1));
        return dynamicObject;
    }
}

