/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util;

import java.util.HashMap;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.NoProviderFoundException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanValidator {
    private static final Logger logger = LoggerFactory.getLogger(BeanValidator.class);

    private BeanValidator() {
    }

    public static <T> void validate(T object) {
        try {
            Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
            Set constraintViolations = validator.validate(object, new Class[0]);
            if (constraintViolations == null || constraintViolations.isEmpty()) {
                return;
            }
            throw new ValidationException(BeanValidator.convertErrorMsg(constraintViolations));
        }
        catch (NoProviderFoundException e) {
            logger.warn(e.getMessage());
            return;
        }
    }

    private static <T> String convertErrorMsg(Set<ConstraintViolation<T>> set) {
        HashMap<String, StringBuilder> errorMap = new HashMap<String, StringBuilder>();
        for (ConstraintViolation<T> cv : set) {
            String property = cv.getPropertyPath().toString();
            if (errorMap.get(property) != null) {
                ((StringBuilder)errorMap.get(property)).append(',').append(cv.getMessage());
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(cv.getMessage());
            errorMap.put(property, sb);
        }
        return ((Object)errorMap).toString();
    }
}

