/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util;

import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bamp.apay.common.constant.ErrorCodeConstant;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class CipherAES {
    private static final String KEY_ALGORITHM = "AES";
    private static final String CHARSET_NAME_UTF8 = "utf-8";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/PKCS5Padding";
    private static final Log logger = LogFactory.getLog(CipherAES.class);

    private CipherAES() {
    }

    public static String encrypt(String content, String seed) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes(CHARSET_NAME_UTF8);
            cipher.init(1, CipherAES.getSecretKey(seed));
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(byteContent);
            assert (encryptData.length == byteContent.length + 16);
            byte[] message = new byte[12 + byteContent.length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.getEncoder().encodeToString(message);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDException(ErrorCodeConstant.ENC_ERROR, new Object[]{e});
        }
    }

    public static String decrypt(String base64Content, String seed) {
        try {
            byte[] content = Base64.getDecoder().decode(base64Content.getBytes(CHARSET_NAME_UTF8));
            if (content.length < 28) {
                throw new IllegalArgumentException();
            }
            GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, (Key)CipherAES.getSecretKey(seed), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return new String(decryptData, CHARSET_NAME_UTF8);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDException(ErrorCodeConstant.ENC_ERROR, new Object[]{e});
        }
    }

    public static SecretKeySpec getSecretKey(String seed) {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            random.setSeed(seed.getBytes(CHARSET_NAME_UTF8));
            kg.init(128, random);
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDException(ErrorCodeConstant.ENC_ERROR, new Object[]{e});
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

