/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class CipherRSA {
    private static final Log LOG = LogFactory.getLog(CipherRSA.class);
    public static final String PUBLIC_KEY = "RSAPublicKey";
    public static final String PRIVATE_KEY = "RSAPrivateKey";
    public static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final int KEY_SIZE = 1024;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String CHARSET_NAME_UTF8 = "utf-8";

    private CipherRSA() {
    }

    private static PrivateKey convertPrivateKey(byte[] privateKey) throws InvalidKeySpecException {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static PublicKey convertPublicKey(byte[] publicKey) throws InvalidKeySpecException {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] sign(byte[] data, byte[] privateKey) {
        try {
            PrivateKey privateK = CipherRSA.convertPrivateKey(privateKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(privateK);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String sign(String data, String privateKey) {
        try {
            return Base64.getEncoder().encodeToString(CipherRSA.sign(data.getBytes(CHARSET_NAME_UTF8), Base64.getDecoder().decode(privateKey)));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] sign) {
        try {
            PublicKey publicK = CipherRSA.convertPublicKey(publicKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(publicK);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean verify(String data, String publicKey, String sign) {
        try {
            return CipherRSA.verify(data.getBytes(CHARSET_NAME_UTF8), Base64.getDecoder().decode(publicKey), Base64.getDecoder().decode(sign));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

