/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import kd.bamp.apay.common.constant.ErrorCodeConstant;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String downloadToBase64(String path) {
        FileService fs = FileServiceFactory.getImageFileService();
        String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            fs.download(path, (OutputStream)out, userAgent);
            String string = Base64.getEncoder().encodeToString(out.toByteArray());
            return string;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDException(ErrorCodeConstant.FILE_ACCESS_ERR, new Object[]{e});
        }
    }
}

