/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bamp.apay.common.util.CheckedExceptionWrapper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.util.ReflectionUtils;

public class GenericsUtils {
    private GenericsUtils() {
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return GenericsUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Set<String> getClassFields(Class<?> clazz, String ... ignoreFields) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isSynthetic()).map(field -> CheckedExceptionWrapper.get(() -> {
            String k = field.getName();
            return !ArrayUtils.contains((Object[])ignoreFields, (Object)k) ? k : null;
        })).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T> Map<String, Object> getClassFieldValue(T clazz, String ... ignoreFields) {
        return Arrays.stream(clazz.getClass().getDeclaredFields()).peek(field -> ReflectionUtils.makeAccessible((Field)field)).map(field -> CheckedExceptionWrapper.get(() -> {
            String k = field.getName();
            Object v = field.get(clazz);
            return v != null && !ArrayUtils.contains((Object[])ignoreFields, (Object)k) ? ImmutablePair.of((Object)k, (Object)v) : null;
        })).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }
}

