/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bamp.apay.common.util.CipherAES;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class JsonUtils {
    private static final Log log = LogFactory.getLog(CipherAES.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    private static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static <T> String toJson(T obj) {
        try {
            return JsonUtils.getObjectMapper().writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("to json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(String text, Class<T> type) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(text, type);
        }
        catch (IOException e) {
            log.error("from json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonNode fromJson(String text) {
        try {
            return JsonUtils.getObjectMapper().readTree(text);
        }
        catch (IOException e) {
            log.error("from json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(String text, JavaType javaType) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(text, javaType);
        }
        catch (IOException e) {
            log.error("from json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(String text, TypeReference<T> valueTypeRef) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(text, valueTypeRef);
        }
        catch (IOException e) {
            log.error("from json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromByte(byte[] src, Class<T> type) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(src, OBJECT_MAPPER.constructType(type));
        }
        catch (IOException e) {
            log.error("from byte failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> type) {
        try {
            return (T)JsonUtils.getObjectMapper().convertValue(map, OBJECT_MAPPER.getTypeFactory().constructType(type));
        }
        catch (IllegalArgumentException e) {
            log.error("fromMap failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> List<T> fromJsonToList(String text, Class<T> type) {
        return (List)JsonUtils.fromJson(text, OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{type}));
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
    }
}

