/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class StrUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrUtils.class);

    private StrUtils() {
    }

    private static TreeMap<String, String> getSortedParamMap(Object obj, List<String> ignoreField) {
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.forEach((k, v) -> {
                if (v != null && !ignoreField.contains(k)) {
                    paramMap.put((String)k, (String)v);
                }
            });
        } else {
            Arrays.stream(obj.getClass().getDeclaredFields()).peek(field -> ReflectionUtils.makeAccessible((Field)field)).forEach(field -> {
                try {
                    String k = field.getName();
                    Object v = field.get(obj);
                    if (v != null && !ignoreField.contains(k)) {
                        paramMap.put(k, v.toString());
                    }
                }
                catch (Exception e) {
                    LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            });
        }
        return paramMap;
    }

    public static String genKVStr(Object obj, List<String> ignoreField) {
        TreeMap<String, String> paramMap = StrUtils.getSortedParamMap(obj, ignoreField);
        return paramMap.keySet().stream().map(k -> k + "=" + (String)paramMap.get(k)).collect(Collectors.joining("&"));
    }

    public static String genKVStr(Object obj, String ... ignoreField) {
        return StrUtils.genKVStr(obj, Arrays.asList(ignoreField));
    }

    public static String genOnlyValueStr(Object obj, List<String> ignoreField) {
        TreeMap<String, String> paramMap = StrUtils.getSortedParamMap(obj, ignoreField);
        return paramMap.keySet().stream().map(k -> (String)paramMap.get(k)).collect(Collectors.joining());
    }

    public static String genOnlyValueStr(Object obj, String ... ignoreField) {
        return StrUtils.genOnlyValueStr(obj, Arrays.asList(ignoreField));
    }
}

