/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.common.util.factory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolFactory.class);
    private static volatile ExecutorService executorService;
    private static volatile ScheduledExecutorService scheduledExecutorService;
    private static Lock lock1;
    private static Lock lock2;

    private ThreadPoolFactory() {
    }

    public static ExecutorService getExecutorService() {
        if (executorService == null) {
            lock1.lock();
            try {
                if (executorService == null) {
                    executorService = ThreadPools.newExecutorService((String)"apay-executor", (int)9);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                lock1.unlock();
            }
        }
        return executorService;
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        if (scheduledExecutorService == null) {
            lock2.lock();
            try {
                if (scheduledExecutorService == null) {
                    scheduledExecutorService = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("APAY-Merchant-Timer-%d").build());
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                lock2.unlock();
            }
        }
        return scheduledExecutorService;
    }

    static {
        lock1 = new ReentrantLock();
        lock2 = new ReentrantLock();
    }
}

