/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.apay.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import kd.bamp.apay.business.paramconfig.dao.PlatMerchantConfDAO;
import kd.bamp.apay.business.paramconfig.po.PlatMerchantConfDO;
import kd.bamp.apay.business.pay.PayApiService;
import kd.bamp.apay.business.pay.PayApiServiceProxy;
import kd.bamp.apay.business.pay.dto.req.BarCodePayReqDTO;
import kd.bamp.apay.business.pay.dto.req.CloseOrderPayReqDTO;
import kd.bamp.apay.business.pay.dto.req.PrePayReqDTO;
import kd.bamp.apay.business.pay.dto.req.QrCodePayReqDTO;
import kd.bamp.apay.business.pay.dto.req.RefundPayReqDTO;
import kd.bamp.apay.business.pay.dto.req.RefundQueryPayReqDTO;
import kd.bamp.apay.business.pay.dto.req.TradeQueryPayReqDTO;
import kd.bamp.apay.business.pay.dto.resp.BarCodePayRespDTO;
import kd.bamp.apay.business.pay.dto.resp.CloseOrderPayRespDTO;
import kd.bamp.apay.business.pay.dto.resp.PrePayRespDTO;
import kd.bamp.apay.business.pay.dto.resp.QrCodePayRespDTO;
import kd.bamp.apay.business.pay.dto.resp.RefundPayRespDTO;
import kd.bamp.apay.business.pay.dto.resp.RefundQueryPayRespDTO;
import kd.bamp.apay.business.pay.dto.resp.TradeQueryPayRespDTO;
import kd.bamp.apay.common.dao.DAOFactory;
import kd.bamp.apay.common.dto.RespDTO;
import kd.bamp.apay.common.enums.ResponseEnum;
import kd.bamp.apay.mservice.dto.req.BarCodeBizReqDTO;
import kd.bamp.apay.mservice.dto.req.CloseOrderBizReqDTO;
import kd.bamp.apay.mservice.dto.req.PrePayBizReqDTO;
import kd.bamp.apay.mservice.dto.req.QrCodeBizReqDTO;
import kd.bamp.apay.mservice.dto.req.RefundBizReqDTO;
import kd.bamp.apay.mservice.dto.req.RefundQueryBizReqDTO;
import kd.bamp.apay.mservice.dto.req.TradeQueryBizReqDTO;
import kd.bamp.apay.mservice.dto.resp.BarCodeBizRespDTO;
import kd.bamp.apay.mservice.dto.resp.CloseOrderBizRespDTO;
import kd.bamp.apay.mservice.dto.resp.PrePayBizRespDTO;
import kd.bamp.apay.mservice.dto.resp.QrCodeBizRespDTO;
import kd.bamp.apay.mservice.dto.resp.RefundBizRespDTO;
import kd.bamp.apay.mservice.dto.resp.RefundQueryBizRespDTO;
import kd.bamp.apay.mservice.dto.resp.TradeQueryBizRespDTO;
import kd.bamp.apay.mserviceapi.APayService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class APayServiceImpl
implements APayService {
    private static final Log logger = LogFactory.getLog(APayServiceImpl.class);
    private PlatMerchantConfDAO platMerchantConfDAO = DAOFactory.get(PlatMerchantConfDAO.class);

    private String getPayConfig(String appCode, String merchantNo) {
        PlatMerchantConfDO platMerchantConfigDO = this.platMerchantConfDAO.getByCloudMerchantNo(appCode, merchantNo);
        return platMerchantConfigDO == null ? null : platMerchantConfigDO.getMerchantNo();
    }

    @Override
    public BarCodeBizRespDTO barCodePay(BarCodeBizReqDTO barCodeBizReqDTO) {
        logger.info("\u4e1a\u52a1\u53c2\u6570->" + JSON.toJSONString((Object)barCodeBizReqDTO));
        BarCodeBizRespDTO barCodeBizRespDTO = new BarCodeBizRespDTO();
        if (StringUtils.isEmpty((String)barCodeBizReqDTO.getMerchantNo())) {
            logger.warn("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            barCodeBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            barCodeBizRespDTO.setBizMsg("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return barCodeBizRespDTO;
        }
        if (StringUtils.isEmpty((String)barCodeBizReqDTO.getAppCode())) {
            logger.warn("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            barCodeBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            barCodeBizRespDTO.setBizMsg("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return barCodeBizRespDTO;
        }
        String merchantNO = this.getPayConfig(barCodeBizReqDTO.getAppCode(), barCodeBizReqDTO.getMerchantNo());
        if (StringUtils.isEmpty((String)merchantNO)) {
            logger.warn("\u5546\u6237\u6216\u95e8\u5e97\u672a\u8fdb\u884c\u652f\u4ed8\u914d\u7f6e");
            barCodeBizRespDTO.setBizCode(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getCode());
            barCodeBizRespDTO.setBizMsg(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getMsg());
            return barCodeBizRespDTO;
        }
        BarCodePayReqDTO barCodePayReqDTO = BarCodePayReqDTO.builder().bizNo(barCodeBizReqDTO.getBizNo()).ip(barCodeBizReqDTO.getIp()).orgCode(barCodeBizReqDTO.getOrgCode()).orderSrc(barCodeBizReqDTO.getOrderSrc()).merchantNo(merchantNO).notifyUrl(barCodeBizReqDTO.getNotifyUrl()).returnUrl(barCodeBizReqDTO.getReturnUrl()).productName(barCodeBizReqDTO.getProductName()).productDesc(barCodeBizReqDTO.getProductDesc()).amount(barCodeBizReqDTO.getAmount()).authorizeCode(barCodeBizReqDTO.getAuthorizeCode()).build();
        PayApiService payApiService = PayApiServiceProxy.createProxy();
        logger.info("\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570->" + JSON.toJSONString((Object)barCodeBizReqDTO));
        RespDTO<BarCodePayRespDTO> respDTO = payApiService.barCodePay(barCodePayReqDTO);
        logger.info("\u652f\u4ed8\u54cd\u5e94\u53c2\u6570->" + JSON.toJSONString(respDTO));
        barCodeBizRespDTO.setBizCode(respDTO.getCode());
        barCodeBizRespDTO.setBizMsg(respDTO.getMsg());
        logger.info("\u54cd\u5e94\u4e1a\u52a1\u7ebf\u53c2\u6570->" + JSON.toJSONString((Object)barCodeBizRespDTO));
        return barCodeBizRespDTO;
    }

    @Override
    public QrCodeBizRespDTO qrCodePay(QrCodeBizReqDTO qrCodeBizReqDTO) {
        logger.info("\u4e1a\u52a1\u53c2\u6570->" + JSON.toJSONString((Object)qrCodeBizReqDTO));
        QrCodeBizRespDTO qrCodeBizRespDTO = new QrCodeBizRespDTO();
        if (StringUtils.isEmpty((String)qrCodeBizReqDTO.getMerchantNo())) {
            logger.warn("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            qrCodeBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            qrCodeBizRespDTO.setBizMsg("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return qrCodeBizRespDTO;
        }
        if (StringUtils.isEmpty((String)qrCodeBizReqDTO.getAppCode())) {
            logger.warn("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            qrCodeBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            qrCodeBizRespDTO.setBizMsg("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return qrCodeBizRespDTO;
        }
        String merchantNO = this.getPayConfig(qrCodeBizReqDTO.getAppCode(), qrCodeBizReqDTO.getMerchantNo());
        if (StringUtils.isEmpty((String)merchantNO)) {
            logger.warn("\u5546\u6237\u6216\u95e8\u5e97\u672a\u8fdb\u884c\u652f\u4ed8\u914d\u7f6e");
            qrCodeBizRespDTO.setBizCode(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getCode());
            qrCodeBizRespDTO.setBizMsg(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getMsg());
            return qrCodeBizRespDTO;
        }
        QrCodePayReqDTO qrCodePayReqDTO = QrCodePayReqDTO.builder().bizNo(qrCodeBizReqDTO.getBizNo()).ip(qrCodeBizReqDTO.getIp()).orgCode(qrCodeBizReqDTO.getOrgCode()).orderSrc(qrCodeBizReqDTO.getOrderSrc()).merchantNo(merchantNO).notifyUrl(qrCodeBizReqDTO.getNotifyUrl()).returnUrl(qrCodeBizReqDTO.getReturnUrl()).productName(qrCodeBizReqDTO.getProductName()).productDesc(qrCodeBizReqDTO.getProductDesc()).amount(qrCodeBizReqDTO.getAmount()).build();
        PayApiService payApiService = PayApiServiceProxy.createProxy();
        RespDTO<QrCodePayRespDTO> respDTO = payApiService.qrCodePay(qrCodePayReqDTO);
        logger.info("\u652f\u4ed8\u54cd\u5e94\u53c2\u6570->" + JSON.toJSONString(respDTO));
        qrCodeBizRespDTO.setBizCode(respDTO.getCode());
        qrCodeBizRespDTO.setBizMsg(respDTO.getMsg());
        logger.info("\u54cd\u5e94\u4e1a\u52a1\u7ebf\u53c2\u6570->" + JSON.toJSONString((Object)qrCodeBizRespDTO));
        return qrCodeBizRespDTO;
    }

    @Override
    public PrePayBizRespDTO prePay(PrePayBizReqDTO prePayBizReqDTO) {
        logger.info("\u4e1a\u52a1\u53c2\u6570->" + JSON.toJSONString((Object)prePayBizReqDTO));
        PrePayBizRespDTO prePayBizRespDTO = new PrePayBizRespDTO();
        if (StringUtils.isEmpty((String)prePayBizReqDTO.getMerchantNo())) {
            logger.warn("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            prePayBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            prePayBizRespDTO.setBizMsg("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return prePayBizRespDTO;
        }
        if (StringUtils.isEmpty((String)prePayBizReqDTO.getAppCode())) {
            logger.warn("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            prePayBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            prePayBizRespDTO.setBizMsg("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return prePayBizRespDTO;
        }
        String merchantNO = this.getPayConfig(prePayBizReqDTO.getAppCode(), prePayBizReqDTO.getMerchantNo());
        if (StringUtils.isEmpty((String)merchantNO)) {
            logger.warn("\u5546\u6237\u6216\u95e8\u5e97\u672a\u8fdb\u884c\u652f\u4ed8\u914d\u7f6e");
            prePayBizRespDTO.setBizCode(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getCode());
            prePayBizRespDTO.setBizMsg(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getMsg());
            return prePayBizRespDTO;
        }
        PrePayReqDTO prePayReqDTO = PrePayReqDTO.builder().bizNo(prePayBizReqDTO.getBizNo()).ip(prePayBizReqDTO.getIp()).orgCode(prePayBizReqDTO.getOrgCode()).orderSrc(prePayBizReqDTO.getOrderSrc()).merchantNo(merchantNO).notifyUrl(prePayBizReqDTO.getNotifyUrl()).returnUrl(prePayBizReqDTO.getReturnUrl()).productName(prePayBizReqDTO.getProductName()).productDesc(prePayBizReqDTO.getProductDesc()).appIdType(prePayBizReqDTO.getAppIdType()).appId(prePayBizReqDTO.getAppId()).serviceMode(prePayBizReqDTO.getServiceMode()).openid(prePayBizReqDTO.getOpenid()).amount(prePayBizReqDTO.getAmount()).build();
        PayApiService payApiService = PayApiServiceProxy.createProxy();
        RespDTO<PrePayRespDTO> respDTO = payApiService.prePay(prePayReqDTO);
        logger.info("\u652f\u4ed8\u54cd\u5e94\u53c2\u6570->" + JSON.toJSONString(respDTO));
        prePayBizRespDTO.setBizCode(respDTO.getCode());
        prePayBizRespDTO.setBizMsg(respDTO.getMsg());
        logger.info("\u54cd\u5e94\u4e1a\u52a1\u7ebf\u53c2\u6570->" + JSON.toJSONString((Object)prePayBizRespDTO));
        return prePayBizRespDTO;
    }

    @Override
    public RefundBizRespDTO refund(RefundBizReqDTO refundBizReqDTO) {
        logger.info("\u4e1a\u52a1\u53c2\u6570->" + JSON.toJSONString((Object)refundBizReqDTO));
        RefundBizRespDTO refundBizRespDTO = new RefundBizRespDTO();
        if (StringUtils.isEmpty((String)refundBizReqDTO.getMerchantNo())) {
            logger.warn("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            refundBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            refundBizRespDTO.setBizMsg("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return refundBizRespDTO;
        }
        if (StringUtils.isEmpty((String)refundBizReqDTO.getAppCode())) {
            logger.warn("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            refundBizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            refundBizRespDTO.setBizMsg("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return refundBizRespDTO;
        }
        String merchantNO = this.getPayConfig(refundBizReqDTO.getAppCode(), refundBizReqDTO.getMerchantNo());
        if (StringUtils.isEmpty((String)merchantNO)) {
            logger.warn("\u5546\u6237\u6216\u95e8\u5e97\u672a\u8fdb\u884c\u652f\u4ed8\u914d\u7f6e");
            refundBizRespDTO.setBizCode(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getCode());
            refundBizRespDTO.setBizMsg(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getMsg());
            return refundBizRespDTO;
        }
        RefundPayReqDTO refundPayReqDTO = RefundPayReqDTO.builder().bizNo(refundBizReqDTO.getBizNo()).ip(refundBizReqDTO.getIp()).orgCode(refundBizReqDTO.getOrgCode()).orderSrc(refundBizReqDTO.getOrderSrc()).merchantNo(merchantNO).notifyUrl(refundBizReqDTO.getNotifyUrl()).returnUrl(refundBizReqDTO.getReturnUrl()).productName(refundBizReqDTO.getProductName()).productDesc(refundBizReqDTO.getProductDesc()).oriBizNo(refundBizReqDTO.getOriBizNo()).refundAmount(new BigDecimal(refundBizReqDTO.getRefundAmount())).build();
        PayApiService payApiService = PayApiServiceProxy.createProxy();
        RespDTO<RefundPayRespDTO> respDTO = payApiService.refund(refundPayReqDTO);
        logger.info("\u652f\u4ed8\u54cd\u5e94\u53c2\u6570->" + JSON.toJSONString(respDTO));
        refundBizRespDTO.setBizCode(respDTO.getCode());
        refundBizRespDTO.setBizMsg(respDTO.getMsg());
        logger.info("\u54cd\u5e94\u4e1a\u52a1\u7ebf\u53c2\u6570->" + JSON.toJSONString((Object)refundBizRespDTO));
        return refundBizRespDTO;
    }

    @Override
    public TradeQueryBizRespDTO tradeQuery(TradeQueryBizReqDTO tradeQueryBizReqDTO) {
        logger.info("\u4e1a\u52a1\u53c2\u6570->" + JSON.toJSONString((Object)tradeQueryBizReqDTO));
        TradeQueryBizRespDTO bizRespDTO = new TradeQueryBizRespDTO();
        if (StringUtils.isEmpty((String)tradeQueryBizReqDTO.getMerchantNo())) {
            logger.warn("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            bizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            bizRespDTO.setBizMsg("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return bizRespDTO;
        }
        if (StringUtils.isEmpty((String)tradeQueryBizReqDTO.getAppCode())) {
            logger.warn("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            bizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            bizRespDTO.setBizMsg("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return bizRespDTO;
        }
        String merchantNO = this.getPayConfig(tradeQueryBizReqDTO.getAppCode(), tradeQueryBizReqDTO.getMerchantNo());
        if (StringUtils.isEmpty((String)merchantNO)) {
            logger.warn("\u5546\u6237\u6216\u95e8\u5e97\u672a\u8fdb\u884c\u652f\u4ed8\u914d\u7f6e");
            bizRespDTO.setBizCode(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getCode());
            bizRespDTO.setBizMsg(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getMsg());
            return bizRespDTO;
        }
        TradeQueryPayReqDTO payReqDTO = TradeQueryPayReqDTO.builder().merchantNo(merchantNO).transOrderNo(tradeQueryBizReqDTO.getBizNo()).orderSrc(tradeQueryBizReqDTO.getOrderSrc()).bizNo(tradeQueryBizReqDTO.getBizNo()).ip(tradeQueryBizReqDTO.getIp()).build();
        PayApiService payApiService = PayApiServiceProxy.createProxy();
        RespDTO<TradeQueryPayRespDTO> respDTO = payApiService.tradeQuery(payReqDTO);
        logger.info("\u652f\u4ed8\u54cd\u5e94\u53c2\u6570->" + JSON.toJSONString(respDTO));
        bizRespDTO.setBizCode(respDTO.getCode());
        bizRespDTO.setBizMsg(respDTO.getMsg());
        BeanUtils.copyProperties((Object)respDTO.getData(), (Object)bizRespDTO);
        logger.info("\u54cd\u5e94\u4e1a\u52a1\u7ebf\u53c2\u6570->" + JSON.toJSONString((Object)bizRespDTO));
        return bizRespDTO;
    }

    @Override
    public RefundQueryBizRespDTO refundQuery(RefundQueryBizReqDTO refundQueryBizReqDTO) {
        logger.info("\u4e1a\u52a1\u53c2\u6570->" + JSON.toJSONString((Object)refundQueryBizReqDTO));
        RefundQueryBizRespDTO bizRespDTO = new RefundQueryBizRespDTO();
        if (StringUtils.isEmpty((String)refundQueryBizReqDTO.getMerchantNo())) {
            logger.warn("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            bizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            bizRespDTO.setBizMsg("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return bizRespDTO;
        }
        if (StringUtils.isEmpty((String)refundQueryBizReqDTO.getAppCode())) {
            logger.warn("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            bizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            bizRespDTO.setBizMsg("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return bizRespDTO;
        }
        String merchantNO = this.getPayConfig(refundQueryBizReqDTO.getAppCode(), refundQueryBizReqDTO.getMerchantNo());
        if (StringUtils.isEmpty((String)merchantNO)) {
            logger.warn("\u5546\u6237\u6216\u95e8\u5e97\u672a\u8fdb\u884c\u652f\u4ed8\u914d\u7f6e");
            bizRespDTO.setBizCode(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getCode());
            bizRespDTO.setBizMsg(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getMsg());
            return bizRespDTO;
        }
        RefundQueryPayReqDTO refundQueryPayReqDTO = RefundQueryPayReqDTO.builder().merchantNo(merchantNO).refundNo(refundQueryBizReqDTO.getRefundNo()).build();
        PayApiService payApiService = PayApiServiceProxy.createProxy();
        RespDTO<RefundQueryPayRespDTO> respDTO = payApiService.refundQuery(refundQueryPayReqDTO);
        logger.info("\u652f\u4ed8\u54cd\u5e94\u53c2\u6570->" + JSON.toJSONString(respDTO));
        bizRespDTO.setBizCode(respDTO.getCode());
        bizRespDTO.setBizMsg(respDTO.getMsg());
        if (respDTO.getData() != null) {
            BeanUtils.copyProperties((Object)respDTO.getData(), (Object)bizRespDTO);
        }
        logger.info("\u54cd\u5e94\u4e1a\u52a1\u7ebf\u53c2\u6570->" + JSON.toJSONString((Object)bizRespDTO));
        return bizRespDTO;
    }

    @Override
    public CloseOrderBizRespDTO closeOrder(CloseOrderBizReqDTO closeOrderBizReqDTO) {
        logger.info("\u4e1a\u52a1\u53c2\u6570->" + JSON.toJSONString((Object)closeOrderBizReqDTO));
        CloseOrderBizRespDTO bizRespDTO = new CloseOrderBizRespDTO();
        if (StringUtils.isEmpty((String)closeOrderBizReqDTO.getMerchantNo())) {
            logger.warn("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            bizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            bizRespDTO.setBizMsg("\u4e1a\u52a1\u5546\u6237\u53f7\u6216\u95e8\u5e97\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return bizRespDTO;
        }
        if (StringUtils.isEmpty((String)closeOrderBizReqDTO.getAppCode())) {
            logger.warn("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            bizRespDTO.setBizCode(ResponseEnum.PARAM_NULL.getCode());
            bizRespDTO.setBizMsg("\u4e1a\u52a1\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return bizRespDTO;
        }
        String merchantNO = this.getPayConfig(closeOrderBizReqDTO.getAppCode(), closeOrderBizReqDTO.getMerchantNo());
        if (StringUtils.isEmpty((String)merchantNO)) {
            logger.warn("\u5546\u6237\u6216\u95e8\u5e97\u672a\u8fdb\u884c\u652f\u4ed8\u914d\u7f6e");
            bizRespDTO.setBizCode(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getCode());
            bizRespDTO.setBizMsg(ResponseEnum.MERCHANT_NO_PAY_CONFIG.getMsg());
            return bizRespDTO;
        }
        CloseOrderPayReqDTO payReqDTO = CloseOrderPayReqDTO.builder().bizNo(closeOrderBizReqDTO.getBizNo()).merchantNo(merchantNO).closeReason(closeOrderBizReqDTO.getCloseReason()).remark(closeOrderBizReqDTO.getRemark()).build();
        PayApiService payApiService = PayApiServiceProxy.createProxy();
        RespDTO<CloseOrderPayRespDTO> respDTO = payApiService.closeOrder(payReqDTO);
        logger.info("\u652f\u4ed8\u54cd\u5e94\u53c2\u6570->" + JSON.toJSONString(respDTO));
        bizRespDTO.setBizCode(respDTO.getCode());
        bizRespDTO.setBizMsg(respDTO.getMsg());
        logger.info("\u54cd\u5e94\u4e1a\u52a1\u7ebf\u53c2\u6570->" + JSON.toJSONString((Object)bizRespDTO));
        return bizRespDTO;
    }
}

