/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.common;

import java.util.EventObject;
import kd.bamp.bastax.common.util.SearchUtil;
import kd.bamp.bastax.common.util.TreeUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class AbstractTreePlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
TreeNodeDragListener,
TreeNodeClickListener {
    public static final String DEFAULT_ROOT_ID = "-1";
    public static final int MAX_LEVEL = 20;

    public TreeNode getRoot(String treeName) {
        return (TreeNode)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)String.format("%s.root", treeName), TreeNode.class);
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
    }

    public void treeNodeDragged(TreeNodeDragEvent event) {
        String nodeId = event.getNodeId().toString();
        String toParentId = event.getToParentId().toString();
        String fromParentId = event.getFromParentId().toString();
        TreeView treeView = (TreeView)event.getSource();
        TreeNode root = this.getRoot(treeView.getKey());
        TreeNode currNode = root.getTreeNode(nodeId, 20);
        currNode.setParentid(toParentId);
        treeView.deleteNode(currNode.getId());
        treeView.addNode(currNode);
        TreeNode toNode = root.getTreeNode(toParentId, 20);
        TreeNode fromNode = root.getTreeNode(fromParentId, 20);
        if (fromNode != null) {
            fromNode.deleteChildNode(nodeId);
        } else {
            root.deleteChildNode(nodeId);
        }
        if (toNode != null) {
            toNode.addChild(currNode);
        }
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)String.format("%s.root", treeView.getKey()), (Object)root);
    }

    public void treeNodeClick(TreeNodeEvent event) {
        Object nodeId = event.getNodeId();
        TreeView treeView = (TreeView)event.getSource();
        this.getPageCache().put(String.format("%s.currentnodeid", treeView.getKey()), nodeId.toString());
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("searchbefore_") || key.startsWith("searchnext_")) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            String treeName = key.replace("searchbefore_", "").replace("searchnext_", "");
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key.substring(0, key.length() - treeName.length() - 1), (TreeView)((TreeView)this.getControl(treeName)), (String[])btns, (String)String.format("%s.root", treeName));
        }
    }
}

