/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReferenceCheckDelOp
extends AbstractOperationServicePlugIn {
    private static final String BDTAXR_TAX_RULES = "bdtaxr_tax_rules";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY_VALUEID = "entryentity.valueid";
    private static final String ENTRYENTITY_ENTRYCLASS = "entryentity.entryclass";
    private static final String ID = "id";
    private static final String LIKE_MASK = "%";
    private static final Map<String, String> entryclassMap = new HashMap<String, String>();
    private String select = "entryentity.valueid";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List list = e.getValidExtDataEntities();
        List ids = list.stream().map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        String entityName = e.getDataEntities()[0].getDataEntityType().getName();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)ids.toArray())});
        HashSet message = new HashSet();
        collection.stream().forEach(object -> {
            QFilter valueIdQ = new QFilter(ENTRYENTITY_VALUEID, "like", (Object)(LIKE_MASK + object.getString(ID) + LIKE_MASK));
            QFilter entryclassQ = new QFilter(ENTRYENTITY_ENTRYCLASS, "=", (Object)entryclassMap.get(entityName));
            entryclassQ.and(QFilter.isNotNull((String)ENTRYENTITY));
            DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)BDTAXR_TAX_RULES, (String)this.select, (QFilter[])new QFilter[]{valueIdQ, entryclassQ});
            if (null != dynamicObject && dynamicObject.length > 0) {
                message.add(object.getString("number"));
            }
        });
        if (!ObjectUtils.isEmpty(message)) {
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"%1$s: \u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664,\u201c\u7a0e\u52a1\u89c4\u5219\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\uff0c\u8bf7\u53bb\u9664\u540e\u518d\u5220\u9664\u3002", (String)"ReferenceCheckDelOp_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", message)));
        }
    }

    static {
        entryclassMap.put("bastax_addressterms", "bastax_addresstype");
        entryclassMap.put("bastax_party", "bastax_party_type");
        entryclassMap.put("bastax_taxproduct", "bastax_taxproduct");
        entryclassMap.put("bastax_process", "bastax_process_type");
    }
}

