/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.euproduct;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EUproductEdit
extends AbstractBillPlugIn {
    private static final String BASEDATAVALUE = "basedatavalue";
    private static final String BASEDATANUMBER = "basedatanumber";
    private static final String BASEDATAVALUEID = "basedatavalueid";
    private static final String TEXTVALUE = "textvalue";
    private static final String COMPAREVALUE = "comparevalue";
    private static final String BASEDATATYPE = "basedatatype";
    private static final String MATERIALTYPE = "materialtype";
    private static final String SELECT_BASEDATAVALUE = "selectBasedataValue";
    private static final String BASTAX_EUPRODUCTBASE = "bastax_euproductbase";
    private static final String TYPE_CHANGE = "is_change";
    private static final String OLD_TYPE = "old_type";
    private static final String MATERIALTYPE_1 = "1";
    private static final String MATERIALTYPE_2 = "2";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BASEDATAVALUE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object materialType = this.getModel().getValue(MATERIALTYPE);
        if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(materialType), (CharSequence)MATERIALTYPE_1)) {
            this.configTextControl(false);
            this.configBaseDataControl(true);
        } else {
            this.configTextControl(true);
            this.configBaseDataControl(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)BASEDATAVALUE)) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue(BASEDATATYPE);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"EUproductEdit_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            String entity = dynamicObject.getString("number");
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId(entity);
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entity);
            if (ObjectUtils.isEmpty((Object)formConfig)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6253\u5f00\u5f02\u5e38", (String)"EUproductEdit_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            listShowParameter.setFormId(formConfig.getF7ListFormId());
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            listShowParameter.getOpenStyle().setInlineStyleCss(css);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setShowTitle(false);
            listShowParameter.setMultiSelect(true);
            listShowParameter.setLookUp(true);
            listShowParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            listShowParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", this.getSelectBasedataId()));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_BASEDATAVALUE);
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas;
        if (StringUtils.equalsIgnoreCase((CharSequence)SELECT_BASEDATAVALUE, (CharSequence)closedCallBackEvent.getActionId()) && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(BASTAX_EUPRODUCTBASE);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(BASTAX_EUPRODUCTBASE);
            boolean isFirst = true;
            for (ListSelectedRow row : listDatas) {
                if (isFirst) {
                    this.getModel().setValue(BASEDATAVALUEID, row.getPrimaryKeyValue(), entryGrid.getSelectRows()[0]);
                    this.getModel().setValue(BASEDATANUMBER, (Object)row.getNumber(), entryGrid.getSelectRows()[0]);
                    this.getModel().setValue(BASEDATAVALUE, (Object)row.getName(), entryGrid.getSelectRows()[0]);
                    isFirst = false;
                    continue;
                }
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                int index = this.getModel().createNewEntryRow(BASTAX_EUPRODUCTBASE, dynamicObject);
                this.getModel().setValue(BASEDATAVALUEID, row.getPrimaryKeyValue(), index);
                this.getModel().setValue(BASEDATANUMBER, (Object)row.getNumber(), index);
                this.getModel().setValue(BASEDATAVALUE, (Object)row.getName(), index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(BASTAX_EUPRODUCTBASE);
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BASEDATATYPE) && !collection.isEmpty() && collection.size() > 0) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            this.showConfirmTips(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString("id"));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)MATERIALTYPE)) {
            Object materialType = this.getModel().getValue(MATERIALTYPE);
            this.getModel().deleteEntryData(BASTAX_EUPRODUCTBASE);
            if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(materialType), (CharSequence)MATERIALTYPE_1)) {
                this.configTextControl(false);
                this.configBaseDataControl(true);
            } else {
                this.getModel().setValue(BASEDATATYPE, null);
                this.configTextControl(true);
                this.configBaseDataControl(false);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BASEDATATYPE)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(TYPE_CHANGE, "false");
                this.getModel().deleteEntryData(BASTAX_EUPRODUCTBASE);
            } else {
                this.getPageCache().put(TYPE_CHANGE, "true");
                String oldCountryId = this.getPageCache().get(OLD_TYPE);
                this.getModel().setValue(BASEDATATYPE, (Object)oldCountryId);
            }
        }
    }

    private void showConfirmTips(String fieldKey, String oldValue) {
        if (!"true".equals(this.getPageCache().get(TYPE_CHANGE))) {
            this.getPageCache().put(OLD_TYPE, oldValue);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff0c\u57fa\u7840\u8d44\u6599\u503c\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417?", (String)"EUproductEdit_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else {
            this.getPageCache().put(TYPE_CHANGE, "false");
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        block7: {
            String materialType;
            JSONObject jsonObject;
            block8: {
                if (ObjectUtils.isEmpty((Object)e.getSourceData()) || !(e.getSourceData() instanceof JSONObject)) break block7;
                jsonObject = (JSONObject)e.getSourceData();
                materialType = jsonObject.getString(MATERIALTYPE);
                JSONObject type = jsonObject.getJSONObject(BASEDATATYPE);
                if (!StringUtils.equalsIgnoreCase((CharSequence)materialType, (CharSequence)MATERIALTYPE_1)) break block8;
                ArrayList<Long> basedatavalueids = new ArrayList<Long>();
                JSONArray basevalue = jsonObject.getJSONArray(BASTAX_EUPRODUCTBASE);
                if (ObjectUtils.isEmpty((Object)type)) {
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"EUproductEdit_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    return;
                }
                String baseDataTpye = type.getString("number");
                for (Object object : basevalue) {
                    String basedatanumber;
                    JSONObject row = (JSONObject)object;
                    String basedatavalue = row.getString(BASEDATAVALUE);
                    DynamicObjectCollection baseDataTpyes = QueryServiceHelper.query((String)baseDataTpye, (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)basedatavalue).and(new QFilter("number", "=", (Object)(basedatanumber = row.getString(BASEDATANUMBER))))});
                    if (!ObjectUtils.isEmpty((Object)baseDataTpyes) && baseDataTpyes.size() > 0) {
                        DynamicObject dynamicObject = (DynamicObject)baseDataTpyes.get(0);
                        Long basedatavalueid = dynamicObject.getLong("id");
                        if (basedatavalueids.contains(basedatavalueid)) {
                            e.setCancel(true);
                            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91cd\u590d\u7684\u57fa\u7840\u8d44\u6599\u540d\u79f0\uff1a%1$s", (String)"EUproductEdit_10", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), basedatavalue));
                            return;
                        }
                        basedatavalueids.add(dynamicObject.getLong("id"));
                        row.put(BASEDATAVALUEID, (Object)basedatavalueid);
                        row.put(COMPAREVALUE, (Object)basedatavalueid);
                        row.put(TEXTVALUE, null);
                        continue;
                    }
                    e.setCancel(true);
                    e.setCancelMessage(String.format("%1$s%2$s%3$s", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u540d\u79f0\u4e3a", (String)"EUproductEdit_8", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), basedatavalue, ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u6570\u636e", (String)"EUproductEdit_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0])));
                    return;
                }
                break block7;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)materialType, (CharSequence)MATERIALTYPE_2)) break block7;
            JSONArray basevalue = jsonObject.getJSONArray(BASTAX_EUPRODUCTBASE);
            if (ObjectUtils.isEmpty((Object)basevalue)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u6587\u672c\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"EUproductEdit_9", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            for (Object object : basevalue) {
                JSONObject row = (JSONObject)object;
                String textValue = row.getString(TEXTVALUE);
                if (StringUtils.isEmpty((CharSequence)textValue)) {
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u6587\u672c\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"EUproductEdit_9", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    return;
                }
                row.put(COMPAREVALUE, (Object)textValue);
                row.put(BASEDATAVALUE, null);
                row.put(BASEDATANUMBER, null);
            }
        }
    }

    private List<Long> getSelectBasedataId() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(BASTAX_EUPRODUCTBASE);
        return collection.stream().filter(o -> !ObjectUtils.isEmpty((Object)o.get(BASEDATAVALUEID))).map(o -> o.getLong(BASEDATAVALUEID)).collect(Collectors.toList());
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit control = (FieldEdit)this.getControl(key);
        control.setMustInput(mustInput);
    }

    private void configBaseDataControl(boolean mustInput) {
        this.setMustInput(BASEDATATYPE, mustInput);
        this.setMustInput(BASEDATAVALUE, mustInput);
        this.getView().setVisible(Boolean.valueOf(mustInput), new String[]{BASEDATAVALUE, BASEDATANUMBER});
    }

    private void configTextControl(boolean mustInput) {
        this.setMustInput(TEXTVALUE, mustInput);
        this.getView().setVisible(Boolean.valueOf(mustInput), new String[]{TEXTVALUE});
    }
}

