/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.roombase;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bamp.bastax.business.roombase.BuildingBusiness;
import kd.bamp.bastax.business.roombase.RoomBusiness;
import kd.bamp.bastax.business.roombase.StageBusiness;
import kd.bamp.bastax.common.constant.StageConstant;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class RoomBaseEditPlugin
extends AbstractFormPlugin
implements TabSelectListener,
TreeNodeClickListener {
    public static final String DELETETREENODE = "deletetreenode";
    public static final String ADDTREENODE = "addtreenode";
    public static final String TABAP = "tabap";
    public static final String BUILDINGTREE = "buildingtree";
    public static final String ROOMTREE = "roomtree";
    public static final String STAGE = "stage";
    public static final String PK_ID = "pkId";
    public static final String REGEX = "_";
    public static final String TAXPROJECT = "taxproject";
    public static final String TAXORG = "taxorg";
    public static final String ROOM = "room";
    public static final String BUILDING = "building";
    public static final String TABSTAGE = "tabstage";
    public static final String TABBUILDING = "tabbuilding";
    public static final String TABROOM = "tabroom";
    public static final String SAVE = "save";
    public static final String DELETE = "delete";
    public static final String EDIT = "edit";
    public static final String NODE_ID = "nodeId";
    public static final String BUILDINGCONTAINER = "buildingcontainer";
    public static final String ROOMCONTAINER = "roomcontainer";
    public static final String CURRENT_NODE_ID = "currentNodeId";
    private static final String REFRESH = "refresh";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String nodeId = (String)showParameter.getCustomParam(NODE_ID);
        Long pkId = (Long)showParameter.getCustomParam(PK_ID);
        if (pkId == null) {
            this.getPageCache().put(CURRENT_NODE_ID, nodeId);
            if (StringUtil.isNotBlank((CharSequence)nodeId) && !"-1".equals(nodeId)) {
                String[] values = nodeId.split(REGEX);
                String flag = values[0];
                if (BUILDING.equalsIgnoreCase(flag)) {
                    this.loadBuildTree(null);
                    Tab tab = (Tab)this.getView().getControl(TABAP);
                    tab.activeTab(TABBUILDING);
                } else {
                    this.loadStageForm(TABSTAGE, showParameter.getStatus());
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{TABBUILDING});
                this.getView().setEnable(Boolean.FALSE, new String[]{TABROOM});
                this.loadStageForm(TABSTAGE, showParameter.getStatus());
            }
        } else {
            this.getPageCache().put(CURRENT_NODE_ID, "room_" + pkId);
            Tab tab = (Tab)this.getView().getControl(TABAP);
            tab.activeTab(TABROOM);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        TreeView buildingtree = (TreeView)this.getView().getControl(BUILDINGTREE);
        buildingtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView roomtree = (TreeView)this.getView().getControl(ROOMTREE);
        roomtree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put(CURRENT_NODE_ID, nodeId);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        TreeView treeView = (TreeView)evt.getSource();
        if (BUILDINGTREE.equalsIgnoreCase(treeView.getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            Long pkId = (Long)showParameter.getCustomParam(PK_ID);
            if (StringUtil.isNotEmpty((CharSequence)nodeId)) {
                String[] values = nodeId.split(REGEX);
                String flag = values[0];
                String billId = values[1];
                this.getView().setEnable(Boolean.FALSE, new String[]{"deletebuildingnode"});
                String key = (String)showParameter.getCustomParam("key");
                this.getView().setVisible(Boolean.TRUE, new String[]{BUILDINGCONTAINER});
                if (STAGE.equalsIgnoreCase(flag)) {
                    if (ADDTREENODE.equals(key) || OperationStatus.ADDNEW.equals((Object)showParameter.getStatus())) {
                        params.put(STAGE, Long.valueOf(billId));
                        DynamicObject building = StageBusiness.queryStageById((Long)Long.valueOf(billId));
                        params.put(TAXORG, building.getLong("taxorg.id"));
                        params.put(TAXPROJECT, building.getLong("taxproject.id"));
                        pkId = null;
                        this.loadBuildForm(pkId, params, BUILDINGCONTAINER, showParameter.getStatus());
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{BUILDINGCONTAINER});
                    }
                } else if (BUILDING.equalsIgnoreCase(flag)) {
                    pkId = Long.valueOf(billId);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"deletebuildingnode"});
                    this.loadBuildForm(pkId, params, BUILDINGCONTAINER, showParameter.getStatus());
                }
            }
        } else if (ROOMTREE.equalsIgnoreCase(treeView.getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            Long pkId = (Long)showParameter.getCustomParam(PK_ID);
            if (StringUtil.isNotEmpty((CharSequence)nodeId)) {
                String[] values = nodeId.split(REGEX);
                String flag = values[0];
                String billId = values[1];
                this.getView().setEnable(Boolean.FALSE, new String[]{"deleteroomnode"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"addroomnode"});
                String key = (String)showParameter.getCustomParam("key");
                this.getView().setVisible(Boolean.TRUE, new String[]{ROOMCONTAINER});
                if (BUILDING.equalsIgnoreCase(flag)) {
                    if (ADDTREENODE.equals(key) || OperationStatus.ADDNEW.equals((Object)showParameter.getStatus())) {
                        DynamicObject building = BuildingBusiness.queryBuildById((Long)Long.valueOf(billId));
                        params.put(BUILDING, Long.valueOf(billId));
                        params.put(STAGE, building.getLong("stage.id"));
                        params.put(TAXORG, building.getLong("taxorg.id"));
                        params.put(TAXPROJECT, building.getLong("taxproject.id"));
                        pkId = null;
                        this.loadRoomForm(pkId, params, showParameter.getStatus());
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{ROOMCONTAINER});
                    }
                } else if (ROOM.equalsIgnoreCase(flag)) {
                    pkId = Long.valueOf(billId);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"deleteroomnode"});
                    this.loadRoomForm(pkId, params, showParameter.getStatus());
                } else if (STAGE.equals(flag)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{ROOMCONTAINER});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"addroomnode"});
                    return;
                }
            }
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey;
        switch (subTabKey = event.getTabKey()) {
            case "tabstage": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btndel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{EDIT});
                this.loadStageForm(TABSTAGE, this.getView().getFormShowParameter().getStatus());
                break;
            }
            case "tabbuilding": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btndel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT});
                this.loadBuildTree(null);
                break;
            }
            case "tabroom": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btndel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT});
                this.loadRoomTree(null);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            Tab tab = (Tab)this.getView().getControl(TABAP);
            String tabName = tab.getCurrentTab();
            this.doOperateKey(tabName, args.getOperateKey());
        }
    }

    private void doOperateKey(String tabName, String key) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long pkId = null;
        OperationResult operationResult = null;
        String operateName = "";
        switch (tabName) {
            case "tabstage": {
                if (SAVE.equals(key)) {
                    operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"RoomBaseEditPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
                    operationResult = this.getView().getView(this.getPageCache().get("stagepageid")).invokeOperation(key);
                    if (operationResult.getSuccessPkIds().size() <= 0) break;
                    Object newPkId = operationResult.getSuccessPkIds().get(0);
                    if (!OperationStatus.ADDNEW.equals((Object)showParameter.getStatus())) break;
                    this.getView().setEnable(Boolean.TRUE, new String[]{TABBUILDING});
                    this.getPageCache().put(CURRENT_NODE_ID, "stage_" + newPkId);
                    break;
                }
                if (!DELETE.equals(key)) break;
                ArrayList<Long> pkidList = new ArrayList<Long>();
                String stageId = (String)showParameter.getCustomParam(NODE_ID);
                pkId = Long.valueOf(stageId.split(REGEX)[1]);
                pkidList.add(pkId);
                DynamicObject[] objects = StageBusiness.queryStageByIds(pkidList);
                DynamicObject[] buildings = BuildingBusiness.queryBuildByStageId((Long)pkId);
                if (buildings != null && buildings.length > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u671f\u4e0b\u5df2\u5b58\u5728\u697c\u680b\u4fe1\u606f\uff0c\u8bf7\u5148\u5220\u9664\u697c\u680b\u4fe1\u606f\u3002", (String)"RoomBaseEditPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().getView(this.getPageCache().get("stagepageid")).close();
                operateName = ResManager.loadKDString((String)"\u5220\u9664", (String)"RoomBaseEditPlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
                operationResult = OperationServiceHelper.executeOperate((String)key, (String)StageConstant.ENTITYNAME, (DynamicObject[])objects, (OperateOption)OperateOption.create());
                break;
            }
            case "tabbuilding": {
                TreeView tree = (TreeView)this.getView().getControl(BUILDINGTREE);
                String foucsNodeId = tree.getTreeState().getFocusNodeId();
                IFormView buildingView = this.getView().getView(this.getPageCache().get("buildingpageid"));
                if (SAVE.equals(key)) {
                    if (buildingView == null) break;
                    operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"RoomBaseEditPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
                    operationResult = buildingView.invokeOperation(key);
                    if (operationResult.getSuccessPkIds().size() <= 0) break;
                    if (OperationStatus.ADDNEW.equals((Object)showParameter.getStatus())) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{TABROOM});
                    }
                    Object newPkId = operationResult.getSuccessPkIds().get(0);
                    this.getPageCache().put(CURRENT_NODE_ID, "building_" + newPkId);
                    break;
                }
                if (ADDTREENODE.equals(key)) {
                    showParameter.setCustomParam("key", (Object)key);
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    this.loadBuildTree(key);
                    break;
                }
                if (DELETETREENODE.equals(key)) {
                    buildingView.close();
                    ArrayList<Long> pkidList = new ArrayList<Long>();
                    if (!StringUtil.isNotEmpty((CharSequence)foucsNodeId)) break;
                    String[] values = foucsNodeId.split(REGEX);
                    pkId = Long.valueOf(values[1]);
                    pkidList.add(pkId);
                    DynamicObject[] objects = BuildingBusiness.queryBuildByIds(pkidList);
                    DynamicObject[] rooms = RoomBusiness.queryRoomByBuildingId((Long)pkId);
                    if (rooms != null && rooms.length > 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u697c\u680b\u4e0b\u5df2\u5b58\u5728\u623f\u95f4\u4fe1\u606f\uff0c\u8bf7\u5148\u5220\u9664\u623f\u95f4\u4fe1\u606f\u3002", (String)"RoomBaseEditPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    operateName = ResManager.loadKDString((String)"\u5220\u9664\u6811\u8282\u70b9", (String)"RoomBaseEditPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
                    operationResult = OperationServiceHelper.executeOperate((String)DELETE, (String)"bastax_building", (DynamicObject[])objects, (OperateOption)OperateOption.create());
                    break;
                }
                if (!REFRESH.equals(key)) break;
                this.loadBuildTree(key);
                break;
            }
            case "tabroom": {
                TreeView tree = (TreeView)this.getView().getControl(ROOMTREE);
                IFormView roomView = this.getView().getView(this.getPageCache().get("roompageid"));
                if (SAVE.equals(key)) {
                    if (roomView == null) break;
                    operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"RoomBaseEditPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
                    operationResult = roomView.invokeOperation(key);
                    if (operationResult.getSuccessPkIds().size() <= 0) break;
                    Object newPkId = operationResult.getSuccessPkIds().get(0);
                    this.getPageCache().put(CURRENT_NODE_ID, "room_" + newPkId);
                    break;
                }
                if (ADDTREENODE.equals(key)) {
                    showParameter.setCustomParam("key", (Object)key);
                    this.loadRoomTree(key);
                    break;
                }
                if (DELETETREENODE.equals(key)) {
                    if (roomView != null) {
                        roomView.close();
                    }
                    ArrayList<Long> pkidList = new ArrayList<Long>();
                    String nodeId = tree.getTreeState().getFocusNodeId();
                    pkId = Long.valueOf(nodeId.split(REGEX)[1]);
                    pkidList.add(pkId);
                    DynamicObject[] objects = RoomBusiness.queryRoomByIds(pkidList);
                    if (nodeId.startsWith(ROOM)) {
                        String buildingId = (String)tree.getTreeState().getFocusNode().get("parentid");
                        this.getPageCache().put(CURRENT_NODE_ID, buildingId);
                    }
                    operateName = ResManager.loadKDString((String)"\u5220\u9664\u6811\u8282\u70b9", (String)"RoomBaseEditPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
                    operationResult = OperationServiceHelper.executeOperate((String)DELETE, (String)"bastax_room", (DynamicObject[])objects, (OperateOption)OperateOption.create());
                    break;
                }
                if (!REFRESH.equals(key)) break;
                this.loadBuildTree(key);
                break;
            }
        }
        if (operationResult != null) {
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(RoomBaseEditPlugin.getSuccessOperate(key));
                if (TABBUILDING.equals(tabName)) {
                    this.loadBuildTree(key);
                } else if (TABROOM.equals(tabName)) {
                    this.loadRoomTree(key);
                } else if (TABSTAGE.equals(tabName)) {
                    this.loadStageForm(TABSTAGE, OperationStatus.EDIT);
                }
            } else {
                this.getView().showOperationResult(operationResult, operateName);
            }
        }
    }

    public static String getSuccessOperate(String operateKey) {
        String opreateResult = "";
        if (DELETETREENODE.equals(operateKey) || DELETE.equals(operateKey)) {
            opreateResult = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RoomBaseEditPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        } else if (SAVE.equals(operateKey)) {
            opreateResult = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RoomBaseEditPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        }
        return opreateResult;
    }

    private void loadStageForm(String targetKey, OperationStatus status) {
        DynamicObject stageObj;
        DynamicObject roomObj;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId("bastax_stage");
        showParameter.setCustomParam("operation", (Object)"doadd");
        String nodeId = this.getPageCache().get(CURRENT_NODE_ID);
        Long pkId = (Long)formShowParameter.getCustomParam(PK_ID);
        if (pkId != null && (roomObj = RoomBusiness.queryRoomById((Long)pkId)) != null) {
            nodeId = "stage_" + roomObj.getLong("stage.id");
        }
        if ((stageObj = StageBusiness.queryStageByNodeId((String)nodeId)) != null) {
            showParameter.setPkId((Object)stageObj.getLong("id"));
        }
        showParameter.setStatus(status);
        this.getPageCache().put("stagepageid", showParameter.getPageId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void loadBuildTree(String key) {
        DynamicObject roomObj;
        String nodeId = this.getPageCache().get(CURRENT_NODE_ID);
        TreeView tree = (TreeView)this.getView().getControl(BUILDINGTREE);
        if (nodeId.startsWith(ROOM)) {
            roomObj = RoomBusiness.queryRoomById((Long)Long.valueOf(nodeId.split(REGEX)[1]));
            if (roomObj != null) {
                nodeId = "building_" + roomObj.getLong("building.id");
            }
        } else if (nodeId.startsWith(BUILDING) && (roomObj = BuildingBusiness.queryBuildById((Long)Long.valueOf(nodeId.split(REGEX)[1]))) == null) {
            nodeId = (String)tree.getTreeState().getFocusNode().get("parentid");
        }
        DynamicObject stageObj = StageBusiness.queryStageByNodeId((String)nodeId);
        if (stageObj != null) {
            TreeNode root = BuildingBusiness.queryBuildTree((Long)stageObj.getLong("id"));
            tree.addNode(root);
            TreeNode buildingNode = root.getTreeNode(nodeId);
            if (nodeId.startsWith(STAGE) && buildingNode.getChildren().size() > 0 && !ADDTREENODE.equals(key)) {
                buildingNode = (TreeNode)buildingNode.getChildren().get(0);
            }
            if (!StringUtils.isEmpty((String)key) && !SAVE.equals(key) && nodeId.startsWith(BUILDING)) {
                buildingNode = root.getTreeNode(buildingNode.getParentid());
                tree.updateNode(buildingNode);
                tree.expand(buildingNode.getId());
            } else {
                tree.updateNode(root);
            }
            if (!ADDTREENODE.equals(key)) {
                tree.focusNode(buildingNode);
            }
            this.getPageCache().put(CURRENT_NODE_ID, buildingNode.getId());
            tree.treeNodeClick(buildingNode.getParentid(), buildingNode.getId());
        }
    }

    private void loadBuildForm(Long pkId, Map<String, Object> params, String targetKey, OperationStatus status) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId("bastax_building");
        showParameter.setCustomParams(params);
        if (pkId != null) {
            showParameter.setPkId((Object)pkId);
            showParameter.setStatus(status);
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put("buildingpageid", showParameter.getPageId());
    }

    private void loadRoomTree(String key) {
        DynamicObject stageObj;
        String nodeId = this.getPageCache().get(CURRENT_NODE_ID);
        TreeView tree = (TreeView)this.getView().getControl(ROOMTREE);
        String treeId = nodeId;
        if (nodeId.startsWith(ROOM)) {
            DynamicObject roomObj = RoomBusiness.queryRoomById((Long)Long.valueOf(nodeId.split(REGEX)[1]));
            treeId = roomObj != null ? "building_" + roomObj.getLong("building.id") : (String)tree.getTreeState().getFocusNode().get("parentid");
        }
        if ((stageObj = StageBusiness.queryStageByNodeId((String)treeId)) != null) {
            TreeNode root = RoomBusiness.queryRoomTree((Long)stageObj.getLong("id"));
            tree.addNode(root);
            TreeNode buildingNode = root.getTreeNode(nodeId);
            if (!nodeId.startsWith(ROOM) && buildingNode.getChildren().size() > 0 && !ADDTREENODE.equals(key)) {
                buildingNode = (TreeNode)buildingNode.getChildren().get(0);
            }
            if (!StringUtils.isEmpty((String)key) && !SAVE.equals(key) && nodeId.startsWith(ROOM)) {
                tree.focusNode(buildingNode);
                buildingNode = root.getTreeNode(buildingNode.getParentid());
                tree.updateNode(buildingNode);
                tree.expand(buildingNode.getId());
            } else {
                tree.updateNode(root);
            }
            tree.focusNode(buildingNode);
            this.getPageCache().put(CURRENT_NODE_ID, buildingNode.getId());
            tree.treeNodeClick(buildingNode.getParentid(), buildingNode.getId());
        }
    }

    private void loadRoomForm(Long pkId, Map<String, Object> params, OperationStatus status) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(ROOMCONTAINER);
        showParameter.setFormId("bastax_room");
        showParameter.setCustomParams(params);
        if (pkId != null) {
            showParameter.setPkId((Object)pkId);
            showParameter.setStatus(status);
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        if (params.get(DELETE) != null) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm((FormShowParameter)showParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        this.getPageCache().put("roompageid", showParameter.getPageId());
    }
}

