/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.roombase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bamp.bastax.business.roombase.BuildingBusiness;
import kd.bamp.bastax.business.roombase.RoomBusiness;
import kd.bamp.bastax.business.roombase.StageBusiness;
import kd.bamp.bastax.common.constant.StageConstant;
import kd.bamp.bastax.common.util.PermissionUtils;
import kd.bamp.bastax.common.util.SearchUtil;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class RoomBaseListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
FilterContainerInitListener,
TreeNodeClickListener,
SearchClickListener,
AfterSearchClickListener {
    private static final String KEY_IMPORT = "importdata";
    private static final String KEY_EXPORT = "exportlist";
    private static final String IMPORT_DETAILS = "importdetails";
    private static final String EXPORT_DETAILS = "exportdetails";
    private static final String DELETE_KEY = "delete";
    private static final String SUBMIT_KEY = "submit";
    private static final String CANCEL_SUBMIT = "unsubmit";
    private static final String AUDIT_KEY = "audit";
    private static final String UNAUDIT_KEY = "unaudit";
    private static final String KEY_SEARCH = "searchap";
    public static final String STAGETREE = "stagetree";
    public static final String BILLLISTAP = "billlistap";
    public static final String TAXORGFILTER = "taxorgfilter";
    public static final String TAXPROJECTFILTER = "taxprojectfilter";
    public static final String STATUSFILTER = "statusfilter";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setEntityId("bastax_room");
            filterContainer.setBillFormId("bastax_room");
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        final HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"basedata", (String)"bastax_room", (String)"47150e89000000ac");
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    List list = hasPermOrgResult.getHasPermOrgs();
                    QFilter taxorgFilter = new QFilter("taxorg.id", "in", (Object)list);
                    setFilterEvent.getQFilters().add(taxorgFilter);
                    if (hasPermOrgResult.getHasPermOrgs().size() == 0) {
                        RoomBaseListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u623f\u95f4\u57fa\u7840\u4fe1\u606f\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"RoomBaseListPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        final TreeView tree = (TreeView)this.getView().getControl(STAGETREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        final IPageCache pageCache = this.getPageCache();
        Search sl = (Search)this.getControl(KEY_SEARCH);
        final IFormView view = this.getView();
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent searchEnterEvent) {
                if (!StringUtil.isEmpty((CharSequence)searchEnterEvent.getText())) {
                    ArrayList<String> dataKey = new ArrayList<String>();
                    dataKey.add("number");
                    SearchUtil.searchMember((String)searchEnterEvent.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)tree, (String)RoomBaseListPlugin.STAGETREE, dataKey);
                } else {
                    RoomBaseListPlugin.this.getPageCache().put("_resultlist", null);
                    RoomBaseListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"RoomBaseListPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                }
            }
        });
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent contInitEvent) {
        CommonFilterColumn cmmOrg = (CommonFilterColumn)contInitEvent.getFilterColumn("taxorg.number");
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"basedata", (String)"bastax_room", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List orgList = hasPermOrgResult.getHasPermOrgs();
            Set orgs = orgList.stream().map(Objects::toString).collect(Collectors.toSet());
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(orgList.size());
            List comboItems = cmmOrg.getComboItems();
            for (ComboItem comboItem : comboItems) {
                if (!orgs.contains(comboItem.getValue())) continue;
                items.add(comboItem);
            }
            cmmOrg.setComboItems(items);
        }
    }

    public void click(SearchClickEvent searchClickEvent) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        List fastQFilters = searchClickEvent.getFastQFilters();
        if (fastQFilters != null) {
            Map map = searchClickEvent.getFilterValues();
            List schemelist = (List)map.get("schemefilter");
            List customlist = (List)map.get("customfilter");
            ArrayList<QFilter> commonQFilterList = new ArrayList<QFilter>();
            for (Map customFiter : customlist) {
                List statusValues;
                List fieldNames = (List)customFiter.get("FieldName");
                if (fieldNames == null || fieldNames.size() == 0) continue;
                if ("taxorg.id".equals(fieldNames.get(0)) || "taxproject.id".equals(fieldNames.get(0))) {
                    List ids = (List)customFiter.get("Value");
                    ArrayList<Long> pkIds = new ArrayList<Long>();
                    for (Object id : ids) {
                        if (!StringUtils.isNotBlank(id)) continue;
                        pkIds.add(Long.valueOf(id.toString()));
                    }
                    if (pkIds.size() <= 0) continue;
                    QFilter qFilter = new QFilter((String)fieldNames.get(0), "in", pkIds);
                    commonQFilterList.add(qFilter);
                    continue;
                }
                if (!"status".equals(fieldNames.get(0)) || (statusValues = (List)customFiter.get("Value")).size() <= 0 || !StringUtils.isNotBlank(statusValues.get(0))) continue;
                QFilter qFilter = new QFilter("status", "in", (Object)statusValues);
                commonQFilterList.add(qFilter);
            }
            fastQFilters.addAll(commonQFilterList);
            FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
            List schemaQFilterList = schemaFilterParameter.getQFilters();
            fastQFilters.addAll(schemaQFilterList);
            list.setQueryFilterParameter(new FilterParameter(fastQFilters, null));
            this.getView().updateView(BILLLISTAP);
            boolean isClickStatus = false;
            boolean isClickTaxOrg = false;
            boolean isClickTaxProject = false;
            for (QFilter qFilter : commonQFilterList) {
                if ("taxorg.id".equals(qFilter.getProperty())) {
                    this.getPageCache().put(TAXORGFILTER, SerializationUtils.toJsonString((Object)qFilter));
                    isClickTaxOrg = true;
                }
                if ("taxproject.id".equals(qFilter.getProperty())) {
                    this.getPageCache().put(TAXPROJECTFILTER, SerializationUtils.toJsonString((Object)qFilter));
                    isClickTaxProject = true;
                }
                if (!"status".equals(qFilter.getProperty())) continue;
                this.getPageCache().put(STATUSFILTER, SerializationUtils.toJsonString((Object)qFilter));
                isClickStatus = true;
            }
            if (!isClickTaxOrg) {
                this.getPageCache().put(TAXORGFILTER, null);
            }
            if (!isClickTaxProject) {
                this.getPageCache().put(TAXPROJECTFILTER, null);
            }
            if (!isClickStatus) {
                this.getPageCache().put(STATUSFILTER, null);
            }
            this.loadStateTree();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(STAGETREE)), (String[])btns, (String)STAGETREE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        if (list != null) {
            QFilter qFilter = new QFilter("taxorg.id", "=", (Object)RequestContext.get().getOrgId());
            list.setQueryFilterParameter(new FilterParameter(qFilter, null));
            this.getPageCache().put(TAXORGFILTER, SerializationUtils.toJsonString((Object)qFilter));
        }
        this.loadStateTree();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        BillList list = (BillList)this.getControl(BILLLISTAP);
        QFilter customerFilter = this.getCustomerFilter();
        FilterParameter filterParameter = new FilterParameter(customerFilter, null);
        if (nodeId != null && !"-1".equals(nodeId)) {
            String flag = nodeId.split("_")[0];
            Long pkId = Long.valueOf(nodeId.split("_")[1]);
            QFilter qFilter = new QFilter("stage.id", "=", (Object)pkId);
            if (flag.startsWith("building")) {
                qFilter = new QFilter("building.id", "=", (Object)pkId);
            }
            filterParameter.getQFilters().add(qFilter);
            this.getView().setEnable(Boolean.TRUE, new String[]{"addnode"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"deletenode"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"addnode"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"deletenode"});
        }
        QFilter statusFilter = null;
        String statusFilterCache = this.getPageCache().get(STATUSFILTER);
        if (!StringUtils.isBlank((CharSequence)statusFilterCache)) {
            statusFilter = (QFilter)SerializationUtils.fromJsonString((String)statusFilterCache, QFilter.class);
            filterParameter.getQFilters().add(statusFilter);
        }
        list.setQueryFilterParameter(filterParameter);
        list.refresh();
        list.clearSelection();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("number".equals(evt.getFieldName())) {
            BillList list = (BillList)evt.getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long pkId = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("tabroom");
            showParameter.setFormId("bastax_roombaseedit");
            showParameter.setCustomParam("nodeId", this.getCurrentNodeId());
            showParameter.setCustomParam("pkId", (Object)pkId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "save"));
            this.getView().showForm(showParameter);
        }
    }

    private void loadStateTree() {
        TreeView tree = (TreeView)this.getView().getControl(STAGETREE);
        QFilter customerFilter = this.getCustomerFilter();
        TreeNode root = StageBusiness.queryStageTree((QFilter)customerFilter);
        tree.addNode(root);
        tree.updateNode(root);
        tree.expand(root.getId());
        this.getPageCache().put(STAGETREE, SerializationUtils.toJsonString((Object)root));
        if (tree.getTreeState().getFocusNodeId() == null || "-1".equals(tree.getTreeState().getFocusNodeId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"addnode"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"deletenode"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"addnode"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"deletenode"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        if (KEY_IMPORT.equals(key) || KEY_EXPORT.equals(key)) {
            this.openTaxMainListform(key);
            if (KEY_IMPORT.equals(key)) {
                billlistap.clearSelection();
                billlistap.refresh();
                this.loadStateTree();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)IMPORT_DETAILS)) {
            this.viewImportdetails();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)EXPORT_DETAILS)) {
            this.viewExportdetails();
        } else if ("addnew".equalsIgnoreCase(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("bastax_roombaseedit");
            showParameter.setCustomParam("nodeId", (Object)"-1");
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
            this.getView().showForm(showParameter);
        } else if ("edit".equalsIgnoreCase(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("bastax_roombaseedit");
            showParameter.setCustomParam("nodeId", this.getCurrentNodeId());
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
            this.getView().showForm(showParameter);
        } else if ("refresh".equalsIgnoreCase(key)) {
            this.loadStateTree();
            billlistap.refresh();
            billlistap.clearSelection();
        } else if ("deletenode".equalsIgnoreCase(key)) {
            if (this.getCurrentNodeId() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5220\u9664\u7684\u6811\u8282\u70b9\u3002", (String)"RoomBaseListPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            } else {
                String nodeId = (String)this.getCurrentNodeId();
                String flag = nodeId.split("_")[0];
                Long pkId = Long.valueOf(nodeId.split("_")[1]);
                DynamicObject[] dynamicObjects = null;
                if ("stage".equals(flag)) {
                    dynamicObjects = BuildingBusiness.queryBuildByStageId((Long)pkId);
                    if (dynamicObjects != null && dynamicObjects.length > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u671f\u4e0b\u5df2\u5b58\u5728\u697c\u680b\u4fe1\u606f\uff0c\u8bf7\u5148\u5220\u9664\u697c\u680b\u4fe1\u606f\u3002", (String)"RoomBaseListPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    } else {
                        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)StageConstant.ENTITYNAME), (Object[])new Object[]{pkId});
                        this.loadStateTree();
                    }
                } else {
                    dynamicObjects = RoomBusiness.queryRoomByBuildingId((Long)pkId);
                    if (dynamicObjects != null && dynamicObjects.length > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u697c\u680b\u4e0b\u5df2\u5b58\u5728\u623f\u95f4\u4fe1\u606f\uff0c\u8bf7\u5148\u5220\u9664\u623f\u95f4\u4fe1\u606f\u3002", (String)"RoomBaseListPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    } else {
                        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bastax_building"), (Object[])new Object[]{pkId});
                        this.loadStateTree();
                    }
                }
            }
        } else {
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RoomBaseListPlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            } else if (this.isOperateKey(key)) {
                List pkidList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(x -> (Long)x).collect(Collectors.toList());
                DynamicObject[] objects = RoomBusiness.queryRoomByIds(pkidList);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)key, (String)"bastax_room", (DynamicObject[])objects, (OperateOption)OperateOption.create());
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(RoomBaseListPlugin.getSuccessOperate(key));
                } else {
                    this.getView().showOperationResult(operationResult);
                }
                if (operationResult.getSuccessPkIds().size() > 0) {
                    if (DELETE_KEY.equals(key)) {
                        billlistap.clearSelection();
                    }
                    billlistap.refresh();
                }
            }
        }
    }

    public static String getSuccessOperate(String operateKey) {
        String opreateResult = "";
        if (DELETE_KEY.equals(operateKey)) {
            opreateResult = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RoomBaseListPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        } else if (SUBMIT_KEY.equals(operateKey)) {
            opreateResult = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"RoomBaseListPlugin_7", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        } else if (CANCEL_SUBMIT.equals(operateKey)) {
            opreateResult = ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"RoomBaseListPlugin_8", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        } else if (AUDIT_KEY.equals(operateKey)) {
            opreateResult = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"RoomBaseListPlugin_9", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        } else if (UNAUDIT_KEY.equals(operateKey)) {
            opreateResult = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"RoomBaseListPlugin_10", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        }
        return opreateResult;
    }

    private boolean isOperateKey(String key) {
        return DELETE_KEY.equals(key) || SUBMIT_KEY.equals(key) || CANCEL_SUBMIT.equals(key) || AUDIT_KEY.equals(key) || UNAUDIT_KEY.equals(key);
    }

    private void openTaxMainListform(String key) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("bastax_room");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        if (KEY_EXPORT.equals(key)) {
            BillList billlistap = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            List pkidList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(x -> (Long)x).collect(Collectors.toList());
            showParameter.setSelectedRows(pkidList.toArray());
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewImportdetails() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("bos_importlog");
        listShowParameter.getListFilterParameter().setFilter(new QFilter("sourceobj.number", "=", (Object)"bastax_room"));
        listShowParameter.getListFilterParameter().setFilter(new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimportlog"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void viewExportdetails() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("bos_exportlog");
        listShowParameter.getListFilterParameter().setFilter(new QFilter("sourceobj.number", "=", (Object)"bastax_room"));
        listShowParameter.getListFilterParameter().setFilter(new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeexportlog"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("addnew".equalsIgnoreCase(evt.getActionId()) || "save".equalsIgnoreCase(evt.getActionId())) {
            BillList billlistap = (BillList)this.getControl(BILLLISTAP);
            billlistap.refreshData();
            this.loadStateTree();
        }
    }

    protected Object getCurrentNodeId() {
        TreeView treeView = (TreeView)this.getControl(STAGETREE);
        Object nodeId = null;
        if (treeView != null && treeView.getTreeState() != null && treeView.getTreeState().getFocusNode() != null) {
            nodeId = treeView.getTreeState().getFocusNode().get("id");
        }
        return nodeId;
    }

    protected QFilter getCustomerFilter() {
        String projectFilterCache;
        QFilter customerFilter = null;
        String orgFilterCache = this.getPageCache().get(TAXORGFILTER);
        if (!StringUtils.isBlank((CharSequence)orgFilterCache)) {
            customerFilter = (QFilter)SerializationUtils.fromJsonString((String)orgFilterCache, QFilter.class);
        }
        if (!StringUtils.isBlank((CharSequence)(projectFilterCache = this.getPageCache().get(TAXPROJECTFILTER)))) {
            QFilter taxProjectFilter = (QFilter)SerializationUtils.fromJsonString((String)projectFilterCache, QFilter.class);
            if (customerFilter == null) {
                customerFilter = taxProjectFilter;
            } else {
                customerFilter.and(taxProjectFilter);
            }
        }
        return customerFilter;
    }
}

