/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxarea;

import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bamp.bastax.common.util.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.New;
import kd.bos.list.plugin.AbstractTreeListPlugin;

public class TaxAreaList
extends AbstractTreeListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof New) {
            TreeNode treeNode;
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeModel().getRoot();
            if (root == (treeNode = root.getTreeNode(currentNodeId, 20))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u533a\u57df\u3002", (String)"TaxAreaList_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private Set<String> validationRepDate(DynamicObject[] rows, Long id, Date start, Date end, String group, String country, DynamicObject row) {
        boolean isEffective = false;
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject exist : rows) {
            Date existStart = exist.getDate("startdate");
            Date existEnd = exist.getDate("enddate");
            String existGroup = exist.getString("group.id");
            String existCountry = exist.getString("country.id");
            if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(id), (CharSequence)exist.getString("id")) || !StringUtils.equalsIgnoreCase((CharSequence)group, (CharSequence)existGroup) || !StringUtils.equalsIgnoreCase((CharSequence)country, (CharSequence)existCountry)) continue;
            if (Objects.isNull(end) && Objects.isNull(existEnd)) {
                isEffective = true;
                break;
            }
            if (!DateUtils.isEffectiveDate((Date)start, (Date)existStart, (Date)existEnd) && !DateUtils.isEffectiveDate((Date)existStart, (Date)start, (Date)end)) continue;
            isEffective = true;
            break;
        }
        if (isEffective) {
            set.add(String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u56fd\u5bb6\uff1a%1$s%2$s\u3002", (String)"TaxAreaList_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), row.getString("group.name"), row.getString("country.name")));
        }
        return set;
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] dynamicObjects = e.getQueryValues();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            String countryName = dynamicObjects[i].getString("country.name");
            String admindivisionFullName = dynamicObjects[i].getString("admindivision.fullname");
            if (admindivisionFullName == null) continue;
            String result = this.changeAdmindivisionName(countryName, admindivisionFullName);
            dynamicObjects[i].getDynamicObject("admindivision").set("fullname", (Object)result);
        }
    }

    private String changeAdmindivisionName(String countryName, String admindivisionFullName) {
        return countryName + "/" + admindivisionFullName.replace("_", "/");
    }
}

