/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxarea;

import java.util.Date;
import java.util.Objects;
import kd.bamp.bastax.common.util.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxAreaOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String countryId;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    Date start = currentObj.getDate("startdate");
                    Date end = currentObj.getDate("enddate");
                    Long country = currentObj.getLong("country.id");
                    Long group = currentObj.getLong("group.id");
                    Long admindivisionId = currentObj.getLong("admindivision.id");
                    boolean isEffective = false;
                    QFilter idQFilter = new QFilter("id", "!=", currentObj.get("id"));
                    QFilter groupQFilter = new QFilter("group", "=", (Object)group);
                    QFilter countryQFilter = new QFilter("country", "=", (Object)country);
                    QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
                    QFilter[] qFilters = new QFilter[]{idQFilter, countryQFilter, groupQFilter, enableQFilter};
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)currentObj.getDataEntityType().getExtendName(), (String)"id,startdate,enddate,group,country", (QFilter[])qFilters);
                    for (DynamicObject exist : colls) {
                        Date existStart = exist.getDate("startdate");
                        Date existEnd = exist.getDate("enddate");
                        if (Objects.isNull(end) && Objects.isNull(existEnd)) {
                            isEffective = true;
                            break;
                        }
                        if (!DateUtils.isEffectiveDate((Date)start, (Date)existStart, (Date)existEnd) && !DateUtils.isEffectiveDate((Date)existStart, (Date)start, (Date)end)) continue;
                        isEffective = true;
                        break;
                    }
                    QFilter admindivisionFilter = new QFilter("id", "=", (Object)admindivisionId);
                    DynamicObject admindivision = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"country", (QFilter[])new QFilter[]{admindivisionFilter});
                    if (isEffective) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u56fd\u5bb6\u6216\u5730\u533a\uff1a%1$s%2$s\u3002", (String)"TaxAreaOp_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), currentObj.getString("group.name"), currentObj.getString("country.name")));
                    }
                    if (admindivision == null || (countryId = admindivision.getString("country")).equalsIgnoreCase(country.toString())) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u9009\u62e9\u7684\u56fd\u5bb6\u6216\u5730\u533a\u4e0e\u201c\u56fd\u5bb6\u6216\u5730\u533a\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"TaxAreaOp_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

