/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxgroup;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class TaxGroupEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TAX_CODE = "taxcode";
    private static final String COUNTRY = "country";
    private static final String COUNTRY_CHANGE = "is_change";
    private static final String ENTYR_ENTITY = "entryentity";
    private static final String TAXCODEPROPERTY_JX = "jx";
    private static final String TAXCODEPROPERTY_XX = "xx";

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        if (org != null) {
            this.getModel().setValue(COUNTRY, (Object)org.getLong("country.id"));
        }
    }

    public void initialize() {
        BasedataEdit taxcodefield = (BasedataEdit)this.getControl(TAX_CODE);
        taxcodefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(TAX_CODE)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            DynamicObjectCollection taxcodes = this.getModel().getEntryEntity(ENTYR_ENTITY);
            List ids = taxcodes.stream().map(o -> o.getLong("taxcode.id")).collect(Collectors.toList());
            QFilter qFilterNoIds = new QFilter("id", "not in", (Object)ids.toArray());
            listFilterParameter.setFilter(qFilterNoIds);
            DynamicObject country = (DynamicObject)this.getModel().getValue(COUNTRY);
            if (country != null) {
                QFilter countryFilter = new QFilter("country.id", "=", (Object)country.getLong("id"));
                listFilterParameter.setFilter(countryFilter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6\u6216\u5730\u533a\u3002", (String)"TaxGroupEditPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (COUNTRY.equals(e.getProperty().getName())) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.showConfirmTips(oldValue.getString("id"));
            } else {
                this.showConfirmTips("");
            }
        }
    }

    private void showConfirmTips(String oldValue) {
        if (this.hasEntryRows() && !"true".equals(this.getPageCache().get(COUNTRY_CHANGE))) {
            this.getPageCache().put("OLD_COUNTRY", oldValue);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("SET_COUNTRY", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxGroupEditPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxGroupEditPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u4fee\u6539\u56fd\u5bb6\u6216\u5730\u533a\u5c06\u6e05\u7a7a\u7a0e\u7801\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"TaxGroupEditPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.getPageCache().put(COUNTRY_CHANGE, "false");
        }
    }

    private boolean hasEntryRows() {
        int size = this.getModel().getEntryRowCount(ENTYR_ENTITY);
        return size == 1 && (DynamicObject)this.getModel().getValue(TAX_CODE, 0) != null || size > 1;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("SET_COUNTRY".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getPageCache().put(COUNTRY_CHANGE, "false");
                this.getModel().deleteEntryData(ENTYR_ENTITY);
                this.getModel().createNewEntryRow(ENTYR_ENTITY);
            } else {
                Long oldCountryId = Long.valueOf(this.getPageCache().get("OLD_COUNTRY"));
                this.getPageCache().put(COUNTRY_CHANGE, "true");
                this.getModel().setValue(COUNTRY, (Object)oldCountryId);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            AtomicInteger jx = new AtomicInteger(0);
            AtomicInteger xx = new AtomicInteger(0);
            DynamicObjectCollection taxcodes = this.getModel().getEntryEntity(ENTYR_ENTITY);
            taxcodes.stream().forEach(row -> {
                String taxcodeproperty = row.getString("taxcode.taxcodeproperty");
                if (StringUtils.equalsIgnoreCase((CharSequence)TAXCODEPROPERTY_JX, (CharSequence)taxcodeproperty)) {
                    jx.getAndIncrement();
                } else if (StringUtils.equalsIgnoreCase((CharSequence)TAXCODEPROPERTY_XX, (CharSequence)taxcodeproperty)) {
                    xx.getAndIncrement();
                }
            });
            if (jx.intValue() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u7a0e\u7ec4\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u6761\u8fdb\u9879\u5c5e\u6027\u7a0e\u7801\uff0c\u8bf7\u4fee\u6539", (String)"TaxGroupEditPlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (xx.intValue() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u7a0e\u7ec4\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u6761\u9500\u9879\u5c5e\u6027\u7a0e\u7801\uff0c\u8bf7\u4fee\u6539", (String)"TaxGroupEditPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

