/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxproject;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bamp.bastax.common.util.PermissionUtils;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.New;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class TaxprojectList
extends AbstractTreeListPlugin {
    private static final String TAXORG = "taxorg.name";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List list = hasPermOrgResult.getHasPermOrgs();
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(32);
            DynamicObject[] collection = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
            for (DynamicObject object : collection) {
                ComboItem item = new ComboItem();
                item.setValue(object.getString("id"));
                item.setCaption(new LocaleString(object.getString("name")));
                combos.add(item);
            }
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!StringUtil.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)TAXORG)) continue;
                CommonFilterColumn filter = (CommonFilterColumn)filterColumn;
                filter.setComboItems(combos);
            }
        }
        ArrayList<String> hideList = new ArrayList<String>();
        hideList.add("enable");
        args.getSchemeFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getCommonFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getFastFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ArrayList<String> hideList = new ArrayList<String>();
        hideList.add("enable");
        List listColumns = args.getListColumns();
        listColumns.removeIf(column -> hideList.contains(column.getListFieldKey()));
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnedit"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btndel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectRows;
        DynamicObject[] objs;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof New) {
            TreeView tree = (TreeView)this.getView().getControl("treeview");
            String parentid = (String)tree.getTreeState().getFocusNode().get("parentid");
            if (StringUtil.isEmpty((CharSequence)parentid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7a0e\u52a1\u9879\u76ee\u7c7b\u522b\u3002", (String)"TaxprojectList_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Submit && (objs = BusinessDataServiceHelper.load((Object[])(listSelectRows = args.getListSelectedData()).getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((ListView)this.getView()).getBillFormId()))).length > 0) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            for (DynamicObject obj : objs) {
                String groupNumber = obj.getString("group.number");
                if (!"001".equalsIgnoreCase(groupNumber) && !"002".equalsIgnoreCase(groupNumber) || obj.get("taxorgan") != null && !StringUtil.isBlank((CharSequence)obj.getString("projectlocation")) && !StringUtil.isBlank((CharSequence)obj.getString("zsfs"))) continue;
                idMap.put(String.valueOf(obj.getPkValue()), obj.getString("number"));
            }
            if (idMap.size() > 0) {
                args.setCancel(true);
                String msg = String.join((CharSequence)"\u3001", idMap.values());
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5\u672a\u7ef4\u62a4:%s\u3002", (String)"TaxprojectList_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), msg));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String focusNodeId = (String)this.getView().getFormShowParameter().getCustomParam("focusNodeId");
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String focusNodeId = (String)this.getView().getFormShowParameter().getCustomParam("focusNodeId");
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            if (focusNodeId.equals(e.getNodeId())) {
                return;
            }
            TreeNode node = null;
            for (TreeNode child : this.getTreeModel().getRoot().getChildren()) {
                if (!focusNodeId.equals(child.getId())) continue;
                node = child;
                break;
            }
            if (node != null) {
                TreeView treeview = (TreeView)this.getControl("treeview");
                treeview.treeNodeClick(this.getTreeModel().getRoot().getId(), node.getId());
                treeview.focusNode(node);
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String focusNodeId = (String)this.getView().getFormShowParameter().getCustomParam("focusNodeId");
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            this.getTreeModel().getTreeFilter().clear();
            this.getTreeModel().getTreeFilter().add(new QFilter("id", "=", (Object)Long.parseLong(focusNodeId)));
        }
    }

    public void setFilter(SetFilterEvent e) {
        String focusNodeId = (String)this.getView().getFormShowParameter().getCustomParam("focusNodeId");
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            e.addCustomQFilter(new QFilter("group", "=", (Object)Long.parseLong(focusNodeId)));
        }
    }
}

