/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxview;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bamp.bastax.common.util.DBUtils;
import kd.bamp.bastax.common.util.OrgUtils;
import kd.bamp.bastax.formplugin.taxview.OrgViewCustomPlugin;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.ViewSchemaParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public abstract class AbstractOrgViewPlugin
extends AbstractBasePlugIn
implements ClickListener,
TreeNodeCheckListener,
TreeNodeDragListener,
SearchEnterListener,
TreeNodeClickListener {
    private static final Log logger = LogFactory.getLog(AbstractOrgViewPlugin.class);
    protected static final String BIZUNITTREE = "bizunittree";
    protected static final String BIZVIEWTREE = "bizviewtree";
    protected static final String ISCHECKUNITCHILD = "ischeckunitchild";
    protected static final String BTN_ADDNODE = "btn_addnode";
    protected static final String BTN_DELETENODE = "btn_deletenode";
    protected static final String UNIT_ROOT = "unittreenode";
    protected static final String VIEW_ROOT = "viewtreenode";
    protected static final String OLD_VIEW_CACHE = "oldviewtree";
    public static final String KEY_ADDNODE = "_addNode_";
    public static final String KEY_UPDATENODE = "_updateNode_";
    public static final String KEY_DELETENODE = "_deleteNode_";
    protected static final String DEAFAULT_VIEW_ID = String.valueOf("40");
    protected static final String TCTB_ORG_DEFAULT_VIEW = "tctb_org_default_view";
    protected static final String TCTB_ORG_VIEW_CUSTOM = "tctb_org_view_custom";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String ISDEFAULT = "isdefault";
    protected TreeView bizunittree;
    protected TreeView bizviewtree;

    public void initialize() {
        super.initialize();
        this.bizunittree = (TreeView)this.getView().getControl(BIZUNITTREE);
        this.bizviewtree = (TreeView)this.getView().getControl(BIZVIEWTREE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ISCHECKUNITCHILD, BTN_ADDNODE, BTN_DELETENODE});
        this.bizunittree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.bizviewtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search orgsearchap = (Search)this.getView().getControl("orgsearchap");
        orgsearchap.addEnterListener((SearchEnterListener)this);
        Search viewsearchap = (Search)this.getView().getControl("viewsearchap");
        viewsearchap.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btn_addnode": {
                this.addNode();
                break;
            }
            case "btn_deletenode": {
                this.deleteNode();
                break;
            }
            case "clear": {
                TreeNode bizTree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZUNITTREE), TreeNode.class);
                this.bizviewtree.deleteAllNodes();
                this.bizviewtree.addNode(new TreeNode(bizTree.getParentid(), bizTree.getId(), bizTree.getText()));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("orgproperty".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            this.filterProperty(newValue);
        }
    }

    private void filterProperty(DynamicObject newValue) {
        this.bizunittree.deleteAllNodes();
        Object qf = null;
        Long viewId = 0L;
        String name = null;
        if (newValue != null) {
            viewId = newValue.getLong("masterid");
            name = newValue.getDynamicObjectType() != null ? newValue.getDynamicObjectType().getName() : null;
        }
        Map unitTreeMap = null;
        unitTreeMap = "bos_org_pattern".equals(name) ? OrgUtils.getAllOrgByOrgpatternId((Long)Long.parseLong(DEAFAULT_VIEW_ID), (Long)viewId) : OrgUtils.getAllOrgByViewId((Long)viewId);
        Map flatOrgTreeMap = OrgUtils.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = OrgUtils.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            unitRoot = OrgUtils.createTreeNode((Map)unitTreeMap);
            flatOrgTreeMap = OrgUtils.getOrgTreeMap((Map)unitTreeMap);
        }
        if (unitRoot != null) {
            OrgUtils.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        }
        this.bizunittree.deleteAllNodes();
        this.bizunittree.addNode(unitRoot);
    }

    private void getInfo(Map<String, Map<String, String>> unitTreeMap, Map<String, Map<String, String>> allTreeMap) {
        for (Map.Entry<String, Map<String, String>> unitTree : unitTreeMap.entrySet()) {
            Map<String, String> map = allTreeMap.get(unitTree.getKey());
            unitTreeMap.get(unitTree.getKey()).put("parentid", this.getParent(map.get("id"), allTreeMap, unitTreeMap));
        }
    }

    private String getParent(String key, Map<String, Map<String, String>> allTreeMap, Map<String, Map<String, String>> unitTreeMap) {
        String parent = "";
        while (StringUtils.isBlank((CharSequence)parent)) {
            Map<String, String> map = allTreeMap.get(key);
            if (unitTreeMap.containsKey(key = map.get("parentid"))) {
                parent = key;
                continue;
            }
            if (!"0".equals(key)) continue;
            parent = map.get("id");
        }
        return parent;
    }

    protected Long saveModelValue(Long id) {
        IDataModel model = this.getModel();
        DynamicObject modelNew = model.getDataEntity();
        modelNew.set("id", (Object)id);
        DynamicObject[] saveDb = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{modelNew});
        return saveDb[0].getLong("id");
    }

    protected void addDutyRoot(TreeNode viewTreeNode) {
        OrgParam param = new OrgParam();
        param.setId(Long.parseLong(viewTreeNode.getId()));
        String parentId = viewTreeNode.getParentid();
        param.setDuty(this.getViewSchemaNumber());
        param.setParentId(parentId.equals("") ? 0L : Long.parseLong(parentId));
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u5f00\u59cb\u6267\u884cOrgUnitServiceHelper.addDutyRoot\uff0c\u53c2\u6570:" + JSON.toJSONString((Object)param));
        long start = System.currentTimeMillis();
        OrgUnitServiceHelper.addDutyRoot((OrgParam)param);
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u7ed3\u675f\u6267\u884cOrgUnitServiceHelper.addDutyRoot\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start));
    }

    protected OrgApiResult addViewSchema(Long pkId) {
        ViewSchemaParam view = new ViewSchemaParam();
        view.setNumber(this.getViewSchemaNumber());
        view.setName(this.getModel().getValue(NAME).toString());
        view.setViewType("40");
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)billShowParameter.getBillStatus().name(), (CharSequence)BillOperationStatus.ADDNEW.name())) {
            view.setCustomId(pkId.longValue());
        } else {
            view.setId(pkId.longValue());
        }
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u5f00\u59cb\u6267\u884cOrgUnitServiceHelper.saveOrgViewSchema,\u53c2\u6570\u4e3a\uff1a" + JSON.toJSON((Object)view));
        long start = System.currentTimeMillis();
        OrgApiResult result = OrgUnitServiceHelper.saveOrgViewSchema((ViewSchemaParam)view);
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u7ed3\u675f\u6267\u884cOrgUnitServiceHelper.saveOrgViewSchema,\u8017\u65f6\u4e3a\uff1a{}\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)(System.currentTimeMillis() - start), JSON.toJSON((Object)result));
        return result;
    }

    private void deleteNode() {
        List rightNodes = this.bizviewtree.getTreeState().getCheckedNodeIds();
        if (rightNodes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u7ec4\u7ec7", (String)"AbstractOrgViewPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode viewRoot = this.getCachedRoot(VIEW_ROOT);
        for (String node : rightNodes) {
            TreeNode checkNodeInfo = OrgUtils.getTreeNodeById((String)node, (TreeNode)viewRoot);
            if (checkNodeInfo == null) continue;
            List<TreeNode> delList = this.getAllChildrenAndSelf(checkNodeInfo);
            delList.addAll(this.getCacheTree(KEY_DELETENODE));
            this.putKeyTreeCache(KEY_DELETENODE, delList);
            String parentId = checkNodeInfo.getParentid();
            if (parentId.equals("")) {
                viewRoot.setChildren(null);
                this.bizviewtree.deleteAllNodes();
                this.bizviewtree.addNode(viewRoot);
                continue;
            }
            viewRoot.deleteChildNode(checkNodeInfo.getId());
            this.bizviewtree.deleteNode(checkNodeInfo.getId());
            TreeNode parentNode = OrgUtils.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
            if (parentNode.getChildren() == null || parentNode.getChildren() != null && parentNode.getChildren().isEmpty()) {
                parentNode.setChildren(null);
            }
            this.bizviewtree.updateNode(parentNode);
            this.bizviewtree.expand(parentId);
        }
        this.getPageCache().put(VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    public void treeNodeDragged(TreeNodeDragEvent evt) {
    }

    private void addNode() {
        List leftNodes = this.bizunittree.getTreeState().getCheckedNodes();
        if (leftNodes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7ec4\u7ec7", (String)"AbstractOrgViewPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        List rightNodes = this.bizviewtree.getTreeState().getCheckedNodeIds();
        if (rightNodes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7", (String)"AbstractOrgViewPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rightNodes.size() > 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%1$s", (String)"AbstractOrgViewPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), rightNodes.size()));
            return;
        }
        String viewCheckedId = (String)rightNodes.get(0);
        TreeNode viewRoot = this.getCachedRoot(VIEW_ROOT);
        List<TreeNode> viewNodeAll = this.getAllChildrenAndSelf(viewRoot);
        List viewIdAll = viewNodeAll.stream().map(TreeNode::getId).collect(Collectors.toList());
        TreeNode viewCheckedNode = OrgUtils.getTreeNodeById((String)viewCheckedId, (TreeNode)viewRoot);
        List unitCheckedNodes = OrgUtils.buildTreeNodeByList((TreeNode)viewCheckedNode, (List)leftNodes);
        unitCheckedNodes.removeIf(node -> node.getId().equals(viewRoot.getId()));
        List<String> dumpIds = unitCheckedNodes.stream().map(TreeNode::getId).filter(viewIdAll::contains).collect(Collectors.toList());
        TreeNode finalAppendNode = this.getAllNode();
        List<TreeNode> needUpdateNodes = this.getNeedUpdateNodes(viewRoot, dumpIds);
        needUpdateNodes.add(viewCheckedNode);
        this.removeNodes(viewRoot, dumpIds);
        this.bizviewtree.updateNodes(needUpdateNodes);
        ArrayList<TreeNode> addList = new ArrayList<TreeNode>();
        if (finalAppendNode.getChildren() != null) {
            for (TreeNode tre : finalAppendNode.getChildren()) {
                this.clearSelectNode(tre);
                tre.setParentid(viewCheckedNode.getId());
                if (viewCheckedNode.getChildren() == null) {
                    viewCheckedNode.addChild(tre);
                } else {
                    viewCheckedNode.getChildren().add(tre);
                }
                addList.addAll(this.getAllChildrenAndSelf(tre));
            }
        }
        OrgUtils.sortTreeNode((List)viewCheckedNode.getChildren());
        this.bizviewtree.checkNode(viewCheckedNode);
        TreeNode old = this.getCachedRoot(OLD_VIEW_CACHE);
        List<TreeNode> tempAddList = addList.stream().filter(node -> null == OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)old) || null != OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)old) && null == OrgUtils.getTreeNodeById((String)node.getParentid(), (TreeNode)viewRoot) || null != OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)old) && null != OrgUtils.getTreeNodeById((String)node.getParentid(), (TreeNode)viewRoot) && !StringUtils.equalsIgnoreCase((CharSequence)node.getParentid(), (CharSequence)OrgUtils.getTreeNodeById((String)node.getParentid(), (TreeNode)viewRoot).getId())).collect(Collectors.toList());
        tempAddList.addAll(this.getCacheTree(KEY_ADDNODE));
        this.putKeyTreeCache(KEY_ADDNODE, tempAddList);
        List<TreeNode> tempUpdateList = addList.stream().filter(node -> null != OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)old) && null != OrgUtils.getTreeNodeById((String)node.getParentid(), (TreeNode)viewRoot)).collect(Collectors.toList());
        tempUpdateList.addAll(this.getCacheTree(KEY_UPDATENODE));
        this.putKeyTreeCache(KEY_UPDATENODE, tempUpdateList);
        this.getPageCache().put(VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    private void clearSelectNode(TreeNode viewCheckedNode) {
        this.bizunittree.uncheckNode(viewCheckedNode.getId());
    }

    private TreeNode getAllNode() {
        List leftNodes = this.bizunittree.getTreeState().getCheckedNodes();
        Long mainViewId = Long.parseLong(this.getPageCache().get("mainViewId"));
        Map<String, Map<String, String>> unitTreeMap = this.getSelectInfo(OrgUtils.getAllOrgByViewId((Long)mainViewId), leftNodes);
        this.removeRepetion(unitTreeMap);
        Map allTreeMap = OrgUtils.getAllOrgByViewId((Long)mainViewId);
        Map flatOrgTreeMap = OrgUtils.getOrgTreeMap(unitTreeMap);
        TreeNode unitRoot = OrgUtils.createTreeNode(unitTreeMap);
        if (unitRoot == null) {
            this.getInfo(unitTreeMap, allTreeMap);
            TreeNode tree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(UNIT_ROOT), TreeNode.class);
            if (unitTreeMap.get(tree.getId()) == null) {
                unitTreeMap.put(tree.getId(), (Map<String, String>)allTreeMap.get(tree.getId()));
            }
            unitRoot = OrgUtils.createTreeNode(unitTreeMap);
            flatOrgTreeMap = OrgUtils.getOrgTreeMap(unitTreeMap);
        }
        OrgUtils.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        return unitRoot;
    }

    private void removeRepetion(Map<String, Map<String, String>> unitTreeMap) {
        TreeNode viewRoot = this.getCachedRoot(VIEW_ROOT);
        List<TreeNode> allViewNodes = this.getAllChildrenAndSelf(viewRoot);
        Set<String> nodeIds = unitTreeMap.keySet();
        Iterator<TreeNode> iterator = allViewNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (!nodeIds.contains(node.getId())) continue;
            iterator.remove();
            if (node.getChildren() == null) continue;
            for (TreeNode n : node.getChildren()) {
                n.setParentid(node.getParentid());
            }
        }
    }

    private Map<String, Map<String, String>> getSelectInfo(Map<String, Map<String, String>> unitTreeMap, List<Map<String, Object>> leftNodes) {
        ArrayList<Object> list = new ArrayList<Object>(leftNodes.size());
        for (Map<String, Object> leftNode : leftNodes) {
            list.add(leftNode.get("id"));
        }
        unitTreeMap.keySet().retainAll(list);
        return unitTreeMap;
    }

    protected TreeNode getCachedRoot(String key) {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(key), TreeNode.class);
    }

    private List<TreeNode> getCacheTree(String key) {
        return SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(key), TreeNode.class);
    }

    private String getViewSchemaNumber() {
        return this.getModel().getValue(NUMBER).toString();
    }

    protected void cacheTreeNode(TreeNode unitTreeNode, TreeNode viewTreeNode) {
        IPageCache cache = this.getPageCache();
        cache.put(UNIT_ROOT, SerializationUtils.toJsonString((Object)unitTreeNode));
        cache.put(VIEW_ROOT, SerializationUtils.toJsonString((Object)viewTreeNode));
        cache.put(OLD_VIEW_CACHE, SerializationUtils.toJsonString((Object)viewTreeNode));
        this.resetKeyCache();
    }

    private void putKeyTreeCache(String key, List<TreeNode> treeNodes) {
        this.getPageCache().put(key, SerializationUtils.toJsonString(treeNodes));
        this.setDataChange();
    }

    private void resetKeyCache() {
        IPageCache cache = this.getPageCache();
        ArrayList list = new ArrayList();
        cache.put(KEY_ADDNODE, SerializationUtils.toJsonString(list));
        cache.put(KEY_UPDATENODE, SerializationUtils.toJsonString(list));
        cache.put(KEY_DELETENODE, SerializationUtils.toJsonString(list));
        this.setDataChange();
    }

    private void setDataChange() {
        List<TreeNode> delete = this.getCacheTree(KEY_DELETENODE);
        List<TreeNode> add = this.getCacheTree(KEY_ADDNODE);
        List<TreeNode> update = this.getCacheTree(KEY_UPDATENODE);
        if (delete.size() > 0 || add.size() > 0 || update.size() > 0) {
            this.getPageCache().put("dataChange", "true");
        } else {
            this.getPageCache().remove("dataChange");
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String nodeId;
        Control treeView = (Control)e.getSource();
        boolean isCheckChild = (Boolean)this.getModel().getValue(ISCHECKUNITCHILD);
        if (isCheckChild && treeView.getKey().equals(BIZUNITTREE)) {
            boolean containsAll;
            nodeId = (String)e.getNodeId();
            TreeNode unitTreeNode = this.getCachedRoot(UNIT_ROOT);
            TreeNode checkNodeInfo = OrgUtils.getTreeNodeById((String)nodeId, (TreeNode)unitTreeNode);
            List checkedNodeIds = this.bizunittree.getTreeState().getCheckedNodeIds();
            boolean empty = this.bizviewtree.getTreeState().getSelectedNodeId().isEmpty();
            boolean bl = containsAll = !empty && checkedNodeIds.containsAll(this.bizviewtree.getTreeState().getSelectedNodeId());
            if (containsAll && StringUtils.isNotBlank((Object)e.getParentNodeId())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_ADDNODE, BTN_DELETENODE});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_ADDNODE, BTN_DELETENODE});
            }
            List<TreeNode> allChildren = this.getAllChildren(checkNodeInfo);
            if (checkedNodeIds.contains(nodeId)) {
                this.bizunittree.checkNodes(allChildren);
            } else {
                List allChildrenIds = allChildren.stream().map(TreeNode::getId).collect(Collectors.toList());
                this.bizunittree.unCheckNodesWithoutChild(allChildrenIds);
            }
        } else if (treeView.getKey().equals(BIZVIEWTREE)) {
            if (e.getChecked().booleanValue()) {
                if (StringUtils.isNotBlank((Object)e.getParentNodeId())) {
                    nodeId = (String)e.getNodeId();
                    List list = this.bizunittree.getTreeState().getSelectedNodeId();
                    this.getView().setEnable(Boolean.valueOf(!list.contains(nodeId)), new String[]{BTN_ADDNODE, BTN_DELETENODE});
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_ADDNODE, BTN_DELETENODE});
            }
        }
        List leftNodes = this.bizunittree.getTreeState().getCheckedNodeIds();
        List rightNodes = this.bizviewtree.getTreeState().getCheckedNodeIds();
        Long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (Objects.nonNull(leftNodes) && leftNodes.size() == 1 && String.valueOf(rootOrgId).equalsIgnoreCase((String)leftNodes.get(0)) && Objects.nonNull(rightNodes) && rightNodes.size() == 1 && !String.valueOf(rootOrgId).equalsIgnoreCase((String)rightNodes.get(0))) {
            String rootName = String.valueOf(((Map)this.bizunittree.getTreeState().getCheckedNodes().get(0)).get("text"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s:\u6839\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u76f4\u63a5\u4fee\u6539\u4e0a\u7ea7\uff01\u4fee\u6539\u6839\u7ec4\u7ec7\u9700\u8981\u5148\u79fb\u9664\u5168\u90e8\u7ec4\u7ec7\uff01", (String)"AbstractOrgViewPlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), rootName), Integer.valueOf(5000));
            return;
        }
    }

    private List<TreeNode> getAllChildren(TreeNode parentNode) {
        if (null == parentNode) {
            return new ArrayList<TreeNode>();
        }
        List children = parentNode.getChildren();
        if (children == null || children.size() == 0) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(children);
        for (TreeNode child : children) {
            result.addAll(this.getAllChildren(child));
        }
        return result;
    }

    private List<TreeNode> getAllChildrenAndSelf(TreeNode parentNode) {
        List<TreeNode> allChildren = this.getAllChildren(parentNode);
        allChildren.add(parentNode);
        return allChildren;
    }

    private List<TreeNode> getNeedUpdateNodes(TreeNode viewRoot, List<String> dumpIds) {
        ArrayList<TreeNode> needUpdateNodes = new ArrayList<TreeNode>(dumpIds.size());
        for (String dumpId : dumpIds) {
            needUpdateNodes.add(this.getParentExcludeIds(viewRoot, OrgUtils.getTreeNodeById((String)dumpId, (TreeNode)viewRoot), dumpIds));
        }
        return needUpdateNodes;
    }

    private void expandUp(TreeView treeView, TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodesAndSelf(treeRoot, treeNode);
        parentNodes.forEach(x -> treeView.expand(x.getId()));
    }

    private List<TreeNode> getParentNodesAndSelf(TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodes(treeRoot, treeNode);
        parentNodes.add(treeNode);
        return parentNodes;
    }

    private List<TreeNode> getParentNodes(TreeNode treeRoot, TreeNode treeNode) {
        String parentId = treeNode.getParentid();
        if ("".equals(parentId)) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        TreeNode parentNode = OrgUtils.getTreeNodeById((String)parentId, (TreeNode)treeRoot);
        result.add(parentNode);
        result.addAll(this.getParentNodesAndSelf(treeRoot, parentNode));
        return result;
    }

    private TreeNode getParentExcludeIds(TreeNode viewRoot, TreeNode targetNode, List<String> dumpIds) {
        if (!dumpIds.contains(targetNode.getId())) {
            return targetNode;
        }
        String parentId = targetNode.getParentid();
        if ("".equals(parentId)) {
            return targetNode;
        }
        TreeNode parentNode = OrgUtils.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
        return this.getParentExcludeIds(viewRoot, parentNode, dumpIds);
    }

    private void removeNodes(TreeNode root, List<String> nodeIds) {
        for (String nodeId : nodeIds) {
            String parentId;
            TreeNode node = OrgUtils.getTreeNodeById((String)nodeId, (TreeNode)root);
            if (node == null || "".equals(parentId = node.getParentid())) continue;
            List childNodes = node.getChildren();
            TreeNode parentNode = OrgUtils.getTreeNodeById((String)parentId, (TreeNode)root);
            List parentChilds = parentNode.getChildren();
            parentChilds.removeIf(x -> x.getId().equals(nodeId));
            if (childNodes == null) continue;
            for (TreeNode childNode : childNodes) {
                parentChilds.add(childNode);
                childNode.setParentid(parentId);
            }
        }
    }

    public void search(SearchEnterEvent e) {
        String text = e.getText();
        Search search = (Search)e.getSource();
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        QFilter[] qf = new QFilter[]{new QFilter(NAME, "like", (Object)("%" + text + "%"))};
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])qf, (String)NAME);
        TreeView orgTree = "orgsearchap".equals(search.getKey()) ? (TreeView)this.getControl(BIZUNITTREE) : (TreeView)this.getControl(BIZVIEWTREE);
        this.unCheckNode(orgTree);
        if (!orgs.isEmpty()) {
            DynamicObject queryOne = (DynamicObject)orgs.get(0);
            for (DynamicObject org : orgs) {
                if (queryOne == null) continue;
                boolean containLeaf = "orgsearchap".equals(search.getKey()) ? (Boolean)this.getModel().getValue(ISCHECKUNITCHILD) : false;
                this.selectNode(orgTree, org, containLeaf);
            }
        }
    }

    private void unCheckNode(TreeView orgTree) {
        List selectedNodeId = orgTree.getTreeState().getSelectedNodeId();
        orgTree.uncheckNodes(selectedNodeId);
    }

    private void selectNode(TreeView orgTree, DynamicObject org, boolean containLeaf) {
        TreeNode bizTree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZUNITTREE), TreeNode.class);
        List childPathNodes = bizTree.getChildPathNodes(org.getString("id"));
        for (TreeNode child : childPathNodes) {
            if (!child.getText().equalsIgnoreCase(org.getString(NAME)) || "100000".equals(child.getId())) continue;
            orgTree.showNode(child.getId());
            orgTree.focusNode(child);
            orgTree.checkNode(child);
            if (containLeaf) {
                TreeNodeCheckEvent tnc = new TreeNodeCheckEvent((Object)orgTree, (Object)child.getParentid(), (Object)child.getId(), Boolean.valueOf(containLeaf));
                this.treeNodeCheck(tnc);
            }
            return;
        }
    }

    protected void setModelValueByViewId(IDataModel model, String viewId) {
        if (!StringUtils.isEmpty((CharSequence)viewId)) {
            String entity = TCTB_ORG_DEFAULT_VIEW;
            if (!StringUtils.equals((CharSequence)viewId, (CharSequence)DEAFAULT_VIEW_ID)) {
                entity = TCTB_ORG_VIEW_CUSTOM;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)entity);
            model.setValue(NUMBER, dynamicObject.get(NUMBER));
            model.setValue(NAME, dynamicObject.get(NAME));
            model.setValue(ISDEFAULT, dynamicObject.get(ISDEFAULT));
        }
        model.setDataChanged(false);
    }

    protected Long saveViewAndOrgDuty() {
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u5f00\u59cb\u6267\u884csaveViewAndOrgDuty...");
        long start = System.currentTimeMillis();
        Long pkId = this.getModel().getDataEntity().getLong("id");
        this.getPageCache().put("isAdd", pkId.equals(0L) ? "1" : "0");
        pkId = pkId.equals(0L) ? Long.valueOf(DBUtils.getLongId((String)TCTB_ORG_VIEW_CUSTOM)) : pkId;
        this.getPageCache().put("pkId", String.valueOf(pkId));
        OrgApiResult result = this.addViewSchema(pkId);
        if (!result.isSuccess()) {
            List ids;
            if (StringUtils.equalsIgnoreCase((CharSequence)((Object)((Object)this)).getClass().getSimpleName(), (CharSequence)OrgViewCustomPlugin.class.getSimpleName()) && !pkId.equals(947076820862300160L) && ObjectUtils.isEmpty((Object)(ids = OrgUnitServiceHelper.getAllOrgByViewId((long)pkId, (boolean)true)))) {
                DeleteServiceHelper.delete((String)TCTB_ORG_VIEW_CUSTOM, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId).and("id", "!=", (Object)947076820862300160L)});
            }
            throw new KDBizException(result.getErrorMsg());
        }
        this.deleteOrgStructure(pkId);
        this.addOrgStructure();
        this.updateOrgStructure();
        this.resetKeyCache();
        this.saveModelValue(pkId);
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u7ed3\u675f\u6267\u884csaveViewAndOrgDuty\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start));
        return pkId;
    }

    private void deleteOrgStructure(Long pkId) {
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u5f00\u59cb\u6267\u884cdeleteOrgStructure..");
        long start = System.currentTimeMillis();
        TreeNode currentTree = this.getCachedRoot(VIEW_ROOT);
        TreeNode oldTree = this.getCachedRoot(OLD_VIEW_CACHE);
        List<TreeNode> delete = this.getCacheTree(KEY_DELETENODE);
        List<Object> nodeList = new ArrayList();
        nodeList.addAll(delete.stream().filter(node -> null != OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)oldTree) && null == OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)currentTree)).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TreeNode>(Comparator.comparing(n -> n.getId()))), ArrayList::new)));
        nodeList = nodeList.stream().distinct().collect(Collectors.toList());
        if (ObjectUtils.isEmpty(nodeList)) {
            return;
        }
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(nodeList.size());
        for (TreeNode treeNode : nodeList) {
            long orgId = Long.parseLong(treeNode.getId());
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId);
            orgParam.setDuty(this.getViewSchemaNumber());
            paramList.add(orgParam);
        }
        OrgUnitServiceHelper.deleteDuty(paramList);
        this.showSaveResult(paramList);
        List orgIds = nodeList.stream().map(node -> Long.valueOf(node.getId())).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u7ed3\u675f\u6267\u884cdeleteOrgStructure\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start));
    }

    private void addOrgStructure() {
        List<TreeNode> add = this.getCacheTree(KEY_ADDNODE);
        TreeNode currentTree = this.getCachedRoot(VIEW_ROOT);
        TreeNode oldTree = this.getCachedRoot(OLD_VIEW_CACHE);
        ArrayList<TreeNode> nodeList = new ArrayList();
        List tempAddNode = add.stream().filter(node -> null == OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)oldTree)).collect(Collectors.toList());
        for (TreeNode node2 : tempAddNode) {
            TreeNode newNode = OrgUtils.getTreeNodeById((String)node2.getId(), (TreeNode)currentTree);
            if (null == newNode || !StringUtils.equalsIgnoreCase((CharSequence)node2.getId(), (CharSequence)newNode.getId())) continue;
            nodeList.add(newNode);
        }
        nodeList = nodeList.stream().distinct().collect(Collectors.toList());
        ArrayList<TreeNode> sortTreeList = new ArrayList<TreeNode>();
        this.sortTreeNode(nodeList, sortTreeList, currentTree);
        if (ObjectUtils.isEmpty(sortTreeList)) {
            return;
        }
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(sortTreeList.size());
        for (TreeNode treeNode : sortTreeList) {
            long orgId = Long.parseLong(treeNode.getId());
            OrgParam orgParam = new OrgParam();
            orgParam.setDuty(this.getViewSchemaNumber());
            orgParam.setId(orgId);
            orgParam.setAutoMoveSubOrg(false);
            orgParam.setParentId(ObjectUtils.isEmpty((Object)treeNode.getParentid()) ? 0L : Long.parseLong(treeNode.getParentid()));
            paramList.add(orgParam);
        }
        if (null == oldTree.getChildren()) {
            this.addDutyRoot(currentTree);
        }
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u5f00\u59cb\u6267\u884cOrgUnitServiceHelper.addDuty\uff0c\u53c2\u6570:" + JSON.toJSONString(paramList));
        long start = System.currentTimeMillis();
        OrgUnitServiceHelper.addDuty(paramList);
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u7ed3\u675f\u6267\u884cOrgUnitServiceHelper.addDuty\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start));
        this.showSaveResult(paramList);
    }

    private void updateOrgStructure() {
        List<TreeNode> update = this.getCacheTree(KEY_UPDATENODE);
        TreeNode currentTree = this.getCachedRoot(VIEW_ROOT);
        TreeNode oldTree = this.getCachedRoot(OLD_VIEW_CACHE);
        ArrayList<TreeNode> nodeList = new ArrayList();
        List tempUpdateNode = update.stream().filter(node -> null != OrgUtils.getTreeNodeById((String)node.getId(), (TreeNode)oldTree)).collect(Collectors.toList());
        for (TreeNode node2 : tempUpdateNode) {
            TreeNode curNode = OrgUtils.getTreeNodeById((String)node2.getId(), (TreeNode)currentTree);
            if (null == curNode || !StringUtils.equalsIgnoreCase((CharSequence)node2.getId(), (CharSequence)curNode.getId())) continue;
            nodeList.add(curNode);
        }
        nodeList = nodeList.stream().distinct().collect(Collectors.toList());
        ArrayList<TreeNode> sortTreeList = new ArrayList<TreeNode>();
        this.sortTreeNode(nodeList, sortTreeList, currentTree);
        if (ObjectUtils.isEmpty(sortTreeList)) {
            return;
        }
        String schemaNumber = this.getViewSchemaNumber();
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(sortTreeList.size());
        for (TreeNode treeNode : sortTreeList) {
            long orgId = Long.parseLong(treeNode.getId());
            OrgParam orgParam = new OrgParam();
            orgParam.setDuty(schemaNumber);
            orgParam.setId(orgId);
            orgParam.setParentId(ObjectUtils.isEmpty((Object)treeNode.getParentid()) ? 0L : Long.parseLong(treeNode.getParentid()));
            paramList.add(orgParam);
        }
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u5f00\u59cb\u6267\u884cOrgUnitServiceHelper.update\uff0c\u53c2\u6570:" + JSON.toJSONString(paramList));
        long start = System.currentTimeMillis();
        OrgUnitServiceHelper.update(paramList);
        logger.info("\u3010AbstractOrgViewPlugin\u3011\u7ed3\u675f\u6267\u884cOrgUnitServiceHelper.update\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start));
        this.showSaveResult(paramList);
    }

    private List<TreeNode> getNextLextChildren(TreeNode parentNode) {
        List children = parentNode.getChildren();
        if (children == null || children.size() == 0) {
            return new ArrayList<TreeNode>();
        }
        return children;
    }

    private void sortTreeNode(List<TreeNode> addNode, List<TreeNode> treeList, TreeNode treeNode) {
        List<TreeNode> tempChildren = this.getNextLextChildren(treeNode);
        for (TreeNode tempChild : tempChildren) {
            treeList.addAll(addNode.stream().filter(node -> StringUtils.equalsIgnoreCase((CharSequence)node.getId(), (CharSequence)tempChild.getId())).collect(Collectors.toList()));
            this.sortTreeNode(addNode, treeList, tempChild);
        }
    }

    private void showSaveResult(List<OrgParam> paramList) {
        for (OrgParam orgParam : paramList) {
            if (orgParam.isSuccess()) continue;
            if (StringUtils.equalsIgnoreCase((CharSequence)this.getPageCache().get("isAdd"), (CharSequence)"1")) {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(Long.valueOf(this.getPageCache().get("pkId")));
                OrgApiResult orgApiResult = OrgUnitServiceHelper.deleteOrgViewSchema(list);
            }
            throw new KDBizException(orgParam.getMsg());
        }
    }
}

