/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.mservice.taxorg;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class TaxOrgUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(TaxOrgUpgradeServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog("begin execute taxOrgUpgrate");
            this.upgrade();
            result.setSuccess(true);
            result.setLog("complete taxOrgUpgrate ");
        }
        catch (Exception e) {
            String errorInfo = "taxOrgUpgrate Exception\uff1a" + e.getMessage();
            result.setErrorInfo(errorInfo);
            result.setSuccess(false);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(errorInfo);
        }
        return result;
    }

    private void upgrade() {
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(10000);
        String selectFields = "org.number number, org.name name,org,parent";
        QFilter viewFilter = new QFilter("view", "=", (Object)947076820862300160L);
        QFilter[] filters = new QFilter[]{viewFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TaxOrgUpgradeServiceImpl.upgrade", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");){
            for (Row row : dataSet) {
                OrgParam orgParam = new OrgParam();
                orgParam.setDuty("40");
                orgParam.setId(row.getLong("org").longValue());
                orgParam.setParentId(row.getLong("parent").longValue());
                paramList.add(orgParam);
            }
        }
        OrgUnitServiceHelper.addOrUpdate(paramList);
        for (OrgParam orgParam : paramList) {
            if (orgParam.isSuccess()) continue;
            logger.error(orgParam.getId() + "\uff1ataxOrgUpgrate fail\uff1a" + orgParam.isSuccess());
        }
    }
}

