/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.hscode;

import java.util.ArrayList;
import java.util.Date;
import kd.bamp.bastax.common.util.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;

public class TaxcHscodeService {
    public static Boolean filterIsSystem(DynamicObject doc, String isSystem) {
        return doc.getString("issystem").equals(isSystem);
    }

    public static boolean isEffective(DynamicObject doc, Date effectiveDate) {
        Date startDate = DateUtils.trunc((Date)doc.getDate("startdate"), (String)"yyyy-MM-dd");
        Date endDate = DateUtils.trunc((Date)doc.getDate("enddate"), (String)"yyyy-MM-dd");
        if (effectiveDate != null) {
            return startDate != null && effectiveDate.getTime() == startDate.getTime() || endDate != null && effectiveDate.getTime() == endDate.getTime() || effectiveDate.after(startDate) && effectiveDate.before(endDate);
        }
        return Boolean.FALSE;
    }

    public static DynamicObject[] filterEffective(DynamicObject[] docs, Date effectiveDate) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject doc : docs) {
            if (!TaxcHscodeService.isEffective(doc, effectiveDate)) continue;
            list.add(doc);
        }
        return list.toArray(new DynamicObject[0]);
    }
}

