/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.roombase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bamp.bastax.business.roombase.BuildingBusiness;
import kd.bamp.bastax.business.roombase.RoomDao;
import kd.bamp.bastax.business.roombase.StageBusiness;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;

public class RoomBusiness {
    public static TreeNode queryRoomTree(Long stageId) {
        DynamicObject stage = StageBusiness.queryStageById(stageId);
        TreeNode root = new TreeNode();
        root.setId("stage_" + stage.getString("id"));
        root.setText(stage.getString("name"));
        root.setChildren(new ArrayList());
        DynamicObject[] buildColl = BuildingBusiness.queryBuildByStageId(stageId);
        Map<Long, List<DynamicObject>> buildMap = Stream.of(buildColl).collect(Collectors.groupingBy(v -> v.getLong("stage.id")));
        DynamicObject[] roomColl = RoomBusiness.queryRoomByStageId(stageId);
        Map<Long, List<DynamicObject>> roomMap = Stream.of(roomColl).collect(Collectors.groupingBy(v -> v.getLong("building.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : buildMap.entrySet()) {
            List<DynamicObject> buildList = entry.getValue();
            if (buildList == null || buildList.size() <= 0) continue;
            for (DynamicObject build : buildList) {
                TreeNode buildNode = new TreeNode();
                buildNode.setId("building_" + build.getString("id"));
                buildNode.setText(build.getString("name"));
                buildNode.setData((Object)build);
                buildNode.setParentid(root.getId());
                buildNode.setChildren(new ArrayList());
                root.getChildren().add(buildNode);
                List<DynamicObject> roomList = roomMap.get(build.getLong("id"));
                if (roomList == null || roomList.size() <= 0) continue;
                for (DynamicObject room : roomList) {
                    TreeNode roomNode = new TreeNode();
                    roomNode.setId("room_" + room.getString("id"));
                    roomNode.setText(room.getString("name"));
                    roomNode.setData((Object)room);
                    roomNode.setParentid(buildNode.getId());
                    buildNode.getChildren().add(roomNode);
                }
            }
        }
        return root;
    }

    public static DynamicObject[] queryRoomByIds(List<Long> ids) {
        return RoomDao.loadRoomByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,roomno,producttype,area,building,stage,taxproject,taxorg");
    }

    public static DynamicObject[] queryRoomByStageId(Long stageId) {
        return RoomDao.loadRoomByStageId(stageId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,roomno,producttype,area,building,stage,taxproject,taxorg");
    }

    public static DynamicObject[] queryRoomByBuildingId(Long buildingId) {
        return RoomDao.loadRoomByBuildingId(buildingId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,roomno,producttype,area,building,stage,taxproject,taxorg");
    }

    public static DynamicObject queryRoomById(Long id) {
        return RoomDao.loadRoomById(id, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,roomno,producttype,area,building,stage,taxproject,taxorg");
    }
}

