/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.roombase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bamp.bastax.business.roombase.BuildingBusiness;
import kd.bamp.bastax.business.roombase.RoomBusiness;
import kd.bamp.bastax.business.roombase.StageDao;
import kd.bamp.bastax.common.constant.StageConstant;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;

public class StageBusiness {
    public static TreeNode queryStageTree(QFilter taxOrgFilter) {
        DynamicObject[] stageColl;
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"StageBusiness_0", (String)"bamp-bastax-business", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        DynamicObject[] buildColl = BuildingBusiness.queryBuildByIds(null);
        Map<Long, List<DynamicObject>> buildMap = Stream.of(buildColl).collect(Collectors.groupingBy(v -> v.getLong("stage.id")));
        for (DynamicObject stage : stageColl = StageBusiness.queryBuildByTaxOrgIds(taxOrgFilter)) {
            TreeNode stageNode = new TreeNode();
            stageNode.setId("stage_" + stage.getString("id"));
            stageNode.setText(stage.getString("name"));
            stageNode.setData((Object)stage);
            stageNode.setParentid(root.getId());
            stageNode.setChildren(new ArrayList(10));
            root.getChildren().add(stageNode);
            List<DynamicObject> buildList = buildMap.get(stage.getLong("id"));
            if (buildList == null || buildList.size() <= 0) continue;
            for (DynamicObject build : buildList) {
                TreeNode buildNode = new TreeNode();
                buildNode.setId("building_" + build.getString("id"));
                buildNode.setText(build.getString("name"));
                buildNode.setData((Object)build);
                buildNode.setParentid(stageNode.getId());
                stageNode.getChildren().add(buildNode);
            }
        }
        return root;
    }

    public static DynamicObject queryStageByNodeId(String nodeId) {
        if (StringUtil.isNotEmpty((CharSequence)nodeId) && !"-1".equals(nodeId)) {
            DynamicObject roomObj;
            String[] params = nodeId.split("_");
            String flag = params[0];
            String billId = params[1];
            if ("stage".equalsIgnoreCase(flag)) {
                return StageBusiness.queryStageById(Long.valueOf(billId));
            }
            if ("building".equalsIgnoreCase(flag)) {
                DynamicObject build = BuildingBusiness.queryBuildById(Long.valueOf(billId));
                if (build != null) {
                    return build.getDynamicObject("stage");
                }
            } else if ("room".equalsIgnoreCase(flag) && (roomObj = RoomBusiness.queryRoomById(Long.valueOf(billId))) != null) {
                return roomObj.getDynamicObject("stage");
            }
        }
        return null;
    }

    public static DynamicObject[] queryStageByIds(List<Long> ids) {
        return StageDao.loadStageByIds(ids, StageConstant.QueryFiled);
    }

    public static DynamicObject queryStageById(Long id) {
        return StageDao.loadStageById(id, StageConstant.QueryFiled);
    }

    public static DynamicObject[] queryBuildByTaxOrgIds(QFilter taxOrgFilter) {
        return StageDao.loadBuildByTaxOrgIds(taxOrgFilter, StageConstant.QueryFiled);
    }
}

