/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.taxcorg;

import java.util.Collections;
import java.util.List;
import kd.bamp.bastax.business.taxcorg.TaxcOrgDao;
import kd.bamp.bastax.business.taxcorg.TaxcOrgService;
import kd.bamp.bastax.common.util.DyoToDtoUtils;
import kd.bos.dataentity.entity.DynamicObject;

public class TaxcOrgBusiness {
    public static Boolean isTaxcOrgExistByOrgId(Long orgid, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgid), taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.isExsitOrg(TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId));
    }

    public static Boolean isTaxcOrgExistByOrgIdAndIsTaxpayer(Long orgid, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgid), taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.isExsitOrg(TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId));
    }

    public static Long queryTaxcOrgIdByOrgNum(String orgNum, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgNums(Collections.singletonList(orgNum), taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        DynamicObject result = TaxcOrgService.queryTaxcOrg(TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId));
        return DyoToDtoUtils.dyoToLong((DynamicObject)result, (String)"org.id");
    }

    public static DynamicObject queryTaxcOrgByOrgIdIsTaxpayer(Long orgId, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgId), taxationsysId);
        DynamicObject[] taxpayerObjs = TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos = TaxcOrgService.filterOrgViewEnbale(dyos), taxationsysId);
        if (taxpayerObjs != null && taxpayerObjs.length > 0) {
            return taxpayerObjs[0];
        }
        return null;
    }

    public static DynamicObject queryTaxcOrgByOrgId(Long orgId, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgId), taxationsysId);
        DynamicObject[] taxpayerObjs = TaxcOrgService.filterBillStatusAndStatus(dyos = TaxcOrgService.filterOrgViewEnbale(dyos), taxationsysId);
        if (taxpayerObjs != null && taxpayerObjs.length > 0) {
            return taxpayerObjs[0];
        }
        return null;
    }

    public static List<String> queryAllTaxcUnifiedsocialcode(Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToStr((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"entryentity.entry_unifiedsocialcode");
    }

    public static List<String> queryTaxcUnifiedsocialcodeByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToStr((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"entryentity.entry_unifiedsocialcode");
    }

    public static DynamicObject[] queryTaxcOrgByOrgIdAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId);
    }

    public static List<Long> queryTaxcOrgIdByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"org.id");
    }

    public static DynamicObject[] queryTaxcOrgByOrgId(List<Long> orgIds, Long taxationsysId, boolean isIncludeDisable) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, taxationsysId);
        if (isIncludeDisable) {
            return dyos;
        }
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId);
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayer(Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId), (String)"org.id");
    }

    public static List<Long> queryTaxOrgIdsByStatusAndIsvirtual(Boolean isEnable, Boolean isVirtual, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, taxationsysId);
        if (isEnable != null) {
            dyos = TaxcOrgService.filterBillStatusAndStatus(dyos, isEnable, taxationsysId);
        }
        if (isVirtual != null) {
            dyos = TaxcOrgService.filterIsVirtual(dyos, isVirtual);
        }
        return DyoToDtoUtils.dyoToLong((DynamicObject[])dyos, (String)"org.id");
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayer(Long taxationsysId, boolean isIncludeTaxationsys) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, taxationsysId, isIncludeTaxationsys);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId, isIncludeTaxationsys), (String)"org.id");
    }

    public static DynamicObject[] queryTaxcOrgByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId);
    }

    public static List<Long> queryTaxcOrgIdsByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterIsTaxPayer(dyos, taxationsysId), (String)"org.id");
    }

    public static List<Long> queryTaxcOrgIdByUnifiedsocialcode(List<String> unifiedsocialcodes, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByUnifiedsocialcodes(unifiedsocialcodes, taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"org.id");
    }

    public static DynamicObject[] queryTaxcOrgByUnifiedsocialcode(List<String> unifiedsocialcodes, Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByUnifiedsocialcodes(unifiedsocialcodes, taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static List<Long> queryAllTaxcOrgId(Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgByQfilter(null, taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId), (String)"org.id");
    }

    public static DynamicObject[] queryAllTaxcOrg(Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgByQfilter(null, taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject[] queryTaxcOrgByOrgNum(List<String> orgNums, Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByOrgNums(orgNums, taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static Boolean isTaxcOrgExistByOrgNum(String orgNum, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgNums(Collections.singletonList(orgNum), taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.isExsitOrg(TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId));
    }

    public static Long queryTaxcOrgIdByTaxpayer(String taxpayer, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByTaxpayers(Collections.singletonList(taxpayer), taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        DynamicObject result = TaxcOrgService.queryTaxcOrg(TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId));
        return DyoToDtoUtils.dyoToLong((DynamicObject)result, (String)"org.id");
    }

    public static DynamicObject queryTaxcOrgByTaxpayer(String taxpayer, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByTaxpayers(Collections.singletonList(taxpayer), taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.queryTaxcOrg(TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId));
    }

    public static DynamicObject[] queryTaxcOrgByIds(List<Long> ids, Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByIds(ids, taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject[] queryTaxcOrgByIds(List<Long> ids) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByIds(ids, null);
        return docs;
    }
}

