/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.taxcorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class TaxcOrgService {
    private static Log logger = LogFactory.getLog(TaxcOrgService.class);

    public static Boolean isExsitOrg(DynamicObject[] dyo) {
        return dyo != null && dyo.length > 0;
    }

    public static DynamicObject queryTaxcOrg(DynamicObject[] doc) {
        return doc.length > 0 ? doc[0] : null;
    }

    public static DynamicObject[] filterBillStatusAndStatus(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatus(DynamicObject[] docs, Boolean isEnable, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
            for (DynamicObject doc : docs) {
                if (!TaxcOrgService.filterBillStatusAndStatus(orgIds, doc, isEnable, taxationsysId).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterIsVirtual(DynamicObject[] docs, Boolean isVirtual) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgService.filterIsVirtual(doc, isVirtual).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusAndIsTaxPayer(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue() || !TaxcOrgService.isTaxpayer(doc, taxationsysId)) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterIsTaxPayer(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgService.isTaxpayer(doc, taxationsysId)) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusAndIsTaxPayer(DynamicObject[] docs, Long taxationsysId, boolean isIncludeTaxationsys) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgService.filterBillStatusAndStatus(doc, taxationsysId, isIncludeTaxationsys).booleanValue() || !TaxcOrgService.isTaxpayer(doc, taxationsysId, isIncludeTaxationsys)) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    private static boolean isTaxpayer(DynamicObject dyo, Long taxationsysId) {
        if (null != dyo) {
            DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer")).findFirst();
            return entryObj.isPresent();
        }
        return false;
    }

    private static boolean isTaxpayer(DynamicObject dyo, Long taxationsysId, boolean isIncludeTaxationsys) {
        if (null != dyo) {
            DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? (isIncludeTaxationsys ? entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") != taxationsysId.longValue()).findFirst()) : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer")).findFirst();
            return entryObj.isPresent();
        }
        return false;
    }

    public static Boolean filterBillStatusAndStatus(DynamicObject doc, Long taxationsysId) {
        if (null != doc) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status"))).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterBillStatusAndStatus(List<Long> orgIds, DynamicObject doc, Boolean isEnable, Long taxationsysId) {
        if (null != doc) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? entryentity.stream().filter(o -> o != null && isEnable.equals(o.getBoolean("entry_status")) && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o != null && isEnable.equals(o.getBoolean("entry_status"))).findFirst();
            if (isEnable.booleanValue()) {
                return TaxcOrgService.filterOrgViewEnbale(orgIds, doc) && entryObj.isPresent();
            }
            return !TaxcOrgService.filterOrgViewEnbale(orgIds, doc) || entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterIsVirtual(DynamicObject doc, Boolean isVirtual) {
        if (null != doc) {
            return isVirtual.equals(doc.getBoolean("isvirtual"));
        }
        return Boolean.FALSE;
    }

    public static Boolean filterBillStatusAndStatus(DynamicObject doc, Long taxationsysId, boolean isIncludeTaxationsys) {
        if (null != doc) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? (isIncludeTaxationsys ? entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && o.getLong("entry_taxationsys.id") != taxationsysId.longValue()).findFirst()) : entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status"))).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static DynamicObject[] filterOrgViewEnbale(DynamicObject[] docs) {
        if (null != docs && docs.length > 0) {
            List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
            List<DynamicObject> collect = Arrays.stream(docs).filter(o -> orgIds.contains(o.getLong("org.id"))).collect(Collectors.toList());
            return collect.toArray(new DynamicObject[0]);
        }
        return null;
    }

    public static boolean filterOrgViewEnbale(List<Long> orgIds, DynamicObject doc) {
        if (null != doc) {
            return orgIds.contains(doc.getLong("org.id"));
        }
        return false;
    }

    public static void removeTaxOrgEntryCache(DynamicObject[] taxOrgs) {
        try {
            if (taxOrgs == null || taxOrgs.length == 0) {
                return;
            }
            ArrayList<Object> pkIds = new ArrayList<Object>(10);
            for (DynamicObject row : taxOrgs) {
                if (!row.containsProperty("entryentity")) continue;
                DynamicObjectCollection entryCol = row.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryCol) {
                    if (!ObjectUtils.isNotEmpty((Object)entry.getPkValue())) continue;
                    pkIds.add(entry.getPkValue());
                }
            }
            if (pkIds.size() > 0) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bastax_taxorg_entry");
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
                cacheManager.removeByPrimaryKey(pkIds.toArray(new Object[pkIds.size()]));
            }
        }
        catch (Exception e) {
            logger.error("removeTaxOrgEntryCache error", (Object)e.getMessage());
        }
    }
}

