/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.opplugin;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaxOrganImportOp
extends BatchImportPlugin {
    public String getDefaultKeyFields() {
        return "number";
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        return super.getOverrideFieldsConfig().stream().filter(new Predicate<ComboItem>(){

            @Override
            public boolean test(ComboItem comboItem) {
                return "number".equalsIgnoreCase(comboItem.getValue());
            }
        }).collect(Collectors.toList());
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> billList = billdatas.iterator();
        Map option = this.ctx.getOption();
        String importType = option.get("importtype").toString();
        if ("override".equalsIgnoreCase(importType) || "overridenew".equalsIgnoreCase(importType)) {
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("preset", "=", (Object)"1")});
            List numberList = Arrays.stream(colls).map(o -> o.getString("number")).collect(Collectors.toList());
            while (billList.hasNext()) {
                String number;
                ImportBillData data = billList.next();
                Integer index = data.getStartIndex();
                if (data.getData().get((Object)"number") == null || !numberList.contains(number = data.getData().getString("number"))) continue;
                logger.log(index, String.format(ResManager.loadKDString((String)"%s: \u7cfb\u7edf\u9884\u8bbe\u7684\u6570\u636e\u4e0d\u53ef\u4fee\u6539\u3002", (String)"TaxOrganImportOp_0", (String)"bamp-bastax-opplugin", (Object[])new Object[0]), number)).fail();
                billList.remove();
            }
        }
    }
}

