/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.opplugin.taxorg;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bamp.bastax.business.taxarea.TaxcAreaBusiness;
import kd.bamp.bastax.business.taxcorg.TaxcOrgBusiness;
import kd.bamp.bastax.common.constant.TaxcOrgConstant;
import kd.bamp.bastax.common.util.EmptyCheckUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class TaxOrgSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(TaxOrgSaveValidator.class);

    public void validate() {
        Map<String, String> checkTaxPayersMap = this.checkTaxPayersMustInput();
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(10);
        this.batchFetchData(cacheMap);
        DynamicObject currentObj = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            if (this.checkTaxPayerMustInput(currentObj, dataEntity, checkTaxPayersMap) && this.checkEntryVolid(currentObj, dataEntity, cacheMap)) continue;
        }
    }

    private void batchFetchData(Map<String, Object> cacheMap) {
        List taxationsysIds;
        List ids = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity()).map(v -> v.getLong(TaxcOrgConstant.ID)).collect(Collectors.toList());
        if (ids.size() > 0) {
            DynamicObject[] orgs = TaxcOrgBusiness.queryTaxcOrgByIds(ids);
            Map<Long, DynamicObject> taxorgMap = Arrays.stream(orgs).collect(Collectors.toMap(k -> k.getLong(TaxcOrgConstant.ID), v -> v));
            cacheMap.put("taxorgMap", taxorgMap);
        }
        if ((taxationsysIds = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity()).flatMap(v -> v.getDynamicObjectCollection("entryentity").stream()).filter(v -> v.getDynamicObject("entry_taxationsys") != null).map(v -> v.getLong("entry_taxationsys.id")).collect(Collectors.toList())).size() > 0) {
            QFilter taxationsysFilter = new QFilter("id", "in", taxationsysIds);
            DynamicObject[] taxationsys = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)"id,countryid", (QFilter[])new QFilter[]{taxationsysFilter});
            Map<Long, DynamicObject> taxationsysMap = Arrays.stream(taxationsys).collect(Collectors.toMap(k -> k.getLong(TaxcOrgConstant.ID), v -> v));
            cacheMap.put("taxationsysMap", taxationsysMap);
        }
    }

    private boolean checkEntryVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<String, Object> cacheMap) {
        DynamicObjectCollection entries = currentObj.getDynamicObjectCollection("entryentity");
        DynamicObject entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)entries.get(i);
            if (!this.checkTaxationsysVolid(currentObj, entry, dataEntity, cacheMap, i + 1)) {
                return false;
            }
            if (this.checkTaxAreaVolid(currentObj, entry, dataEntity, cacheMap, i + 1)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTaxationsysVolid(DynamicObject currentObj, DynamicObject entry, ExtendedDataEntity dataEntity, Map<String, Object> cacheMap, int index) {
        if (cacheMap == null || cacheMap.get("taxorgMap") == null || entry.getDynamicObject("entry_taxationsys") == null) {
            return true;
        }
        Map taxorgMap = (Map)cacheMap.get("taxorgMap");
        if (taxorgMap.size() == 0) {
            return true;
        }
        DynamicObject taxorgDb = (DynamicObject)taxorgMap.get(currentObj.getLong(TaxcOrgConstant.ID));
        if (taxorgDb == null) {
            return true;
        }
        Map<Long, DynamicObject> entryMap = taxorgDb.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(k -> k.getLong(TaxcOrgConstant.ID), v -> v));
        DynamicObject entryDb = entryMap.get(entry.getLong(TaxcOrgConstant.ID));
        if (entryDb == null) {
            return true;
        }
        if ("1".equalsIgnoreCase(entryDb.getString("entry_taxpayerdetail")) && entry.getLong("entry_taxationsys.id") != entryDb.getLong("entry_taxationsys.id")) {
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u201c\u7a0e\u6536\u5236\u5ea6\u201d\u503c\u3002", (String)"TaxOrgSaveValidator_2", (String)"bamp-bastax-opplugin", (Object[])new Object[0]), index));
            return false;
        }
        return true;
    }

    private boolean checkTaxAreaVolid(DynamicObject currentObj, DynamicObject entry, ExtendedDataEntity dataEntity, Map<String, Object> cacheMap, int index) {
        DynamicObject[] taxAreas;
        DynamicObject country;
        if (cacheMap == null || cacheMap.get("taxationsysMap") == null || entry.getDynamicObject("entry_taxationsys") == null || EmptyCheckUtils.isEmpty((Object)entry.getDynamicObjectCollection("entry_taxarea"))) {
            return true;
        }
        Map taxationsysMap = (Map)cacheMap.get("taxationsysMap");
        DynamicObject taxsystemDb = (DynamicObject)taxationsysMap.get(entry.getLong("entry_taxationsys.id"));
        if (taxsystemDb != null && taxsystemDb.getDynamicObject("countryid") != null && (country = taxsystemDb.getDynamicObject("countryid")) != null && (taxAreas = TaxcAreaBusiness.loadTaxcAreaByCountryId((Long)country.getLong("id"))) != null) {
            List areaGroupIdsDb = Arrays.stream(taxAreas).map(o -> o.getLong("group.id")).collect(Collectors.toList());
            List inVolidList = entry.getDynamicObjectCollection("entry_taxarea").stream().filter(v -> !areaGroupIdsDb.contains(v.getLong("fbasedataid_id"))).collect(Collectors.toList());
            if (inVolidList.size() > 0) {
                String inVolidNumbers = inVolidList.stream().map(v -> v.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining("\u3001"));
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5f53\u524d\u7a0e\u6536\u5236\u5ea6\u4e0b\uff0c\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7a0e\u6536\u8f96\u533a:%2$s\u3002", (String)"TaxOrgSaveValidator_3", (String)"bamp-bastax-opplugin", (Object[])new Object[0]), index, inVolidNumbers));
                return false;
            }
        }
        return true;
    }

    protected Map<String, String> checkTaxPayersMustInput() {
        List objs = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        List orgIds = objs.stream().filter(obj -> {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
            DynamicObject entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (DynamicObject)entries.get(i);
                if (!entry.getBoolean("entry_istaxpayer") || entry.getDynamicObject("entry_taxationsys") == null || obj.getDynamicObject("org") == null) continue;
                return true;
            }
            return false;
        }).map(obj -> obj.getLong("org.id")).collect(Collectors.toList());
        if (orgIds.size() > 0) {
            try {
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxcMainMService", (String)"checkTaxPayersMustInput", (Object[])new Object[]{orgIds, null});
                if (result != null) {
                    return (Map)result.get("data");
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected boolean checkTaxPayerMustInput(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<String, String> checkTaxPayersMap) {
        DynamicObjectCollection entries = currentObj.getDynamicObjectCollection("entryentity");
        DynamicObject entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)entries.get(i);
            if (!entry.getBoolean("entry_istaxpayer") || entry.getDynamicObject("entry_taxationsys") == null || currentObj.getDynamicObject("org") == null) continue;
            String key = currentObj.getLong("org.id") + "_" + entry.getLong("entry_taxationsys.id");
            if (checkTaxPayersMap == null || ObjectUtils.isEmpty((Object)checkTaxPayersMap.get(key))) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxOrgSaveValidator_1", (String)"bamp-bastax-opplugin", (Object[])new Object[0]), currentObj.getString("org.name")));
            return false;
        }
        return true;
    }
}

