/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.servicehelper;

import java.util.List;
import java.util.Map;
import kd.bd.barcode.common.vo.Barcode;
import kd.bd.barcode.common.vo.BarcodeGenerateOption;
import kd.bd.barcode.common.vo.BarcodeGenerated;
import kd.bd.barcode.mservice.api.IBarcodeGenerateBillService;
import kd.bd.barcode.mservice.api.IBarcodeGenerateService;
import kd.bd.barcode.mservice.api.IBarcodeParseService;
import kd.bd.barcode.mservice.api.IPkgBarcodeExportService;
import kd.bd.barcode.servicehelper.ServiceFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;

public class BarcodeServiceHelper {
    public static IBarcodeParseService getBarcodeParseService() {
        return (IBarcodeParseService)ServiceFactory.getService("BarcodeParseService");
    }

    public static IBarcodeGenerateService getBarcodeGenerateService() {
        return (IBarcodeGenerateService)ServiceFactory.getService("BarcodeGenerateService");
    }

    public static IPkgBarcodeExportService getPkgBarcodeExportService() {
        return (IPkgBarcodeExportService)ServiceFactory.getService("PkgBarcodeExportService");
    }

    public static IBarcodeGenerateBillService getBarcodeGenerateBillService() {
        return (IBarcodeGenerateBillService)ServiceFactory.getService("BarcodeGenerateBillService");
    }

    public static boolean hasBarcodeRule(String entityKey, Long orgID) {
        return BarcodeServiceHelper.getBarcodeParseService().hasBarcodeRule(entityKey, orgID);
    }

    public static DynamicObjectCollection parseBarcodesByRule(List<String> barcodes, Long ruleID, Long orgID) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeParseService().parseBarcodesByRule(barcodes, ruleID, orgID);
    }

    public static DynamicObjectCollection parseBarcodes(List<String> barcodes, String entityKey, Long orgID) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeParseService().parseBarcodes(barcodes, entityKey, orgID);
    }

    public static DynamicObjectCollection parseBarcode(String barcode, String entityKey, Long orgID) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeParseService().parseBarcode(barcode, entityKey, orgID);
    }

    public static DynamicObject getBarcodeInfo(String barcode, String entityKey, Long orgID, boolean fPkg) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeParseService().getBarcodeInfo(barcode, entityKey, orgID, fPkg);
    }

    public static DynamicObjectCollection getBarcodeDetail(String packageBarcode, String entityKey, Long orgID) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeParseService().getPackageBarcodeDetail(packageBarcode, entityKey, orgID);
    }

    public static DynamicObjectCollection getPackageBarcodesDetail(List<String> packageBarcodes, String entityKey, Long orgID) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeParseService().getPackageBarcodesDetail(packageBarcodes, entityKey, orgID);
    }

    public static List<BarcodeGenerated> generateBarcodes(List<BarcodeGenerateOption> options) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeGenerateService().generateBarcodes(options);
    }

    public static List<BarcodeGenerated> generateBarcodes(Long ruleId, Long orgId, List<BarcodeGenerateOption> options) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeGenerateService().generateBarcodes(ruleId, orgId, options);
    }

    public static BarcodeGenerated generateBarcode(BarcodeGenerateOption option) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeGenerateService().generateBarcode(option);
    }

    public static List<BarcodeGenerated> generateSaveBarcodes(List<BarcodeGenerateOption> options) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeGenerateService().generateSaveBarcodes(options);
    }

    public static List<BarcodeGenerated> generateSaveBarcodes(Long ruleId, Long orgId, List<BarcodeGenerateOption> options) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeGenerateService().generateSaveBarcodes(ruleId, orgId, options);
    }

    public static OperationResult saveBarcodes(Long orgId, List<Barcode> barcodes) throws KDBizException {
        return BarcodeServiceHelper.getBarcodeGenerateService().saveBarcodes(orgId, barcodes);
    }

    public static Map<String, List<DynamicObject>> getMapByBarcodeRule(DynamicObject[] dataEntities) throws KDBizException {
        return BarcodeServiceHelper.getPkgBarcodeExportService().getMapByBarcodeRule(dataEntities);
    }
}

