/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import kd.bd.barcode.common.BarcodeProp;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeMetadataHelper {
    private static final String MODULE = "bd-barcode-common";
    private static final Log LOGGER = LogFactory.getLog(BarcodeMetadataHelper.class);

    public static DynamicObject createDynamicObject(String name, String[] propsArr) {
        if (propsArr == null || propsArr.length == 0) {
            throw new InvalidParameterException("propsArr is null");
        }
        DynamicObjectType dt = new DynamicObjectType(name);
        boolean fPropNull = true;
        for (int i = 0; i < propsArr.length; ++i) {
            if (StringUtils.isEmpty((String)propsArr[i])) continue;
            DynamicProperty dp = new DynamicProperty();
            dp.setName(propsArr[i]);
            dt.addProperty(dp);
            fPropNull = false;
        }
        if (fPropNull) {
            LOGGER.error("param: propsArr is null");
            throw new InvalidParameterException("propsArr elements are null!");
        }
        return new DynamicObject(dt);
    }

    public static DynamicObject createDynamicObject(String name, String[] propsArr, Class<?>[] typesArr) {
        if (propsArr == null || propsArr.length == 0) {
            throw new InvalidParameterException("propsArr is null");
        }
        if (typesArr == null || typesArr.length == 0) {
            throw new InvalidParameterException("typesArr is null");
        }
        Field pTypeField = BarcodeMetadataHelper.getPropertyTypeField();
        DynamicObjectType dt = new DynamicObjectType(name);
        boolean fPropNull = true;
        for (int i = 0; i < propsArr.length; ++i) {
            if (StringUtils.isEmpty((String)propsArr[i])) continue;
            DynamicProperty dp = new DynamicProperty();
            dp.setName(propsArr[i]);
            BarcodeMetadataHelper.setDynamicPropertyPropertyType(pTypeField, dp, typesArr[i]);
            dt.addProperty(dp);
            fPropNull = false;
        }
        if (fPropNull) {
            throw new InvalidParameterException("propsArr elements are null!");
        }
        return new DynamicObject(dt);
    }

    public static void setDynamicPropertyPropertyType(Field pTypeField, DynamicProperty dp, Class<?> cls) {
        if (pTypeField != null && dp.getPropertyType() == null) {
            try {
                pTypeField.set(dp, cls);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("barcode parsed, cannot set id propertyType");
            }
        }
    }

    public static Field getPropertyTypeField() {
        Field pTypeField = null;
        try {
            Class<DynamicProperty> dpClass = DynamicProperty.class;
            pTypeField = dpClass.getDeclaredField("_propertyType");
            AccessibleObject.setAccessible(new AccessibleObject[]{pTypeField}, true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.error("barcode parse,  cannot get _propertyType field");
        }
        return pTypeField;
    }

    public static DynamicProperty getPropertyMeta(String pname, DynamicObjectType objType) {
        DynamicProperty propMeta = objType.getProperty(pname);
        if (propMeta == null && objType instanceof MainEntityType) {
            propMeta = (DynamicProperty)((MainEntityType)objType).findProperty(pname);
        }
        return propMeta;
    }

    public static String getEntryName(String pname, DynamicObjectType objType) {
        DynamicProperty pType = BarcodeMetadataHelper.getPropertyMeta(pname, objType);
        if (pType == null) {
            return null;
        }
        IDataEntityType parentType = pType.getParent();
        if (parentType instanceof IEntryType) {
            return parentType.getName();
        }
        return null;
    }

    public static String getPropName(String prop) {
        int indexDot;
        String pName = prop;
        if (prop != null && (indexDot = prop.indexOf(46)) > 0) {
            pName = prop.substring(0, indexDot);
        }
        return pName;
    }

    public static BarcodeProp getPropNameField(String prop) {
        BarcodeProp barcodeProp = new BarcodeProp();
        int indexDot = prop.indexOf(46);
        if (indexDot <= 0) {
            LOGGER.error("NO field is specified in object prop, cannot get the obj segment, " + prop);
            String msg = ResManager.loadResFormat((String)"\u5206\u6bb5\u5c5e\u6027\uff08%1\uff09\u4e2d\u672a\u6307\u5b9a\u5173\u8054\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027", (String)"PROP_NO_FIELD", (String)MODULE, (Object[])new Object[]{prop});
            throw new KDBizException(msg);
        }
        String pName = prop.substring(0, indexDot);
        String pField = prop.substring(indexDot + 1);
        barcodeProp.setName(pName);
        barcodeProp.setField(pField);
        return barcodeProp;
    }

    public static void checkPropValid(DynamicObjectType objType, String pname) throws KDBizException {
        DynamicProperty pType = BarcodeMetadataHelper.getPropertyMeta(pname, objType);
        if (pType == null) {
            LOGGER.error("barcode rule entry objprop is not valid (Entity, key): (" + objType.getName() + ", " + pname + ")");
            String msg = ResManager.loadResFormat((String)"%1\uff08%2\uff09\u6ca1\u6709\u6307\u5b9a\u7684\u5c5e\u6027%3", (String)"ENTRY_PROP_INVALID", (String)MODULE, (Object[])new Object[]{objType.getDisplayName(), objType.getName(), pname});
            throw new KDBizException(msg);
        }
    }

    public static String getItemClassTypeProp(DynamicObjectType objType, ItemClassProp pMeta) {
        String typePropName = pMeta.getTypePropName();
        String propName = null;
        DataEntityPropertyCollection props = objType.getProperties();
        for (IDataEntityProperty prop : props) {
            if (!(prop instanceof ItemClassTypeProp) || !typePropName.equals(prop.getName())) continue;
            propName = prop.getName();
            break;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("itemClassProp: " + pMeta.getName() + ", itemClassTypeProp: " + propName);
        }
        return propName;
    }
}

