/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeParsedValJsonHelper {
    private static final Log LOGGER = LogFactory.getLog(BarcodeParsedValJsonHelper.class);
    private static final String PROP_ID = "id";
    private static final String[] PROPARR = new String[]{"id"};
    private static final String[] barcodeProps = new String[]{"barcode", "objvalues", "srcbillid", "exception"};
    private static final String[] segProps = new String[]{"prop", "segment", "propvalue", "valuetype", "exception", "parsecls"};
    private static final String CACHE_VAL = "barcode_cacheVal";
    private static final Field PROP_FIELD = BarcodeMetadataHelper.getPropertyTypeField();

    public static DynamicObjectCollection getCachedBarcodeBizInfos(String jsonStr) {
        if (StringUtils.isEmpty((String)jsonStr)) {
            return null;
        }
        JSONArray cacheJson = JSONArray.parseArray((String)jsonStr);
        DynamicObjectCollection bizInfos = new DynamicObjectCollection();
        for (int i = 0; i < cacheJson.size(); ++i) {
            JSONObject barcodeJson = cacheJson.getJSONObject(i);
            DynamicObject barcodeVals = BarcodeParsedValJsonHelper.convertBarcodeJson(barcodeJson);
            bizInfos.add((Object)barcodeVals);
        }
        LOGGER.info("[getCachedBarcodeBizInfos]-json: " + jsonStr);
        LOGGER.info("[getCachedBarcodeBizInfos]-bizInfos: " + bizInfos);
        return bizInfos;
    }

    private static DynamicObject convertBarcodeJson(JSONObject barcodeJson) {
        DynamicObject barcodeVals = BarcodeMetadataHelper.createDynamicObject("bcprs_vals", barcodeProps);
        barcodeVals.set("barcode", barcodeJson.get((Object)"barcode"));
        barcodeVals.set("srcbillid", barcodeJson.get((Object)"srcbillid"));
        barcodeVals.set("exception", barcodeJson.get((Object)"exception"));
        JSONArray infoJson = barcodeJson.getJSONArray("objvalues");
        if (infoJson != null) {
            DynamicObjectCollection propObjs = BarcodeParsedValJsonHelper.convertBarcodeSegmentJsonArr(infoJson);
            barcodeVals.set("objvalues", (Object)propObjs);
        }
        return barcodeVals;
    }

    private static DynamicObjectCollection convertBarcodeSegmentJsonArr(JSONArray infoJson) {
        DynamicObjectCollection propObjs = new DynamicObjectCollection();
        for (int j = 0; j < infoJson.size(); ++j) {
            JSONObject propJson = infoJson.getJSONObject(j);
            DynamicObject propVal = BarcodeParsedValJsonHelper.convertBarcodeSegmentJson(propJson);
            propObjs.add((Object)propVal);
        }
        return propObjs;
    }

    private static DynamicObject convertBarcodeSegmentJson(JSONObject propJson) {
        DynamicObject propVal = BarcodeMetadataHelper.createDynamicObject("bcprs_val", segProps);
        Object prop = propJson.get((Object)"prop");
        propVal.set("prop", prop);
        String seg = propJson.getString("segment");
        propVal.set("segment", (Object)seg);
        Object val = BarcodeParsedValJsonHelper.getPropVal(PROP_FIELD, propJson);
        propVal.set("propvalue", val);
        String valType = propJson.getString("valuetype");
        propVal.set("valuetype", (Object)valType);
        String err = propJson.getString("exception");
        propVal.set("exception", (Object)err);
        String custCls = propJson.getString("parsecls");
        propVal.set("parsecls", (Object)custCls);
        return propVal;
    }

    private static DynamicObject getBOVal(Field pTypeField, Object val) {
        DynamicObject dynVal = null;
        if (val != null) {
            dynVal = BarcodeMetadataHelper.createDynamicObject(CACHE_VAL, PROPARR);
            DynamicProperty idType = dynVal.getDynamicObjectType().getProperty(PROP_ID);
            BarcodeMetadataHelper.setDynamicPropertyPropertyType(pTypeField, idType, val.getClass());
            try {
                dynVal.set(PROP_ID, val);
            }
            catch (Exception e) {
                LOGGER.error("failed to set id with val: " + val);
            }
        }
        return dynVal;
    }

    public static String getBarcodeBizInfosJsonString(DynamicObjectCollection bizInfos) {
        JSONArray cacheJson = new JSONArray(bizInfos.size());
        for (DynamicObject info : bizInfos) {
            JSONObject barcodeJson = new JSONObject();
            barcodeJson.put("barcode", info.get("barcode"));
            barcodeJson.put("srcbillid", info.get("srcbillid"));
            barcodeJson.put("exception", info.get("exception"));
            DynamicObjectCollection propObjs = info.getDynamicObjectCollection("objvalues");
            if (propObjs != null && !propObjs.isEmpty()) {
                JSONArray infoJson = BarcodeParsedValJsonHelper.convertSegments2Json(propObjs);
                barcodeJson.put("objvalues", (Object)infoJson);
            }
            cacheJson.add((Object)barcodeJson);
        }
        LOGGER.info("[getBarcodeBizInfosJsonString]-bizInfos: " + bizInfos);
        LOGGER.info("[getBarcodeBizInfosJsonString]-json: " + cacheJson);
        return cacheJson.toJSONString();
    }

    private static JSONArray convertSegments2Json(DynamicObjectCollection propObjs) {
        JSONArray infoJson = new JSONArray(propObjs.size());
        for (DynamicObject propVal : propObjs) {
            JSONObject propJson = BarcodeParsedValJsonHelper.convertSegment2Json(propVal);
            infoJson.add((Object)propJson);
        }
        return infoJson;
    }

    private static JSONObject convertSegment2Json(DynamicObject propVal) {
        String prop = propVal.getString("prop");
        String seg = propVal.getString("segment");
        Object val = propVal.get("propvalue");
        String valType = propVal.getString("valuetype");
        String err = propVal.getString("exception");
        String custCls = propVal.getString("parsecls");
        return BarcodeParsedValJsonHelper.getSegmentJson(prop, seg, val, valType, err, custCls);
    }

    private static JSONObject getSegmentJson(String prop, String seg, Object val, String valType, String err, String custCls) {
        JSONObject propJson = new JSONObject();
        propJson.put("prop", (Object)prop);
        propJson.put("segment", (Object)seg);
        if (val instanceof DynamicObject) {
            Object id = ((DynamicObject)val).get(PROP_ID);
            propJson.put("propvalue", id);
        } else {
            propJson.put("propvalue", val);
        }
        propJson.put("valuetype", (Object)valType);
        propJson.put("exception", (Object)err);
        propJson.put("parsecls", (Object)custCls);
        return propJson;
    }

    public static String getSegmentJsonStr(String prop, String seg, Object val, String valType, String err, String custCls) {
        return BarcodeParsedValJsonHelper.getSegmentJson(prop, seg, val, valType, err, custCls).toString();
    }

    private static Object getPropVal(Field pTypeField, JSONObject propJson) {
        String vType = (String)propJson.get((Object)"valuetype");
        Object val = null;
        if ("B".equals(vType)) {
            val = propJson.get((Object)"propvalue");
            val = BarcodeParsedValJsonHelper.getBOVal(pTypeField, val);
        } else {
            val = "D".equals(vType) ? propJson.getDate("propvalue") : ("A".equals(vType) || "Q".equals(vType) ? propJson.getBigDecimal("propvalue") : ("T".equals(vType) ? propJson.getInteger("propvalue") : propJson.get((Object)"propvalue")));
        }
        return val;
    }

    public static Object getPropVal(String json) {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        JSONObject propJson = JSONObject.parseObject((String)json);
        return BarcodeParsedValJsonHelper.getPropVal(PROP_FIELD, propJson);
    }
}

