/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.common.form;

import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.mvc.SessionManager;

public class FormShowParameterBuilder {
    public static FormShowParameter getFormShowParameter(String entityId, String viewBillFormId, String permissionEntityId, OperationStatus operationStatus, String pkId, IFormView billView) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        FormShowParameter parameter = FormShowParameterBuilder.createFormShowParameter(billView, mainEntityType);
        if (parameter instanceof BillShowParameter) {
            ((BillShowParameter)parameter).setPermissionEntityId(permissionEntityId);
            ((BillShowParameter)parameter).setStatus(operationStatus);
            ((BillShowParameter)parameter).setPkId((Object)pkId);
        }
        ShowType showType = FormShowParameterBuilder.getShowType(entityId, parameter, billView);
        parameter.getOpenStyle().setShowType(showType);
        parameter.setFormId(viewBillFormId);
        return parameter;
    }

    protected static FormShowParameter createFormShowParameter(IFormView billView, MainEntityType mainEntityType) {
        Object parameter = null;
        parameter = mainEntityType instanceof BasedataEntityType ? (billView instanceof IMobileListView ? new MobileBillShowParameter() : new BaseShowParameter()) : (mainEntityType instanceof BillEntityType ? (billView instanceof IMobileListView ? new MobileBillShowParameter() : new BillShowParameter()) : new FormShowParameter());
        return parameter;
    }

    protected static ShowType getShowType(String entityId, FormShowParameter parameter, IFormView view) {
        ShowType showType;
        if (view instanceof IMobileListView) {
            showType = ShowType.Floating;
        } else if (view instanceof IListView) {
            LocaleString caption = FormMetadataCache.getFormConfig((String)entityId).getCaption();
            parameter.setCaption(caption.toString());
            if (FormShowParameterBuilder.parentIsModel(view)) {
                showType = ShowType.Modal;
            } else {
                showType = view.getFormShowParameter().getFormConfig().getShowType();
                parameter.getOpenStyle().setTargetKey("tabap");
            }
        } else {
            showType = ShowType.Modal;
            Object isOpenNewTab = view.getFormShowParameter().getCustomParam("isOpenNewTab");
            if (isOpenNewTab != null && ((Boolean)isOpenNewTab).booleanValue()) {
                showType = ShowType.MainNewTabPage;
                parameter.getOpenStyle().setTargetKey("tabap");
            }
        }
        return showType;
    }

    protected static boolean parentIsModel(IFormView view) {
        FormShowParameter parentParameter;
        boolean isModel = false;
        FormShowParameter formShowParameter = parentParameter = view == null ? null : view.getFormShowParameter();
        while (parentParameter != null) {
            if (parentParameter.getOpenStyle().getShowType().compareTo((Enum)ShowType.Modal) == 0) {
                isModel = true;
                break;
            }
            parentParameter = parentParameter.getParentPageId() == null ? null : SessionManager.getCurrent().getFormShowParameter(parentParameter.getParentPageId());
        }
        return isModel;
    }
}

