/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeDataLoader {
    private static final Log LOGGER = LogFactory.getLog(BarcodeDataLoader.class);

    public static void loadBarcodesInfos(IFormView view, IFormView billView, DynamicObjectCollection bizInfos) {
        IDataModel billInfo = billView.getModel();
        String entryName = null;
        MainEntityType dataEntityType = billInfo.getDataEntityType();
        HashMap<String, Integer> entryRowIdxMap = new HashMap<String, Integer>(16);
        boolean hasSetValue4BillPage = false;
        for (DynamicObject info : bizInfos) {
            DynamicObjectCollection propObjs = info.getDynamicObjectCollection("objvalues");
            for (DynamicObject propVal : propObjs) {
                int entryIndex;
                String prop = propVal.getString("prop");
                Object prsVal = propVal.get("propvalue");
                if (StringUtils.isEmpty((String)prop) || prsVal == null) continue;
                String eprop = BarcodeMetadataHelper.getPropName((String)prop);
                entryName = BarcodeMetadataHelper.getEntryName((String)eprop, (DynamicObjectType)dataEntityType);
                int n = entryIndex = entryRowIdxMap.get(entryName) == null ? -1 : (Integer)entryRowIdxMap.get(entryName);
                if (StringUtils.isNotEmpty((String)entryName) && entryIndex == -1) {
                    entryIndex = BarcodeDataLoader.findEntryRowIdx(billView, billInfo, entryName, eprop);
                    entryRowIdxMap.put(entryName, entryIndex);
                }
                BarcodeDataLoader.loadBarcodeSegment(billInfo, eprop, prsVal, entryName, entryIndex);
                hasSetValue4BillPage = true;
            }
        }
        LOGGER.info("loadBarcodesInfos: hasSetValue4BillPage=" + hasSetValue4BillPage);
        if (hasSetValue4BillPage) {
            view.sendFormAction(billView);
        }
    }

    private static int findEntryRowIdx(IFormView billView, IDataModel billInfo, String entryName, String eprop) {
        int entryIndex = -1;
        if (StringUtils.isEmpty((String)entryName) || billInfo.getProperty(eprop) == null) {
            return entryIndex;
        }
        entryIndex = billInfo.getEntryCurrentRowIndex(entryName);
        DynamicObject currentEntryRow = billInfo.getEntryRowEntity(entryName, entryIndex);
        if (currentEntryRow == null || !BarcodeDataLoader.checkEntryValNull(currentEntryRow, eprop)) {
            BarcodeDataLoader.addNewEntry(billView, billInfo, entryName);
            entryIndex = billInfo.getEntryCurrentRowIndex(entryName);
        }
        return entryIndex;
    }

    public static void checkException(IFormView prsView, DynamicObjectCollection bizInfos) {
        StringBuilder errMsg = new StringBuilder();
        ArrayList<String> msgList = new ArrayList<String>();
        boolean fHasParsedSegs = false;
        for (DynamicObject info : bizInfos) {
            String eMsg;
            DynamicObjectCollection propObjs = info.getDynamicObjectCollection("objvalues");
            if (!fHasParsedSegs && propObjs != null && !propObjs.isEmpty()) {
                for (DynamicObject prop : propObjs) {
                    if (fHasParsedSegs || prop.get("propvalue") == null) continue;
                    fHasParsedSegs = true;
                    break;
                }
            }
            if (StringUtils.isEmpty((String)(eMsg = (String)info.get("exception"))) || msgList.contains(eMsg)) continue;
            errMsg.append(eMsg).append(System.lineSeparator());
            msgList.add(eMsg);
        }
        if (errMsg.length() == 0) {
            return;
        }
        if (!fHasParsedSegs) {
            throw new KDBizException(errMsg.toString());
        }
        prsView.showTipNotification(errMsg.toString());
    }

    private static boolean checkEntryValNull(DynamicObject currentEntryRow, String eprop) {
        boolean fNull = true;
        if (currentEntryRow == null || currentEntryRow.getDynamicObjectType().getProperty(eprop) == null) {
            return fNull;
        }
        Object epVal = currentEntryRow.get(eprop);
        if (epVal == null) {
            return fNull;
        }
        fNull = epVal instanceof BigDecimal ? BarcodeDataLoader.isAmtZero((BigDecimal)epVal) : (epVal instanceof String ? StringUtils.isBlank((String)epVal.toString()) : false);
        return fNull;
    }

    private static boolean isAmtZero(BigDecimal epVal) {
        return epVal.compareTo(BigDecimal.ZERO) == 0;
    }

    private static void addNewEntry(IFormView billView, IDataModel billInfo, String entryName) {
        AbstractGrid grid = (AbstractGrid)billView.getControl(entryName);
        billInfo.getDataEntity(true);
        int entryIndex = billInfo.createNewEntryRow(entryName);
        grid.selectRows(entryIndex, true);
    }

    private static void loadBarcodeSegment(IDataModel billInfo, String prop, Object val, String entryName, int entryIndex) {
        if (billInfo.getProperty(prop) == null) {
            LOGGER.error("the billInfo does NOT has prop, " + prop);
            return;
        }
        boolean fNoEntry = StringUtils.isEmpty((String)entryName);
        if (!(fNoEntry || entryIndex >= 0 && entryIndex <= billInfo.getEntryRowCount(entryName))) {
            LOGGER.error("entryIndex < 0 or > rowCount");
            return;
        }
        if (val instanceof DynamicObject) {
            DynamicObject dyno = (DynamicObject)val;
            if (fNoEntry) {
                billInfo.setItemValueByID(prop, dyno.get("id"));
            } else {
                billInfo.setItemValueByID(prop, dyno.get("id"), entryIndex);
            }
        } else if (fNoEntry) {
            billInfo.setValue(prop, val);
        } else {
            billInfo.setValue(prop, val, entryIndex);
        }
        LOGGER.info("set " + prop + " at row " + entryIndex);
    }
}

