/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.config;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class BarcodeScanConfigFormPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit botpEdit;
        super.registerListener(e);
        BasedataEdit srcBillEdit = (BasedataEdit)this.getView().getControl("srcbill");
        if (srcBillEdit != null) {
            srcBillEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((botpEdit = (BasedataEdit)this.getView().getControl("botp")) != null) {
            botpEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParameter = showParameter.getListFilterParameter();
        List f7QFilters = filterParameter.getQFilters();
        if ("srcbill".equals(fieldKey)) {
            DynamicObject tarEntity = this.getModel().getDataEntity().getDynamicObject("targetbill");
            String tarEntityNum = tarEntity == null ? "" : tarEntity.getString("number");
            List srcBills = ConvertMetaServiceHelper.loadConvertBills((String)tarEntityNum, (ConvertOpType)ConvertOpType.Draw);
            List srcEntityNumbers = srcBills.stream().map(ConvertBill::getEntityNumber).collect(Collectors.toList());
            f7QFilters.add(new QFilter("number", "in", srcEntityNumbers));
        } else if ("botp".equals(fieldKey)) {
            DynamicObject srcEntity = this.getModel().getDataEntity().getDynamicObject("srcbill");
            String srcEntityNum = srcEntity == null ? "" : srcEntity.getString("number");
            DynamicObject tarEntity = this.getModel().getDataEntity().getDynamicObject("targetbill");
            String tarEntityNum = tarEntity == null ? "" : tarEntity.getString("number");
            List botpRules = ConvertMetaServiceHelper.loadRules((String)srcEntityNum, (String)tarEntityNum);
            List botpRuleNumbers = botpRules.stream().filter(ConvertRuleElement::isEnabled).map(ConvertRuleElement::getId).collect(Collectors.toList());
            f7QFilters.add(new QFilter("number", "in", botpRuleNumbers));
        }
    }
}

