/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.generate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.common.vo.Barcode;
import kd.bd.barcode.common.vo.BarcodeBillEntryData;
import kd.bd.barcode.common.vo.BarcodeGenerateOption;
import kd.bd.barcode.common.vo.BarcodeGenerated;
import kd.bd.barcode.mservice.api.IBarcodeGenerateService;
import kd.bd.barcode.servicehelper.ServiceFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class BarcodeGeneratePlugin
extends AbstractFormPlugin {
    private static final String KEY_BILL = "bill";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BARCODEDETAIL = "barcodedetail";
    private static final String BARCODERULE = "barcoderule";
    private static final String PROP_MASTER = "masterid";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap", "toolbarap2"});
        this.addClickListeners(new String[]{"toolbarap", "toolbarap2"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)KEY_BILL, (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.showBillList();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (BARCODERULE.equals(e.getProperty().getName())) {
            this.cleanCacheData();
            DynamicObject barcoderule = (DynamicObject)this.getModel().getValue(BARCODERULE);
            barcoderule = BusinessDataServiceHelper.loadSingleFromCache((Object)barcoderule.getPkValue(), (String)"barcode_rule");
            this.getModel().setValue("bizobj", (Object)barcoderule.getDynamicObject("bizobj"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List ids = (List)formShowParameter.getCustomParam("ids");
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                this.showSelectBill(ids);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "selectbill": {
                this.selectBill();
                break;
            }
            case "generatebarcode": {
                this.generateBarcode();
                break;
            }
            case "save": {
                this.saveBarcode();
                break;
            }
            case "add": {
                this.cleanCacheData();
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int i;
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        int[] rowIndexs = e.getRowIndexs();
        Map<String, Object> map = this.getCacheData();
        if (ENTRYENTITY.equals(name)) {
            List val = (List)map.get("val");
            for (i = rowIndexs.length - 1; i >= 0; --i) {
                val.remove(rowIndexs[i]);
            }
            this.getView().getPageCache().put("val", JSON.toJSON((Object)val).toString());
        }
        if (BARCODEDETAIL.equals(name)) {
            List barcodes = (List)map.get("barcodes");
            for (i = rowIndexs.length - 1; i >= 0; --i) {
                barcodes.remove(rowIndexs[i]);
            }
            this.getView().getPageCache().put("barcodes", JSON.toJSON((Object)barcodes).toString());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        ArrayList ids = Lists.newArrayList();
        returnData.forEach(e -> ids.add(e.getPrimaryKeyValue()));
        this.showSelectBill(ids);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        for (int i = 1; i <= 40; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"textfield" + i});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"id"});
        String pageId = this.getView().getPageId();
        if (StringUtils.isNotBlank((String)pageId) && pageId.startsWith("barcodegen_")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"selectbill"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"add"});
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String entityKey = (String)formShowParameter.getCustomParam("entityKey");
            QFilter[] qfArr = new QFilter[]{new QFilter("number", "=", (Object)entityKey)};
            DynamicObject bizObjectType = BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"id", (QFilter[])qfArr);
            this.getModel().setValue("bizobj", (Object)bizObjectType);
            BasedataEdit rule = (BasedataEdit)this.getView().getControl(BARCODERULE);
            rule.setQFilter(new QFilter("bizobj.number", "=", (Object)entityKey));
        }
    }

    private Map<String, Object> getCacheData() {
        List title = Lists.newArrayList();
        ArrayList val = Lists.newArrayList();
        List barcodes = Lists.newArrayList();
        Map source = Maps.newHashMap();
        List keys = Lists.newArrayList();
        IPageCache pageCache = this.getView().getPageCache();
        if (StringUtils.isNotBlank((String)pageCache.get("title"))) {
            title = JSON.parseArray((String)pageCache.get("title"), String.class);
        }
        if (StringUtils.isNotBlank((String)pageCache.get("val"))) {
            JSONArray temp = JSON.parseArray((String)pageCache.get("val"));
            temp.forEach(e -> val.add((List)e));
        }
        if (StringUtils.isNotBlank((String)pageCache.get("barcodes"))) {
            barcodes = JSON.parseArray((String)pageCache.get("barcodes"), Barcode.class);
        }
        if (StringUtils.isNotBlank((String)pageCache.get("source"))) {
            source = (Map)JSON.parseObject((String)pageCache.get("source"), Map.class);
        }
        if (StringUtils.isNotBlank((String)pageCache.get("keys"))) {
            keys = JSON.parseArray((String)pageCache.get("keys"), String.class);
        }
        HashMap map = Maps.newHashMap();
        map.put("title", title);
        map.put("val", val);
        map.put("barcodes", barcodes);
        map.put("source", source);
        map.put("keys", keys);
        return map;
    }

    private void cleanCacheData() {
        for (int i = 1; i <= 40; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"textfield" + i});
        }
        this.getView().getPageCache().put("title", "");
        this.getView().getPageCache().put("val", "");
        this.getView().getPageCache().put("barcodes", "");
        this.getView().getPageCache().put("keys", "");
        this.getView().getPageCache().put("source", "");
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().deleteEntryData(BARCODEDETAIL);
    }

    private void generateBarcode() {
        this.getModel().deleteEntryData(BARCODEDETAIL);
        ArrayList options = Lists.newArrayList();
        DynamicObjectCollection mEntries = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject mEntry : mEntries) {
            Object[] array;
            int number = mEntry.getInt("barcodenumber");
            if (number == 0) continue;
            BarcodeGenerateOption option = new BarcodeGenerateOption();
            ArrayList entries = Lists.newArrayList();
            String entryinfo = mEntry.getString("entryinfo");
            if (StringUtils.isNotBlank((String)entryinfo) && ArrayUtils.isNotEmpty((Object[])(array = entryinfo.split(";")))) {
                for (Object info : array) {
                    String entryName = ((String)info).split(":")[0];
                    Long entryId = Long.valueOf(((String)info).split(":")[1]);
                    if (StringUtils.isEmpty((String)entryName) || entryId == null || entryId <= 0L) continue;
                    BarcodeBillEntryData entryInfo = new BarcodeBillEntryData();
                    entryInfo.setEntryName(entryName);
                    entryInfo.setEntryId(entryId);
                    entries.add(entryInfo);
                }
            }
            option.setBillId(Long.valueOf(mEntry.getLong("id")));
            option.setEntryNameIds((List)entries);
            option.setCount(number);
            options.add(option);
        }
        if (options.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u751f\u6210\u7684\u6761\u7801", (String)"GENERATE_ERROR_NOBAROCDE", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject barcoderule = (DynamicObject)this.getModel().getValue(BARCODERULE);
        Long ruleId = barcoderule != null ? Long.valueOf(barcoderule.getLong("id")) : null;
        IBarcodeGenerateService iService = (IBarcodeGenerateService)ServiceFactory.getService((String)"BarcodeGenerateService");
        List barcodesGen = iService.generateBarcodes(ruleId, Long.valueOf(RequestContext.get().getOrgId()), (List)options);
        StringBuilder builder = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        int i = 0;
        int msgCount = 0;
        for (BarcodeGenerated barcodeGen : barcodesGen) {
            String exceptionMsg;
            if (barcodeGen.getBarcode() != null && StringUtils.isNotBlank((String)barcodeGen.getBarcode().getBarcodeString())) {
                ++i;
            }
            if (!StringUtils.isNotBlank((String)(exceptionMsg = barcodeGen.getExceptionMsg()))) continue;
            builder.append(exceptionMsg);
            builder.append(lineSeparator);
            ++msgCount;
        }
        if (i == 0) {
            this.getView().showMessage(builder.toString());
            return;
        }
        int[] row = this.getModel().batchCreateNewEntryRow(BARCODEDETAIL, i);
        Map<String, Object> map = this.getCacheData();
        List val = (List)map.get("val");
        List barcodes = (List)map.get("barcodes");
        List title = (List)map.get("title");
        Map sourceMap = (Map)map.get("source");
        List keys = (List)map.get("keys");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        i = 0;
        List objs = null;
        int showNum = 0;
        int getNum = 0;
        Integer genNum = null;
        for (BarcodeGenerated barcodeGen : barcodesGen) {
            String valInfo;
            if (barcodeGen.getBarcode() == null || StringUtils.isBlank((String)barcodeGen.getBarcode().getBarcodeString()) || StringUtils.isNotBlank((String)barcodeGen.getExceptionMsg())) continue;
            barcodes.add(barcodeGen.getBarcode());
            TextEdit field = (TextEdit)this.getView().getControl("textfield21");
            field.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6761\u7801\u503c", (String)"BARCODE_VALUE", (String)"bd-barcode-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.TRUE, new String[]{"textfield21"});
            this.getModel().setValue("textfield21", (Object)barcodeGen.getBarcode().getBarcodeString(), row[i]);
            if (objs == null && StringUtils.isNotBlank((String)(valInfo = this.getValInfo(mEntries, getNum)))) {
                String[] info = valInfo.split(";");
                int valrow = Integer.parseInt(info[0]);
                genNum = Integer.parseInt(info[1]);
                getNum = Integer.parseInt(info[2]);
                if (valrow < val.size()) {
                    objs = (List)val.get(valrow);
                }
            }
            if (objs != null) {
                for (int j = 0; j < objs.size(); ++j) {
                    Object obj = objs.get(j);
                    if (obj instanceof java.util.Date) {
                        obj = sdf.format(obj);
                    }
                    TextEdit field1 = (TextEdit)this.getView().getControl("textfield" + (22 + j));
                    field1.setCaption(new LocaleString((String)title.get(j)));
                    this.getView().setVisible(Boolean.TRUE, new String[]{"textfield" + (22 + j)});
                    this.getModel().setValue("textfield" + (22 + j), obj, row[i]);
                }
                if (++showNum == genNum) {
                    ++getNum;
                    showNum = 0;
                    genNum = null;
                    objs = null;
                }
            }
            ++i;
        }
        this.getPageCache().put("barcodes", JSON.toJSON((Object)barcodes).toString());
        if (msgCount > 0) {
            this.getView().showMessage(builder.toString());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f", (String)"GENERATE_SUCCESS", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
        }
    }

    private String getValInfo(DynamicObjectCollection mEntries, int i) {
        if (i >= mEntries.size()) {
            return "";
        }
        DynamicObject mEntry = (DynamicObject)mEntries.get(i);
        if (mEntry.getInt("barcodenumber") != 0) {
            return i + ";" + mEntry.getInt("barcodenumber") + ";" + i;
        }
        return this.getValInfo(mEntries, ++i);
    }

    private void saveBarcode() {
        IBarcodeGenerateService iService = (IBarcodeGenerateService)ServiceFactory.getService((String)"BarcodeGenerateService");
        Map<String, Object> map = this.getCacheData();
        OperationResult saveBarcodes = iService.saveBarcodes(Long.valueOf(RequestContext.get().getOrgId()), (List)map.get("barcodes"));
        ValidateResultCollection validateResult = saveBarcodes.getValidateResult();
        if (validateResult != null && CollectionUtils.isNotEmpty((Collection)validateResult.getValidateErrors())) {
            StringBuilder validateErr = new StringBuilder();
            HashSet errorDataIndexs = validateResult.getErrorDataIndexs();
            List validateErrors = validateResult.getValidateErrors();
            for (ValidateResult result : validateErrors) {
                List errorInfos = result.getAllErrorInfo();
                if (!CollectionUtils.isNotEmpty((Collection)errorInfos)) continue;
                Iterator errIt = errorDataIndexs.iterator();
                while (errIt.hasNext()) {
                    int intValue = (Integer)errIt.next();
                    if (intValue >= errorInfos.size()) continue;
                    OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(intValue);
                    validateErr.append(errorInfo.getMessage());
                }
            }
            this.getView().showMessage(validateErr.toString());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SAVE_SUCCESS", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
        }
        this.cleanCacheData();
    }

    private void selectBill() {
        DynamicObject barcoderule = (DynamicObject)this.getModel().getValue(BARCODERULE);
        if (barcoderule == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6761\u7801\u89c4\u5219", (String)"SELECT_BARCODE_RULE", (String)"bd-barcode-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        this.cleanCacheData();
        this.showBillList();
    }

    private void showBillList() {
        DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
        String entityKey = bizobj.getString("number");
        String entityF7 = "bos_listf7";
        ListShowParameter param = new ListShowParameter();
        param.setLookUp(true);
        param.setFormId(entityF7);
        param.setBillFormId(entityKey);
        param.setMultiSelect(true);
        param.setShowFilter(true);
        OpenStyle openStyle = param.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss inlineCss = openStyle.getInlineStyleCss();
        if (inlineCss == null) {
            inlineCss = new StyleCss();
        }
        inlineCss.setHeight("600");
        inlineCss.setWidth("900");
        openStyle.setInlineStyleCss(inlineCss);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setting_close"));
        this.getView().showForm((FormShowParameter)param);
        this.getPageCache().put("BARCODEGENERATE_PAGEID", param.getPageId());
    }

    private Object getComboPropTitle(MainEntityType dt, String objprop, Object value) {
        IDataEntityProperty property = (IDataEntityProperty)dt.getProperties().get((Object)objprop);
        if (property instanceof ComboProp) {
            for (ValueMapItem item : ((ComboProp)property).getComboItems()) {
                if (!value.equals(item.getValue())) continue;
                return item.getName().toString();
            }
        }
        return value;
    }

    private String getEntryName(String pname, MainEntityType dt) {
        String sup;
        String entryName = BarcodeMetadataHelper.getEntryName((String)pname, (DynamicObjectType)dt);
        if (StringUtils.isNotBlank((String)entryName) && StringUtils.isNotBlank((String)(sup = this.getEntryName(entryName, dt)))) {
            entryName = sup + "." + entryName;
        }
        return entryName;
    }

    private void showSelectBill(List<Object> ids) {
        this.cleanCacheData();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        ArrayList title = Lists.newArrayList();
        ArrayList keys = Lists.newArrayList();
        ArrayList entryIds = Lists.newArrayList();
        HashSet selectFields = Sets.newHashSet();
        selectFields.add("id");
        DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)((String)bizobj.get("number")));
        DynamicObject barcoderule = (DynamicObject)this.getModel().getValue(BARCODERULE);
        barcoderule = BusinessDataServiceHelper.loadSingleFromCache((Object)barcoderule.getPkValue(), (String)"barcode_rule");
        DynamicObjectCollection entryCollection = barcoderule.getDynamicObjectCollection("entry");
        String qtyProp = null;
        for (DynamicObject entry : entryCollection) {
            String entryName;
            String itemClsTypeProp;
            String pField;
            DynamicObjectType dynamicComplexPropertyType;
            String key = entry.getString("objprop");
            if (StringUtils.isBlank((String)key)) continue;
            String pname = BarcodeMetadataHelper.getPropName((String)key);
            DynamicProperty propertyMeta = BarcodeMetadataHelper.getPropertyMeta((String)pname, (DynamicObjectType)dt);
            DynamicProperty property = null;
            if (propertyMeta instanceof MaterielProp && (property = (dynamicComplexPropertyType = ((MaterielProp)propertyMeta).getDynamicComplexPropertyType()).getProperty(PROP_MASTER)) instanceof MasterBasedataProp && key.indexOf(46) > -1 && ("number".equals(pField = key.split("\\.")[1]) || "name".equals(pField))) {
                key = pname + "." + PROP_MASTER + "." + pField;
            }
            if (propertyMeta instanceof ItemClassProp && (itemClsTypeProp = BarcodeMetadataHelper.getItemClassTypeProp((DynamicObjectType)dt, (ItemClassProp)((ItemClassProp)propertyMeta))) != null) {
                selectFields.add(itemClsTypeProp);
            }
            if (StringUtils.isNotBlank((String)(entryName = this.getEntryName(pname, dt)))) {
                keys.add(entryName + "." + key);
                entryIds.add(entryName + ".id");
                selectFields.add(entryName + "." + key);
                selectFields.add(entryName + ".id");
                if (property != null) {
                    selectFields.add(entryName + "." + pname + ".masterid");
                }
            } else {
                keys.add(key);
                selectFields.add(key);
                if (property != null) {
                    selectFields.add(PROP_MASTER);
                }
            }
            Object name = key.split("\\.")[0];
            for (Map.Entry dtEntry : dt.getAllFields().entrySet()) {
                if (!((String)dtEntry.getKey()).equals(name)) continue;
                name = ((IDataEntityProperty)dtEntry.getValue()).getDisplayName().toString();
                title.add(name);
                break;
            }
            if (!entry.getBoolean("isqtyprop")) continue;
            qtyProp = key;
            if (!StringUtils.isNotBlank((String)entryName)) continue;
            qtyProp = entryName + "." + key;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)((String)bizobj.get("number")), (String)StringUtils.join((Collection)selectFields, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids.toArray())});
        if (query == null || query.size() == 0) {
            return;
        }
        int[] row = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, query.size());
        ArrayList<ArrayList> val = new ArrayList<ArrayList>(query.size());
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("text-align", "right");
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject data = (DynamicObject)query.get(i);
            if (barcoderule.getBoolean("isperitem")) {
                BigDecimal quantity = new BigDecimal(data.get(qtyProp).toString()).setScale(0, 1);
                this.getModel().setValue("barcodenumber", (Object)quantity, row[i]);
            }
            if (data.getDynamicObjectType().getProperty(PROP_MASTER) != null && data.get(PROP_MASTER) instanceof DynamicObject) {
                data = (DynamicObject)data.get(PROP_MASTER);
            }
            StringBuilder entryinfo = new StringBuilder();
            for (String entryId : entryIds) {
                String[] split = entryId.replace(".id", "").split("\\.");
                String entryName = split[split.length - 1];
                entryinfo.append(entryName).append(':').append(String.valueOf(data.get(entryId))).append(';');
            }
            this.getModel().setValue("entryinfo", (Object)entryinfo.toString(), row[i]);
            this.getModel().setValue("id", data.get("id"), row[i]);
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < keys.size() && j < 20; ++j) {
                String textfield = "textfield" + (j + 1);
                String key = (String)keys.get(j);
                Object value = data.get(key);
                if ((value = this.getComboPropTitle(dt, key, value)) instanceof Timestamp || value instanceof Date) {
                    value = sdf.format(value);
                }
                TextEdit field = (TextEdit)this.getView().getControl(textfield);
                if (value instanceof BigDecimal) {
                    value = new BigDecimal(value.toString()).setScale(5, 0);
                    this.getView().updateControlMetadata(textfield, (Map)map);
                }
                if (j < title.size()) {
                    field.setCaption(new LocaleString((String)title.get(j)));
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{textfield});
                this.getModel().setValue(textfield, value, row[i]);
                list.add(value);
            }
            val.add(list);
        }
        this.getView().getPageCache().put("title", JSON.toJSON((Object)title).toString());
        this.getView().getPageCache().put("val", JSON.toJSON(val).toString());
        this.getView().getPageCache().put("keys", JSON.toJSON((Object)keys).toString());
    }
}

