/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.info;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BarcodeInfoPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent beforeitemclickevent) {
        String itemkey = beforeitemclickevent.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if ("btn_view".equals(itemkey) && rows.size() == 1) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("barcode_detail");
            this.getPageCache().put("id", String.valueOf((Long)billList.getFocusRowPkId()));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
        if ("btn_print".equals(itemkey)) {
            Long id = null;
            for (ListSelectedRow row : rows) {
                Object primaryKeyValue = row.getPrimaryKeyValue();
                QFilter[] filter = new QFilter[]{new QFilter("id", "=", primaryKeyValue)};
                DynamicObject info = BusinessDataServiceHelper.loadSingle((String)"barcode_info", (String)"barcode,barcoderule", (QFilter[])filter);
                DynamicObject rule = info.getDynamicObject("barcoderule");
                if (rule == null) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u6761\u7801\u503c:%1\u7684\u6761\u7801\u89c4\u5219\u4e0d\u5b58\u5728", (String)"INFO_BARCODERULE_NOT_EXIST", (String)"bd-barcode-formplugin", (Object[])new Object[]{info.getString("barcode")}));
                    return;
                }
                Long ruleId = rule.getLong("id");
                if (id == null) {
                    id = ruleId;
                }
                if (id.equals(ruleId)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6761\u7801\u503c\u7684\u6761\u7801\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"INFO_BARCODERULE_NOT_EQUALS", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        this.showDetail();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.showDetail();
    }

    private void showDetail() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("barcode_detail");
        BillList billList = (BillList)this.getControl("billlistap");
        this.getPageCache().put("id", String.valueOf((Long)billList.getFocusRowPkId()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

