/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.info;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.servicehelper.BarcodeServiceHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PackageBarcodeExportPlugin
extends AbstractOperationServicePlugIn {
    private static Log LOGGER = LogFactory.getLog(PackageBarcodeExportPlugin.class);
    private static final String[] title = new String[]{ResManager.loadKDString((String)"\u5305\u88c5\u6761\u7801\u503c", (String)"PKG_EXPORT_PKGVALUE", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6761\u7801\u89c4\u5219", (String)"PKG_EXPORT_RULE", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5305\u88c5\u6570\u91cf", (String)"PKG_EXPORT_PKGCOUNT", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5305\u88c5\u6570\u91cf", (String)"PKG_EXPORT_ALRCOUNT", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"PKG_EXPORT_BIZ", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"PKG_EXPORT_ORG", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6210\u65f6\u95f4", (String)"PKG_EXPORT_CRECATETIME", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u66f4\u65b0\u65f6\u95f4", (String)"PKG_EXPORT_UPDATETIME", (String)"bd-barcode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u666e\u901a\u6761\u7801\u503c", (String)"PKG_EXPORT_BCVALUE", (String)"bd-barcode-formplugin", (Object[])new Object[0])};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("barcode");
        e.getFieldKeys().add("barcoderule");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("entry.ebarcode");
        e.getFieldKeys().add("ebarcode.objprop");
        e.getFieldKeys().add("ebarcode.segmentval");
        e.getFieldKeys().add("entry.isleaf");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs arg) {
        super.beginOperationTransaction(arg);
        OperationResult operationResult = this.getOperationResult();
        String operationKey = arg.getOperationKey();
        DynamicObject[] dataEntities = arg.getDataEntities();
        try {
            if ("donothing".equals(operationKey)) {
                Map map = BarcodeServiceHelper.getMapByBarcodeRule((DynamicObject[])dataEntities);
                XSSFWorkbook book = this.loadBook(map);
                String url = this.downLoadExcel(book);
                InteractionContext interactionContext = new InteractionContext();
                HashMap urlMap = Maps.newHashMap();
                urlMap.put("url", url);
                interactionContext.setCustShowParameter((Map)urlMap);
                operationResult.setInteractionContext(interactionContext);
            }
        }
        catch (Exception e) {
            LOGGER.error("packageBarcode export error: ", (Throwable)e);
            operationResult.setSuccess(false);
            String msg = ResManager.loadKDString((String)"\u5305\u88c5\u6761\u7801\u88c5\u7bb1\u4fe1\u606f\u5bfc\u51fa\u5931\u8d25", (String)"PackageBarcodeExportPlugin_0", (String)"bd-barcode-formplugin", (Object[])new Object[0]);
            operationResult.setMessage(msg);
        }
    }

    private XSSFWorkbook loadBook(Map<String, List<DynamicObject>> map) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            XSSFSheet sheet = workbook.createSheet(entry.getKey());
            List<DynamicObject> list = entry.getValue();
            DynamicObject dynamicObject = list.get(0);
            DynamicObject barcoderule = (DynamicObject)dynamicObject.get("barcoderule");
            barcoderule = BusinessDataServiceHelper.loadSingle((String)"barcode_rule", (String)"entry.objprop,bizobj,packagecount", (QFilter[])new QFilter[]{new QFilter("id", "=", barcoderule.get("id"))});
            DynamicObject bizobj = (DynamicObject)barcoderule.get("bizobj");
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)((String)bizobj.get("number")));
            DynamicObjectCollection ruleEntry = (DynamicObjectCollection)barcoderule.get("entry");
            List<String> objprops = this.setTitle(workbook, sheet, ruleEntry, dt);
            HashMap maxWidth = Maps.newHashMap();
            int rowNum = 0;
            for (DynamicObject pkgbarcode : list) {
                this.pkgAddRow(pkgbarcode, barcoderule, bizobj, workbook, sheet, objprops, sdf, rowNum, maxWidth);
            }
            for (int i = 0; i < maxWidth.size(); ++i) {
                Integer width = (Integer)maxWidth.get(i);
                if (width == null) continue;
                sheet.setColumnWidth(i, width.intValue());
            }
        }
        return workbook;
    }

    private void setStyle(XSSFWorkbook workbook, XSSFCell cell) {
        cell.setCellType(CellType.STRING);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cell.setCellStyle((CellStyle)cellStyle);
    }

    private List<String> setTitle(XSSFWorkbook workbook, XSSFSheet sheet, DynamicObjectCollection ruleEntry, MainEntityType dt) {
        int i;
        XSSFRow trow = sheet.createRow(0);
        for (i = 0; i < title.length; ++i) {
            XSSFCell tcell = trow.createCell(i);
            tcell.setCellValue(title[i]);
            this.setStyle(workbook, tcell);
        }
        ArrayList objprops = Lists.newArrayList();
        for (DynamicObject data : ruleEntry) {
            String objprop = (String)data.get("objprop");
            if (!StringUtils.isNotBlank((CharSequence)objprop)) continue;
            objprops.add(objprop);
            String pname = BarcodeMetadataHelper.getPropName((String)objprop);
            DynamicProperty meta = BarcodeMetadataHelper.getPropertyMeta((String)pname, (DynamicObjectType)dt);
            XSSFCell tcell = trow.createCell(i);
            tcell.setCellValue(meta.getDisplayName().toString());
            tcell.setCellStyle((CellStyle)workbook.createCellStyle());
            this.setStyle(workbook, tcell);
            ++i;
        }
        return objprops;
    }

    private String downLoadExcel(XSSFWorkbook book) throws Exception {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String name = ResManager.loadKDString((String)"\u5305\u88c5\u6761\u7801", (String)"PACKAGE_BARCODE", (String)"bd-barcode-formplugin", (Object[])new Object[0]) + "-" + dateFormat.format(date) + ".xlsx";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        book.write((OutputStream)out);
        ByteArrayInputStream bin = new ByteArrayInputStream(out.toByteArray());
        out.close();
        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = tfc.saveAsUrl(name, (InputStream)bin, 1800);
        return url;
    }

    private void pkgAddRow(DynamicObject pkgbarcode, DynamicObject barcoderule, DynamicObject bizobj, XSSFWorkbook workbook, XSSFSheet sheet, List<String> objprops, SimpleDateFormat sdf, int rowNum, Map<Integer, Integer> maxWidth) {
        DynamicObjectCollection pkgEntry = (DynamicObjectCollection)pkgbarcode.get("entry");
        DynamicObject barcodeInfo = (DynamicObject)pkgbarcode.get("barcode");
        DynamicObject createdorg = (DynamicObject)pkgbarcode.get("org");
        ArrayList pkgInfoData = Lists.newArrayList();
        pkgInfoData.add(barcodeInfo.getString("barcode"));
        pkgInfoData.add(barcoderule.getString("name"));
        pkgInfoData.add(String.valueOf(barcoderule.getInt("packagecount")));
        pkgInfoData.add(String.valueOf(pkgEntry.size()));
        pkgInfoData.add(bizobj.getString("name"));
        if (createdorg != null) {
            pkgInfoData.add(createdorg.getString("name"));
        } else {
            pkgInfoData.add("");
        }
        pkgInfoData.add(sdf.format((Date)pkgbarcode.get("modifytime")));
        pkgInfoData.add(sdf.format((Date)pkgbarcode.get("createtime")));
        for (DynamicObject data : pkgEntry) {
            int j;
            XSSFRow row = sheet.createRow(++rowNum);
            for (j = 0; j < pkgInfoData.size(); ++j) {
                XSSFCell cell = row.createCell(j);
                cell.setCellValue((String)pkgInfoData.get(j));
                this.setStyle(workbook, cell);
                Integer max = maxWidth.get(j);
                int width = cell.getStringCellValue().getBytes(StandardCharsets.UTF_8).length * 256 + 200;
                max = max != null ? Integer.valueOf(Math.max(width, max)) : Integer.valueOf(width);
                maxWidth.put(j, max);
            }
            DynamicObject ebarcode = (DynamicObject)data.get("ebarcode");
            if (ebarcode == null) continue;
            String barcode = ebarcode.getString("barcode");
            XSSFCell cell = row.createCell(j++);
            cell.setCellValue(barcode);
            this.setStyle(workbook, cell);
            DynamicObjectCollection ebarcodeEntry = (DynamicObjectCollection)ebarcode.get("entry");
            for (String objprop : objprops) {
                int count = 0;
                for (DynamicObject ebarcodeInfo : ebarcodeEntry) {
                    XSSFCell ecell;
                    if (ebarcodeInfo.getString("objprop").equals(objprop)) {
                        ecell = row.createCell(j);
                        ecell.setCellValue((String)ebarcodeInfo.get("segmentval"));
                        this.setStyle(workbook, ecell);
                        Integer max = maxWidth.get(j);
                        int width = cell.getStringCellValue().getBytes(StandardCharsets.UTF_8).length * 256 + 200;
                        max = max != null ? Integer.valueOf(Math.max(width, max)) : Integer.valueOf(width);
                        maxWidth.put(j, max);
                        ++j;
                        continue;
                    }
                    if (++count != ebarcodeEntry.size()) continue;
                    ecell = row.createCell(j++);
                    ecell.setCellValue("");
                    this.setStyle(workbook, ecell);
                }
            }
        }
    }
}

